/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.bucket;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.hdds.client.DefaultReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.ClientVersion;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.request.validation.RequestFeatureValidator;
import org.apache.hadoop.ozone.om.request.validation.RequestProcessingPhase;
import org.apache.hadoop.ozone.om.request.validation.ValidationCondition;
import org.apache.hadoop.ozone.om.request.validation.ValidationContext;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.bucket.OMBucketCreateResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeature;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.upgrade.LayoutFeature;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMBucketCreateRequest
extends OMClientRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMBucketCreateRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMBucketCreateRequest.class);
    }

    public OMBucketCreateRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OzoneManagerProtocolProtos.CreateBucketRequest createBucketRequest = this.getOmRequest().getCreateBucketRequest();
        OzoneManagerProtocolProtos.BucketInfo bucketInfo = createBucketRequest.getBucketInfo();
        OmUtils.validateBucketName((String)bucketInfo.getBucketName(), (boolean)ozoneManager.isStrictS3());
        OMBucketCreateRequest.validateMaxBucket(ozoneManager);
        KeyProviderCryptoExtension kmsProvider = ozoneManager.getKmsProvider();
        OzoneManagerProtocolProtos.CreateBucketRequest.Builder newCreateBucketRequest = createBucketRequest.toBuilder();
        OzoneManagerProtocolProtos.BucketInfo.Builder newBucketInfo = bucketInfo.toBuilder();
        long initialTime = Time.now();
        newBucketInfo.setCreationTime(initialTime).setModificationTime(initialTime);
        if (bucketInfo.hasBeinfo()) {
            newBucketInfo.setBeinfo(this.getBeinfo(kmsProvider, bucketInfo));
        }
        boolean hasSourceVolume = bucketInfo.hasSourceVolume();
        boolean hasSourceBucket = bucketInfo.hasSourceBucket();
        if (hasSourceBucket != hasSourceVolume) {
            throw new OMException("Both source volume and source bucket are required for bucket links", OMException.ResultCodes.INVALID_REQUEST);
        }
        if (hasSourceBucket && bucketInfo.hasBeinfo()) {
            throw new OMException("Encryption cannot be set for bucket links", OMException.ResultCodes.INVALID_REQUEST);
        }
        if (bucketInfo.hasDefaultReplicationConfig()) {
            DefaultReplicationConfig drc = DefaultReplicationConfig.fromProto((HddsProtos.DefaultReplicationConfig)bucketInfo.getDefaultReplicationConfig());
            ozoneManager.validateReplicationConfig(drc.getReplicationConfig());
        }
        newCreateBucketRequest.setBucketInfo(newBucketInfo.build());
        return this.getOmRequest().toBuilder().setUserInfo(this.getUserInfo()).setCreateBucketRequest(newCreateBucketRequest.build()).build();
    }

    private static void validateMaxBucket(OzoneManager ozoneManager) throws IOException {
        long nrOfBuckets;
        int maxBucket = ozoneManager.getConfiguration().getInt("ozone.om.max.buckets", 100000);
        if (maxBucket <= 0) {
            maxBucket = 100000;
        }
        if ((nrOfBuckets = ozoneManager.getMetadataManager().getBucketTable().getEstimatedKeyCount()) >= (long)maxBucket) {
            throw new OMException("Cannot create more than " + maxBucket + " buckets", OMException.ResultCodes.TOO_MANY_BUCKETS);
        }
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex) {
        OMClientResponse omClientResponse;
        Exception exception;
        OzoneManagerProtocolProtos.UserInfo userInfo;
        AuditLogger auditLogger;
        OmBucketInfo omBucketInfo;
        String bucketName;
        String volumeName;
        OzoneManagerProtocolProtos.BucketInfo bucketInfo;
        OMMetrics omMetrics;
        block24: {
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumBucketCreates();
            OMMetadataManager metadataManager = ozoneManager.getMetadataManager();
            OzoneManagerProtocolProtos.CreateBucketRequest createBucketRequest = this.getOmRequest().getCreateBucketRequest();
            bucketInfo = createBucketRequest.getBucketInfo();
            volumeName = bucketInfo.getVolumeName();
            bucketName = bucketInfo.getBucketName();
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            omBucketInfo = null;
            if (!bucketInfo.hasBucketLayout()) {
                BucketLayout defaultBucketLayout = ozoneManager.getOMDefaultBucketLayout();
                omBucketInfo = OmBucketInfo.getFromProtobuf((OzoneManagerProtocolProtos.BucketInfo)bucketInfo, (BucketLayout)defaultBucketLayout);
            } else {
                omBucketInfo = OmBucketInfo.getFromProtobuf((OzoneManagerProtocolProtos.BucketInfo)bucketInfo);
            }
            if (omBucketInfo.getBucketLayout().isFileSystemOptimized()) {
                omMetrics.incNumFSOBucketCreates();
            }
            auditLogger = ozoneManager.getAuditLogger();
            userInfo = this.getOmRequest().getUserInfo();
            String volumeKey = metadataManager.getVolumeKey(volumeName);
            String bucketKey = metadataManager.getBucketKey(volumeName, bucketName);
            exception = null;
            boolean acquiredBucketLock = false;
            boolean acquiredVolumeLock = false;
            omClientResponse = null;
            try {
                try {
                    if (ozoneManager.getAclsEnabled()) {
                        this.checkAcls(ozoneManager, OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.CREATE, volumeName, bucketName, null);
                    }
                    this.mergeOmLockDetails(metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName}));
                    acquiredVolumeLock = this.getOmLockDetails().isLockAcquired();
                    this.mergeOmLockDetails(metadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    acquiredBucketLock = this.getOmLockDetails().isLockAcquired();
                    OmVolumeArgs omVolumeArgs = (OmVolumeArgs)metadataManager.getVolumeTable().getReadCopy((Object)volumeKey);
                    if (omVolumeArgs == null) {
                        LOG.debug("volume: {} not found ", (Object)volumeName);
                        throw new OMException("Volume doesn't exist", OMException.ResultCodes.VOLUME_NOT_FOUND);
                    }
                    if (metadataManager.getBucketTable().isExist((Object)bucketKey)) {
                        LOG.debug("bucket: {} already exists ", (Object)bucketName);
                        throw new OMException("Bucket already exist", OMException.ResultCodes.BUCKET_ALREADY_EXISTS);
                    }
                    if (!bucketInfo.hasSourceBucket()) {
                        this.checkQuotaBytesValid(metadataManager, omVolumeArgs, omBucketInfo, volumeKey);
                    }
                    omBucketInfo.setObjectID(ozoneManager.getObjectIdFromTxId(transactionLogIndex));
                    omBucketInfo.setUpdateID(transactionLogIndex, ozoneManager.isRatisEnabled());
                    this.addDefaultAcls(omBucketInfo, omVolumeArgs);
                    this.checkQuotaInNamespace(omVolumeArgs, 1L);
                    omVolumeArgs.incrUsedNamespace(1L);
                    metadataManager.getVolumeTable().addCacheEntry(new CacheKey((Object)volumeKey), CacheValue.get((long)transactionLogIndex, (Object)omVolumeArgs));
                    metadataManager.getBucketTable().addCacheEntry(new CacheKey((Object)bucketKey), CacheValue.get((long)transactionLogIndex, (Object)omBucketInfo));
                    omResponse.setCreateBucketResponse(OzoneManagerProtocolProtos.CreateBucketResponse.newBuilder().build());
                    omClientResponse = new OMBucketCreateResponse(omResponse.build(), omBucketInfo, omVolumeArgs.copyObject());
                }
                catch (IOException | InvalidPathException ex) {
                    exception = ex;
                    omClientResponse = new OMBucketCreateResponse(this.createErrorOMResponse(omResponse, exception));
                    if (acquiredBucketLock) {
                        this.mergeOmLockDetails(metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    }
                    if (acquiredVolumeLock) {
                        this.mergeOmLockDetails(metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (acquiredBucketLock) {
                    this.mergeOmLockDetails(metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                }
                if (acquiredVolumeLock) {
                    this.mergeOmLockDetails(metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (acquiredBucketLock) {
                this.mergeOmLockDetails(metadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            }
            if (acquiredVolumeLock) {
                this.mergeOmLockDetails(metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        this.auditLog(auditLogger, this.buildAuditMessage(OMAction.CREATE_BUCKET, omBucketInfo.toAuditMap(), exception, userInfo));
        if (exception == null) {
            LOG.info("created bucket: {} of layout {} in volume: {}", new Object[]{bucketName, omBucketInfo.getBucketLayout(), volumeName});
            omMetrics.incNumBuckets();
            if (this.isECBucket(bucketInfo)) {
                omMetrics.incEcBucketsTotal();
            }
            return omClientResponse;
        }
        omMetrics.incNumBucketCreateFails();
        if (this.isECBucket(bucketInfo)) {
            omMetrics.incEcBucketCreateFailsTotal();
        }
        LOG.error("Bucket creation failed for bucket:{} in volume:{}", new Object[]{bucketName, volumeName, exception});
        return omClientResponse;
    }

    private boolean isECBucket(OzoneManagerProtocolProtos.BucketInfo bucketInfo) {
        return bucketInfo.hasDefaultReplicationConfig() && bucketInfo.getDefaultReplicationConfig().hasEcReplicationConfig();
    }

    private void addDefaultAcls(OmBucketInfo omBucketInfo, OmVolumeArgs omVolumeArgs) {
        ArrayList acls = new ArrayList();
        if (omBucketInfo.getAcls() != null) {
            acls.addAll(omBucketInfo.getAcls());
        }
        List defaultVolumeAcls = omVolumeArgs.getDefaultAcls();
        OzoneAclUtil.inheritDefaultAcls(acls, (List)defaultVolumeAcls);
        omBucketInfo.setAcls(acls);
    }

    private OzoneManagerProtocolProtos.BucketEncryptionInfoProto getBeinfo(KeyProviderCryptoExtension kmsProvider, OzoneManagerProtocolProtos.BucketInfo bucketInfo) throws IOException {
        OzoneManagerProtocolProtos.BucketEncryptionInfoProto bek = bucketInfo.getBeinfo();
        OzoneManagerProtocolProtos.BucketEncryptionInfoProto.Builder bekb = null;
        if (kmsProvider == null) {
            throw new OMException("Invalid KMS provider, check configuration hadoop.security.key.provider.path", OMException.ResultCodes.INVALID_KMS_PROVIDER);
        }
        if (bek.getKeyName() == null) {
            throw new OMException("Bucket encryption key needed.", OMException.ResultCodes.BUCKET_ENCRYPTION_KEY_NOT_FOUND);
        }
        KeyProvider.Metadata metadata = kmsProvider.getMetadata(bek.getKeyName());
        if (metadata == null) {
            throw new OMException("Bucket encryption key " + bek.getKeyName() + " doesn't exist.", OMException.ResultCodes.BUCKET_ENCRYPTION_KEY_NOT_FOUND);
        }
        kmsProvider.warmUpEncryptedKeys(new String[]{bek.getKeyName()});
        bekb = OzoneManagerProtocolProtos.BucketEncryptionInfoProto.newBuilder().setKeyName(bek.getKeyName()).setCryptoProtocolVersion(OzoneManagerProtocolProtos.CryptoProtocolVersionProto.ENCRYPTION_ZONES).setSuite(OMPBHelper.convert((CipherSuite)CipherSuite.convert((String)metadata.getCipher())));
        return bekb.build();
    }

    private void checkQuotaInNamespace(OmVolumeArgs omVolumeArgs, long allocatedNamespace) throws IOException {
        if (omVolumeArgs.getQuotaInNamespace() > 0L) {
            long toUseNamespaceInTotal;
            long usedNamespace = omVolumeArgs.getUsedNamespace();
            long quotaInNamespace = omVolumeArgs.getQuotaInNamespace();
            if (quotaInNamespace < (toUseNamespaceInTotal = usedNamespace + allocatedNamespace)) {
                throw new OMException("The namespace quota of Volume:" + omVolumeArgs.getVolume() + " exceeded: quotaInNamespace: " + quotaInNamespace + " but namespace consumed: " + toUseNamespaceInTotal + ".", OMException.ResultCodes.QUOTA_EXCEEDED);
            }
        }
    }

    public boolean checkQuotaBytesValid(OMMetadataManager metadataManager, OmVolumeArgs omVolumeArgs, OmBucketInfo omBucketInfo, String volumeKey) throws IOException {
        long quotaInBytes = omBucketInfo.getQuotaInBytes();
        long volumeQuotaInBytes = omVolumeArgs.getQuotaInBytes();
        if (volumeQuotaInBytes > 0L && quotaInBytes <= 0L) {
            throw new OMException("Bucket space quota in this volume should be set as volume space quota is already set.", OMException.ResultCodes.QUOTA_ERROR);
        }
        long totalBucketQuota = 0L;
        if (quotaInBytes <= 0L) {
            return false;
        }
        totalBucketQuota = quotaInBytes;
        List bucketList = metadataManager.listBuckets(omVolumeArgs.getVolume(), null, null, Integer.MAX_VALUE, false);
        for (OmBucketInfo bucketInfo : bucketList) {
            long nextQuotaInBytes = bucketInfo.getQuotaInBytes();
            if (nextQuotaInBytes <= -1L) continue;
            totalBucketQuota += nextQuotaInBytes;
        }
        if (volumeQuotaInBytes < totalBucketQuota && volumeQuotaInBytes != -1L) {
            throw new OMException("Total buckets quota in this volume should not be greater than volume quota : the total space quota is set to:" + totalBucketQuota + ". But the volume space quota is:" + volumeQuotaInBytes, OMException.ResultCodes.QUOTA_EXCEEDED);
        }
        return true;
    }

    @RequestFeatureValidator(conditions={ValidationCondition.CLUSTER_NEEDS_FINALIZATION}, processingPhase=RequestProcessingPhase.PRE_PROCESS, requestType=OzoneManagerProtocolProtos.Type.CreateBucket)
    public static OzoneManagerProtocolProtos.OMRequest disallowCreateBucketWithECReplicationConfig(OzoneManagerProtocolProtos.OMRequest req, ValidationContext ctx) throws OMException {
        if (!ctx.versionManager().isAllowed((LayoutFeature)OMLayoutFeature.ERASURE_CODED_STORAGE_SUPPORT) && req.getCreateBucketRequest().getBucketInfo().hasDefaultReplicationConfig() && req.getCreateBucketRequest().getBucketInfo().getDefaultReplicationConfig().hasEcReplicationConfig()) {
            throw new OMException("Cluster does not have the Erasure Coded Storage support feature finalized yet, but the request contains an Erasure Coded replication type. Rejecting the request, please finalize the cluster upgrade and then try again.", OMException.ResultCodes.NOT_SUPPORTED_OPERATION_PRIOR_FINALIZATION);
        }
        return req;
    }

    @RequestFeatureValidator(conditions={ValidationCondition.CLUSTER_NEEDS_FINALIZATION}, processingPhase=RequestProcessingPhase.PRE_PROCESS, requestType=OzoneManagerProtocolProtos.Type.CreateBucket)
    public static OzoneManagerProtocolProtos.OMRequest handleCreateBucketWithBucketLayoutDuringPreFinalize(OzoneManagerProtocolProtos.OMRequest req, ValidationContext ctx) throws OMException {
        if (!ctx.versionManager().isAllowed((LayoutFeature)OMLayoutFeature.BUCKET_LAYOUT_SUPPORT)) {
            if (req.getCreateBucketRequest().getBucketInfo().hasBucketLayout()) {
                if (!BucketLayout.fromProto((OzoneManagerProtocolProtos.BucketLayoutProto)req.getCreateBucketRequest().getBucketInfo().getBucketLayout()).isLegacy()) {
                    throw new OMException("Cluster does not have the Bucket Layout support feature finalized yet, but the request contains a non LEGACY bucket type. Rejecting the request, please finalize the cluster upgrade and then try again.", OMException.ResultCodes.NOT_SUPPORTED_OPERATION_PRIOR_FINALIZATION);
                }
            } else {
                return OMBucketCreateRequest.changeBucketLayout(req, BucketLayout.LEGACY);
            }
        }
        return req;
    }

    @RequestFeatureValidator(conditions={ValidationCondition.OLDER_CLIENT_REQUESTS}, processingPhase=RequestProcessingPhase.PRE_PROCESS, requestType=OzoneManagerProtocolProtos.Type.CreateBucket)
    public static OzoneManagerProtocolProtos.OMRequest setDefaultBucketLayoutForOlderClients(OzoneManagerProtocolProtos.OMRequest req, ValidationContext ctx) {
        if (ClientVersion.fromProtoValue((int)req.getVersion()).compareTo((Enum)ClientVersion.BUCKET_LAYOUT_SUPPORT) < 0) {
            return OMBucketCreateRequest.changeBucketLayout(req, BucketLayout.LEGACY);
        }
        return req;
    }

    private static OzoneManagerProtocolProtos.OMRequest changeBucketLayout(OzoneManagerProtocolProtos.OMRequest originalRequest, BucketLayout newLayout) {
        OzoneManagerProtocolProtos.CreateBucketRequest createBucketRequest = originalRequest.getCreateBucketRequest();
        OzoneManagerProtocolProtos.BucketInfo newBucketInfo = createBucketRequest.getBucketInfo().toBuilder().setBucketLayout(newLayout.toProto()).build();
        OzoneManagerProtocolProtos.CreateBucketRequest newCreateRequest = createBucketRequest.toBuilder().setBucketInfo(newBucketInfo).build();
        return originalRequest.toBuilder().setCreateBucketRequest(newCreateRequest).build();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMBucketCreateRequest.java", OMBucketCreateRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.bucket.OMBucketCreateRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 90);
    }
}

