/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.ratis.metrics;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;

@Metrics(about="OzoneManagerStateMachine Metrics", context="ozone")
public final class OzoneManagerStateMachineMetrics
implements MetricsSource {
    private static final String SOURCE_NAME = OzoneManagerStateMachineMetrics.class.getSimpleName();
    private MetricsRegistry registry = new MetricsRegistry(SOURCE_NAME);
    private static OzoneManagerStateMachineMetrics instance;
    @Metric(about="Number of apply transactions in applyTransactionMap.")
    private MutableCounterLong applyTransactionMapSize;
    @Metric(about="Number of ratis transactions in ratisTransactionMap.")
    private MutableCounterLong ratisTransactionMapSize;

    private OzoneManagerStateMachineMetrics() {
    }

    public static synchronized OzoneManagerStateMachineMetrics create() {
        if (instance != null) {
            return instance;
        }
        MetricsSystem ms = DefaultMetricsSystem.instance();
        OzoneManagerStateMachineMetrics metrics = new OzoneManagerStateMachineMetrics();
        instance = (OzoneManagerStateMachineMetrics)ms.register(SOURCE_NAME, "OzoneManager StateMachine Metrics", (Object)metrics);
        return instance;
    }

    @VisibleForTesting
    public long getApplyTransactionMapSize() {
        return this.applyTransactionMapSize.value();
    }

    @VisibleForTesting
    public long getRatisTransactionMapSize() {
        return this.ratisTransactionMapSize.value();
    }

    public void updateApplyTransactionMapSize(long size) {
        this.applyTransactionMapSize.incr(Math.negateExact(this.applyTransactionMapSize.value()) + size);
    }

    public void updateRatisTransactionMapSize(long size) {
        this.ratisTransactionMapSize.incr(Math.negateExact(this.ratisTransactionMapSize.value()) + size);
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder rb = collector.addRecord(SOURCE_NAME);
        this.applyTransactionMapSize.snapshot(rb, all);
        this.ratisTransactionMapSize.snapshot(rb, all);
        rb.endRecord();
    }
}

