/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class ResolvedBucket {
    private final String requestedVolume;
    private final String requestedBucket;
    private final String realVolume;
    private final String realBucket;
    private final String bucketOwner;
    private final BucketLayout bucketLayout;

    public ResolvedBucket(String requestedVolume, String requestedBucket, OmBucketInfo resolved) {
        this.requestedVolume = requestedVolume;
        this.requestedBucket = requestedBucket;
        if (resolved != null) {
            this.realVolume = resolved.getVolumeName();
            this.realBucket = resolved.getBucketName();
            this.bucketOwner = resolved.getOwner();
            this.bucketLayout = resolved.getBucketLayout();
        } else {
            this.realVolume = null;
            this.realBucket = null;
            this.bucketOwner = null;
            this.bucketLayout = null;
        }
    }

    public ResolvedBucket(String requestedVolume, String requestedBucket, String realVolume, String realBucket, String bucketOwner, BucketLayout bucketLayout) {
        this.requestedVolume = requestedVolume;
        this.requestedBucket = requestedBucket;
        this.realVolume = realVolume;
        this.realBucket = realBucket;
        this.bucketOwner = bucketOwner;
        this.bucketLayout = bucketLayout;
    }

    public ResolvedBucket(Pair<String, String> requested, Pair<String, String> real, String owner, BucketLayout bucketLayout) {
        this((String)requested.getLeft(), (String)requested.getRight(), (String)real.getLeft(), (String)real.getRight(), owner, bucketLayout);
    }

    public String requestedVolume() {
        return this.requestedVolume;
    }

    public String requestedBucket() {
        return this.requestedBucket;
    }

    public String realVolume() {
        return this.realVolume;
    }

    public String realBucket() {
        return this.realBucket;
    }

    public String bucketOwner() {
        return this.bucketOwner;
    }

    public BucketLayout bucketLayout() {
        return this.bucketLayout;
    }

    public OmKeyArgs update(OmKeyArgs args) {
        return this.isLink() ? args.toBuilder().setVolumeName(this.realVolume()).setBucketName(this.realBucket()).build() : args;
    }

    public OzoneManagerProtocolProtos.KeyArgs update(OzoneManagerProtocolProtos.KeyArgs args) {
        return this.isLink() ? args.toBuilder().setVolumeName(this.realVolume()).setBucketName(this.realBucket()).build() : args;
    }

    public boolean isLink() {
        return !Objects.equals(this.requestedVolume, this.realVolume) || !Objects.equals(this.requestedBucket, this.realBucket);
    }

    public boolean isDangling() {
        return this.realVolume == null || this.realBucket == null;
    }

    public Map<String, String> audit() {
        return this.audit(new LinkedHashMap<String, String>());
    }

    public Map<String, String> audit(Map<String, String> auditMap) {
        auditMap.putIfAbsent("volume", this.requestedVolume());
        auditMap.putIfAbsent("bucket", this.requestedBucket());
        if (this.isLink()) {
            auditMap.put("sourceVolume", this.realVolume());
            auditMap.put("sourceBucket", this.realBucket());
        }
        return auditMap;
    }
}

