/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.client.DefaultReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.ozone.om.ListIterator;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzoneListStatusHelper {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneListStatusHelper.class);
    private final OMMetadataManager metadataManager;
    private final long scmBlockSize;
    private final GetFileStatusHelper getStatusHelper;
    private final ReplicationConfig omDefaultReplication;

    OzoneListStatusHelper(OMMetadataManager metadataManager, long scmBlockSize, GetFileStatusHelper func, ReplicationConfig omDefaultReplication) {
        this.metadataManager = metadataManager;
        this.scmBlockSize = scmBlockSize;
        this.getStatusHelper = func;
        this.omDefaultReplication = omDefaultReplication;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<OzoneFileStatus> listStatusFSO(OmKeyArgs args, String startKey, long numEntries, String clientAddress, boolean allowPartialPrefixes) throws IOException {
        String startKeyPrefix;
        String dbPrefixKey;
        OmBucketInfo omBucketInfo;
        String prefixKey;
        String bucketName;
        String volumeName;
        block25: {
            OzoneFileStatus fileStatus;
            String keyName;
            Preconditions.checkNotNull((Object)args, (Object)"Key args can not be null");
            volumeName = args.getVolumeName();
            bucketName = args.getBucketName();
            prefixKey = keyName = args.getKeyName();
            String volumeKey = this.metadataManager.getVolumeKey(volumeName);
            String bucketKey = this.metadataManager.getBucketKey(volumeName, bucketName);
            OmVolumeArgs volumeInfo = (OmVolumeArgs)this.metadataManager.getVolumeTable().get((Object)volumeKey);
            omBucketInfo = (OmBucketInfo)this.metadataManager.getBucketTable().get((Object)bucketKey);
            if (volumeInfo == null || omBucketInfo == null) {
                if (!LOG.isDebugEnabled()) return new ArrayList<OzoneFileStatus>();
                LOG.debug(String.format("%s does not exist.", volumeInfo == null ? "Volume : " + volumeName : "Bucket: " + volumeName + "/" + bucketName));
                return new ArrayList<OzoneFileStatus>();
            }
            if (StringUtils.isNotBlank((CharSequence)startKey)) {
                if (StringUtils.isNotBlank((CharSequence)keyName)) {
                    if (!OzoneFSUtils.isSibling((String)keyName, (String)startKey) && !OzoneFSUtils.isImmediateChild((String)keyName, (String)startKey)) {
                        if (!LOG.isDebugEnabled()) return new ArrayList<OzoneFileStatus>();
                        LOG.debug("StartKey {} is not an immediate child or not a sibling of keyName {}. Returns empty list", (Object)startKey, (Object)keyName);
                        return new ArrayList<OzoneFileStatus>();
                    }
                } else {
                    prefixKey = keyName = OzoneFSUtils.getParentDir((String)startKey);
                    args = args.toBuilder().setKeyName(keyName).setSortDatanodesInPipeline(false).build();
                }
            }
            if ((fileStatus = this.getStatusHelper.apply(args, clientAddress, allowPartialPrefixes)) == null) {
                try {
                    dbPrefixKey = this.getDbKey(keyName, args, volumeInfo, omBucketInfo);
                    prefixKey = OzoneFSUtils.getParentDir((String)keyName);
                }
                catch (OMException ome) {
                    if (ome.getResult() != OMException.ResultCodes.FILE_NOT_FOUND) throw ome;
                    if (!LOG.isDebugEnabled()) return new ArrayList<OzoneFileStatus>();
                    LOG.debug("Parent directory of keyName:{} does not exist.Returns empty list", (Object)keyName);
                    return new ArrayList<OzoneFileStatus>();
                }
            } else {
                if (fileStatus.isFile()) {
                    return Collections.singletonList(fileStatus);
                }
                long id = this.getId(fileStatus, omBucketInfo);
                long volumeId = volumeInfo.getObjectID();
                long bucketId = omBucketInfo.getObjectID();
                dbPrefixKey = this.metadataManager.getOzonePathKey(volumeId, bucketId, id, "");
            }
            startKeyPrefix = "";
            try {
                if (!Strings.isNullOrEmpty((String)startKey)) {
                    startKeyPrefix = this.getDbKey(startKey, args, volumeInfo, omBucketInfo);
                }
            }
            catch (OMException ome) {
                if (ome.getResult() == OMException.ResultCodes.FILE_NOT_FOUND) break block25;
                throw ome;
            }
        }
        TreeMap<String, OzoneFileStatus> map = new TreeMap<String, OzoneFileStatus>();
        BucketLayout bucketLayout = omBucketInfo.getBucketLayout();
        ReplicationConfig replication = Optional.ofNullable(omBucketInfo.getDefaultReplicationConfig()).map(DefaultReplicationConfig::getReplicationConfig).orElse(this.omDefaultReplication);
        Throwable throwable = null;
        Object var22_27 = null;
        try (ListIterator.MinHeapIterator heapIterator = new ListIterator.MinHeapIterator(this.metadataManager, dbPrefixKey, bucketLayout, startKeyPrefix, volumeName, bucketName);){
            try {
                while ((long)map.size() < numEntries) {
                    if (!heapIterator.hasNext()) {
                        return map.values().stream().filter(e -> e != null).collect(Collectors.toList());
                    }
                    ListIterator.HeapEntry entry = heapIterator.next();
                    OzoneFileStatus status = this.getStatus(prefixKey, this.scmBlockSize, volumeName, bucketName, replication, entry);
                    if (map.containsKey(entry.getKey())) continue;
                    map.put(entry.getKey(), status);
                }
                return map.values().stream().filter(e -> e != null).collect(Collectors.toList());
            }
            catch (NoSuchElementException e2) {
                throw new IOException(e2);
            }
            catch (UncheckedIOException e3) {
                throw e3.getCause();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private OzoneFileStatus getStatus(String prefixPath, long scmBlockSz, String volumeName, String bucketName, ReplicationConfig bucketReplication, ListIterator.HeapEntry entry) {
        OmKeyInfo keyInfo;
        if (entry == null || entry.getValue() == null) {
            return null;
        }
        Object value = entry.getValue();
        boolean isDir = "directoryTable".equals(entry.getTableName());
        if (isDir) {
            Preconditions.checkArgument((boolean)(value instanceof OmDirectoryInfo));
            OmDirectoryInfo dirInfo = (OmDirectoryInfo)value;
            String dirName = OMFileRequest.getAbsolutePath(prefixPath, dirInfo.getName());
            keyInfo = OMFileRequest.getOmKeyInfo(volumeName, bucketName, dirInfo, dirName);
            keyInfo.setReplicationConfig(bucketReplication);
        } else {
            Preconditions.checkArgument((boolean)(value instanceof OmKeyInfo));
            keyInfo = (OmKeyInfo)value;
            keyInfo.setFileName(keyInfo.getKeyName());
            String fullKeyPath = OMFileRequest.getAbsolutePath(prefixPath, keyInfo.getKeyName());
            keyInfo.setKeyName(fullKeyPath);
        }
        return new OzoneFileStatus(keyInfo, scmBlockSz, isDir);
    }

    private String getDbKey(String key, OmKeyArgs args, OmVolumeArgs volumeInfo, OmBucketInfo omBucketInfo) throws IOException {
        String parent = OzoneFSUtils.getParentDir((String)key);
        OmKeyArgs startKeyArgs = args.toBuilder().setKeyName(parent).setSortDatanodesInPipeline(false).build();
        OzoneFileStatus fileStatusInfo = this.getStatusHelper.apply(startKeyArgs, null, false);
        Preconditions.checkNotNull((Object)fileStatusInfo);
        long startKeyParentId = this.getId(fileStatusInfo, omBucketInfo);
        long volumeId = volumeInfo.getObjectID();
        long bucketId = omBucketInfo.getObjectID();
        return this.metadataManager.getOzonePathKey(volumeId, bucketId, startKeyParentId, OzoneFSUtils.getFileName((String)key));
    }

    private long getId(OzoneFileStatus fileStatus, OmBucketInfo omBucketInfo) {
        if (fileStatus.getKeyInfo() != null) {
            return fileStatus.getKeyInfo().getObjectID();
        }
        return omBucketInfo.getObjectID();
    }

    @FunctionalInterface
    public static interface GetFileStatusHelper {
        public OzoneFileStatus apply(OmKeyArgs var1, String var2, boolean var3) throws IOException;
    }
}

