/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.security;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.ha.SCMRatisServer;
import org.apache.hadoop.hdds.scm.ha.SCMService;
import org.apache.hadoop.hdds.scm.security.ScmSecretKeyStateBuilder;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.symmetric.LocalSecretKeyStore;
import org.apache.hadoop.hdds.security.symmetric.SecretKeyConfig;
import org.apache.hadoop.hdds.security.symmetric.SecretKeyManager;
import org.apache.hadoop.hdds.security.symmetric.SecretKeyState;
import org.apache.hadoop.hdds.security.symmetric.SecretKeyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretKeyManagerService
implements SCMService,
Runnable {
    public static final Logger LOG = LoggerFactory.getLogger(SecretKeyManagerService.class);
    private static final String SERVICE_NAME = SecretKeyManagerService.class.getSimpleName();
    private final SCMContext scmContext;
    private final SecretKeyManager secretKeyManager;
    private final SecretKeyConfig secretKeyConfig;
    private final Lock serviceLock = new ReentrantLock();
    private SCMService.ServiceStatus serviceStatus = SCMService.ServiceStatus.PAUSING;
    private final ScheduledExecutorService scheduler;

    public SecretKeyManagerService(SCMContext scmContext, ConfigurationSource conf, SCMRatisServer ratisServer) {
        this.scmContext = scmContext;
        this.secretKeyConfig = new SecretKeyConfig(conf, "scm");
        LocalSecretKeyStore secretKeyStore = new LocalSecretKeyStore(this.secretKeyConfig.getLocalSecretKeyFile());
        SecretKeyState secretKeyState = new ScmSecretKeyStateBuilder().setSecretKeyStore((SecretKeyStore)secretKeyStore).setRatisServer(ratisServer).build();
        this.secretKeyManager = new SecretKeyManager(secretKeyState, (SecretKeyStore)secretKeyStore, this.secretKeyConfig);
        this.scheduler = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat(scmContext.threadNamePrefix() + this.getServiceName()).build());
        this.start();
    }

    @Override
    public void notifyStatusChanged() {
        this.serviceLock.lock();
        try {
            if (this.scmContext.isLeaderReady()) {
                if (!this.secretKeyManager.isInitialized()) {
                    this.scheduler.schedule(() -> {
                        try {
                            this.secretKeyManager.checkAndInitialize();
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Error replicating initialized state.", e);
                        }
                    }, 0L, TimeUnit.SECONDS);
                }
                this.serviceStatus = SCMService.ServiceStatus.RUNNING;
            } else {
                this.serviceStatus = SCMService.ServiceStatus.PAUSING;
            }
        }
        finally {
            this.serviceLock.unlock();
        }
    }

    @Override
    public boolean shouldRun() {
        this.serviceLock.lock();
        try {
            boolean bl = this.serviceStatus == SCMService.ServiceStatus.RUNNING;
            return bl;
        }
        finally {
            this.serviceLock.unlock();
        }
    }

    @Override
    public void run() {
        if (!this.shouldRun()) {
            return;
        }
        try {
            this.secretKeyManager.checkAndRotate(false);
        }
        catch (Exception e) {
            LOG.error("Error occurred when updating SecretKeys.", (Throwable)e);
        }
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public void start() {
        LOG.info("Scheduling rotation checker with interval {}", (Object)this.secretKeyConfig.getRotationCheckDuration());
        this.scheduler.scheduleAtFixedRate(this, 0L, this.secretKeyConfig.getRotationCheckDuration().toMillis(), TimeUnit.MILLISECONDS);
    }

    public SecretKeyManager getSecretKeyManager() {
        return this.secretKeyManager;
    }

    @Override
    public void stop() {
        this.scheduler.shutdownNow();
    }

    public static boolean isSecretKeyEnable(SecurityConfig conf) {
        return conf.isSecurityEnabled() && (conf.isBlockTokenEnabled() || conf.isContainerTokenEnabled());
    }
}

