/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node;

import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartDatanodeAdminHandler
implements EventHandler<DatanodeDetails> {
    private static final Logger LOG = LoggerFactory.getLogger(StartDatanodeAdminHandler.class);
    private final NodeManager nodeManager;
    private final PipelineManager pipelineManager;

    public StartDatanodeAdminHandler(NodeManager nodeManager, PipelineManager pipelineManager) {
        this.nodeManager = nodeManager;
        this.pipelineManager = pipelineManager;
    }

    public void onMessage(DatanodeDetails datanodeDetails, EventPublisher publisher) {
        Set<PipelineID> pipelineIds = this.nodeManager.getPipelines(datanodeDetails);
        LOG.info("Admin start on datanode {}. Finalizing its pipelines {}", (Object)datanodeDetails, pipelineIds);
        for (PipelineID pipelineID : pipelineIds) {
            try {
                this.pipelineManager.closePipeline(pipelineID);
            }
            catch (IOException e) {
                LOG.info("Could not finalize pipeline={} for dn={}", (Object)pipelineID, (Object)datanodeDetails);
            }
        }
    }
}

