/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node;

import java.util.Comparator;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMNodeStat;

public class DatanodeUsageInfo {
    private DatanodeDetails datanodeDetails;
    private SCMNodeStat scmNodeStat;
    private int containerCount;

    public DatanodeUsageInfo(DatanodeDetails datanodeDetails, SCMNodeStat scmNodeStat) {
        this.datanodeDetails = datanodeDetails;
        this.scmNodeStat = scmNodeStat;
        this.containerCount = -1;
    }

    private static int compareByUtilization(DatanodeUsageInfo first, DatanodeUsageInfo second) {
        if (first.equals(second)) {
            return 0;
        }
        return Double.compare(first.calculateUtilization(), second.calculateUtilization());
    }

    public double calculateUtilization(long plusSize) {
        long capacity = this.scmNodeStat.getCapacity().get();
        if (capacity == 0L) {
            return 0.0;
        }
        long numerator = capacity - this.scmNodeStat.getRemaining().get() + plusSize;
        return (double)numerator / (double)capacity;
    }

    public double calculateUtilization() {
        return this.calculateUtilization(0L);
    }

    public void setDatanodeDetails(DatanodeDetails datanodeDetails) {
        this.datanodeDetails = datanodeDetails;
    }

    public void setScmNodeStat(SCMNodeStat scmNodeStat) {
        this.scmNodeStat = scmNodeStat;
    }

    public DatanodeDetails getDatanodeDetails() {
        return this.datanodeDetails;
    }

    public SCMNodeStat getScmNodeStat() {
        return this.scmNodeStat;
    }

    public int getContainerCount() {
        return this.containerCount;
    }

    public void setContainerCount(int containerCount) {
        this.containerCount = containerCount;
    }

    public static Comparator<DatanodeUsageInfo> getMostUtilized() {
        return DatanodeUsageInfo::compareByUtilization;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatanodeUsageInfo that = (DatanodeUsageInfo)o;
        return this.datanodeDetails.equals((Object)that.datanodeDetails);
    }

    public int hashCode() {
        return this.datanodeDetails.hashCode();
    }

    public HddsProtos.DatanodeUsageInfoProto toProto(int clientVersion) {
        return this.toProtoBuilder(clientVersion).build();
    }

    private HddsProtos.DatanodeUsageInfoProto.Builder toProtoBuilder(int clientVersion) {
        HddsProtos.DatanodeUsageInfoProto.Builder builder = HddsProtos.DatanodeUsageInfoProto.newBuilder();
        if (this.datanodeDetails != null) {
            builder.setNode(this.datanodeDetails.toProto(clientVersion));
        }
        if (this.scmNodeStat != null) {
            builder.setCapacity(this.scmNodeStat.getCapacity().get().longValue());
            builder.setUsed(this.scmNodeStat.getScmUsed().get().longValue());
            builder.setRemaining(this.scmNodeStat.getRemaining().get().longValue());
            builder.setCommitted(this.scmNodeStat.getCommitted().get().longValue());
            builder.setFreeSpaceToSpare(this.scmNodeStat.getFreeSpaceToSpare().get().longValue());
        }
        builder.setContainerCount((long)this.containerCount);
        return builder;
    }
}

