/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.conf.ConfigurationException;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.DefaultConfigManager;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.scm.ScmUtils;
import org.apache.hadoop.hdds.scm.ha.SCMHAUtils;
import org.apache.hadoop.hdds.scm.ha.SCMNodeDetails;
import org.apache.hadoop.hdds.scm.server.SCMStorageConfig;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.ozone.common.Storage;
import org.apache.hadoop.ozone.ha.ConfUtils;
import org.apache.hadoop.ozone.util.OzoneNetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMHANodeDetails {
    public static final Logger LOG = LoggerFactory.getLogger(SCMHANodeDetails.class);
    private final SCMNodeDetails localNodeDetails;
    private final List<SCMNodeDetails> peerNodeDetails;
    private static String[] nodeSpecificConfigKeys = new String[]{"ozone.scm.datanode.address", "ozone.scm.datanode.port", "ozone.scm.datanode.bind.host", "ozone.scm.block.client.address", "ozone.scm.block.client.port", "ozone.scm.block.client.bind.host", "ozone.scm.client.address", "ozone.scm.client.port", "ozone.scm.client.bind.host", "ozone.scm.security.service.address", "ozone.scm.security.service.port", "ozone.scm.security.service.bind.host", "ozone.scm.ratis.port", "ozone.scm.grpc.port", "ozone.scm.http-bind-host", "ozone.scm.https-bind-host", "ozone.scm.http-address", "ozone.scm.https-address", "ozone.scm.db.dirs", "ozone.scm.address"};

    public SCMHANodeDetails(SCMNodeDetails localNodeDetails, List<SCMNodeDetails> peerNodeDetails) {
        this.localNodeDetails = localNodeDetails;
        this.peerNodeDetails = peerNodeDetails;
    }

    public SCMNodeDetails getLocalNodeDetails() {
        return this.localNodeDetails;
    }

    public List<SCMNodeDetails> getPeerNodeDetails() {
        return this.peerNodeDetails;
    }

    public static SCMHANodeDetails loadDefaultConfig(OzoneConfiguration conf) throws IOException {
        int ratisPort = conf.getInt("ozone.scm.ratis.port", 9894);
        int grpcPort = conf.getInt("ozone.scm.grpc.port", 9895);
        InetSocketAddress rpcAddress = new InetSocketAddress(InetAddress.getLocalHost(), 0);
        SCMNodeDetails scmNodeDetails = new SCMNodeDetails.Builder().setRatisPort(ratisPort).setGrpcPort(grpcPort).setRpcAddress(rpcAddress).setDatanodeProtocolServerAddress(HddsServerUtil.getScmDataNodeBindAddress((ConfigurationSource)conf)).setDatanodeAddressKey("ozone.scm.datanode.address").setBlockProtocolServerAddress(HddsServerUtil.getScmBlockClientBindAddress((ConfigurationSource)conf)).setBlockProtocolServerAddressKey("ozone.scm.block.client.address").setClientProtocolServerAddress(HddsServerUtil.getScmClientBindAddress((ConfigurationSource)conf)).setClientProtocolServerAddressKey("ozone.scm.client.address").build();
        return new SCMHANodeDetails(scmNodeDetails, Collections.emptyList());
    }

    private static void validateSCMHAConfig(SCMStorageConfig scmStorageConfig, OzoneConfiguration conf) {
        Storage.StorageState state = scmStorageConfig.getState();
        boolean scmHAEnableDefault = state == Storage.StorageState.INITIALIZED ? scmStorageConfig.isSCMHAEnabled() : SCMHAUtils.isSCMHAEnabled((ConfigurationSource)conf);
        boolean scmHAEnabled = SCMHAUtils.isSCMHAEnabled((ConfigurationSource)conf);
        if (Storage.StorageState.INITIALIZED.equals((Object)state) && scmHAEnabled != scmHAEnableDefault) {
            String errorMessage = String.format("Current State of SCM: %s", scmHAEnableDefault ? "Ratis SCM is enabled " : "SCM is running in Non-HA without Ratis") + " Ratis SCM -> Non Ratis SCM or Non HA SCM -> HA SCM is not supported";
            if (StringUtils.isNotEmpty((CharSequence)conf.get("ozone.scm.ratis.enable"))) {
                throw new ConfigurationException(String.format("Invalid Config %s Provided ConfigValue: %s, Expected Config Value: %s. %s", "ozone.scm.ratis.enable", scmHAEnabled, scmHAEnableDefault, errorMessage));
            }
            LOG.warn("Invalid config {}. The config was not specified, but the default value {} conflicts with the expected config value {}. Falling back to the expected value. {}", new Object[]{"ozone.scm.ratis.enable", true, scmHAEnableDefault, errorMessage});
        }
        DefaultConfigManager.setConfigValue((String)"ozone.scm.ratis.enable", (Object)scmHAEnableDefault);
    }

    public static SCMHANodeDetails loadSCMHAConfig(OzoneConfiguration conf, SCMStorageConfig storageConfig) throws IOException {
        Collection<String> scmServiceIds;
        InetSocketAddress localRpcAddress = null;
        String localScmServiceId = null;
        String localScmNodeId = null;
        int localRatisPort = 0;
        int localGrpcPort = 0;
        localScmServiceId = conf.getTrimmed("ozone.scm.default.service.id");
        LOG.info("ServiceID for StorageContainerManager is {}", (Object)localScmServiceId);
        SCMHANodeDetails.validateSCMHAConfig(storageConfig, conf);
        if (localScmServiceId == null) {
            LOG.info("{} is not defined, falling back to {} to find serviceID for StorageContainerManager if it is HA enabled cluster", (Object)"ozone.scm.default.service.id", (Object)"ozone.scm.service.ids");
            scmServiceIds = conf.getTrimmedStringCollection("ozone.scm.service.ids");
        } else {
            LOG.info("ServiceID for StorageContainerManager is {}", (Object)localScmServiceId);
            scmServiceIds = Collections.singleton(localScmServiceId);
        }
        localScmNodeId = conf.get("ozone.scm.node.id");
        int found = 0;
        boolean isSCMddressSet = false;
        for (String serviceId : scmServiceIds) {
            Collection scmNodeIds = SCMHAUtils.getSCMNodeIds((ConfigurationSource)conf, (String)serviceId);
            if (scmNodeIds.size() == 0) {
                throw new IllegalArgumentException(String.format("Configuration does not have any value set for %s for the service %s. List of SCM Node ID's should be specified for an SCM service", "ozone.scm.nodes", serviceId));
            }
            ArrayList<SCMNodeDetails> peerNodesList = new ArrayList<SCMNodeDetails>();
            for (String nodeId : scmNodeIds) {
                boolean isPeer = localScmNodeId != null && !localScmNodeId.equals(nodeId);
                String rpcAddrKey = ConfUtils.addKeySuffixes((String)"ozone.scm.address", (String[])new String[]{serviceId, nodeId});
                String rpcAddrStr = conf.get(rpcAddrKey);
                if (rpcAddrStr == null || rpcAddrStr.isEmpty()) {
                    SCMHANodeDetails.throwConfException("Configuration does not have any value set for %s. SCM RPC Address should be set for all nodes in a SCM service.", rpcAddrKey);
                }
                isSCMddressSet = true;
                String ratisPortKey = ConfUtils.addKeySuffixes((String)"ozone.scm.ratis.port", (String[])new String[]{serviceId, nodeId});
                int ratisPort = conf.getInt(ratisPortKey, conf.getInt("ozone.scm.ratis.port", 9894));
                String grpcPortKey = ConfUtils.addKeySuffixes((String)"ozone.scm.grpc.port", (String[])new String[]{serviceId, nodeId});
                int grpcPort = conf.getInt(grpcPortKey, conf.getInt("ozone.scm.grpc.port", 9895));
                InetSocketAddress addr = null;
                try {
                    addr = NetUtils.createSocketAddr((String)rpcAddrStr, (int)ratisPort);
                }
                catch (Exception e) {
                    LOG.error("Couldn't create socket address for SCM {} : {}", new Object[]{nodeId, rpcAddrStr, e});
                    throw e;
                }
                boolean flexibleFqdnResolutionEnabled = conf.getBoolean("ozone.network.flexible.fqdn.resolution.enabled", false);
                if (OzoneNetUtils.isUnresolved((boolean)flexibleFqdnResolutionEnabled, (InetSocketAddress)addr)) {
                    LOG.error("Address for SCM {} : {} couldn't be resolved. Proceeding with unresolved host to create Ratis ring.", (Object)nodeId, (Object)rpcAddrStr);
                }
                if (!isPeer && OzoneNetUtils.isAddressLocal((boolean)flexibleFqdnResolutionEnabled, (InetSocketAddress)addr)) {
                    localRpcAddress = addr;
                    localScmServiceId = serviceId;
                    localScmNodeId = nodeId;
                    localRatisPort = ratisPort;
                    localGrpcPort = grpcPort;
                    ++found;
                    continue;
                }
                peerNodesList.add(SCMHANodeDetails.getHASCMNodeDetails(conf, serviceId, nodeId, addr, ratisPort, grpcPort));
            }
            if (found == 1) {
                LOG.info("Found matching SCM address with SCMServiceId: {}, SCMNodeId: {}, RPC Address: {} and Ratis port: {}", new Object[]{localScmServiceId, localScmNodeId, NetUtils.getHostPortString(localRpcAddress), localRatisPort});
                ConfUtils.setNodeSpecificConfigs((String[])nodeSpecificConfigKeys, (OzoneConfiguration)conf, (String)localScmServiceId, (String)localScmNodeId, (Logger)LOG);
                return new SCMHANodeDetails(SCMHANodeDetails.getHASCMNodeDetails(conf, localScmServiceId, localScmNodeId, localRpcAddress, localRatisPort, localGrpcPort), peerNodesList);
            }
            if (found <= true) continue;
            SCMHANodeDetails.throwConfException("Configuration has multiple %s addresses that match local node's address. Please configure the system with %s and %s", "ozone.scm.address", "ozone.scm.service.ids", "ozone.scm.address");
        }
        if (!isSCMddressSet) {
            return SCMHANodeDetails.loadDefaultConfig(conf);
        }
        return null;
    }

    public static SCMNodeDetails getHASCMNodeDetails(OzoneConfiguration conf, String localScmServiceId, String localScmNodeId, InetSocketAddress rpcAddress, int ratisPort, int grpcPort) {
        Preconditions.checkNotNull((Object)localScmServiceId);
        Preconditions.checkNotNull((Object)localScmNodeId);
        SCMNodeDetails.Builder builder = new SCMNodeDetails.Builder();
        builder.setRpcAddress(rpcAddress).setRatisPort(ratisPort).setGrpcPort(grpcPort).setSCMServiceId(localScmServiceId).setSCMNodeId(localScmNodeId).setBlockProtocolServerAddress(ScmUtils.getScmBlockProtocolServerAddress(conf, localScmServiceId, localScmNodeId)).setBlockProtocolServerAddressKey(ScmUtils.getScmBlockProtocolServerAddressKey(localScmServiceId, localScmNodeId)).setClientProtocolServerAddress(ScmUtils.getClientProtocolServerAddress(conf, localScmServiceId, localScmNodeId)).setClientProtocolServerAddressKey(ScmUtils.getClientProtocolServerAddressKey(localScmServiceId, localScmNodeId)).setDatanodeProtocolServerAddress(ScmUtils.getScmDataNodeBindAddress((ConfigurationSource)conf, localScmServiceId, localScmNodeId)).setDatanodeAddressKey(ScmUtils.getScmDataNodeBindAddressKey(localScmServiceId, localScmNodeId));
        return builder.build();
    }

    private static void throwConfException(String message, String ... arguments) throws IllegalArgumentException {
        String exceptionMsg = String.format(message, arguments);
        LOG.error(exceptionMsg);
        throw new IllegalArgumentException(exceptionMsg);
    }
}

