/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.security.cert.X509Certificate;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.ratis.RatisHelper;
import org.apache.hadoop.hdds.scm.ha.SCMRatisResponse;
import org.apache.hadoop.hdds.scm.proxy.SCMClientConfig;
import org.apache.hadoop.hdds.scm.proxy.SCMSecurityProtocolFailoverProxyProvider;
import org.apache.hadoop.hdds.scm.server.SCMStorageConfig;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.ssl.KeyStoresFactory;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CAType;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CertificateServer;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CertificateStore;
import org.apache.hadoop.hdds.security.x509.certificate.authority.DefaultCAServer;
import org.apache.hadoop.hdds.security.x509.certificate.authority.profile.PKIProfile;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.security.x509.certificate.client.SCMCertificateClient;
import org.apache.hadoop.ozone.OzoneConsts;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.retry.RetryPolicies;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HASecurityUtils {
    public static final Logger LOG = LoggerFactory.getLogger(HASecurityUtils.class);

    private HASecurityUtils() {
    }

    public static void initializeSecurity(SCMStorageConfig scmStorageConfig, OzoneConfiguration conf, String scmHostname, boolean primaryscm) throws IOException {
        LOG.info("Initializing secure StorageContainerManager.");
        SecurityConfig securityConfig = new SecurityConfig((ConfigurationSource)conf);
        SCMSecurityProtocolClientSideTranslatorPB scmSecurityClient = HASecurityUtils.getScmSecurityClientWithFixedDuration(conf);
        try (SCMCertificateClient certClient = new SCMCertificateClient(securityConfig, scmSecurityClient, scmStorageConfig.getScmId(), scmStorageConfig.getClusterID(), scmStorageConfig.getScmCertSerialId(), scmHostname, primaryscm, certIDString -> {
            try {
                scmStorageConfig.setScmCertSerialId((String)certIDString);
            }
            catch (IOException e) {
                LOG.error("Failed to set new certificate ID", (Throwable)e);
                throw new RuntimeException("Failed to set new certificate ID");
            }
        });){
            certClient.initWithRecovery();
        }
    }

    public static CertificateServer initializeRootCertificateServer(SecurityConfig config, CertificateStore scmCertStore, SCMStorageConfig scmStorageConfig, BigInteger rootCertId, PKIProfile pkiProfile, String component) throws IOException {
        String subject = "scm@" + InetAddress.getLocalHost().getHostName();
        DefaultCAServer rootCAServer = new DefaultCAServer(subject, scmStorageConfig.getClusterID(), scmStorageConfig.getScmId(), scmCertStore, rootCertId, pkiProfile, component);
        rootCAServer.init(config, CAType.ROOT);
        return rootCAServer;
    }

    public static CertificateServer initializeRootCertificateServer(SecurityConfig config, CertificateStore scmCertStore, SCMStorageConfig scmStorageConfig, PKIProfile pkiProfile) throws IOException {
        return HASecurityUtils.initializeRootCertificateServer(config, scmCertStore, scmStorageConfig, BigInteger.ONE, pkiProfile, OzoneConsts.SCM_ROOT_CA_COMPONENT_NAME);
    }

    public static GrpcTlsConfig createSCMRatisTLSConfig(SecurityConfig conf, CertificateClient certificateClient) throws IOException {
        if (conf.isSecurityEnabled() && conf.isGrpcTlsEnabled()) {
            KeyStoresFactory serverKeyFactory = certificateClient.getServerKeyStoresFactory();
            return new GrpcTlsConfig(serverKeyFactory.getKeyManagers()[0], serverKeyFactory.getTrustManagers()[0], true);
        }
        return null;
    }

    public static SCMRatisResponse submitScmRequestToRatis(RaftGroup raftGroup, GrpcTlsConfig tlsConfig, Message message) throws Exception {
        SupportedRpcType rpc = SupportedRpcType.GRPC;
        RaftProperties properties = RatisHelper.newRaftProperties((RpcType)rpc);
        RaftClient.Builder builder = RaftClient.newBuilder().setRaftGroup(raftGroup).setLeaderId(null).setProperties(properties).setParameters(RatisHelper.setClientTlsConf((RpcType)rpc, (GrpcTlsConfig)tlsConfig)).setRetryPolicy((RetryPolicy)RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)120, (TimeDuration)TimeDuration.valueOf((long)500L, (TimeUnit)TimeUnit.MILLISECONDS)));
        try (RaftClient raftClient = builder.build();){
            CompletableFuture future = raftClient.async().send(message);
            RaftClientReply raftClientReply = (RaftClientReply)future.get();
            SCMRatisResponse sCMRatisResponse = SCMRatisResponse.decode(raftClientReply);
            return sCMRatisResponse;
        }
    }

    private static SCMSecurityProtocolClientSideTranslatorPB getScmSecurityClientWithFixedDuration(OzoneConfiguration conf) throws IOException {
        SCMClientConfig scmClientConfig;
        long duration = conf.getTimeDuration("ozone.scm.info.wait.duration", 600L, TimeUnit.SECONDS);
        int retryCount = (int)(duration / ((scmClientConfig = (SCMClientConfig)conf.getObject(SCMClientConfig.class)).getRetryInterval() / 1000L));
        if (retryCount > scmClientConfig.getRetryCount()) {
            scmClientConfig.setRetryCount(retryCount);
            conf.setFromObject((Object)scmClientConfig);
        }
        return new SCMSecurityProtocolClientSideTranslatorPB(new SCMSecurityProtocolFailoverProxyProvider((ConfigurationSource)conf, UserGroupInformation.getCurrentUser()));
    }

    public static boolean isSelfSignedCertificate(X509Certificate cert) {
        return cert.getIssuerX500Principal().equals(cert.getSubjectX500Principal());
    }

    public static boolean isCACertificate(X509Certificate cert) {
        return cert.getBasicConstraints() != -1;
    }
}

