/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication.health;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.ReplicationManagerReport;
import org.apache.hadoop.hdds.scm.container.replication.ContainerCheckRequest;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.hdds.scm.container.replication.health.AbstractCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuasiClosedContainerHandler
extends AbstractCheck {
    public static final Logger LOG = LoggerFactory.getLogger(QuasiClosedContainerHandler.class);
    private final ReplicationManager replicationManager;

    public QuasiClosedContainerHandler(ReplicationManager replicationManager) {
        this.replicationManager = replicationManager;
    }

    @Override
    public boolean handle(ContainerCheckRequest request) {
        ContainerInfo containerInfo = request.getContainerInfo();
        if (containerInfo.getReplicationType() != HddsProtos.ReplicationType.RATIS) {
            return false;
        }
        if (containerInfo.getState() != HddsProtos.LifeCycleState.QUASI_CLOSED) {
            return false;
        }
        LOG.debug("Checking container {} in QuasiClosedContainerHandler", (Object)containerInfo);
        Set<ContainerReplica> replicas = request.getContainerReplicas();
        if (this.canForceCloseContainer(containerInfo, replicas)) {
            if (!request.isReadOnly()) {
                this.forceCloseContainer(containerInfo, replicas);
            }
        } else {
            LOG.debug("Container {} cannot be force closed and is stuck in QUASI_CLOSED", (Object)containerInfo);
            request.getReport().incrementAndSample(ReplicationManagerReport.HealthState.QUASI_CLOSED_STUCK, containerInfo.containerID());
        }
        return false;
    }

    private boolean canForceCloseContainer(ContainerInfo container, Set<ContainerReplica> replicas) {
        int replicationFactor = container.getReplicationConfig().getRequiredNodes();
        long uniqueQuasiClosedReplicaCount = replicas.stream().filter(r -> r.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED).map(ContainerReplica::getOriginDatanodeId).distinct().count();
        return uniqueQuasiClosedReplicaCount > (long)(replicationFactor / 2);
    }

    private void forceCloseContainer(ContainerInfo container, Set<ContainerReplica> replicas) {
        List quasiClosedReplicas = replicas.stream().filter(r -> r.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED).collect(Collectors.toList());
        Long sequenceId = quasiClosedReplicas.stream().map(ContainerReplica::getSequenceId).max(Long::compare).orElse(-1L);
        LOG.info("Force closing container {} with BCSID {}, which is in QUASI_CLOSED state.", (Object)container.containerID(), (Object)sequenceId);
        quasiClosedReplicas.stream().filter(r -> sequenceId != -1L).filter(replica -> replica.getSequenceId().equals(sequenceId)).forEach(replica -> this.replicationManager.sendCloseContainerReplicaCommand(container, replica.getDatanodeDetails(), true));
    }
}

