/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication.health;

import java.util.Set;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.replication.ContainerCheckRequest;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.hdds.scm.container.replication.health.AbstractCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MismatchedReplicasHandler
extends AbstractCheck {
    public static final Logger LOG = LoggerFactory.getLogger(MismatchedReplicasHandler.class);
    private final ReplicationManager replicationManager;

    public MismatchedReplicasHandler(ReplicationManager replicationManager) {
        this.replicationManager = replicationManager;
    }

    @Override
    public boolean handle(ContainerCheckRequest request) {
        ContainerInfo containerInfo = request.getContainerInfo();
        Set<ContainerReplica> replicas = request.getContainerReplicas();
        if (containerInfo.getState() != HddsProtos.LifeCycleState.CLOSED && containerInfo.getState() != HddsProtos.LifeCycleState.QUASI_CLOSED) {
            return false;
        }
        LOG.debug("Checking container {} in MismatchedReplicasHandler", (Object)containerInfo);
        if (request.isReadOnly()) {
            return false;
        }
        for (ContainerReplica replica : replicas) {
            if (!this.shouldBeClosed(containerInfo, replica)) continue;
            LOG.debug("Sending close command for mismatched replica {} of container {}.", (Object)replica, (Object)containerInfo);
            if (containerInfo.getState() == HddsProtos.LifeCycleState.CLOSED) {
                this.replicationManager.sendCloseContainerReplicaCommand(containerInfo, replica.getDatanodeDetails(), true);
                continue;
            }
            if (containerInfo.getState() != HddsProtos.LifeCycleState.QUASI_CLOSED) continue;
            this.replicationManager.sendCloseContainerReplicaCommand(containerInfo, replica.getDatanodeDetails(), false);
        }
        return false;
    }

    private boolean shouldBeClosed(ContainerInfo container, ContainerReplica replica) {
        if (replica.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.OPEN || replica.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSING) {
            return true;
        }
        return container.getState() == HddsProtos.LifeCycleState.CLOSED && replica.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED && container.getSequenceId() == replica.getSequenceId().longValue();
    }
}

