/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.time.Duration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.function.Supplier;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.replication.CommandTargetOverloadedException;
import org.apache.hadoop.hdds.scm.container.replication.ContainerHealthResult;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UnhealthyReplicationProcessor<HealthResult extends ContainerHealthResult>
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(UnhealthyReplicationProcessor.class);
    private final ReplicationManager replicationManager;
    private volatile boolean runImmediately = false;
    private final Supplier<Duration> interval;

    public UnhealthyReplicationProcessor(ReplicationManager replicationManager, Supplier<Duration> interval) {
        this.replicationManager = replicationManager;
        this.interval = interval;
    }

    protected abstract HealthResult dequeueHealthResultFromQueue(ReplicationQueue var1);

    protected abstract void requeueHealthResult(ReplicationQueue var1, HealthResult var2);

    protected abstract boolean inflightOperationLimitReached(ReplicationManager var1, long var2);

    public void processAll(ReplicationQueue queue) {
        int processed = 0;
        int failed = 0;
        int overloaded = 0;
        HashMap healthStateCntMap = Maps.newHashMap();
        LinkedList<HealthResult> failedOnes = new LinkedList<HealthResult>();
        long inflightLimit = this.replicationManager.getReplicationInFlightLimit();
        while (this.replicationManager.shouldRun()) {
            if (inflightLimit > 0L && this.inflightOperationLimitReached(this.replicationManager, inflightLimit)) {
                LOG.info("The maximum number of pending replicas ({}) are scheduled. Ending the iteration.", (Object)inflightLimit);
                this.replicationManager.getMetrics().incrPendingReplicationLimitReachedTotal();
                break;
            }
            HealthResult healthResult = this.dequeueHealthResultFromQueue(queue);
            if (healthResult == null) break;
            try {
                this.processContainer(healthResult);
                ++processed;
                healthStateCntMap.compute(((ContainerHealthResult)healthResult).getHealthState(), (healthState, cnt) -> cnt == null ? 1 : cnt + 1);
            }
            catch (CommandTargetOverloadedException e) {
                LOG.debug("All targets overloaded when processing Health result of class: {} for container {}", healthResult.getClass(), (Object)((ContainerHealthResult)healthResult).getContainerInfo());
                ++overloaded;
                failedOnes.add(healthResult);
            }
            catch (Exception e) {
                LOG.error("Error processing Health result of class: {} for container {}", new Object[]{healthResult.getClass(), ((ContainerHealthResult)healthResult).getContainerInfo(), e});
                ++failed;
                failedOnes.add(healthResult);
            }
        }
        failedOnes.forEach(result -> this.requeueHealthResult(queue, result));
        if (processed > 0 || failed > 0 || overloaded > 0) {
            LOG.info("Processed {} containers with health state counts {}, failed processing {}, deferred due to load {}", new Object[]{processed, healthStateCntMap, failed, overloaded});
        }
    }

    protected abstract int sendDatanodeCommands(ReplicationManager var1, HealthResult var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processContainer(HealthResult healthResult) throws IOException {
        ContainerInfo containerInfo;
        ContainerInfo containerInfo2 = containerInfo = ((ContainerHealthResult)healthResult).getContainerInfo();
        synchronized (containerInfo2) {
            this.sendDatanodeCommands(this.replicationManager, healthResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                if (this.replicationManager.shouldRun()) {
                    this.processAll(this.replicationManager.getQueue());
                }
                Duration duration = this.interval.get();
                if (!this.runImmediately && LOG.isDebugEnabled()) {
                    LOG.debug("May wait {} before next run", (Object)duration);
                }
                UnhealthyReplicationProcessor unhealthyReplicationProcessor = this;
                synchronized (unhealthyReplicationProcessor) {
                    if (!this.runImmediately) {
                        this.wait(duration.toMillis());
                    }
                    this.runImmediately = false;
                }
            }
            return;
        }
        catch (InterruptedException e) {
            LOG.warn("{} interrupted. Exiting...", (Object)Thread.currentThread().getName());
            Thread.currentThread().interrupt();
        }
    }

    @VisibleForTesting
    synchronized void runImmediately() {
        this.runImmediately = true;
        this.notify();
    }
}

