/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication;

import java.util.List;
import java.util.Set;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.replication.ContainerReplicaOp;
import org.apache.hadoop.hdds.scm.container.replication.RatisContainerReplicaCount;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;

public class LegacyRatisContainerReplicaCount
extends RatisContainerReplicaCount {
    public LegacyRatisContainerReplicaCount(ContainerInfo container, Set<ContainerReplica> replicas, int inFlightAdd, int inFlightDelete, int replicationFactor, int minHealthyForMaintenance) {
        super(container, replicas, inFlightAdd, inFlightDelete, replicationFactor, minHealthyForMaintenance);
    }

    public LegacyRatisContainerReplicaCount(ContainerInfo container, Set<ContainerReplica> replicas, List<ContainerReplicaOp> pendingOps, int minHealthyForMaintenance, boolean considerUnhealthy) {
        super(container, replicas, pendingOps, minHealthyForMaintenance, considerUnhealthy);
    }

    @Override
    protected int healthyReplicaCountAdapter() {
        return -this.getMisMatchedReplicaCount();
    }

    @Override
    public int getUnhealthyReplicaCountAdapter() {
        return this.getMisMatchedReplicaCount();
    }

    @Override
    public boolean isHealthyEnoughForOffline() {
        long countInService = this.getReplicas().stream().filter(r -> r.getDatanodeDetails().getPersistedOpState() == HddsProtos.NodeOperationalState.IN_SERVICE).count();
        if (countInService == 0L) {
            return false;
        }
        HddsProtos.LifeCycleState containerState = this.getContainer().getState();
        return (containerState == HddsProtos.LifeCycleState.CLOSED || containerState == HddsProtos.LifeCycleState.QUASI_CLOSED) && this.getReplicas().stream().filter(r -> r.getDatanodeDetails().getPersistedOpState() == HddsProtos.NodeOperationalState.IN_SERVICE).filter(r -> r.getState() != StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.UNHEALTHY).allMatch(r -> ReplicationManager.compareState(containerState, r.getState()));
    }

    @Override
    public boolean isSufficientlyReplicatedForOffline(DatanodeDetails datanode, NodeManager nodeManager) {
        return super.isSufficientlyReplicated() && super.getVulnerableUnhealthyReplicas(dn -> {
            try {
                return nodeManager.getNodeStatus((DatanodeDetails)dn);
            }
            catch (NodeNotFoundException e) {
                return null;
            }
        }).isEmpty();
    }
}

