/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.hdds.utils.MetadataKeyFilters;
import org.apache.hadoop.hdds.utils.TableCacheMetrics;
import org.apache.hadoop.hdds.utils.db.AutoCloseSupplier;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CodecBuffer;
import org.apache.hadoop.hdds.utils.db.CodecRegistry;
import org.apache.hadoop.hdds.utils.db.RDBTable;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheResult;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.hdds.utils.db.cache.FullTableCache;
import org.apache.hadoop.hdds.utils.db.cache.PartialTableCache;
import org.apache.hadoop.hdds.utils.db.cache.TableCache;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.function.CheckedBiFunction;

public class TypedTable<KEY, VALUE>
implements Table<KEY, VALUE> {
    private static final long EPOCH_DEFAULT = -1L;
    static final int BUFFER_SIZE_DEFAULT = 4096;
    private final RDBTable rawTable;
    private final Class<KEY> keyType;
    private final Codec<KEY> keyCodec;
    private final Class<VALUE> valueType;
    private final Codec<VALUE> valueCodec;
    private final boolean supportCodecBuffer;
    private final CodecBuffer.Capacity bufferCapacity = new CodecBuffer.Capacity((Object)this, 4096);
    private final TableCache<KEY, VALUE> cache;

    public TypedTable(RDBTable rawTable, CodecRegistry codecRegistry, Class<KEY> keyType, Class<VALUE> valueType) throws IOException {
        this(rawTable, codecRegistry, keyType, valueType, TableCache.CacheType.PARTIAL_CACHE, "");
    }

    public TypedTable(RDBTable rawTable, CodecRegistry codecRegistry, Class<KEY> keyType, Class<VALUE> valueType, TableCache.CacheType cacheType, String threadNamePrefix) throws IOException {
        this.rawTable = Objects.requireNonNull(rawTable, "rawTable==null");
        Objects.requireNonNull(codecRegistry, "codecRegistry == null");
        this.keyType = Objects.requireNonNull(keyType, "keyType == null");
        this.keyCodec = codecRegistry.getCodecFromClass(keyType);
        Objects.requireNonNull(this.keyCodec, "keyCodec == null");
        this.valueType = Objects.requireNonNull(valueType, "valueType == null");
        this.valueCodec = codecRegistry.getCodecFromClass(valueType);
        Objects.requireNonNull(this.valueCodec, "valueCodec == null");
        boolean bl = this.supportCodecBuffer = this.keyCodec.supportCodecBuffer() && this.valueCodec.supportCodecBuffer();
        if (cacheType == TableCache.CacheType.FULL_CACHE) {
            this.cache = new FullTableCache(threadNamePrefix);
            try (TableIterator tableIterator = this.iterator();){
                while (tableIterator.hasNext()) {
                    Table.KeyValue kv = (Table.KeyValue)tableIterator.next();
                    this.cache.loadInitial(new CacheKey(kv.getKey()), CacheValue.get(-1L, kv.getValue()));
                }
            }
        } else {
            this.cache = new PartialTableCache(threadNamePrefix);
        }
    }

    private CodecBuffer encodeKeyCodecBuffer(KEY key) throws IOException {
        return key == null ? null : this.keyCodec.toDirectCodecBuffer(key);
    }

    private byte[] encodeKey(KEY key) throws IOException {
        return key == null ? null : this.keyCodec.toPersistedFormat(key);
    }

    private byte[] encodeValue(VALUE value) throws IOException {
        return value == null ? null : this.valueCodec.toPersistedFormat(value);
    }

    private KEY decodeKey(byte[] key) throws IOException {
        return (KEY)(key == null ? null : this.keyCodec.fromPersistedFormat(key));
    }

    private VALUE decodeValue(byte[] value) throws IOException {
        return (VALUE)(value == null ? null : this.valueCodec.fromPersistedFormat(value));
    }

    @Override
    public void put(KEY key, VALUE value) throws IOException {
        block25: {
            if (this.supportCodecBuffer) {
                try (CodecBuffer k = this.keyCodec.toDirectCodecBuffer(key);
                     CodecBuffer v = this.valueCodec.toDirectCodecBuffer(value);){
                    this.rawTable.put(k.asReadOnlyByteBuffer(), v.asReadOnlyByteBuffer());
                    break block25;
                }
            }
            this.rawTable.put(this.encodeKey(key), this.encodeValue(value));
        }
    }

    @Override
    public void putWithBatch(BatchOperation batch, KEY key, VALUE value) throws IOException {
        if (this.supportCodecBuffer) {
            CodecBuffer keyBuffer = null;
            CodecBuffer valueBuffer = null;
            try {
                keyBuffer = this.keyCodec.toDirectCodecBuffer(key);
                valueBuffer = this.valueCodec.toDirectCodecBuffer(value);
                this.rawTable.putWithBatch(batch, keyBuffer, valueBuffer);
            }
            catch (Exception e) {
                IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{valueBuffer, keyBuffer});
                throw e;
            }
        } else {
            this.rawTable.putWithBatch(batch, this.encodeKey(key), this.encodeValue(value));
        }
    }

    @Override
    public boolean isEmpty() throws IOException {
        return this.rawTable.isEmpty();
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean isExist(KEY key) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public VALUE get(KEY key) throws IOException {
        CacheResult<VALUE> cacheResult = this.cache.lookup(new CacheKey<KEY>(key));
        if (cacheResult.getCacheStatus() == CacheResult.CacheStatus.EXISTS) {
            return (VALUE)this.valueCodec.copyObject(cacheResult.getValue().getCacheValue());
        }
        if (cacheResult.getCacheStatus() == CacheResult.CacheStatus.NOT_EXIST) {
            return null;
        }
        return this.getFromTable(key);
    }

    @Override
    public VALUE getSkipCache(KEY key) throws IOException {
        return this.getFromTable(key);
    }

    @Override
    public VALUE getReadCopy(KEY key) throws IOException {
        CacheResult<VALUE> cacheResult = this.cache.lookup(new CacheKey<KEY>(key));
        if (cacheResult.getCacheStatus() == CacheResult.CacheStatus.EXISTS) {
            return cacheResult.getValue().getCacheValue();
        }
        if (cacheResult.getCacheStatus() == CacheResult.CacheStatus.NOT_EXIST) {
            return null;
        }
        return this.getFromTable(key);
    }

    @Override
    public VALUE getIfExist(KEY key) throws IOException {
        CacheResult<VALUE> cacheResult = this.cache.lookup(new CacheKey<KEY>(key));
        if (cacheResult.getCacheStatus() == CacheResult.CacheStatus.EXISTS) {
            return (VALUE)this.valueCodec.copyObject(cacheResult.getValue().getCacheValue());
        }
        if (cacheResult.getCacheStatus() == CacheResult.CacheStatus.NOT_EXIST) {
            return null;
        }
        return this.getFromTableIfExist(key);
    }

    private Integer getFromTable(CodecBuffer key, CodecBuffer outValue) throws IOException {
        return outValue.putFromSource(buffer -> this.rawTable.get(key.asReadOnlyByteBuffer(), (ByteBuffer)buffer));
    }

    private VALUE getFromTable(KEY key) throws IOException {
        if (this.supportCodecBuffer) {
            return this.getFromTable(key, (CheckedBiFunction<CodecBuffer, CodecBuffer, Integer, IOException>)((CheckedBiFunction)this::getFromTable));
        }
        byte[] keyBytes = this.encodeKey(key);
        byte[] valueBytes = this.rawTable.get(keyBytes);
        return this.decodeValue(valueBytes);
    }

    private Integer getFromTableIfExist(CodecBuffer key, CodecBuffer outValue) throws IOException {
        return outValue.putFromSource(buffer -> this.rawTable.getIfExist(key.asReadOnlyByteBuffer(), (ByteBuffer)buffer));
    }

    /*
     * Exception decompiling
     */
    private VALUE getFromTable(KEY key, CheckedBiFunction<CodecBuffer, CodecBuffer, Integer, IOException> get) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 28[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private VALUE getFromTableIfExist(KEY key) throws IOException {
        if (this.supportCodecBuffer) {
            return this.getFromTable(key, (CheckedBiFunction<CodecBuffer, CodecBuffer, Integer, IOException>)((CheckedBiFunction)this::getFromTableIfExist));
        }
        byte[] keyBytes = this.encodeKey(key);
        byte[] valueBytes = this.rawTable.getIfExist(keyBytes);
        return this.decodeValue(valueBytes);
    }

    @Override
    public void delete(KEY key) throws IOException {
        if (this.keyCodec.supportCodecBuffer()) {
            try (CodecBuffer buffer = this.keyCodec.toDirectCodecBuffer(key);){
                this.rawTable.delete(buffer.asReadOnlyByteBuffer());
            }
        } else {
            this.rawTable.delete(this.encodeKey(key));
        }
    }

    @Override
    public void deleteWithBatch(BatchOperation batch, KEY key) throws IOException {
        this.rawTable.deleteWithBatch(batch, this.encodeKey(key));
    }

    @Override
    public void deleteRange(KEY beginKey, KEY endKey) throws IOException {
        this.rawTable.deleteRange(this.encodeKey(beginKey), this.encodeKey(endKey));
    }

    @Override
    public Table.KeyValueIterator<KEY, VALUE> iterator() throws IOException {
        return this.iterator((Object)null);
    }

    @Override
    public Table.KeyValueIterator<KEY, VALUE> iterator(KEY prefix) throws IOException {
        if (this.supportCodecBuffer) {
            CodecBuffer prefixBuffer = this.encodeKeyCodecBuffer(prefix);
            try {
                return this.newCodecBufferTableIterator(this.rawTable.iterator(prefixBuffer));
            }
            catch (Throwable t) {
                if (prefixBuffer != null) {
                    prefixBuffer.release();
                }
                throw t;
            }
        }
        byte[] prefixBytes = this.encodeKey(prefix);
        return new TypedTableIterator(this.rawTable.iterator(prefixBytes));
    }

    @Override
    public String getName() {
        return this.rawTable.getName();
    }

    public String toString() {
        return JavaUtils.getClassSimpleName(this.getClass()) + "-" + this.getName() + "(" + JavaUtils.getClassSimpleName(this.keyType) + "->" + JavaUtils.getClassSimpleName(this.valueType) + ")";
    }

    @Override
    public long getEstimatedKeyCount() throws IOException {
        if (this.cache.getCacheType() == TableCache.CacheType.FULL_CACHE) {
            return this.cache.size();
        }
        return this.rawTable.getEstimatedKeyCount();
    }

    @Override
    public void close() throws Exception {
        this.rawTable.close();
    }

    @Override
    public void addCacheEntry(CacheKey<KEY> cacheKey, CacheValue<VALUE> cacheValue) {
        this.cache.put(cacheKey, cacheValue);
    }

    @Override
    public CacheValue<VALUE> getCacheValue(CacheKey<KEY> cacheKey) {
        return this.cache.get(cacheKey);
    }

    @Override
    public Iterator<Map.Entry<CacheKey<KEY>, CacheValue<VALUE>>> cacheIterator() {
        return this.cache.iterator();
    }

    @Override
    public TableCacheMetrics createCacheMetrics() {
        return TableCacheMetrics.create(this.cache, this.getName());
    }

    @Override
    public List<TypedKeyValue> getRangeKVs(KEY startKey, int count, KEY prefix, MetadataKeyFilters.MetadataKeyFilter ... filters) throws IOException, IllegalArgumentException {
        byte[] startKeyBytes = this.encodeKey(startKey);
        byte[] prefixBytes = this.encodeKey(prefix);
        List<Table.KeyValue<byte[], byte[]>> rangeKVBytes = this.rawTable.getRangeKVs(startKeyBytes, count, prefixBytes, filters);
        ArrayList<TypedKeyValue> rangeKVs = new ArrayList<TypedKeyValue>();
        rangeKVBytes.forEach(byteKV -> rangeKVs.add(new TypedKeyValue((Table.KeyValue)byteKV)));
        return rangeKVs;
    }

    @Override
    public List<TypedKeyValue> getSequentialRangeKVs(KEY startKey, int count, KEY prefix, MetadataKeyFilters.MetadataKeyFilter ... filters) throws IOException, IllegalArgumentException {
        byte[] startKeyBytes = this.encodeKey(startKey);
        byte[] prefixBytes = this.encodeKey(prefix);
        List<Table.KeyValue<byte[], byte[]>> rangeKVBytes = this.rawTable.getSequentialRangeKVs(startKeyBytes, count, prefixBytes, filters);
        ArrayList<TypedKeyValue> rangeKVs = new ArrayList<TypedKeyValue>();
        rangeKVBytes.forEach(byteKV -> rangeKVs.add(new TypedKeyValue((Table.KeyValue)byteKV)));
        return rangeKVs;
    }

    @Override
    public void deleteBatchWithPrefix(BatchOperation batch, KEY prefix) throws IOException {
        this.rawTable.deleteBatchWithPrefix(batch, this.encodeKey(prefix));
    }

    @Override
    public void dumpToFileWithPrefix(File externalFile, KEY prefix) throws IOException {
        this.rawTable.dumpToFileWithPrefix(externalFile, this.encodeKey(prefix));
    }

    @Override
    public void loadFromFile(File externalFile) throws IOException {
        this.rawTable.loadFromFile(externalFile);
    }

    @Override
    public void cleanupCache(List<Long> epochs) {
        this.cache.cleanup(epochs);
    }

    @VisibleForTesting
    TableCache<KEY, VALUE> getCache() {
        return this.cache;
    }

    RawIterator<CodecBuffer> newCodecBufferTableIterator(TableIterator<CodecBuffer, Table.KeyValue<CodecBuffer, CodecBuffer>> i) {
        return new RawIterator<CodecBuffer>(i){

            @Override
            AutoCloseSupplier<CodecBuffer> convert(KEY key) throws IOException {
                final CodecBuffer buffer = TypedTable.this.encodeKeyCodecBuffer(key);
                return new AutoCloseSupplier<CodecBuffer>(){

                    @Override
                    public void close() {
                        buffer.release();
                    }

                    @Override
                    public CodecBuffer get() {
                        return buffer;
                    }
                };
            }

            @Override
            Table.KeyValue<KEY, VALUE> convert(Table.KeyValue<CodecBuffer, CodecBuffer> raw) throws IOException {
                Object key = TypedTable.this.keyCodec.fromCodecBuffer(raw.getKey());
                Object value = TypedTable.this.valueCodec.fromCodecBuffer(raw.getValue());
                return Table.newKeyValue(key, value);
            }
        };
    }

    abstract class RawIterator<RAW>
    implements Table.KeyValueIterator<KEY, VALUE> {
        private final TableIterator<RAW, Table.KeyValue<RAW, RAW>> rawIterator;

        RawIterator(TableIterator<RAW, Table.KeyValue<RAW, RAW>> rawIterator) {
            this.rawIterator = rawIterator;
        }

        abstract AutoCloseSupplier<RAW> convert(KEY var1) throws IOException;

        abstract Table.KeyValue<KEY, VALUE> convert(Table.KeyValue<RAW, RAW> var1) throws IOException;

        @Override
        public void seekToFirst() {
            this.rawIterator.seekToFirst();
        }

        @Override
        public void seekToLast() {
            this.rawIterator.seekToLast();
        }

        @Override
        public Table.KeyValue<KEY, VALUE> seek(KEY key) throws IOException {
            try (AutoCloseSupplier<RAW> rawKey = this.convert(key);){
                Table.KeyValue<RAW, RAW> result = this.rawIterator.seek(rawKey.get());
                Table.KeyValue keyValue = result == null ? null : this.convert(result);
                return keyValue;
            }
        }

        @Override
        public void close() throws IOException {
            this.rawIterator.close();
        }

        @Override
        public boolean hasNext() {
            return this.rawIterator.hasNext();
        }

        @Override
        public Table.KeyValue<KEY, VALUE> next() {
            try {
                return this.convert((Table.KeyValue)this.rawIterator.next());
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed next()", e);
            }
        }

        @Override
        public void removeFromDB() throws IOException {
            this.rawIterator.removeFromDB();
        }
    }

    public class TypedTableIterator
    extends RawIterator<byte[]> {
        TypedTableIterator(TableIterator<byte[], Table.KeyValue<byte[], byte[]>> rawIterator) {
            super(rawIterator);
        }

        @Override
        AutoCloseSupplier<byte[]> convert(KEY key) throws IOException {
            byte[] keyArray = TypedTable.this.encodeKey(key);
            return () -> keyArray;
        }

        @Override
        Table.KeyValue<KEY, VALUE> convert(Table.KeyValue<byte[], byte[]> raw) {
            return new TypedKeyValue(raw);
        }
    }

    public final class TypedKeyValue
    implements Table.KeyValue<KEY, VALUE> {
        private final Table.KeyValue<byte[], byte[]> rawKeyValue;

        private TypedKeyValue(Table.KeyValue<byte[], byte[]> rawKeyValue) {
            this.rawKeyValue = rawKeyValue;
        }

        @Override
        public KEY getKey() throws IOException {
            return TypedTable.this.decodeKey(this.rawKeyValue.getKey());
        }

        @Override
        public VALUE getValue() throws IOException {
            return TypedTable.this.decodeValue(this.rawKeyValue.getValue());
        }
    }
}

