/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hdds.utils.db.RocksDatabase;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.bouncycastle.util.Strings;
import org.rocksdb.HistogramData;
import org.rocksdb.HistogramType;
import org.rocksdb.LiveFileMetaData;
import org.rocksdb.Statistics;
import org.rocksdb.TickerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBStoreMetrics
implements MetricsSource {
    private Statistics statistics;
    private final RocksDatabase rocksDB;
    private Set<String> histogramAttributes = new HashSet<String>();
    private String contextName;
    private static final Logger LOG = LoggerFactory.getLogger(RocksDBStoreMetrics.class);
    public static final String ROCKSDB_CONTEXT_PREFIX = "Rocksdb_";
    public static final String ROCKSDB_PROPERTY_PREFIX = "rocksdb.";
    private static final String BLOB_DB_PREFIX = "BLOB_DB_";
    private final String[][] cfPros = new String[][]{{"mem-table-flush-pending", "false", ""}, {"estimate-pending-compaction-bytes", "true", ""}, {"compaction-pending", "false", ""}, {"block-cache-capacity", "true", ""}, {"block-cache-usage", "true", ""}, {"block-cache-pinned-usage", "true", ""}, {"base-level", "false", ""}, {"cur-size-active-mem-table", "true", ""}, {"cur-size-all-mem-tables", "true", ""}, {"size-all-mem-tables", "true", ""}, {"num-immutable-mem-table", "true", ""}, {"live-sst-files-size", "true", ""}, {"estimate-num-keys", "true", ""}, {"estimate-table-readers-mem", "true", ""}};
    private static final String NUM_FILES_AT_LEVEL = "num_files_at_level";
    private static final String SIZE_AT_LEVEL = "size_at_level";
    private static final String LAST_SEQUENCE_NUMBER = "last_sequence_number";

    public RocksDBStoreMetrics(Statistics statistics, RocksDatabase db, String dbName) {
        this.contextName = ROCKSDB_CONTEXT_PREFIX + dbName;
        this.statistics = statistics;
        this.rocksDB = db;
        this.histogramAttributes.add("Average");
        this.histogramAttributes.add("Median");
        this.histogramAttributes.add("Percentile95");
        this.histogramAttributes.add("Percentile99");
        this.histogramAttributes.add("StandardDeviation");
        this.histogramAttributes.add("Max");
        for (String[] property : this.cfPros) {
            property[2] = property[0].replace("-", "_");
        }
    }

    public static RocksDBStoreMetrics create(Statistics statistics, RocksDatabase db, String contextName) {
        RocksDBStoreMetrics metrics = new RocksDBStoreMetrics(statistics, db, contextName);
        MetricsSystem ms = DefaultMetricsSystem.instance();
        MetricsSource metricsSource = ms.getSource(metrics.contextName);
        if (metricsSource != null) {
            return (RocksDBStoreMetrics)metricsSource;
        }
        return (RocksDBStoreMetrics)ms.register(metrics.contextName, "RocksDB Metrics", (Object)metrics);
    }

    public void unregister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(this.contextName);
    }

    public void getMetrics(MetricsCollector metricsCollector, boolean b) {
        MetricsRecordBuilder rb = metricsCollector.addRecord(this.contextName);
        this.getHistogramData(rb);
        this.getTickerTypeData(rb);
        this.getDBPropertyData(rb);
        this.getLatestSequenceNumber(rb);
    }

    private void getHistogramData(MetricsRecordBuilder rb) {
        if (this.statistics == null) {
            return;
        }
        for (HistogramType histogramType : HistogramType.values()) {
            if (histogramType.name().startsWith(BLOB_DB_PREFIX)) continue;
            HistogramData histogram = this.statistics.getHistogramData(HistogramType.valueOf((String)histogramType.name()));
            for (String histogramAttribute : this.histogramAttributes) {
                try {
                    Method method = HistogramData.class.getMethod("get" + histogramAttribute, new Class[0]);
                    double metricValue = (Double)method.invoke((Object)histogram, new Object[0]);
                    rb.addGauge(Interns.info((String)(histogramType.name() + "_" + histogramAttribute.toUpperCase()), (String)"RocksDBStat"), metricValue);
                }
                catch (Exception e) {
                    LOG.error("Error reading histogram data", (Throwable)e);
                }
            }
        }
    }

    private void getTickerTypeData(MetricsRecordBuilder rb) {
        if (this.statistics == null) {
            return;
        }
        for (TickerType tickerType : TickerType.values()) {
            if (tickerType.name().startsWith(BLOB_DB_PREFIX)) continue;
            rb.addCounter(Interns.info((String)tickerType.name(), (String)"RocksDBStat"), this.statistics.getTickerCount(tickerType));
        }
    }

    private void getDBPropertyData(MetricsRecordBuilder rb) {
        int index = 0;
        try {
            for (index = 0; index < this.cfPros.length; ++index) {
                Boolean aggregated = Boolean.valueOf(this.cfPros[index][1]);
                long sum = 0L;
                for (RocksDatabase.ColumnFamily cf : this.rocksDB.getExtraColumnFamilies()) {
                    long value = Long.parseLong(this.rocksDB.getProperty(cf, ROCKSDB_PROPERTY_PREFIX + this.cfPros[index][0]));
                    rb.addCounter(Interns.info((String)(cf.getName() + "_" + this.cfPros[index][2]), (String)"RocksDBProperty"), value);
                    if (!aggregated.booleanValue()) continue;
                    sum += value;
                }
                if (!aggregated.booleanValue()) continue;
                rb.addCounter(Interns.info((String)this.cfPros[index][2], (String)"RocksDBProperty"), sum);
            }
        }
        catch (IOException e) {
            LOG.error("Failed to get property {} from rocksdb", (Object)this.cfPros[index][0], (Object)e);
        }
        try {
            Map<String, Map<Integer, Map<String, Long>>> data = this.computeSstFileStat();
            this.exportSstFileStat(rb, data.get(NUM_FILES_AT_LEVEL), NUM_FILES_AT_LEVEL);
            this.exportSstFileStat(rb, data.get(SIZE_AT_LEVEL), SIZE_AT_LEVEL);
        }
        catch (IOException e) {
            LOG.error("Failed to compute sst file stat", (Throwable)e);
        }
    }

    private Map<String, Map<Integer, Map<String, Long>>> computeSstFileStat() throws IOException {
        List<LiveFileMetaData> liveFileMetaDataList = this.rocksDB.getLiveFilesMetaData();
        HashMap<String, Map<Integer, Map<String, Long>>> ret = new HashMap<String, Map<Integer, Map<String, Long>>>();
        HashMap numStatPerCF = new HashMap();
        HashMap sizeStatPerCF = new HashMap();
        for (LiveFileMetaData file : liveFileMetaDataList) {
            Long value;
            HashMap<String, Long> numStat = (HashMap<String, Long>)numStatPerCF.get(file.level());
            String cf = Strings.fromByteArray((byte[])file.columnFamilyName());
            if (numStat != null) {
                value = (Long)numStat.get(cf);
                numStat.put(cf, value == null ? 1L : value + 1L);
            } else {
                numStat = new HashMap<String, Long>();
                numStat.put(cf, 1L);
                numStatPerCF.put(file.level(), numStat);
            }
            HashMap<String, Long> sizeStat = (HashMap<String, Long>)sizeStatPerCF.get(file.level());
            if (sizeStat != null) {
                value = (Long)sizeStat.get(cf);
                sizeStat.put(cf, value == null ? file.size() : value + file.size());
                continue;
            }
            sizeStat = new HashMap<String, Long>();
            sizeStat.put(cf, file.size());
            sizeStatPerCF.put(file.level(), sizeStat);
        }
        ret.put(NUM_FILES_AT_LEVEL, numStatPerCF);
        ret.put(SIZE_AT_LEVEL, sizeStatPerCF);
        return ret;
    }

    private void exportSstFileStat(MetricsRecordBuilder rb, Map<Integer, Map<String, Long>> numStatPerCF, String metricName) {
        for (Map.Entry<Integer, Map<String, Long>> entry : numStatPerCF.entrySet()) {
            Map<String, Long> numStat = entry.getValue();
            numStat.forEach((cf, v) -> rb.addCounter(Interns.info((String)(cf + "_" + metricName + entry.getKey()), (String)"RocksDBProperty"), v.longValue()));
            rb.addCounter(Interns.info((String)(metricName + entry.getKey()), (String)"RocksDBProperty"), numStat.values().stream().mapToLong(p -> p).sum());
        }
    }

    private void getLatestSequenceNumber(MetricsRecordBuilder rb) {
        try {
            rb.addCounter(Interns.info((String)LAST_SEQUENCE_NUMBER, (String)"RocksDBStat"), this.rocksDB.getLatestSequenceNumber());
        }
        catch (IOException e) {
            LOG.error("Failed to get latest sequence number", (Throwable)e);
        }
    }
}

