/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.server;

import com.google.protobuf.ServiceException;
import io.opentracing.Span;
import java.util.function.UnaryOperator;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.hdds.utils.ProtocolMessageMetrics;
import org.apache.ratis.util.UncheckedAutoCloseable;
import org.apache.ratis.util.function.CheckedFunction;
import org.slf4j.Logger;

public class OzoneProtocolMessageDispatcher<REQUEST, RESPONSE, TYPE> {
    private final String serviceName;
    private final ProtocolMessageMetrics<TYPE> protocolMessageMetrics;
    private final Logger logger;
    private final UnaryOperator<REQUEST> requestPreprocessor;
    private final UnaryOperator<RESPONSE> responsePreprocessor;

    public OzoneProtocolMessageDispatcher(String serviceName, ProtocolMessageMetrics<TYPE> protocolMessageMetrics, Logger logger) {
        this(serviceName, protocolMessageMetrics, logger, req -> req, resp -> resp);
    }

    public OzoneProtocolMessageDispatcher(String serviceName, ProtocolMessageMetrics<TYPE> protocolMessageMetrics, Logger logger, UnaryOperator<REQUEST> requestPreprocessor, UnaryOperator<RESPONSE> responsePreprocessor) {
        this.serviceName = serviceName;
        this.protocolMessageMetrics = protocolMessageMetrics;
        this.logger = logger;
        this.requestPreprocessor = requestPreprocessor;
        this.responsePreprocessor = responsePreprocessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RESPONSE processRequest(REQUEST request, CheckedFunction<REQUEST, RESPONSE, ServiceException> methodCall, TYPE type, String traceId) throws ServiceException {
        Span span = TracingUtil.importAndCreateSpan((String)type.toString(), (String)traceId);
        try {
            Object response;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("[service={}] [type={}] request is received: <json>{}</json>", new Object[]{this.serviceName, type, OzoneProtocolMessageDispatcher.escapeNewLines(this.requestPreprocessor.apply(request))});
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("{} {} request is received", (Object)this.serviceName, type);
            }
            try (UncheckedAutoCloseable ignored = this.protocolMessageMetrics.measure(type);){
                response = methodCall.apply(request);
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("[service={}] [type={}] request is processed. Response: <json>{}</json>", new Object[]{this.serviceName, type, OzoneProtocolMessageDispatcher.escapeNewLines(this.responsePreprocessor.apply(response))});
            }
            Object object = response;
            return (RESPONSE)object;
        }
        finally {
            span.finish();
        }
    }

    private static String escapeNewLines(Object input) {
        return input.toString().replaceAll("\n", "\\\\n");
    }
}

