/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.proxy;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.ConfigurationException;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.proto.SCMSecretKeyProtocolProtos;
import org.apache.hadoop.hdds.ratis.ServerNotLeaderException;
import org.apache.hadoop.hdds.scm.ha.SCMHAUtils;
import org.apache.hadoop.hdds.scm.ha.SCMNodeInfo;
import org.apache.hadoop.hdds.scm.proxy.SCMClientConfig;
import org.apache.hadoop.hdds.scm.proxy.SCMProxyInfo;
import org.apache.hadoop.hdds.utils.LegacyHadoopConfigurationSource;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretKeyProtocolFailoverProxyProvider<T extends SCMSecretKeyProtocolProtos.SCMSecretKeyProtocolService.BlockingInterface>
implements FailoverProxyProvider<T>,
Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(SecretKeyProtocolFailoverProxyProvider.class);
    private final Map<String, FailoverProxyProvider.ProxyInfo<T>> scmProxies;
    private final Map<String, SCMProxyInfo> scmProxyInfoMap;
    private List<String> scmNodeIds;
    private volatile String currentProxySCMNodeId;
    private volatile int currentProxyIndex;
    private final ConfigurationSource conf;
    private final SCMClientConfig scmClientConfig;
    private final long scmVersion;
    private String scmServiceId;
    private final int maxRetryCount;
    private final long retryInterval;
    private final UserGroupInformation ugi;
    private final Class<T> proxyClazz;
    private String updatedLeaderNodeID = null;

    public SecretKeyProtocolFailoverProxyProvider(ConfigurationSource conf, UserGroupInformation userGroupInformation, Class<T> proxyClazz) {
        Preconditions.checkNotNull((Object)userGroupInformation);
        this.ugi = userGroupInformation;
        this.conf = conf;
        this.proxyClazz = proxyClazz;
        this.scmVersion = RPC.getProtocolVersion(proxyClazz);
        this.scmProxies = new HashMap<String, FailoverProxyProvider.ProxyInfo<T>>();
        this.scmProxyInfoMap = new HashMap<String, SCMProxyInfo>();
        this.loadConfigs();
        this.currentProxyIndex = 0;
        this.currentProxySCMNodeId = this.scmNodeIds.get(this.currentProxyIndex);
        this.scmClientConfig = (SCMClientConfig)conf.getObject(SCMClientConfig.class);
        this.maxRetryCount = this.scmClientConfig.getRetryCount();
        this.retryInterval = this.scmClientConfig.getRetryInterval();
    }

    protected synchronized void loadConfigs() {
        List scmNodeInfoList = SCMNodeInfo.buildNodeInfo((ConfigurationSource)this.conf);
        this.scmNodeIds = new ArrayList<String>();
        for (SCMNodeInfo scmNodeInfo : scmNodeInfoList) {
            if (scmNodeInfo.getScmSecurityAddress() == null) {
                throw new ConfigurationException("SCM Client Address could not be obtained from config. Config is not properly defined");
            }
            InetSocketAddress scmSecurityAddress = NetUtils.createSocketAddr((String)scmNodeInfo.getScmSecurityAddress());
            this.scmServiceId = scmNodeInfo.getServiceId();
            String scmNodeId = scmNodeInfo.getNodeId();
            this.scmNodeIds.add(scmNodeId);
            SCMProxyInfo scmProxyInfo = new SCMProxyInfo(this.scmServiceId, scmNodeId, scmSecurityAddress);
            this.scmProxyInfoMap.put(scmNodeId, scmProxyInfo);
        }
    }

    public synchronized FailoverProxyProvider.ProxyInfo<T> getProxy() {
        FailoverProxyProvider.ProxyInfo<T> currentProxyInfo = this.scmProxies.get(this.getCurrentProxySCMNodeId());
        if (currentProxyInfo == null) {
            currentProxyInfo = this.createSCMProxy(this.getCurrentProxySCMNodeId());
        }
        return currentProxyInfo;
    }

    private FailoverProxyProvider.ProxyInfo<T> createSCMProxy(String nodeId) {
        SCMProxyInfo scmProxyInfo = this.scmProxyInfoMap.get(nodeId);
        InetSocketAddress address = scmProxyInfo.getAddress();
        try {
            T scmProxy = this.createSCMProxy(address);
            FailoverProxyProvider.ProxyInfo proxyInfo = new FailoverProxyProvider.ProxyInfo(scmProxy, scmProxyInfo.toString());
            this.scmProxies.put(nodeId, proxyInfo);
            return proxyInfo;
        }
        catch (IOException ioe) {
            LOG.error("{} Failed to create RPC proxy to SCM at {}", new Object[]{this.getClass().getSimpleName(), address, ioe});
            throw new RuntimeException(ioe);
        }
    }

    private T createSCMProxy(InetSocketAddress scmAddress) throws IOException {
        Configuration hadoopConf = LegacyHadoopConfigurationSource.asHadoopConfiguration((ConfigurationSource)this.conf);
        RPC.setProtocolEngine((Configuration)hadoopConf, this.proxyClazz, ProtobufRpcEngine.class);
        RetryPolicy connectionRetryPolicy = RetryPolicies.failoverOnNetworkException((int)0);
        return (T)((SCMSecretKeyProtocolProtos.SCMSecretKeyProtocolService.BlockingInterface)RPC.getProtocolProxy(this.proxyClazz, (long)this.scmVersion, (InetSocketAddress)scmAddress, (UserGroupInformation)this.ugi, (Configuration)hadoopConf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)hadoopConf), (int)((int)this.scmClientConfig.getRpcTimeOut()), (RetryPolicy)connectionRetryPolicy).getProxy());
    }

    public synchronized void performFailover(T currentProxy) {
        if (this.updatedLeaderNodeID != null) {
            this.currentProxySCMNodeId = this.updatedLeaderNodeID;
        } else {
            this.nextProxyIndex();
        }
        LOG.debug("Failing over to next proxy. {}", (Object)this.getCurrentProxySCMNodeId());
    }

    public synchronized void performFailoverToAssignedLeader(String newLeader, Exception e) {
        ServerNotLeaderException snle = (ServerNotLeaderException)SCMHAUtils.getServerNotLeaderException((Exception)e);
        if (snle != null && snle.getSuggestedLeader() != null) {
            Optional<SCMProxyInfo> matchedProxyInfo = this.scmProxyInfoMap.values().stream().filter(proxyInfo -> NetUtils.getHostPortString((InetSocketAddress)proxyInfo.getAddress()).equals(snle.getSuggestedLeader())).findFirst();
            if (matchedProxyInfo.isPresent()) {
                newLeader = matchedProxyInfo.get().getNodeId();
                LOG.debug("Performing failover to suggested leader {}, nodeId {}", (Object)snle.getSuggestedLeader(), (Object)newLeader);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Suggested leader {} does not match with any of the proxyInfo adress {}", (Object)snle.getSuggestedLeader(), (Object)Arrays.toString(this.scmProxyInfoMap.values().toArray()));
            }
        }
        this.assignLeaderToNode(newLeader);
    }

    private synchronized void assignLeaderToNode(String newLeaderNodeId) {
        if (!this.currentProxySCMNodeId.equals(newLeaderNodeId)) {
            if (this.scmProxyInfoMap.containsKey(newLeaderNodeId)) {
                this.updatedLeaderNodeID = newLeaderNodeId;
                LOG.debug("Updated LeaderNodeID {}", (Object)this.updatedLeaderNodeID);
            } else {
                this.updatedLeaderNodeID = null;
            }
        }
    }

    private synchronized void nextProxyIndex() {
        this.currentProxyIndex = (this.getCurrentProxyIndex() + 1) % this.scmProxyInfoMap.size();
        this.currentProxySCMNodeId = this.scmNodeIds.get(this.currentProxyIndex);
    }

    public RetryPolicy getRetryPolicy() {
        return (exception, retries, failovers, isIdempotentOrAtMostOnce) -> {
            if (LOG.isDebugEnabled()) {
                if (exception.getCause() != null) {
                    LOG.debug("RetryProxy: SCM Security Server {}: {}: {}", new Object[]{this.getCurrentProxySCMNodeId(), exception.getCause().getClass().getSimpleName(), exception.getCause().getMessage()});
                } else {
                    LOG.debug("RetryProxy: SCM {}: {}", (Object)this.getCurrentProxySCMNodeId(), (Object)exception.getMessage());
                }
            }
            if (SCMHAUtils.checkRetriableWithNoFailoverException((Exception)exception)) {
                this.setUpdatedLeaderNodeID();
            } else {
                this.performFailoverToAssignedLeader(null, exception);
            }
            return SCMHAUtils.getRetryAction((int)failovers, (int)retries, (Exception)exception, (int)this.maxRetryCount, (long)this.getRetryInterval());
        };
    }

    public synchronized void setUpdatedLeaderNodeID() {
        this.updatedLeaderNodeID = this.getCurrentProxySCMNodeId();
    }

    public Class<T> getInterface() {
        return this.proxyClazz;
    }

    @Override
    public synchronized void close() throws IOException {
        for (FailoverProxyProvider.ProxyInfo<T> proxyInfo : this.scmProxies.values()) {
            if (proxyInfo.proxy == null) continue;
            RPC.stopProxy((Object)proxyInfo.proxy);
        }
    }

    public synchronized String getCurrentProxySCMNodeId() {
        return this.currentProxySCMNodeId;
    }

    public synchronized int getCurrentProxyIndex() {
        return this.currentProxyIndex;
    }

    private long getRetryInterval() {
        return this.retryInterval;
    }
}

