/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import com.google.common.annotations.VisibleForTesting;
import java.time.Duration;
import java.time.Instant;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.ozone.container.replication.AbstractReplicationTask;
import org.apache.hadoop.ozone.container.replication.ContainerReplicator;
import org.apache.hadoop.ozone.container.replication.ReplicationTask;
import org.apache.hadoop.util.Time;

@Metrics(about="Closed container replication metrics", context="dfs")
public class MeasuredReplicator
implements ContainerReplicator,
AutoCloseable {
    private static final String NAME = ContainerReplicator.class.getSimpleName();
    private final ContainerReplicator delegate;
    private final String name;
    @Metric(about="Number of successful replication tasks")
    private MutableCounterLong success;
    @Metric(about="Time spent on successful replication tasks")
    private MutableGaugeLong successTime;
    @Metric(about="Number of failed replication attempts")
    private MutableCounterLong failure;
    @Metric(about="Time spent waiting in the queue before starting the task")
    private MutableGaugeLong queueTime;
    @Metric(about="Time spent on failed replication attempts")
    private MutableGaugeLong failureTime;
    @Metric(about="Bytes transferred for failed replication attempts")
    private MutableGaugeLong failureBytes;
    @Metric(about="Bytes transferred for successful replication tasks")
    private MutableGaugeLong transferredBytes;

    public MeasuredReplicator(ContainerReplicator delegate, String name) {
        this.delegate = delegate;
        this.name = name;
        DefaultMetricsSystem.instance().register(this.metricsName(), "Closed container " + name + " replication metrics", (Object)this);
    }

    private String metricsName() {
        return NAME + "/" + this.name;
    }

    @Override
    public void replicate(ReplicationTask task) {
        long start = Time.monotonicNow();
        long msInQueue = Duration.between(task.getQueued(), Instant.now()).toMillis();
        this.queueTime.incr(msInQueue);
        this.delegate.replicate(task);
        long elapsed = Time.monotonicNow() - start;
        if (task.getStatus() == AbstractReplicationTask.Status.FAILED) {
            this.failure.incr();
            this.failureBytes.incr(task.getTransferredBytes());
            this.failureTime.incr(elapsed);
        } else if (task.getStatus() == AbstractReplicationTask.Status.DONE) {
            this.transferredBytes.incr(task.getTransferredBytes());
            this.success.incr();
            this.successTime.incr(elapsed);
        }
    }

    @Override
    public void close() throws Exception {
        DefaultMetricsSystem.instance().unregisterSource(this.metricsName());
    }

    @VisibleForTesting
    public MutableCounterLong getSuccess() {
        return this.success;
    }

    @VisibleForTesting
    public MutableGaugeLong getSuccessTime() {
        return this.successTime;
    }

    @VisibleForTesting
    public MutableGaugeLong getFailureTime() {
        return this.failureTime;
    }

    @VisibleForTesting
    public MutableCounterLong getFailure() {
        return this.failure;
    }

    @VisibleForTesting
    public MutableGaugeLong getQueueTime() {
        return this.queueTime;
    }

    @VisibleForTesting
    public MutableGaugeLong getTransferredBytes() {
        return this.transferredBytes;
    }

    @VisibleForTesting
    public MutableGaugeLong getFailureBytes() {
        return this.failureBytes;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.name + "}@" + Integer.toHexString(this.hashCode());
    }
}

