/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.volume;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.fs.SpaceUsageCheckFactory;
import org.apache.hadoop.hdds.fs.SpaceUsageCheckParams;
import org.apache.hadoop.hdds.fs.SpaceUsageSource;
import org.apache.hadoop.ozone.container.common.volume.VolumeUsage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VolumeInfo {
    private static final Logger LOG = LoggerFactory.getLogger(VolumeInfo.class);
    private final String rootDir;
    private final StorageType storageType;
    private final VolumeUsage usage;

    private VolumeInfo(Builder b) throws IOException {
        boolean succeeded;
        this.rootDir = b.rootDir;
        File root = new File(this.rootDir);
        boolean bl = succeeded = root.isDirectory() || root.mkdirs();
        if (!succeeded) {
            LOG.error("Unable to create the volume root dir at : {}", (Object)root);
            throw new IOException("Unable to create the volume root dir at " + root);
        }
        this.storageType = b.storageType != null ? b.storageType : StorageType.DEFAULT;
        SpaceUsageCheckFactory usageCheckFactory = b.usageCheckFactory;
        if (usageCheckFactory == null) {
            usageCheckFactory = SpaceUsageCheckFactory.create((ConfigurationSource)b.conf);
        }
        SpaceUsageCheckParams checkParams = usageCheckFactory.paramsFor(root);
        this.usage = new VolumeUsage(checkParams, b.conf);
    }

    public long getCapacity() {
        return this.usage.getCapacity();
    }

    public long getAvailable() {
        return this.usage.getAvailable();
    }

    public SpaceUsageSource getCurrentUsage() {
        return this.usage.getCurrentUsage();
    }

    public void incrementUsedSpace(long usedSpace) {
        this.usage.incrementUsedSpace(usedSpace);
    }

    public void decrementUsedSpace(long reclaimedSpace) {
        this.usage.decrementUsedSpace(reclaimedSpace);
    }

    public void refreshNow() {
        this.usage.refreshNow();
    }

    public long getScmUsed() {
        return this.usage.getUsedSpace();
    }

    void shutdownUsageThread() {
        this.usage.shutdown();
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    @VisibleForTesting
    public VolumeUsage getUsageForTesting() {
        return this.usage;
    }

    public long getReservedInBytes() {
        return this.usage.getReservedBytes();
    }

    public static class Builder {
        private final ConfigurationSource conf;
        private final String rootDir;
        private SpaceUsageCheckFactory usageCheckFactory;
        private StorageType storageType;

        public Builder(String root, ConfigurationSource config) {
            this.rootDir = root;
            this.conf = config;
        }

        public Builder storageType(StorageType st) {
            this.storageType = st;
            return this;
        }

        public Builder usageCheckFactory(SpaceUsageCheckFactory factory) {
            this.usageCheckFactory = factory;
            return this;
        }

        public VolumeInfo build() throws IOException {
            return new VolumeInfo(this);
        }
    }
}

