/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine.commandhandler;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.ozone.container.common.statemachine.SCMConnectionManager;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.CommandHandler;
import org.apache.hadoop.ozone.container.ozoneimpl.OzoneContainer;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshVolumeUsageCommandHandler
implements CommandHandler {
    static final Logger LOG = LoggerFactory.getLogger(RefreshVolumeUsageCommandHandler.class);
    private final AtomicInteger invocationCount = new AtomicInteger(0);
    private final AtomicLong totalTime = new AtomicLong(0L);

    @Override
    public void handle(SCMCommand command, OzoneContainer container, StateContext context, SCMConnectionManager connectionManager) {
        LOG.info("receive command to refresh usage info of all volumes");
        this.invocationCount.incrementAndGet();
        long startTime = Time.monotonicNow();
        container.getVolumeSet().refreshAllVolumeUsage();
        this.totalTime.getAndAdd(Time.monotonicNow() - startTime);
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type getCommandType() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.refreshVolumeUsageInfo;
    }

    @Override
    public int getInvocationCount() {
        return this.invocationCount.get();
    }

    @Override
    public long getAverageRunTime() {
        int invocations = this.invocationCount.get();
        return invocations == 0 ? 0L : this.totalTime.get() / (long)invocations;
    }

    @Override
    public long getTotalRunTime() {
        return this.totalTime.get();
    }

    @Override
    public int getQueuedCount() {
        return 0;
    }
}

