/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;
import org.apache.hadoop.hdds.conf.PostConstruct;
import org.apache.hadoop.hdds.conf.ReconfigurableConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigGroup(prefix="hdds.datanode")
public class DatanodeConfiguration
extends ReconfigurableConfig {
    public static final String CONFIG_PREFIX = "hdds.datanode";
    private static final String BLOCK_DELETE_THREAD_MAX = "block.delete.threads.max";
    public static final String HDDS_DATANODE_BLOCK_DELETE_THREAD_MAX = "hdds.datanode.block.delete.threads.max";
    private static final Logger LOG = LoggerFactory.getLogger(DatanodeConfiguration.class);
    static final String CONTAINER_DELETE_THREADS_MAX_KEY = "hdds.datanode.container.delete.threads.max";
    static final String CONTAINER_CLOSE_THREADS_MAX_KEY = "hdds.datanode.container.close.threads.max";
    static final String PERIODIC_DISK_CHECK_INTERVAL_MINUTES_KEY = "hdds.datanode.periodic.disk.check.interval.minutes";
    public static final String DISK_CHECK_FILE_SIZE_KEY = "hdds.datanode.disk.check.io.file.size";
    public static final String DISK_CHECK_IO_TEST_COUNT_KEY = "hdds.datanode.disk.check.io.test.count";
    public static final String DISK_CHECK_IO_FAILURES_TOLERATED_KEY = "hdds.datanode.disk.check.io.failures.tolerated";
    public static final String FAILED_DATA_VOLUMES_TOLERATED_KEY = "hdds.datanode.failed.data.volumes.tolerated";
    public static final String FAILED_METADATA_VOLUMES_TOLERATED_KEY = "hdds.datanode.failed.metadata.volumes.tolerated";
    public static final String FAILED_DB_VOLUMES_TOLERATED_KEY = "hdds.datanode.failed.db.volumes.tolerated";
    public static final String DISK_CHECK_MIN_GAP_KEY = "hdds.datanode.disk.check.min.gap";
    public static final String DISK_CHECK_TIMEOUT_KEY = "hdds.datanode.disk.check.timeout";
    public static final String WAIT_ON_ALL_FOLLOWERS = "hdds.datanode.wait.on.all.followers";
    public static final String CONTAINER_SCHEMA_V3_ENABLED = "hdds.datanode.container.schema.v3.enabled";
    static final boolean CHUNK_DATA_VALIDATION_CHECK_DEFAULT = false;
    static final long PERIODIC_DISK_CHECK_INTERVAL_MINUTES_DEFAULT = 60L;
    static final int FAILED_VOLUMES_TOLERATED_DEFAULT = -1;
    public static final int DISK_CHECK_IO_TEST_COUNT_DEFAULT = 3;
    public static final int DISK_CHECK_IO_FAILURES_TOLERATED_DEFAULT = 1;
    public static final int DISK_CHECK_FILE_SIZE_DEFAULT = 100;
    static final boolean WAIT_ON_ALL_FOLLOWERS_DEFAULT = false;
    static final Duration DISK_CHECK_MIN_GAP_DEFAULT = Duration.ofMinutes(10L);
    static final Duration DISK_CHECK_TIMEOUT_DEFAULT = Duration.ofMinutes(10L);
    static final boolean CONTAINER_SCHEMA_V3_ENABLED_DEFAULT = true;
    static final long ROCKSDB_LOG_MAX_FILE_SIZE_BYTES_DEFAULT = 0x2000000L;
    static final int ROCKSDB_LOG_MAX_FILE_NUM_DEFAULT = 64;
    static final long ROCKSDB_DELETE_OBSOLETE_FILES_PERIOD_MICRO_SECONDS_DEFAULT = 3600000000L;
    static final int ROCKSDB_MAX_OPEN_FILES_DEFAULT = 1024;
    public static final String ROCKSDB_LOG_MAX_FILE_SIZE_BYTES_KEY = "hdds.datanode.rocksdb.log.max-file-size";
    public static final String ROCKSDB_LOG_MAX_FILE_NUM_KEY = "hdds.datanode.rocksdb.log.max-file-num";
    public static final String ROCKSDB_DELETE_OBSOLETE_FILES_PERIOD_MICRO_SECONDS_KEY = "hdds.datanode.rocksdb.delete_obsolete_files_period";
    public static final Boolean OZONE_DATANODE_CHECK_EMPTY_CONTAINER_DIR_ON_DELETE_DEFAULT = false;
    @Config(key="read.chunk.threads.per.volume", type=ConfigType.INT, defaultValue="10", tags={ConfigTag.DATANODE}, description="Number of threads per volume that Datanode will use for reading replicated chunks.")
    private int numReadThreadPerVolume = 10;
    static final int CONTAINER_DELETE_THREADS_DEFAULT = 2;
    static final int CONTAINER_CLOSE_THREADS_DEFAULT = 3;
    static final int BLOCK_DELETE_THREADS_DEFAULT = 5;
    public static final String BLOCK_DELETE_COMMAND_WORKER_INTERVAL = "hdds.datanode.block.delete.command.worker.interval";
    public static final Duration BLOCK_DELETE_COMMAND_WORKER_INTERVAL_DEFAULT = Duration.ofSeconds(2L);
    @Config(key="container.delete.threads.max", type=ConfigType.INT, defaultValue="2", tags={ConfigTag.DATANODE}, description="The maximum number of threads used to delete containers on a datanode")
    private int containerDeleteThreads = 2;
    @Config(key="container.close.threads.max", type=ConfigType.INT, defaultValue="3", tags={ConfigTag.DATANODE}, description="The maximum number of threads used to close containers on a datanode")
    private int containerCloseThreads = 3;
    @Config(key="block.delete.threads.max", type=ConfigType.INT, defaultValue="5", tags={ConfigTag.DATANODE}, description="The maximum number of threads used to handle delete  blocks on a datanode")
    private int blockDeleteThreads = 5;
    @Config(key="block.delete.queue.limit", type=ConfigType.INT, defaultValue="5", tags={ConfigTag.DATANODE}, description="The maximum number of block delete commands queued on  a datanode, This configuration is also used by the SCM to control whether to send delete commands to the DN. If the DN has more commands waiting in the queue than this value, the SCM will not send any new block delete commands. until the DN has processed some commands and the queue length is reduced.")
    private int blockDeleteQueueLimit = 5;
    @Config(key="block.delete.command.worker.interval", type=ConfigType.TIME, defaultValue="2s", tags={ConfigTag.DATANODE}, description="The interval between DeleteCmdWorker execution of delete commands.")
    private Duration blockDeleteCommandWorkerInterval = BLOCK_DELETE_COMMAND_WORKER_INTERVAL_DEFAULT;
    @Config(key="command.queue.limit", type=ConfigType.INT, defaultValue="5000", tags={ConfigTag.DATANODE}, description="The default maximum number of commands in the queue and command type's sub-queue on a datanode")
    private int cmdQueueLimit = 5000;
    @Config(key="block.deleting.service.interval", defaultValue="60s", type=ConfigType.TIME, tags={ConfigTag.SCM, ConfigTag.DELETION}, description="Time interval of the Datanode block deleting service. The block deleting service runs on Datanode periodically and deletes blocks queued for deletion. Unit could be defined with postfix (ns,ms,s,m,h,d). ")
    private Duration blockDeletionInterval = Duration.ofSeconds(60L);
    @Config(key="recovering.container.scrubbing.service.interval", defaultValue="1m", type=ConfigType.TIME, tags={ConfigTag.SCM, ConfigTag.DELETION}, description="Time interval of the stale recovering container scrubbing service. The recovering container scrubbing service runs on Datanode periodically and deletes stale recovering container Unit could be defined with postfix (ns,ms,s,m,h,d).")
    private Duration recoveringContainerScrubInterval = Duration.ofMinutes(10L);
    @Config(key="block.delete.max.lock.wait.timeout", defaultValue="100ms", type=ConfigType.TIME, tags={ConfigTag.DATANODE, ConfigTag.DELETION}, description="Timeout for the thread used to process the delete block command to wait for the container lock.")
    private long blockDeleteMaxLockWaitTimeoutMs = Duration.ofMillis(100L).toMillis();
    @Config(key="block.deleting.limit.per.interval", defaultValue="5000", reconfigurable=true, type=ConfigType.INT, tags={ConfigTag.SCM, ConfigTag.DELETION}, description="Number of blocks to be deleted in an interval.")
    private int blockLimitPerInterval = 5000;
    @Config(key="block.deleting.max.lock.holding.time", defaultValue="1s", type=ConfigType.TIME, tags={ConfigTag.DATANODE, ConfigTag.DELETION}, description="This configuration controls the maximum time that the block deleting service can hold the lock during the deletion of blocks. Once this configured time period is reached, the service will release and re-acquire the lock. This is not a hard limit as the time check only occurs after the completion of each transaction, which means the actual execution time may exceed this limit. Unit could be defined with postfix (ns,ms,s,m,h,d). ")
    private long blockDeletingMaxLockHoldingTime = Duration.ofSeconds(1L).toMillis();
    @Config(key="periodic.disk.check.interval.minutes", defaultValue="60", type=ConfigType.LONG, tags={ConfigTag.DATANODE}, description="Periodic disk check run interval in minutes.")
    private long periodicDiskCheckIntervalMinutes = 60L;
    @Config(key="failed.data.volumes.tolerated", defaultValue="-1", type=ConfigType.INT, tags={ConfigTag.DATANODE}, description="The number of data volumes that are allowed to fail before a datanode stops offering service. Config this to -1 means unlimited, but we should have at least one good volume left.")
    private int failedDataVolumesTolerated = -1;
    @Config(key="failed.metadata.volumes.tolerated", defaultValue="-1", type=ConfigType.INT, tags={ConfigTag.DATANODE}, description="The number of metadata volumes that are allowed to fail before a datanode stops offering service. Config this to -1 means unlimited, but we should have at least one good volume left.")
    private int failedMetadataVolumesTolerated = -1;
    @Config(key="failed.db.volumes.tolerated", defaultValue="-1", type=ConfigType.INT, tags={ConfigTag.DATANODE}, description="The number of db volumes that are allowed to fail before a datanode stops offering service. Config this to -1 means unlimited, but we should have at least one good volume left.")
    private int failedDbVolumesTolerated = -1;
    @Config(key="disk.check.io.test.count", defaultValue="3", type=ConfigType.INT, tags={ConfigTag.DATANODE}, description="The number of IO tests required to determine if a disk  has failed. Each disk check does one IO test. The volume will be failed if more than hdds.datanode.disk.check.io.failures.tolerated out of the last hdds.datanode.disk.check.io.test.count runs failed. Set to 0 to disable disk IO checks.")
    private int volumeIOTestCount = 3;
    @Config(key="disk.check.io.failures.tolerated", defaultValue="1", type=ConfigType.INT, tags={ConfigTag.DATANODE}, description="The number of IO tests out of the last hdds.datanode.disk.check.io.test.count test run that are allowed to fail before the volume is marked as failed.")
    private int volumeIOFailureTolerance = 1;
    @Config(key="disk.check.io.file.size", defaultValue="100B", type=ConfigType.SIZE, tags={ConfigTag.DATANODE}, description="The size of the temporary file that will be synced to the disk and read back to assess its health. The contents of the file will be stored in memory during the duration of the check.")
    private int volumeHealthCheckFileSize = 100;
    @Config(key="disk.check.min.gap", defaultValue="10m", type=ConfigType.TIME, tags={ConfigTag.DATANODE}, description="The minimum gap between two successive checks of the same Datanode volume. Unit could be defined with postfix (ns,ms,s,m,h,d).")
    private Duration diskCheckMinGap = DISK_CHECK_MIN_GAP_DEFAULT;
    @Config(key="disk.check.timeout", defaultValue="10m", type=ConfigType.TIME, tags={ConfigTag.DATANODE}, description="Maximum allowed time for a disk check to complete. If the check does not complete within this time interval then the disk is declared as failed. Unit could be defined with postfix (ns,ms,s,m,h,d).")
    private Duration diskCheckTimeout = DISK_CHECK_TIMEOUT_DEFAULT;
    @Config(key="chunk.data.validation.check", defaultValue="false", type=ConfigType.BOOLEAN, tags={ConfigTag.DATANODE}, description="Enable safety checks such as checksum validation for Ratis calls.")
    private boolean isChunkDataValidationCheck = false;
    @Config(key="wait.on.all.followers", defaultValue="false", type=ConfigType.BOOLEAN, tags={ConfigTag.DATANODE}, description="Defines whether the leader datanode will wait for bothfollowers to catch up before removing the stateMachineData from the cache.")
    private boolean waitOnAllFollowers = false;
    @Config(key="container.schema.v3.enabled", defaultValue="true", type=ConfigType.BOOLEAN, tags={ConfigTag.DATANODE}, description="Enable use of container schema v3(one rocksdb per disk).")
    private boolean containerSchemaV3Enabled = true;
    @Config(key="container.schema.v3.key.separator", defaultValue="|", type=ConfigType.STRING, tags={ConfigTag.DATANODE}, description="The default separator between Container ID and container meta key name.")
    private String containerSchemaV3KeySeparator = "|";
    @Config(key="rocksdb.log.level", defaultValue="INFO", type=ConfigType.STRING, tags={ConfigTag.DATANODE}, description="The user log level of RocksDB(DEBUG/INFO/WARN/ERROR/FATAL))")
    private String rocksdbLogLevel = "INFO";
    @Config(key="rocksdb.log.max-file-size", defaultValue="32MB", type=ConfigType.SIZE, tags={ConfigTag.DATANODE}, description="The max size of each user log file of RocksDB. O means no size limit.")
    private long rocksdbLogMaxFileSize = 0x2000000L;
    @Config(key="rocksdb.log.max-file-num", defaultValue="64", type=ConfigType.INT, tags={ConfigTag.DATANODE}, description="The max user log file number to keep for each RocksDB")
    private int rocksdbLogMaxFileNum = 64;
    @Config(key="rocksdb.delete-obsolete-files-period", defaultValue="1h", timeUnit=TimeUnit.MICROSECONDS, type=ConfigType.TIME, tags={ConfigTag.DATANODE}, description="Periodicity when obsolete files get deleted. Default is 1h.")
    private long rocksdbDeleteObsoleteFilesPeriod = 3600000000L;
    @Config(key="rocksdb.max-open-files", defaultValue="1024", type=ConfigType.INT, tags={ConfigTag.DATANODE}, description="The total number of files that a RocksDB can open. ")
    private int rocksdbMaxOpenFiles = 1024;
    @Config(key="rocksdb.auto-compaction-small-sst-file", defaultValue="true", type=ConfigType.BOOLEAN, tags={ConfigTag.DATANODE}, description="Auto compact small SST files (rocksdb.auto-compaction-small-sst-file-size-threshold) when count exceeds (rocksdb.auto-compaction-small-sst-file-num-threshold)")
    private boolean autoCompactionSmallSstFile = true;
    @Config(key="rocksdb.auto-compaction-small-sst-file-size-threshold", defaultValue="1MB", type=ConfigType.SIZE, tags={ConfigTag.DATANODE}, description="SST files smaller than this configuration will be auto compacted.")
    private long autoCompactionSmallSstFileSize = 0x100000L;
    @Config(key="rocksdb.auto-compaction-small-sst-file-num-threshold", defaultValue="512", type=ConfigType.INT, tags={ConfigTag.DATANODE}, description="Auto compaction will happen if the number of small SST  files exceeds this threshold.")
    private int autoCompactionSmallSstFileNum = 512;
    @Config(key="check.empty.container.dir.on.delete", type=ConfigType.BOOLEAN, defaultValue="false", tags={ConfigTag.DATANODE}, description="Boolean Flag to decide whether to check container directory or not to determine container is empty")
    private boolean bCheckEmptyContainerDir = OZONE_DATANODE_CHECK_EMPTY_CONTAINER_DIR_ON_DELETE_DEFAULT;

    public Duration getBlockDeletionInterval() {
        return this.blockDeletionInterval;
    }

    public void setRecoveringContainerScrubInterval(Duration duration) {
        this.recoveringContainerScrubInterval = duration;
    }

    public Duration getRecoveringContainerScrubInterval() {
        return this.recoveringContainerScrubInterval;
    }

    public void setBlockDeletionInterval(Duration duration) {
        this.blockDeletionInterval = duration;
    }

    public int getBlockDeletionLimit() {
        return this.blockLimitPerInterval;
    }

    public Duration getBlockDeletingMaxLockHoldingTime() {
        return Duration.ofMillis(this.blockDeletingMaxLockHoldingTime);
    }

    public void setBlockDeletingMaxLockHoldingTime(Duration maxLockHoldingTime) {
        this.blockDeletingMaxLockHoldingTime = maxLockHoldingTime.toMillis();
    }

    public void setBlockDeletionLimit(int limit) {
        this.blockLimitPerInterval = limit;
    }

    public boolean waitOnAllFollowers() {
        return this.waitOnAllFollowers;
    }

    public void setWaitOnAllFollowers(boolean val) {
        this.waitOnAllFollowers = val;
    }

    @PostConstruct
    public void validate() {
        if (this.containerDeleteThreads < 1) {
            LOG.warn("hdds.datanode.container.delete.threads.max must be greater than zero and was set to {}. Defaulting to {}", (Object)this.containerDeleteThreads, (Object)2);
            this.containerDeleteThreads = 2;
        }
        if (this.containerCloseThreads < 1) {
            LOG.warn("hdds.datanode.container.close.threads.max must be greater than zero and was set to {}. Defaulting to {}", (Object)this.containerCloseThreads, (Object)3);
            this.containerCloseThreads = 3;
        }
        if (this.periodicDiskCheckIntervalMinutes < 1L) {
            LOG.warn("hdds.datanode.periodic.disk.check.interval.minutes must be greater than zero and was set to {}. Defaulting to {}", (Object)this.periodicDiskCheckIntervalMinutes, (Object)60L);
            this.periodicDiskCheckIntervalMinutes = 60L;
        }
        if (this.failedDataVolumesTolerated < -1) {
            LOG.warn("hdds.datanode.failed.data.volumes.toleratedmust be greater than -1 and was set to {}. Defaulting to {}", (Object)this.failedDataVolumesTolerated, (Object)-1);
            this.failedDataVolumesTolerated = -1;
        }
        if (this.failedMetadataVolumesTolerated < -1) {
            LOG.warn("hdds.datanode.failed.metadata.volumes.toleratedmust be greater than -1 and was set to {}. Defaulting to {}", (Object)this.failedMetadataVolumesTolerated, (Object)-1);
            this.failedMetadataVolumesTolerated = -1;
        }
        if (this.failedDbVolumesTolerated < -1) {
            LOG.warn("hdds.datanode.failed.db.volumes.toleratedmust be greater than -1 and was set to {}. Defaulting to {}", (Object)this.failedDbVolumesTolerated, (Object)-1);
            this.failedDbVolumesTolerated = -1;
        }
        if (this.volumeIOTestCount == 0) {
            LOG.info("{} set to {}. Disk IO health tests have been disabled.", (Object)DISK_CHECK_IO_TEST_COUNT_KEY, (Object)this.volumeIOTestCount);
        } else {
            if (this.volumeIOTestCount < 0) {
                LOG.warn("{} must be greater than 0 but was set to {}.Defaulting to {}", new Object[]{DISK_CHECK_IO_TEST_COUNT_KEY, this.volumeIOTestCount, 3});
                this.volumeIOTestCount = 3;
            }
            if (this.volumeIOFailureTolerance < 0) {
                LOG.warn("{} must be greater than or equal to 0 but was set to {}. Defaulting to {}", new Object[]{DISK_CHECK_IO_FAILURES_TOLERATED_KEY, this.volumeIOFailureTolerance, 1});
                this.volumeIOFailureTolerance = 1;
            }
            if (this.volumeIOFailureTolerance >= this.volumeIOTestCount) {
                LOG.warn("{} was set to {} but cannot be greater or equals to {} set to {}. Defaulting {} to {} and {} to {}", new Object[]{DISK_CHECK_IO_FAILURES_TOLERATED_KEY, this.volumeIOFailureTolerance, DISK_CHECK_IO_TEST_COUNT_KEY, this.volumeIOTestCount, DISK_CHECK_IO_FAILURES_TOLERATED_KEY, 1, DISK_CHECK_IO_TEST_COUNT_KEY, 3});
                this.volumeIOTestCount = 3;
                this.volumeIOFailureTolerance = 1;
            }
            if (this.volumeHealthCheckFileSize < 1) {
                LOG.warn("hdds.datanode.disk.check.io.file.sizemust be at least 1 byte and was set to {}. Defaulting to {}", (Object)this.volumeHealthCheckFileSize, (Object)100);
                this.volumeHealthCheckFileSize = 100;
            }
        }
        if (this.diskCheckMinGap.isNegative()) {
            LOG.warn("hdds.datanode.disk.check.min.gap must be greater than zero and was set to {}. Defaulting to {}", (Object)this.diskCheckMinGap, (Object)DISK_CHECK_MIN_GAP_DEFAULT);
            this.diskCheckMinGap = DISK_CHECK_MIN_GAP_DEFAULT;
        }
        if (this.diskCheckTimeout.isNegative()) {
            LOG.warn("hdds.datanode.disk.check.timeout must be greater than zero and was set to {}. Defaulting to {}", (Object)this.diskCheckTimeout, (Object)DISK_CHECK_TIMEOUT_DEFAULT);
            this.diskCheckTimeout = DISK_CHECK_TIMEOUT_DEFAULT;
        }
        if (this.blockDeleteCommandWorkerInterval.isNegative()) {
            LOG.warn("hdds.datanode.block.delete.command.worker.interval must be greater than zero and was set to {}. Defaulting to {}", (Object)this.blockDeleteCommandWorkerInterval, (Object)BLOCK_DELETE_COMMAND_WORKER_INTERVAL_DEFAULT);
            this.blockDeleteCommandWorkerInterval = BLOCK_DELETE_COMMAND_WORKER_INTERVAL_DEFAULT;
        }
        if (this.rocksdbLogMaxFileSize < 0L) {
            LOG.warn("hdds.datanode.rocksdb.log.max-file-size must be no less than zero and was set to {}. Defaulting to {}", (Object)this.rocksdbLogMaxFileSize, (Object)0x2000000L);
            this.rocksdbLogMaxFileSize = 0x2000000L;
        }
        if (this.rocksdbLogMaxFileNum <= 0) {
            LOG.warn("hdds.datanode.rocksdb.log.max-file-num must be greater than zero and was set to {}. Defaulting to {}", (Object)this.rocksdbLogMaxFileNum, (Object)64);
            this.rocksdbLogMaxFileNum = 64;
        }
        if (this.rocksdbDeleteObsoleteFilesPeriod <= 0L) {
            LOG.warn("hdds.datanode.rocksdb.delete_obsolete_files_period must be greater than zero and was set to {}. Defaulting to {}", (Object)this.rocksdbDeleteObsoleteFilesPeriod, (Object)3600000000L);
            this.rocksdbDeleteObsoleteFilesPeriod = 3600000000L;
        }
    }

    public void setContainerDeleteThreads(int containerDeleteThreads) {
        this.containerDeleteThreads = containerDeleteThreads;
    }

    public int getContainerDeleteThreads() {
        return this.containerDeleteThreads;
    }

    public void setContainerCloseThreads(int containerCloseThreads) {
        this.containerCloseThreads = containerCloseThreads;
    }

    public int getContainerCloseThreads() {
        return this.containerCloseThreads;
    }

    public long getPeriodicDiskCheckIntervalMinutes() {
        return this.periodicDiskCheckIntervalMinutes;
    }

    public void setPeriodicDiskCheckIntervalMinutes(long periodicDiskCheckIntervalMinutes) {
        this.periodicDiskCheckIntervalMinutes = periodicDiskCheckIntervalMinutes;
    }

    public int getFailedDataVolumesTolerated() {
        return this.failedDataVolumesTolerated;
    }

    public void setFailedDataVolumesTolerated(int failedVolumesTolerated) {
        this.failedDataVolumesTolerated = failedVolumesTolerated;
    }

    public int getFailedMetadataVolumesTolerated() {
        return this.failedMetadataVolumesTolerated;
    }

    public void setFailedMetadataVolumesTolerated(int failedVolumesTolerated) {
        this.failedMetadataVolumesTolerated = failedVolumesTolerated;
    }

    public int getFailedDbVolumesTolerated() {
        return this.failedDbVolumesTolerated;
    }

    public void setFailedDbVolumesTolerated(int failedVolumesTolerated) {
        this.failedDbVolumesTolerated = failedVolumesTolerated;
    }

    public int getVolumeIOTestCount() {
        return this.volumeIOTestCount;
    }

    public void setVolumeIOTestCount(int testCount) {
        this.volumeIOTestCount = testCount;
    }

    public int getVolumeIOFailureTolerance() {
        return this.volumeIOFailureTolerance;
    }

    public void setVolumeIOFailureTolerance(int failureTolerance) {
        this.volumeIOFailureTolerance = failureTolerance;
    }

    public int getVolumeHealthCheckFileSize() {
        return this.volumeHealthCheckFileSize;
    }

    public void getVolumeHealthCheckFileSize(int fileSizeBytes) {
        this.volumeHealthCheckFileSize = fileSizeBytes;
    }

    public boolean getCheckEmptyContainerDir() {
        return this.bCheckEmptyContainerDir;
    }

    public Duration getDiskCheckMinGap() {
        return this.diskCheckMinGap;
    }

    public void setDiskCheckMinGap(Duration duration) {
        this.diskCheckMinGap = duration;
    }

    public Duration getDiskCheckTimeout() {
        return this.diskCheckTimeout;
    }

    public void setDiskCheckTimeout(Duration duration) {
        this.diskCheckTimeout = duration;
    }

    public int getBlockDeleteThreads() {
        return this.blockDeleteThreads;
    }

    public void setBlockDeleteThreads(int threads) {
        this.blockDeleteThreads = threads;
    }

    public int getBlockDeleteQueueLimit() {
        return this.blockDeleteQueueLimit;
    }

    public long getBlockDeleteMaxLockWaitTimeoutMs() {
        return this.blockDeleteMaxLockWaitTimeoutMs;
    }

    public void setBlockDeleteQueueLimit(int queueLimit) {
        this.blockDeleteQueueLimit = queueLimit;
    }

    public Duration getBlockDeleteCommandWorkerInterval() {
        return this.blockDeleteCommandWorkerInterval;
    }

    public void setBlockDeleteCommandWorkerInterval(Duration blockDeleteCommandWorkerInterval) {
        this.blockDeleteCommandWorkerInterval = blockDeleteCommandWorkerInterval;
    }

    public int getCommandQueueLimit() {
        return this.cmdQueueLimit;
    }

    public void setCommandQueueLimit(int queueLimit) {
        this.cmdQueueLimit = queueLimit;
    }

    public boolean isChunkDataValidationCheck() {
        return this.isChunkDataValidationCheck;
    }

    public void setChunkDataValidationCheck(boolean writeChunkValidationCheck) {
        this.isChunkDataValidationCheck = writeChunkValidationCheck;
    }

    public void setNumReadThreadPerVolume(int threads) {
        this.numReadThreadPerVolume = threads;
    }

    public int getNumReadThreadPerVolume() {
        return this.numReadThreadPerVolume;
    }

    public boolean getContainerSchemaV3Enabled() {
        return this.containerSchemaV3Enabled;
    }

    public void setContainerSchemaV3Enabled(boolean containerSchemaV3Enabled) {
        this.containerSchemaV3Enabled = containerSchemaV3Enabled;
    }

    public String getContainerSchemaV3KeySeparator() {
        return this.containerSchemaV3KeySeparator;
    }

    public void setContainerSchemaV3KeySeparator(String separator) {
        this.containerSchemaV3KeySeparator = separator;
    }

    public String getRocksdbLogLevel() {
        return this.rocksdbLogLevel;
    }

    public void setRocksdbLogLevel(String level) {
        this.rocksdbLogLevel = level;
    }

    public void setRocksdbLogMaxFileNum(int count) {
        this.rocksdbLogMaxFileNum = count;
    }

    public int getRocksdbLogMaxFileNum() {
        return this.rocksdbLogMaxFileNum;
    }

    public void setRocksdbLogMaxFileSize(long size) {
        this.rocksdbLogMaxFileSize = size;
    }

    public long getRocksdbLogMaxFileSize() {
        return this.rocksdbLogMaxFileSize;
    }

    public long getRocksdbDeleteObsoleteFilesPeriod() {
        return this.rocksdbDeleteObsoleteFilesPeriod;
    }

    public void setRocksdbDeleteObsoleteFilesPeriod(long period) {
        this.rocksdbDeleteObsoleteFilesPeriod = period;
    }

    public void setRocksdbMaxOpenFiles(int count) {
        this.rocksdbMaxOpenFiles = count;
    }

    public int getRocksdbMaxOpenFiles() {
        return this.rocksdbMaxOpenFiles;
    }

    public boolean autoCompactionSmallSstFile() {
        return this.autoCompactionSmallSstFile;
    }

    public void setAutoCompactionSmallSstFile(boolean auto) {
        this.autoCompactionSmallSstFile = auto;
    }

    public long getAutoCompactionSmallSstFileSize() {
        return this.autoCompactionSmallSstFileSize;
    }

    public void setAutoCompactionSmallSstFileSize(long size) {
        this.autoCompactionSmallSstFileSize = size;
    }

    public int getAutoCompactionSmallSstFileNum() {
        return this.autoCompactionSmallSstFileNum;
    }

    public void setAutoCompactionSmallSstFileNum(int num) {
        this.autoCompactionSmallSstFileNum = num;
    }
}

