/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.ozone.util.ShutdownHookManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeLibraryLoader {
    private static final Logger LOG = LoggerFactory.getLogger(NativeLibraryLoader.class);
    public static final int LIBRARY_SHUTDOWN_HOOK_PRIORITY = 1;
    private static final String OS = System.getProperty("os.name").toLowerCase();
    public static final String NATIVE_LIB_TMP_DIR = "native.lib.tmp.dir";
    private Map<String, Boolean> librariesLoaded;
    private static volatile NativeLibraryLoader instance;

    public NativeLibraryLoader(Map<String, Boolean> librariesLoaded) {
        this.librariesLoaded = librariesLoaded;
    }

    private static synchronized void initNewInstance() {
        if (instance == null) {
            instance = new NativeLibraryLoader(new ConcurrentHashMap<String, Boolean>());
        }
    }

    public static NativeLibraryLoader getInstance() {
        if (instance == null) {
            NativeLibraryLoader.initNewInstance();
        }
        return instance;
    }

    public static String getJniLibraryFileName(String libraryName) {
        return NativeLibraryLoader.appendLibOsSuffix("lib" + libraryName);
    }

    public static boolean isMac() {
        return OS.startsWith("mac");
    }

    public static boolean isWindows() {
        return OS.startsWith("win");
    }

    public static boolean isLinux() {
        return OS.startsWith("linux");
    }

    @VisibleForTesting
    static String getLibOsSuffix() {
        if (NativeLibraryLoader.isMac()) {
            return ".dylib";
        }
        if (NativeLibraryLoader.isWindows()) {
            return ".dll";
        }
        if (NativeLibraryLoader.isLinux()) {
            return ".so";
        }
        throw new UnsatisfiedLinkError(String.format("Unsupported OS %s", OS));
    }

    private static String appendLibOsSuffix(String libraryFileName) {
        return libraryFileName + NativeLibraryLoader.getLibOsSuffix();
    }

    public static boolean isLibraryLoaded(String libraryName) {
        return NativeLibraryLoader.getInstance().librariesLoaded.getOrDefault(libraryName, false);
    }

    public synchronized boolean loadLibrary(String libraryName) {
        if (NativeLibraryLoader.isLibraryLoaded(libraryName)) {
            return true;
        }
        LOG.info("Loading Library: {}", (Object)libraryName);
        boolean loaded = false;
        try {
            Optional<File> file;
            loaded = false;
            try {
                System.loadLibrary(libraryName);
                loaded = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!loaded && (file = this.copyResourceFromJarToTemp(libraryName)).isPresent()) {
                System.load(file.get().getAbsolutePath());
                loaded = true;
            }
        }
        catch (Throwable e) {
            LOG.warn("Unable to load library: {}", (Object)libraryName, (Object)e);
        }
        this.librariesLoaded.put(libraryName, loaded);
        return NativeLibraryLoader.isLibraryLoaded(libraryName);
    }

    @VisibleForTesting
    static String getSystemProperty(String property) {
        return System.getProperty(property);
    }

    @VisibleForTesting
    static InputStream getResourceStream(String libraryFileName) {
        return NativeLibraryLoader.class.getClassLoader().getResourceAsStream(libraryFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<File> copyResourceFromJarToTemp(String libraryName) throws IOException {
        String libraryFileName = NativeLibraryLoader.getJniLibraryFileName(libraryName);
        try (InputStream is = null;){
            is = NativeLibraryLoader.getResourceStream(libraryFileName);
            if (is == null) {
                Optional<File> optional = Optional.empty();
                return optional;
            }
            String nativeLibDir = Objects.nonNull(NativeLibraryLoader.getSystemProperty(NATIVE_LIB_TMP_DIR)) ? NativeLibraryLoader.getSystemProperty(NATIVE_LIB_TMP_DIR) : "";
            File dir = new File(nativeLibDir).getAbsoluteFile();
            File temp = File.createTempFile(libraryName, NativeLibraryLoader.getLibOsSuffix(), dir);
            if (!temp.exists()) {
                Optional<File> optional = Optional.empty();
                return optional;
            }
            temp.deleteOnExit();
            Files.copy(is, temp.toPath(), StandardCopyOption.REPLACE_EXISTING);
            ShutdownHookManager.get().addShutdownHook(temp::delete, 1);
            Optional<File> optional = Optional.of(temp);
            return optional;
        }
    }
}

