/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.masc;

import java.io.FileFilter;
import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.commons.Internal;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.masc.Masc;
import opennlp.tools.formats.masc.MascDocumentStream;
import opennlp.tools.formats.masc.MascPOSSampleStream;
import opennlp.tools.postag.POSSample;
import opennlp.tools.util.ObjectStream;

@Internal
public class MascPOSSampleStreamFactory
extends AbstractSampleStreamFactory<POSSample, Parameters>
implements Masc {
    protected MascPOSSampleStreamFactory(Class<Parameters> params) {
        super(params);
    }

    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(POSSample.class, "masc", new MascPOSSampleStreamFactory(Parameters.class));
    }

    public ObjectStream<POSSample> create(String[] args) {
        if (args == null) {
            throw new IllegalArgumentException("Passed args must not be null!");
        }
        Parameters params = (Parameters)ArgumentParser.parse((String[])args, Parameters.class);
        try {
            FileFilter fileFilter = pathname -> pathname.getName().contains(params.getFileFilter());
            return new MascPOSSampleStream(new MascDocumentStream(params.getData(), params.getRecurrentSearch(), fileFilter));
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO Error while creating an Input Stream: " + e.getMessage(), (Throwable)e);
        }
    }

    public static interface Parameters
    extends BasicFormatParams {
        @ArgumentParser.ParameterDescription(valueName="recurrentSearch", description="search through files recursively")
        public Boolean getRecurrentSearch();

        @ArgumentParser.ParameterDescription(valueName="fileFilterString", description="only include files which contain a given string in their name")
        public String getFileFilter();
    }
}

