/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.everit.json.schema.loader.internal;

import com.hazelcast.shaded.org.everit.json.schema.SchemaException;
import com.hazelcast.shaded.org.everit.json.schema.loader.internal.ReferenceResolver;
import com.hazelcast.shaded.org.everit.json.schema.loader.internal.ResolutionScopeChangeListener;
import com.hazelcast.shaded.org.json.JSONObject;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

@Deprecated
public class TypeBasedMultiplexer {
    private final Map<Class<?>, Consumer<?>> actions = new HashMap();
    private final String keyOfObj;
    private final Object obj;
    private URI id;
    private final Collection<ResolutionScopeChangeListener> scopeChangeListeners = new ArrayList<ResolutionScopeChangeListener>(1);

    public TypeBasedMultiplexer(Object obj) {
        this(null, obj);
    }

    public TypeBasedMultiplexer(String keyOfObj, Object obj) {
        this(keyOfObj, obj, null);
    }

    public TypeBasedMultiplexer(String keyOfObj, Object obj, URI id) {
        this.keyOfObj = keyOfObj;
        this.obj = Objects.requireNonNull(obj, "obj cannot be null");
        this.id = id;
    }

    public void addResolutionScopeChangeListener(ResolutionScopeChangeListener resolutionScopeChangeListener) {
        this.scopeChangeListeners.add(resolutionScopeChangeListener);
    }

    public <E> OnTypeConsumer<E> ifIs(Class<E> predicateClass) {
        if (predicateClass == JSONObject.class) {
            throw new IllegalArgumentException("use ifObject() instead");
        }
        return new OnTypeConsumerImpl(predicateClass);
    }

    public OnTypeConsumer<JSONObject> ifObject() {
        return new IdModifyingTypeConsumerImpl(JSONObject.class);
    }

    public void orElse(Consumer<Object> orElseConsumer) {
        Consumer<Object> consumer = this.actions.keySet().stream().filter(clazz -> clazz.isAssignableFrom(this.obj.getClass())).findFirst().map(this.actions::get).orElse(orElseConsumer::accept);
        consumer.accept(this.obj);
    }

    public void requireAny() {
        this.orElse(obj -> {
            throw new SchemaException(this.keyOfObj, new ArrayList(this.actions.keySet()), obj);
        });
    }

    private void triggerResolutionScopeChange() {
        for (ResolutionScopeChangeListener listener : this.scopeChangeListeners) {
            listener.resolutionScopeChanged(this.id);
        }
    }

    private class OnTypeConsumerImpl<E>
    implements OnTypeConsumer<E> {
        protected final Class<?> key;

        OnTypeConsumerImpl(Class<?> key) {
            this.key = key;
        }

        @Override
        public TypeBasedMultiplexer then(Consumer<E> consumer) {
            TypeBasedMultiplexer.this.actions.put(this.key, consumer);
            return TypeBasedMultiplexer.this;
        }
    }

    private class IdModifyingTypeConsumerImpl
    extends OnTypeConsumerImpl<JSONObject> {
        IdModifyingTypeConsumerImpl(Class<?> key) {
            super(key);
        }

        @Override
        public TypeBasedMultiplexer then(Consumer<JSONObject> consumer) {
            Consumer<JSONObject> wrapperConsumer = obj -> {
                if (obj.has("id") && obj.get("id") instanceof String) {
                    URI origId = TypeBasedMultiplexer.this.id;
                    String idAttr = obj.getString("id");
                    TypeBasedMultiplexer.this.id = ReferenceResolver.resolve(TypeBasedMultiplexer.this.id, idAttr);
                    TypeBasedMultiplexer.this.triggerResolutionScopeChange();
                    consumer.accept((JSONObject)obj);
                    TypeBasedMultiplexer.this.id = origId;
                    TypeBasedMultiplexer.this.triggerResolutionScopeChange();
                } else {
                    consumer.accept((JSONObject)obj);
                }
            };
            TypeBasedMultiplexer.this.actions.put(this.key, wrapperConsumer);
            return TypeBasedMultiplexer.this;
        }
    }

    @FunctionalInterface
    public static interface OnTypeConsumer<E> {
        public TypeBasedMultiplexer then(Consumer<E> var1);
    }
}

