/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.datamodel;

import com.hazelcast.jet.impl.util.Util;
import java.util.Objects;
import javax.annotation.Nonnull;

public class WindowResult<R> {
    private final long start;
    private final long end;
    @Nonnull
    private final R result;
    private final boolean isEarly;

    public WindowResult(long start, long end, @Nonnull R result, boolean isEarly) {
        this.start = start;
        this.end = end;
        this.result = result;
        this.isEarly = isEarly;
    }

    public WindowResult(long start, long end, @Nonnull R result) {
        this(start, end, result, false);
    }

    public long start() {
        return this.start;
    }

    public long end() {
        return this.end;
    }

    @Nonnull
    public R result() {
        return this.result;
    }

    public boolean isEarly() {
        return this.isEarly;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WindowResult that = (WindowResult)obj;
        return this.start == that.start && this.end == that.end && this.isEarly == that.isEarly && Objects.equals(this.result, that.result);
    }

    public int hashCode() {
        int hc = 17;
        hc = 73 * hc + Long.hashCode(this.start);
        hc = 73 * hc + Long.hashCode(this.end);
        hc = 73 * hc + Boolean.hashCode(this.isEarly);
        hc = 73 * hc + Objects.hashCode(this.result);
        return hc;
    }

    public String toString() {
        return String.format("WindowResult{start=%s, end=%s, value='%s', isEarly=%s}", Util.toLocalTime(this.start), Util.toLocalTime(this.end), this.result, this.isEarly);
    }
}

