/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.ui.plugins.sfmenu;

import java.util.Collections;
import java.util.List;
import org.apache.wicket.Page;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.reference.ClassReference;
import org.wicketstuff.jquery.ui.plugins.sfmenu.ISfMenuItem;

public abstract class AbstractSfMenuItem
implements ISfMenuItem {
    private static final long serialVersionUID = 1L;
    private IModel<String> title;
    private boolean enabled = true;
    private boolean openInNewWindow = false;
    private final ClassReference<? extends Page> pageClassReference;
    private final PageParameters pageParameters;
    private final String pageUrl;

    public AbstractSfMenuItem(IModel<String> title) {
        this.title = title;
        this.pageClassReference = null;
        this.pageParameters = null;
        this.pageUrl = null;
    }

    public AbstractSfMenuItem(IModel<String> title, Class<? extends Page> pageClass) {
        Args.notNull(pageClass, (String)"pageClass");
        this.title = title;
        this.pageClassReference = ClassReference.of(pageClass);
        this.pageParameters = new PageParameters();
        this.pageUrl = null;
    }

    public AbstractSfMenuItem(IModel<String> title, Class<? extends Page> pageClass, PageParameters pageParameters) {
        Args.notNull(pageClass, (String)"pageClass");
        this.title = title;
        this.pageClassReference = ClassReference.of(pageClass);
        this.pageParameters = pageParameters;
        this.pageUrl = null;
    }

    public AbstractSfMenuItem(IModel<String> title, String pageUrl) {
        this.title = title;
        this.pageClassReference = null;
        this.pageParameters = null;
        this.pageUrl = pageUrl;
    }

    public AbstractSfMenuItem(IModel<String> title, String pageUrl, boolean openInNewWindow) {
        this.title = title;
        this.pageClassReference = null;
        this.pageParameters = null;
        this.pageUrl = pageUrl;
        this.openInNewWindow = openInNewWindow;
    }

    @Override
    public IModel<String> getTitle() {
        return this.title;
    }

    public void setTitle(IModel<String> title) {
        this.title = title;
    }

    @Override
    public List<ISfMenuItem> getItems() {
        return Collections.emptyList();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isOpenInNewWindow() {
        return this.openInNewWindow;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setOpenInNewWindow(boolean openInNewWindow) {
        this.openInNewWindow = openInNewWindow;
    }

    @Override
    public Class<? extends Page> getPageClass() {
        if (this.pageClassReference != null) {
            return this.pageClassReference.get();
        }
        return null;
    }

    @Override
    public PageParameters getPageParameters() {
        return this.pageParameters;
    }

    @Override
    public String getPageUrl() {
        return this.pageUrl;
    }
}

