/*
 * Decompiled with CFR 0.152.
 */
package com.github.caldav4j.methods;

import com.github.caldav4j.exceptions.CalDAV4JException;
import com.github.caldav4j.exceptions.CalDAV4JProtocolException;
import com.github.caldav4j.util.UrlUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpGetMethod
extends HttpGet {
    private static final String HEADER_ACCEPT = "Accept";
    private static final String ERR_CONTENT_TYPE = "Expected content-type text/calendar. Was: ";
    private static final Logger log = LoggerFactory.getLogger(HttpGetMethod.class);
    private CalendarBuilder calendarBuilder = null;

    public HttpGetMethod(URI uri, CalendarBuilder calendarBuilder) {
        super(uri);
        this.calendarBuilder = calendarBuilder;
        this.addHeader(HEADER_ACCEPT, "text/calendar; text/html; text/xml;");
    }

    public HttpGetMethod(String uri, CalendarBuilder calendarBuilder) {
        this(URI.create(uri), calendarBuilder);
    }

    public Calendar getResponseBodyAsCalendar(HttpResponse response) throws ParserException, CalDAV4JException {
        Calendar ret = null;
        BufferedInputStream stream = null;
        try {
            String contentType;
            Header header = this.getFirstHeader("Content-Type");
            String string = contentType = header != null ? header.getValue() : null;
            if (UrlUtils.isBlank(contentType) || contentType.startsWith("text/calendar")) {
                if (response.getEntity() != null && response.getEntity().getContent() != null) {
                    stream = new BufferedInputStream(response.getEntity().getContent());
                    ret = this.calendarBuilder.build((InputStream)stream);
                    return ret;
                }
                throw new CalDAV4JException("Error: No content stream at " + this.getURI());
            }
            log.error(ERR_CONTENT_TYPE + contentType);
            throw new CalDAV4JProtocolException(ERR_CONTENT_TYPE + contentType);
        }
        catch (IOException e) {
            if (stream != null && log.isWarnEnabled()) {
                log.warn("Server response is " + UrlUtils.parseISToString(stream));
            }
            throw new CalDAV4JException("Error retrieving and parsing server response at " + this.getURI(), e);
        }
    }

    public CalendarBuilder getCalendarBuilder() {
        return this.calendarBuilder;
    }

    public void setCalendarBuilder(CalendarBuilder calendarBuilder) {
        this.calendarBuilder = calendarBuilder;
    }
}

