/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl;

import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.sql.SqlColumnMetadata;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.sql.impl.row.JetSqlRow;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SqlRowImpl
implements SqlRow {
    private final SqlRowMetadata rowMetadata;
    private final JetSqlRow row;

    public SqlRowImpl(SqlRowMetadata rowMetadata, JetSqlRow row) {
        this.rowMetadata = rowMetadata;
        this.row = row;
    }

    @Override
    @Nullable
    public <T> T getObject(int columnIndex) {
        this.checkIndex(columnIndex);
        return this.getObject0(columnIndex, true);
    }

    @Override
    @Nullable
    public <T> T getObject(@Nonnull String columnName) {
        int columnIndex = this.resolveIndex(columnName);
        return this.getObject0(columnIndex, true);
    }

    public <T> T getObjectRaw(int columnIndex) {
        this.checkIndex(columnIndex);
        return this.getObject0(columnIndex, false);
    }

    private <T> T getObject0(int columnIndex, boolean deserialize) {
        if (deserialize) {
            try {
                return (T)this.row.get(columnIndex);
            }
            catch (HazelcastSerializationException e) {
                throw new HazelcastSerializationException("Failed to deserialize query result value: " + e.getMessage(), e);
            }
        }
        return (T)this.row.getMaybeSerialized(columnIndex);
    }

    private int resolveIndex(String columnName) {
        int index = this.rowMetadata.findColumn(columnName);
        if (index == -1) {
            throw new IllegalArgumentException("Column \"" + columnName + "\" doesn't exist");
        }
        return index;
    }

    @Override
    @Nonnull
    public SqlRowMetadata getMetadata() {
        return this.rowMetadata;
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.rowMetadata.getColumnCount()) {
            throw new IndexOutOfBoundsException("Column index is out of range: " + index);
        }
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        for (int i = 0; i < this.rowMetadata.getColumnCount(); ++i) {
            SqlColumnMetadata columnMetadata = this.rowMetadata.getColumn(i);
            Object columnValue = this.row.getMaybeSerialized(i);
            joiner.add(columnMetadata.getName() + " " + columnMetadata.getType() + "=" + columnValue);
        }
        return joiner.toString();
    }
}

