/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.DefaultMessageTaskFactoryProvider;
import com.hazelcast.client.impl.protocol.MessageTaskFactory;
import com.hazelcast.client.impl.protocol.MessageTaskFactoryProvider;
import com.hazelcast.client.impl.protocol.task.MessageTask;
import com.hazelcast.client.impl.protocol.task.NoSuchMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.ServiceLoader;
import com.hazelcast.internal.util.collection.Int2ObjectHashMap;
import com.hazelcast.spi.impl.NodeEngine;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.Map;

public class CompositeMessageTaskFactory
implements MessageTaskFactory {
    private static final String FACTORY_ID = "com.hazelcast.client.impl.protocol.MessageTaskFactoryProvider";
    private final Node node;
    private final NodeEngine nodeEngine;
    private final Int2ObjectHashMap<MessageTaskFactory> factories;

    public CompositeMessageTaskFactory(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.node = nodeEngine.getNode();
        DefaultMessageTaskFactoryProvider defaultProvider = new DefaultMessageTaskFactoryProvider(this.nodeEngine);
        this.factories = new Int2ObjectHashMap(defaultProvider.getFactories().size());
        this.loadProvider(defaultProvider);
        this.loadServices();
    }

    private void loadProvider(MessageTaskFactoryProvider provider) {
        Int2ObjectHashMap<MessageTaskFactory> providerFactories = provider.getFactories();
        this.factories.putAll((Map<Integer, MessageTaskFactory>)providerFactories);
    }

    private void loadServices() {
        try {
            ClassLoader classLoader = this.node.getConfigClassLoader();
            Iterator<Class<MessageTaskFactoryProvider>> iter = ServiceLoader.classIterator(MessageTaskFactoryProvider.class, FACTORY_ID, classLoader);
            while (iter.hasNext()) {
                Class<MessageTaskFactoryProvider> clazz = iter.next();
                Constructor<MessageTaskFactoryProvider> constructor = clazz.getDeclaredConstructor(NodeEngine.class);
                MessageTaskFactoryProvider messageTaskProvider = constructor.newInstance(this.nodeEngine);
                this.loadProvider(messageTaskProvider);
            }
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public MessageTask create(ClientMessage clientMessage, Connection connection) {
        try {
            MessageTaskFactory factory = this.factories.get(clientMessage.getMessageType());
            if (factory != null) {
                return factory.create(clientMessage, connection);
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrow(e);
        }
        return new NoSuchMessageTask(clientMessage, this.node, connection);
    }
}

