/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.datacache;

import java.util.Objects;
import org.apache.openjpa.datacache.DataCacheManager;
import org.apache.openjpa.datacache.QueryCache;
import org.apache.openjpa.datacache.QueryKey;
import org.apache.openjpa.datacache.QueryResult;
import org.apache.openjpa.datacache.TypesChangedEvent;
import org.apache.openjpa.datacache.TypesChangedListener;
import org.apache.openjpa.kernel.QueryStatistics;
import org.apache.openjpa.util.RuntimeExceptionTranslator;

public class DelegatingQueryCache
implements QueryCache {
    private final QueryCache _cache;
    private final DelegatingQueryCache _del;
    private final RuntimeExceptionTranslator _trans;

    public DelegatingQueryCache(QueryCache cache) {
        this(cache, null);
    }

    public DelegatingQueryCache(QueryCache cache, RuntimeExceptionTranslator trans) {
        this._cache = cache;
        this._trans = trans;
        this._del = cache instanceof DelegatingQueryCache ? (DelegatingQueryCache)this._cache : null;
    }

    public QueryCache getDelegate() {
        return this._cache;
    }

    public QueryCache getInnermostDelegate() {
        return this._del == null ? this._cache : this._del.getInnermostDelegate();
    }

    public int hashCode() {
        return this.getInnermostDelegate().hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DelegatingQueryCache) {
            other = ((DelegatingQueryCache)other).getInnermostDelegate();
        }
        return Objects.equals(this.getInnermostDelegate(), other);
    }

    protected RuntimeException translate(RuntimeException re) {
        return this._trans == null ? re : this._trans.translate(re);
    }

    @Override
    public void initialize(DataCacheManager mgr) {
        if (this._cache == null) {
            return;
        }
        try {
            this._cache.initialize(mgr);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public void onTypesChanged(TypesChangedEvent e) {
        if (this._cache == null) {
            return;
        }
        try {
            this._cache.onTypesChanged(e);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public QueryResult get(QueryKey qk) {
        if (this._cache == null) {
            return null;
        }
        try {
            return this._cache.get(qk);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public QueryResult put(QueryKey qk, QueryResult oids) {
        if (this._cache == null) {
            return null;
        }
        try {
            return this._cache.put(qk, oids);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public QueryResult remove(QueryKey qk) {
        if (this._cache == null) {
            return null;
        }
        try {
            return this._cache.remove(qk);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public void clear() {
        if (this._cache == null) {
            return;
        }
        try {
            this._cache.clear();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public boolean pin(QueryKey qk) {
        if (this._cache == null) {
            return false;
        }
        try {
            return this._cache.pin(qk);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public boolean unpin(QueryKey qk) {
        if (this._cache == null) {
            return false;
        }
        try {
            return this._cache.unpin(qk);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public void writeLock() {
        if (this._cache == null) {
            return;
        }
        try {
            this._cache.writeLock();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public void writeUnlock() {
        if (this._cache == null) {
            return;
        }
        try {
            this._cache.writeUnlock();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public void addTypesChangedListener(TypesChangedListener listen) {
        if (this._cache == null) {
            return;
        }
        try {
            this._cache.addTypesChangedListener(listen);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public boolean removeTypesChangedListener(TypesChangedListener listen) {
        if (this._cache == null) {
            return false;
        }
        try {
            return this._cache.removeTypesChangedListener(listen);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public void close() {
        if (this._cache == null) {
            return;
        }
        try {
            this._cache.close();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public QueryStatistics<QueryKey> getStatistics() {
        if (this._cache == null) {
            return null;
        }
        try {
            return this._cache.getStatistics();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }
}

