/****************************************************************************
 * boards/arm64/zynq-mpsoc/zcu111/include/board.h
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __BOARDS_ARM64_ZYNQ_MPSOC_ZCU111_INCLUDE_BOARD_H
#define __BOARDS_ARM64_ZYNQ_MPSOC_ZCU111_INCLUDE_BOARD_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include <nuttx/config.h>

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

/* LED definitions **********************************************************/

/* The ZCU111 PL has only one MIO LEDs, Others LED connected to PL.
 *
 * If CONFIG_ARCH_LEDS is not defined, then the user can control the LEDs in
 * any way.  The following definitions are used to access individual LEDs.
 */

/* LED index values for use with board_userled() */

#define BOARD_LED1                     0
#define BOARD_NLEDS                    1

/* LED bits for use with board_userled_all() */

#define BOARD_LED1_BIT                 (1 << BOARD_LED1)

/* If CONFIG_ARCH_LEDs is defined, then NuttX will control the LED on board
 * The following definitions describe how NuttX controls the LED:
 *
 *   SYMBOL              Meaning                  LED1 state
 *   ------------------  -----------------------  ----------
 *   LED_STARTED         NuttX has been started   OFF
 *   LED_HEAPALLOCATE    Heap has been allocated  OFF
 *   LED_IRQSENABLED     Interrupts enabled       OFF
 *   LED_STACKCREATED    Idle stack created       ON
 *   LED_INIRQ           In an interrupt          No change
 *   LED_SIGNAL          In a signal handler      No change
 *   LED_ASSERTION       An assertion failed      No change
 *   LED_PANIC           The system has crashed   Blinking
 *   LED_IDLE            STM32 is is sleep mode   Not used
 */

#define LED_STARTED      0
#define LED_HEAPALLOCATE 0
#define LED_IRQSENABLED  0
#define LED_STACKCREATED 1
#define LED_INIRQ        2
#define LED_SIGNAL       2
#define LED_ASSERTION    2
#define LED_PANIC        1

/****************************************************************************
 * The clock of MPSOC include low power field and Full power field
 * The low power field include:
 * I/O PLL(IOPLL) and RPU PLL(RPLL)
 * The full power field include:
 * APU PLL(APLL) Video PLL(VPLL) and DDR PLL(DPLL)

 * There are 5 clock source:
 * 1. PS_REF_CLK    (device pin, normal source).
 * 2. ALT_REF_CLK   (one of two MIO pins).
 * 3. VIDEO_REF_CLK (one of two MIO pins).
 * 4. AUX_REF_CLK   (PL fabric source).
 * 5. GTR_REF_CLK   (multiplexer output from GTR serial unit).
 ****************************************************************************/

/****************************************************************************
 * Clock frequence defnition
 ****************************************************************************/

#define CLK_CCF_VIDEO_CLK       27000000
#define CLK_CCF_PSS_REF_CLK     33333333
#define CLK_CCF_GT_CRX_REF_CLK  108000000
#define CLK_CCF_AUX_REF_CLK     27000000
#define CLK_CCF_ALT_REF_CLK     0

#endif /* __BOARDS_ARM64_ZYNQ_MPSOC_ZCU111_INCLUDE_BOARD_H */
