/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.gzip.zipnum;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.archive.format.gzip.GZIPMemberWriter;
import org.archive.format.gzip.GZIPMemberWriterCommittedOutputStream;

public class ZipNumWriter
extends GZIPMemberWriterCommittedOutputStream {
    int limit;
    int count;
    OutputStream manifestOut;
    ByteArrayOutputStream manifestBuffer;
    char delimiter = (char)9;

    public ZipNumWriter(OutputStream main, OutputStream manifest, int limit) {
        super(new GZIPMemberWriter(main));
        this.manifestOut = manifest;
        this.limit = limit;
        this.count = 0;
        this.manifestBuffer = new ByteArrayOutputStream();
    }

    public void addRecord(byte[] bytes) throws IOException {
        if (this.count == 0) {
            this.manifestBuffer.write(bytes);
        }
        this.write(bytes);
        ++this.count;
        if (this.count == this.limit) {
            this.finishCurrent();
        }
    }

    @Override
    public void close() throws IOException {
        this.finishCurrent();
    }

    private void finishCurrent() throws IOException {
        if (this.count == 0) {
            return;
        }
        long start = this.getBytesWritten();
        this.commit();
        long end = this.getBytesWritten();
        long len = end - start;
        StringBuilder sb = new StringBuilder();
        sb.append(start);
        sb.append(this.delimiter);
        sb.append(len);
        sb.append(this.delimiter);
        this.manifestOut.write(sb.toString().getBytes(StandardCharsets.UTF_8));
        this.manifestBuffer.writeTo(this.manifestOut);
        this.manifestOut.flush();
        this.count = 0;
        this.manifestBuffer.reset();
    }
}

