/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.geogrid;

import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.opensearch.common.geo.GeoBoundingBox;
import org.opensearch.index.fielddata.SortedBinaryDocValues;
import org.opensearch.index.fielddata.SortedNumericDoubleValues;
import org.opensearch.search.aggregations.bucket.geogrid.BoundedCellValues;
import org.opensearch.search.aggregations.bucket.geogrid.UnboundedCellValues;
import org.opensearch.search.aggregations.support.ValuesSource;

public class CellIdSource
extends ValuesSource.Numeric {
    private final ValuesSource.GeoPoint valuesSource;
    private final int precision;
    private final GeoPointLongEncoder encoder;
    private final GeoBoundingBox geoBoundingBox;

    public CellIdSource(ValuesSource.GeoPoint valuesSource, int precision, GeoBoundingBox geoBoundingBox, GeoPointLongEncoder encoder) {
        this.valuesSource = valuesSource;
        this.precision = precision;
        this.geoBoundingBox = geoBoundingBox;
        this.encoder = encoder;
    }

    public int precision() {
        return this.precision;
    }

    @Override
    public boolean isFloatingPoint() {
        return false;
    }

    @Override
    public SortedNumericDocValues longValues(LeafReaderContext ctx) {
        if (this.geoBoundingBox.isUnbounded()) {
            return new UnboundedCellValues(this.valuesSource.geoPointValues(ctx), this.precision, this.encoder);
        }
        return new BoundedCellValues(this.valuesSource.geoPointValues(ctx), this.precision, this.encoder, this.geoBoundingBox);
    }

    @Override
    public SortedNumericDoubleValues doubleValues(LeafReaderContext ctx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedBinaryDocValues bytesValues(LeafReaderContext ctx) {
        throw new UnsupportedOperationException();
    }

    @FunctionalInterface
    public static interface GeoPointLongEncoder {
        public long encode(double var1, double var3, int var5);
    }
}

