/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.net;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.net.URLExemptionFilter;
import org.apache.nutch.plugin.Extension;
import org.apache.nutch.plugin.PluginRepository;
import org.apache.nutch.plugin.PluginRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLExemptionFilters {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private URLExemptionFilter[] filters;

    public URLExemptionFilters(Configuration conf) {
        Extension[] extensions = PluginRepository.get(conf).getExtensionPoint(URLExemptionFilter.X_POINT_ID).getExtensions();
        this.filters = new URLExemptionFilter[extensions.length];
        for (int i = 0; i < extensions.length; ++i) {
            try {
                this.filters[i] = (URLExemptionFilter)extensions[i].getExtensionInstance();
                continue;
            }
            catch (PluginRuntimeException e) {
                throw new IllegalStateException(e);
            }
        }
        if (this.filters.length > 0) {
            LOG.info("Found {} URLExemptionFilter implementations: '{}'", (Object)this.filters.length, (Object)Arrays.toString(this.filters));
        }
    }

    public boolean isExempted(String fromUrl, String toUrl) {
        if (this.filters.length < 1) {
            return false;
        }
        boolean exempted = fromUrl != null && toUrl != null;
        for (int i = 0; i < this.filters.length && exempted; ++i) {
            exempted = this.filters[i].filter(fromUrl, toUrl);
        }
        return exempted;
    }
}

