/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.CoordinatorNotAvailableException;
import org.apache.kafka.common.errors.FencedMemberEpochException;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.GroupMaxSizeReachedException;
import org.apache.kafka.common.errors.IllegalGenerationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnknownMemberIdException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnsupportedAssignorException;
import org.apache.kafka.common.message.ConsumerGroupDescribeResponseData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.Group;
import org.apache.kafka.coordinator.group.Record;
import org.apache.kafka.coordinator.group.RecordHelpers;
import org.apache.kafka.coordinator.group.Utils;
import org.apache.kafka.coordinator.group.assignor.PartitionAssignor;
import org.apache.kafka.coordinator.group.assignor.PartitionAssignorException;
import org.apache.kafka.coordinator.group.classic.ClassicGroup;
import org.apache.kafka.coordinator.group.classic.ClassicGroupMember;
import org.apache.kafka.coordinator.group.classic.ClassicGroupState;
import org.apache.kafka.coordinator.group.consumer.Assignment;
import org.apache.kafka.coordinator.group.consumer.ConsumerGroup;
import org.apache.kafka.coordinator.group.consumer.ConsumerGroupMember;
import org.apache.kafka.coordinator.group.consumer.CurrentAssignmentBuilder;
import org.apache.kafka.coordinator.group.consumer.TargetAssignmentBuilder;
import org.apache.kafka.coordinator.group.consumer.TopicMetadata;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataValue;
import org.apache.kafka.coordinator.group.generated.GroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.GroupMetadataValue;
import org.apache.kafka.coordinator.group.metrics.GroupCoordinatorMetricsShard;
import org.apache.kafka.coordinator.group.runtime.CoordinatorResult;
import org.apache.kafka.coordinator.group.runtime.CoordinatorTimer;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;
import org.apache.kafka.timeline.TimelineHashSet;
import org.slf4j.Logger;

public class GroupMetadataManager {
    private final LogContext logContext;
    private final Logger log;
    private final SnapshotRegistry snapshotRegistry;
    private final Time time;
    private final CoordinatorTimer<Void, Record> timer;
    private final GroupCoordinatorMetricsShard metrics;
    private final Map<String, PartitionAssignor> assignors;
    private final PartitionAssignor defaultAssignor;
    private final TimelineHashMap<String, Group> groups;
    private final TimelineHashMap<String, TimelineHashSet<String>> groupsByTopics;
    private final int consumerGroupMaxSize;
    private final int consumerGroupHeartbeatIntervalMs;
    private final int consumerGroupSessionTimeoutMs;
    private final int consumerGroupMetadataRefreshIntervalMs;
    private MetadataImage metadataImage;
    static final CoordinatorResult<Void, Record> EMPTY_RESULT = new CoordinatorResult(Collections.emptyList(), CompletableFuture.completedFuture(null));
    private final int classicGroupMaxSize;
    private final int classicGroupInitialRebalanceDelayMs;
    private final int classicGroupNewMemberJoinTimeoutMs;
    private final int classicGroupMinSessionTimeoutMs;
    private final int classicGroupMaxSessionTimeoutMs;

    private GroupMetadataManager(SnapshotRegistry snapshotRegistry, LogContext logContext, Time time, CoordinatorTimer<Void, Record> timer, GroupCoordinatorMetricsShard metrics, List<PartitionAssignor> assignors, MetadataImage metadataImage, int consumerGroupMaxSize, int consumerGroupSessionTimeoutMs, int consumerGroupHeartbeatIntervalMs, int consumerGroupMetadataRefreshIntervalMs, int classicGroupMaxSize, int classicGroupInitialRebalanceDelayMs, int classicGroupNewMemberJoinTimeoutMs, int classicGroupMinSessionTimeoutMs, int classicGroupMaxSessionTimeoutMs) {
        this.logContext = logContext;
        this.log = logContext.logger(GroupMetadataManager.class);
        this.snapshotRegistry = snapshotRegistry;
        this.time = time;
        this.timer = timer;
        this.metrics = metrics;
        this.metadataImage = metadataImage;
        this.assignors = assignors.stream().collect(Collectors.toMap(PartitionAssignor::name, Function.identity()));
        this.defaultAssignor = assignors.get(0);
        this.groups = new TimelineHashMap(snapshotRegistry, 0);
        this.groupsByTopics = new TimelineHashMap(snapshotRegistry, 0);
        this.consumerGroupMaxSize = consumerGroupMaxSize;
        this.consumerGroupSessionTimeoutMs = consumerGroupSessionTimeoutMs;
        this.consumerGroupHeartbeatIntervalMs = consumerGroupHeartbeatIntervalMs;
        this.consumerGroupMetadataRefreshIntervalMs = consumerGroupMetadataRefreshIntervalMs;
        this.classicGroupMaxSize = classicGroupMaxSize;
        this.classicGroupInitialRebalanceDelayMs = classicGroupInitialRebalanceDelayMs;
        this.classicGroupNewMemberJoinTimeoutMs = classicGroupNewMemberJoinTimeoutMs;
        this.classicGroupMinSessionTimeoutMs = classicGroupMinSessionTimeoutMs;
        this.classicGroupMaxSessionTimeoutMs = classicGroupMaxSessionTimeoutMs;
    }

    public MetadataImage image() {
        return this.metadataImage;
    }

    public Group group(String groupId) throws GroupIdNotFoundException {
        Group group = (Group)this.groups.get((Object)groupId, Long.MAX_VALUE);
        if (group == null) {
            throw new GroupIdNotFoundException(String.format("Group %s not found.", groupId));
        }
        return group;
    }

    public Group group(String groupId, long committedOffset) throws GroupIdNotFoundException {
        Group group = (Group)this.groups.get((Object)groupId, committedOffset);
        if (group == null) {
            throw new GroupIdNotFoundException(String.format("Group %s not found.", groupId));
        }
        return group;
    }

    public List<ListGroupsResponseData.ListedGroup> listGroups(List<String> statesFilter, long committedOffset) {
        Stream<Object> groupStream = this.groups.values(committedOffset).stream();
        if (!statesFilter.isEmpty()) {
            groupStream = groupStream.filter(group -> statesFilter.contains(group.stateAsString(committedOffset)));
        }
        return groupStream.map(group -> group.asListedGroup(committedOffset)).collect(Collectors.toList());
    }

    public List<ConsumerGroupDescribeResponseData.DescribedGroup> consumerGroupDescribe(List<String> groupIds, long committedOffset) {
        ArrayList<ConsumerGroupDescribeResponseData.DescribedGroup> describedGroups = new ArrayList<ConsumerGroupDescribeResponseData.DescribedGroup>();
        groupIds.forEach(groupId -> {
            try {
                describedGroups.add(this.consumerGroup((String)groupId, committedOffset).asDescribedGroup(committedOffset, this.defaultAssignor.name()));
            }
            catch (GroupIdNotFoundException exception) {
                describedGroups.add(new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId(groupId).setErrorCode(Errors.GROUP_ID_NOT_FOUND.code()));
            }
        });
        return describedGroups;
    }

    public List<DescribeGroupsResponseData.DescribedGroup> describeGroups(List<String> groupIds, long committedOffset) {
        ArrayList<DescribeGroupsResponseData.DescribedGroup> describedGroups = new ArrayList<DescribeGroupsResponseData.DescribedGroup>();
        groupIds.forEach(groupId -> {
            try {
                ClassicGroup group = this.classicGroup((String)groupId, committedOffset);
                if (group.isInState(ClassicGroupState.STABLE)) {
                    if (!group.protocolName().isPresent()) {
                        throw new IllegalStateException("Invalid null group protocol for stable group");
                    }
                    describedGroups.add(new DescribeGroupsResponseData.DescribedGroup().setGroupId(groupId).setGroupState(group.stateAsString()).setProtocolType(group.protocolType().orElse("")).setProtocolData(group.protocolName().get()).setMembers(group.allMembers().stream().map(member -> member.describe(group.protocolName().get())).collect(Collectors.toList())));
                } else {
                    describedGroups.add(new DescribeGroupsResponseData.DescribedGroup().setGroupId(groupId).setGroupState(group.stateAsString()).setProtocolType(group.protocolType().orElse("")).setMembers(group.allMembers().stream().map(member -> member.describeNoMetadata()).collect(Collectors.toList())));
                }
            }
            catch (GroupIdNotFoundException exception) {
                describedGroups.add(new DescribeGroupsResponseData.DescribedGroup().setGroupId(groupId).setGroupState(ClassicGroupState.DEAD.toString()));
            }
        });
        return describedGroups;
    }

    ConsumerGroup getOrMaybeCreateConsumerGroup(String groupId, boolean createIfNotExists) throws GroupIdNotFoundException {
        Group group = (Group)this.groups.get((Object)groupId);
        if (group == null && !createIfNotExists) {
            throw new GroupIdNotFoundException(String.format("Consumer group %s not found.", groupId));
        }
        if (group == null) {
            ConsumerGroup consumerGroup = new ConsumerGroup(this.snapshotRegistry, groupId, this.metrics);
            this.groups.put((Object)groupId, (Object)consumerGroup);
            this.metrics.onConsumerGroupStateTransition(null, consumerGroup.state());
            return consumerGroup;
        }
        if (group.type() == Group.GroupType.CONSUMER) {
            return (ConsumerGroup)group;
        }
        throw new GroupIdNotFoundException(String.format("Group %s is not a consumer group.", groupId));
    }

    ClassicGroup getOrMaybeCreateClassicGroup(String groupId, boolean createIfNotExists) throws UnknownMemberIdException, GroupIdNotFoundException {
        Group group = (Group)this.groups.get((Object)groupId);
        if (group == null && !createIfNotExists) {
            throw new UnknownMemberIdException(String.format("Classic group %s not found.", groupId));
        }
        if (group == null) {
            ClassicGroup classicGroup = new ClassicGroup(this.logContext, groupId, ClassicGroupState.EMPTY, this.time, this.metrics);
            this.groups.put((Object)groupId, (Object)classicGroup);
            this.metrics.onClassicGroupStateTransition(null, classicGroup.currentState());
            return classicGroup;
        }
        if (group.type() == Group.GroupType.CLASSIC) {
            return (ClassicGroup)group;
        }
        throw new GroupIdNotFoundException(String.format("Group %s is not a classic group.", groupId));
    }

    public ClassicGroup classicGroup(String groupId, long committedOffset) throws GroupIdNotFoundException {
        Group group = this.group(groupId, committedOffset);
        if (group.type() == Group.GroupType.CLASSIC) {
            return (ClassicGroup)group;
        }
        throw new GroupIdNotFoundException(String.format("Group %s is not a classic group.", groupId));
    }

    public ConsumerGroup consumerGroup(String groupId, long committedOffset) throws GroupIdNotFoundException {
        Group group = this.group(groupId, committedOffset);
        if (group.type() == Group.GroupType.CONSUMER) {
            return (ConsumerGroup)group;
        }
        throw new GroupIdNotFoundException(String.format("Group %s is not a consumer group.", groupId));
    }

    private void removeGroup(String groupId) {
        Group group = (Group)this.groups.remove((Object)groupId);
        if (group != null) {
            switch (group.type()) {
                case CONSUMER: {
                    ConsumerGroup consumerGroup = (ConsumerGroup)group;
                    this.metrics.onConsumerGroupStateTransition(consumerGroup.state(), null);
                    break;
                }
                case CLASSIC: {
                    ClassicGroup classicGroup = (ClassicGroup)group;
                    this.metrics.onClassicGroupStateTransition(classicGroup.currentState(), null);
                }
            }
        }
    }

    private void throwIfEmptyString(String value, String error) throws InvalidRequestException {
        if (value != null && value.isEmpty()) {
            throw new InvalidRequestException(error);
        }
    }

    private void throwIfNotNull(Object value, String error) throws InvalidRequestException {
        if (value != null) {
            throw new InvalidRequestException(error);
        }
    }

    private void throwIfNull(Object value, String error) throws InvalidRequestException {
        if (value == null) {
            throw new InvalidRequestException(error);
        }
    }

    private void throwIfConsumerGroupHeartbeatRequestIsInvalid(ConsumerGroupHeartbeatRequestData request) throws InvalidRequestException, UnsupportedAssignorException {
        this.throwIfEmptyString(request.groupId(), "GroupId can't be empty.");
        this.throwIfEmptyString(request.instanceId(), "InstanceId can't be empty.");
        this.throwIfEmptyString(request.rackId(), "RackId can't be empty.");
        if (request.memberEpoch() > 0 || request.memberEpoch() == -1) {
            this.throwIfEmptyString(request.memberId(), "MemberId can't be empty.");
        } else if (request.memberEpoch() == 0) {
            if (request.rebalanceTimeoutMs() == -1) {
                throw new InvalidRequestException("RebalanceTimeoutMs must be provided in first request.");
            }
            if (request.topicPartitions() == null || !request.topicPartitions().isEmpty()) {
                throw new InvalidRequestException("TopicPartitions must be empty when (re-)joining.");
            }
            if (request.subscribedTopicNames() == null || request.subscribedTopicNames().isEmpty()) {
                throw new InvalidRequestException("SubscribedTopicNames must be set in first request.");
            }
        } else if (request.memberEpoch() == -2) {
            this.throwIfEmptyString(request.memberId(), "MemberId can't be empty.");
            this.throwIfNull(request.instanceId(), "InstanceId can't be null.");
        } else {
            throw new InvalidRequestException("MemberEpoch is invalid.");
        }
        if (request.serverAssignor() != null && !this.assignors.containsKey(request.serverAssignor())) {
            throw new UnsupportedAssignorException("ServerAssignor " + request.serverAssignor() + " is not supported. Supported assignors: " + String.join((CharSequence)", ", this.assignors.keySet()) + ".");
        }
    }

    private boolean isSubset(List<ConsumerGroupHeartbeatRequestData.TopicPartitions> ownedTopicPartitions, Map<Uuid, Set<Integer>> target) {
        if (ownedTopicPartitions == null) {
            return false;
        }
        for (ConsumerGroupHeartbeatRequestData.TopicPartitions topicPartitions : ownedTopicPartitions) {
            Set<Integer> partitions = target.get(topicPartitions.topicId());
            if (partitions == null) {
                return false;
            }
            for (Integer partitionId : topicPartitions.partitions()) {
                if (partitions.contains(partitionId)) continue;
                return false;
            }
        }
        return true;
    }

    private void throwIfConsumerGroupIsFull(ConsumerGroup group, String memberId) throws GroupMaxSizeReachedException {
        if (group.numMembers() >= this.consumerGroupMaxSize && (memberId.isEmpty() || !group.hasMember(memberId))) {
            throw new GroupMaxSizeReachedException("The consumer group has reached its maximum capacity of " + this.consumerGroupMaxSize + " members.");
        }
    }

    private void throwIfMemberEpochIsInvalid(ConsumerGroupMember member, int receivedMemberEpoch, List<ConsumerGroupHeartbeatRequestData.TopicPartitions> ownedTopicPartitions) {
        if (receivedMemberEpoch > member.memberEpoch()) {
            throw new FencedMemberEpochException("The consumer group member has a greater member epoch (" + receivedMemberEpoch + ") than the one known by the group coordinator (" + member.memberEpoch() + "). The member must abandon all its partitions and rejoin.");
        }
        if (!(receivedMemberEpoch >= member.memberEpoch() || receivedMemberEpoch == member.previousMemberEpoch() && this.isSubset(ownedTopicPartitions, member.assignedPartitions()))) {
            throw new FencedMemberEpochException("The consumer group member has a smaller member epoch (" + receivedMemberEpoch + ") than the one known by the group coordinator (" + member.memberEpoch() + "). The member must abandon all its partitions and rejoin.");
        }
    }

    private void throwIfInstanceIdIsUnreleased(ConsumerGroupMember member, String groupId, String receivedMemberId, String receivedInstanceId) {
        if (member.memberEpoch() != -2) {
            this.log.info("[GroupId {}] Static member {} with instance id {} cannot join the group because the instance id is is owned by member {}.", new Object[]{groupId, receivedMemberId, receivedInstanceId, member.memberId()});
            throw Errors.UNRELEASED_INSTANCE_ID.exception("Static member " + receivedMemberId + " with instance id " + receivedInstanceId + " cannot join the group because the instance id is owned by " + member.memberId() + " member.");
        }
    }

    private void throwIfInstanceIdIsFenced(ConsumerGroupMember member, String groupId, String receivedMemberId, String receivedInstanceId) {
        if (!member.memberId().equals(receivedMemberId)) {
            this.log.info("[GroupId {}] Static member {} with instance id {} is fenced by existing member {}.", new Object[]{groupId, receivedMemberId, receivedInstanceId, member.memberId()});
            throw Errors.FENCED_INSTANCE_ID.exception("Static member " + receivedMemberId + " with instance id " + receivedInstanceId + " was fenced by member " + member.memberId() + ".");
        }
    }

    private void throwIfStaticMemberIsUnknown(ConsumerGroupMember staticMember, String receivedInstanceId) {
        if (staticMember == null) {
            throw Errors.UNKNOWN_MEMBER_ID.exception("Instance id " + receivedInstanceId + " is unknown.");
        }
    }

    private ConsumerGroupHeartbeatResponseData.Assignment createResponseAssignment(ConsumerGroupMember member) {
        return new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(this.fromAssignmentMap(member.assignedPartitions()));
    }

    private List<ConsumerGroupHeartbeatResponseData.TopicPartitions> fromAssignmentMap(Map<Uuid, Set<Integer>> assignment) {
        return assignment.entrySet().stream().map(keyValue -> new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId((Uuid)keyValue.getKey()).setPartitions(new ArrayList((Collection)keyValue.getValue()))).collect(Collectors.toList());
    }

    private CoordinatorResult<ConsumerGroupHeartbeatResponseData, Record> consumerGroupHeartbeat(String groupId, String memberId, int memberEpoch, String instanceId, String rackId, int rebalanceTimeoutMs, String clientId, String clientHost, List<String> subscribedTopicNames, String assignorName, List<ConsumerGroupHeartbeatRequestData.TopicPartitions> ownedTopicPartitions) throws ApiException {
        ConsumerGroupMember.Builder updatedMemberBuilder;
        ConsumerGroupMember member;
        long currentTimeMs = this.time.milliseconds();
        ArrayList<Record> records = new ArrayList<Record>();
        boolean createIfNotExists = memberEpoch == 0;
        ConsumerGroup group = this.getOrMaybeCreateConsumerGroup(groupId, createIfNotExists);
        this.throwIfConsumerGroupIsFull(group, memberId);
        if (memberId.isEmpty()) {
            memberId = Uuid.randomUuid().toString();
        }
        boolean staticMemberReplaced = false;
        if (instanceId == null) {
            member = group.getOrMaybeCreateMember(memberId, createIfNotExists);
            this.throwIfMemberEpochIsInvalid(member, memberEpoch, ownedTopicPartitions);
            if (createIfNotExists) {
                this.log.info("[GroupId {}] Member {} joins the consumer group.", (Object)groupId, (Object)memberId);
            }
            updatedMemberBuilder = new ConsumerGroupMember.Builder(member);
        } else {
            member = group.staticMember(instanceId);
            if (memberEpoch == 0) {
                if (member == null) {
                    member = group.getOrMaybeCreateMember(memberId, createIfNotExists);
                    updatedMemberBuilder = new ConsumerGroupMember.Builder(member);
                    this.log.info("[GroupId {}] Static member {} with instance id {} joins the consumer group.", new Object[]{groupId, memberId, instanceId});
                } else {
                    this.throwIfInstanceIdIsUnreleased(member, groupId, memberId, instanceId);
                    staticMemberReplaced = true;
                    updatedMemberBuilder = new ConsumerGroupMember.Builder(memberId).setAssignedPartitions(member.assignedPartitions());
                    this.removeMemberAndCancelTimers(records, group.groupId(), member.memberId());
                    this.log.info("[GroupId {}] Static member {} with instance id {} re-joins the consumer group.", new Object[]{groupId, memberId, instanceId});
                }
            } else {
                this.throwIfStaticMemberIsUnknown(member, instanceId);
                this.throwIfInstanceIdIsFenced(member, groupId, memberId, instanceId);
                this.throwIfMemberEpochIsInvalid(member, memberEpoch, ownedTopicPartitions);
                updatedMemberBuilder = new ConsumerGroupMember.Builder(member);
            }
        }
        int groupEpoch = group.groupEpoch();
        Map<String, TopicMetadata> subscriptionMetadata = group.subscriptionMetadata();
        ConsumerGroupMember updatedMember = updatedMemberBuilder.maybeUpdateInstanceId(Optional.ofNullable(instanceId)).maybeUpdateRackId(Optional.ofNullable(rackId)).maybeUpdateRebalanceTimeoutMs(Utils.ofSentinel(rebalanceTimeoutMs)).maybeUpdateServerAssignorName(Optional.ofNullable(assignorName)).maybeUpdateSubscribedTopicNames(Optional.ofNullable(subscribedTopicNames)).setClientId(clientId).setClientHost(clientHost).build();
        boolean bumpGroupEpoch = false;
        if (!updatedMember.equals(member)) {
            records.add(RecordHelpers.newMemberSubscriptionRecord(groupId, updatedMember));
            if (!updatedMember.subscribedTopicNames().equals(member.subscribedTopicNames())) {
                this.log.info("[GroupId {}] Member {} updated its subscribed topics to: {}.", new Object[]{groupId, memberId, updatedMember.subscribedTopicNames()});
                bumpGroupEpoch = true;
            }
            if (!updatedMember.subscribedTopicRegex().equals(member.subscribedTopicRegex())) {
                this.log.info("[GroupId {}] Member {} updated its subscribed regex to: {}.", new Object[]{groupId, memberId, updatedMember.subscribedTopicRegex()});
                bumpGroupEpoch = true;
            }
        }
        if (bumpGroupEpoch || group.hasMetadataExpired(currentTimeMs)) {
            subscriptionMetadata = group.computeSubscriptionMetadata(member, updatedMember, this.metadataImage.topics(), this.metadataImage.cluster());
            if (!subscriptionMetadata.equals(group.subscriptionMetadata())) {
                this.log.info("[GroupId {}] Computed new subscription metadata: {}.", (Object)groupId, subscriptionMetadata);
                bumpGroupEpoch = true;
                records.add(RecordHelpers.newGroupSubscriptionMetadataRecord(groupId, subscriptionMetadata));
            }
            if (bumpGroupEpoch) {
                records.add(RecordHelpers.newGroupEpochRecord(groupId, ++groupEpoch));
                this.log.info("[GroupId {}] Bumped group epoch to {}.", (Object)groupId, (Object)groupEpoch);
                this.metrics.record("ConsumerGroupRebalances");
            }
            group.setMetadataRefreshDeadline(currentTimeMs + (long)this.consumerGroupMetadataRefreshIntervalMs, groupEpoch);
        }
        int targetAssignmentEpoch = group.assignmentEpoch();
        Assignment targetAssignment = group.targetAssignment(memberId);
        if (groupEpoch > targetAssignmentEpoch || staticMemberReplaced) {
            String preferredServerAssignor = group.computePreferredServerAssignor(member, updatedMember).orElse(this.defaultAssignor.name());
            try {
                TargetAssignmentBuilder assignmentResultBuilder = new TargetAssignmentBuilder(groupId, groupEpoch, this.assignors.get(preferredServerAssignor)).withMembers(group.members()).withStaticMembers(group.staticMembers()).withSubscriptionMetadata(subscriptionMetadata).withTargetAssignment(group.targetAssignment()).addOrUpdateMember(memberId, updatedMember);
                TargetAssignmentBuilder.TargetAssignmentResult assignmentResult = staticMemberReplaced ? assignmentResultBuilder.removeMember(member.memberId()).build() : assignmentResultBuilder.build();
                this.log.info("[GroupId {}] Computed a new target assignment for epoch {} with '{}' assignor: {}.", new Object[]{groupId, groupEpoch, preferredServerAssignor, assignmentResult.targetAssignment()});
                records.addAll(assignmentResult.records());
                targetAssignment = assignmentResult.targetAssignment().get(memberId);
                targetAssignmentEpoch = groupEpoch;
            }
            catch (PartitionAssignorException ex) {
                String msg = String.format("Failed to compute a new target assignment for epoch %d: %s", groupEpoch, ex.getMessage());
                this.log.error("[GroupId {}] {}.", (Object)groupId, (Object)msg);
                throw new UnknownServerException(msg, (Throwable)((Object)ex));
            }
        }
        boolean assignmentUpdated = false;
        if (updatedMember.state() != ConsumerGroupMember.MemberState.STABLE || updatedMember.targetMemberEpoch() != targetAssignmentEpoch) {
            ConsumerGroupMember prevMember = updatedMember;
            if ((updatedMember = new CurrentAssignmentBuilder(updatedMember).withTargetAssignment(targetAssignmentEpoch, targetAssignment).withCurrentPartitionEpoch(group::currentPartitionEpoch).withOwnedTopicPartitions(ownedTopicPartitions).build()) != prevMember) {
                assignmentUpdated = true;
                records.add(RecordHelpers.newCurrentAssignmentRecord(groupId, updatedMember));
                this.log.info("[GroupId {}] Member {} transitioned from {} to {}.", new Object[]{groupId, memberId, member.currentAssignmentSummary(), updatedMember.currentAssignmentSummary()});
                if (updatedMember.state() == ConsumerGroupMember.MemberState.REVOKING) {
                    this.scheduleConsumerGroupRevocationTimeout(groupId, memberId, updatedMember.rebalanceTimeoutMs(), updatedMember.memberEpoch());
                } else {
                    this.cancelConsumerGroupRevocationTimeout(groupId, memberId);
                }
            }
        }
        this.scheduleConsumerGroupSessionTimeout(groupId, memberId);
        ConsumerGroupHeartbeatResponseData response = new ConsumerGroupHeartbeatResponseData().setMemberId(updatedMember.memberId()).setMemberEpoch(updatedMember.memberEpoch()).setHeartbeatIntervalMs(this.consumerGroupHeartbeatIntervalMs);
        if (ownedTopicPartitions != null || memberEpoch == 0 || assignmentUpdated) {
            response.setAssignment(this.createResponseAssignment(updatedMember));
        }
        return new CoordinatorResult<ConsumerGroupHeartbeatResponseData, Record>(records, response);
    }

    private void removeMemberAndCancelTimers(List<Record> records, String groupId, String memberId) {
        this.removeMember(records, groupId, memberId);
        this.cancelTimers(groupId, memberId);
    }

    private CoordinatorResult<ConsumerGroupHeartbeatResponseData, Record> consumerGroupLeave(String groupId, String instanceId, String memberId, int memberEpoch) throws ApiException {
        List<Record> records;
        ConsumerGroup group = this.getOrMaybeCreateConsumerGroup(groupId, false);
        if (instanceId == null) {
            ConsumerGroupMember member = group.getOrMaybeCreateMember(memberId, false);
            this.log.info("[GroupId {}] Member {} left the consumer group.", (Object)groupId, (Object)memberId);
            records = this.consumerGroupFenceMember(group, member);
        } else {
            ConsumerGroupMember member = group.staticMember(instanceId);
            this.throwIfStaticMemberIsUnknown(member, instanceId);
            this.throwIfInstanceIdIsFenced(member, groupId, memberId, instanceId);
            if (memberEpoch == -2) {
                this.log.info("[GroupId {}] Static Member {} with instance id {} temporarily left the consumer group.", new Object[]{group.groupId(), memberId, instanceId});
                records = this.consumerGroupStaticMemberGroupLeave(group, member);
            } else {
                this.log.info("[GroupId {}] Static Member {} with instance id {} left the consumer group.", new Object[]{group.groupId(), memberId, instanceId});
                records = this.consumerGroupFenceMember(group, member);
            }
        }
        return new CoordinatorResult<ConsumerGroupHeartbeatResponseData, Record>(records, new ConsumerGroupHeartbeatResponseData().setMemberId(memberId).setMemberEpoch(memberEpoch));
    }

    private List<Record> consumerGroupStaticMemberGroupLeave(ConsumerGroup group, ConsumerGroupMember member) {
        ConsumerGroupMember leavingStaticMember = new ConsumerGroupMember.Builder(member).setMemberEpoch(-2).setPartitionsPendingRevocation(Collections.emptyMap()).build();
        return Collections.singletonList(RecordHelpers.newCurrentAssignmentRecord(group.groupId(), leavingStaticMember));
    }

    private List<Record> consumerGroupFenceMember(ConsumerGroup group, ConsumerGroupMember member) {
        ArrayList<Record> records = new ArrayList<Record>();
        this.removeMember(records, group.groupId(), member.memberId());
        Map<String, TopicMetadata> subscriptionMetadata = group.computeSubscriptionMetadata(member, null, this.metadataImage.topics(), this.metadataImage.cluster());
        if (!subscriptionMetadata.equals(group.subscriptionMetadata())) {
            this.log.info("[GroupId {}] Computed new subscription metadata: {}.", (Object)group.groupId(), subscriptionMetadata);
            records.add(RecordHelpers.newGroupSubscriptionMetadataRecord(group.groupId(), subscriptionMetadata));
        }
        int groupEpoch = group.groupEpoch() + 1;
        records.add(RecordHelpers.newGroupEpochRecord(group.groupId(), groupEpoch));
        this.cancelTimers(group.groupId(), member.memberId());
        return records;
    }

    private void removeMember(List<Record> records, String groupId, String memberId) {
        records.add(RecordHelpers.newCurrentAssignmentTombstoneRecord(groupId, memberId));
        records.add(RecordHelpers.newTargetAssignmentTombstoneRecord(groupId, memberId));
        records.add(RecordHelpers.newMemberSubscriptionTombstoneRecord(groupId, memberId));
    }

    private void cancelTimers(String groupId, String memberId) {
        this.cancelConsumerGroupSessionTimeout(groupId, memberId);
        this.cancelConsumerGroupRevocationTimeout(groupId, memberId);
    }

    private void scheduleConsumerGroupSessionTimeout(String groupId, String memberId) {
        String key = GroupMetadataManager.consumerGroupSessionTimeoutKey(groupId, memberId);
        this.timer.schedule(key, this.consumerGroupSessionTimeoutMs, TimeUnit.MILLISECONDS, true, () -> {
            try {
                ConsumerGroup group = this.getOrMaybeCreateConsumerGroup(groupId, false);
                ConsumerGroupMember member = group.getOrMaybeCreateMember(memberId, false);
                this.log.info("[GroupId {}] Member {} fenced from the group because its session expired.", (Object)groupId, (Object)memberId);
                return new CoordinatorResult(this.consumerGroupFenceMember(group, member));
            }
            catch (GroupIdNotFoundException ex) {
                this.log.debug("[GroupId {}] Could not fence {} because the group does not exist.", (Object)groupId, (Object)memberId);
            }
            catch (UnknownMemberIdException ex) {
                this.log.debug("[GroupId {}] Could not fence {} because the member does not exist.", (Object)groupId, (Object)memberId);
            }
            return new CoordinatorResult(Collections.emptyList());
        });
    }

    private void cancelConsumerGroupSessionTimeout(String groupId, String memberId) {
        this.timer.cancel(GroupMetadataManager.consumerGroupSessionTimeoutKey(groupId, memberId));
    }

    private void scheduleConsumerGroupRevocationTimeout(String groupId, String memberId, long revocationTimeoutMs, int expectedMemberEpoch) {
        String key = GroupMetadataManager.consumerGroupRevocationTimeoutKey(groupId, memberId);
        this.timer.schedule(key, revocationTimeoutMs, TimeUnit.MILLISECONDS, true, () -> {
            try {
                ConsumerGroup group = this.getOrMaybeCreateConsumerGroup(groupId, false);
                ConsumerGroupMember member = group.getOrMaybeCreateMember(memberId, false);
                if (member.state() != ConsumerGroupMember.MemberState.REVOKING || member.memberEpoch() != expectedMemberEpoch) {
                    this.log.debug("[GroupId {}] Ignoring revocation timeout for {} because the member state does not match the expected state.", (Object)groupId, (Object)memberId);
                    return new CoordinatorResult(Collections.emptyList());
                }
                this.log.info("[GroupId {}] Member {} fenced from the group because it failed to revoke partitions within {}ms.", new Object[]{groupId, memberId, revocationTimeoutMs});
                return new CoordinatorResult(this.consumerGroupFenceMember(group, member));
            }
            catch (GroupIdNotFoundException ex) {
                this.log.debug("[GroupId {}] Could not fence {}} because the group does not exist.", (Object)groupId, (Object)memberId);
            }
            catch (UnknownMemberIdException ex) {
                this.log.debug("[GroupId {}] Could not fence {} because the member does not exist.", (Object)groupId, (Object)memberId);
            }
            return new CoordinatorResult(Collections.emptyList());
        });
    }

    private void cancelConsumerGroupRevocationTimeout(String groupId, String memberId) {
        this.timer.cancel(GroupMetadataManager.consumerGroupRevocationTimeoutKey(groupId, memberId));
    }

    public CoordinatorResult<ConsumerGroupHeartbeatResponseData, Record> consumerGroupHeartbeat(RequestContext context, ConsumerGroupHeartbeatRequestData request) throws ApiException {
        this.throwIfConsumerGroupHeartbeatRequestIsInvalid(request);
        if (request.memberEpoch() == -1 || request.memberEpoch() == -2) {
            return this.consumerGroupLeave(request.groupId(), request.instanceId(), request.memberId(), request.memberEpoch());
        }
        return this.consumerGroupHeartbeat(request.groupId(), request.memberId(), request.memberEpoch(), request.instanceId(), request.rackId(), request.rebalanceTimeoutMs(), context.clientId(), context.clientAddress.toString(), request.subscribedTopicNames(), request.serverAssignor(), request.topicPartitions());
    }

    public void replay(ConsumerGroupMemberMetadataKey key, ConsumerGroupMemberMetadataValue value) {
        String groupId = key.groupId();
        String memberId = key.memberId();
        ConsumerGroup consumerGroup = this.getOrMaybeCreateConsumerGroup(groupId, value != null);
        HashSet<String> oldSubscribedTopicNames = new HashSet<String>(consumerGroup.subscribedTopicNames());
        if (value != null) {
            ConsumerGroupMember oldMember = consumerGroup.getOrMaybeCreateMember(memberId, true);
            consumerGroup.updateMember(new ConsumerGroupMember.Builder(oldMember).updateWith(value).build());
        } else {
            ConsumerGroupMember oldMember = consumerGroup.getOrMaybeCreateMember(memberId, false);
            if (oldMember.memberEpoch() != -1) {
                throw new IllegalStateException("Received a tombstone record to delete member " + memberId + " but did not receive ConsumerGroupCurrentMemberAssignmentValue tombstone.");
            }
            if (consumerGroup.targetAssignment().containsKey(memberId)) {
                throw new IllegalStateException("Received a tombstone record to delete member " + memberId + " but did not receive ConsumerGroupTargetAssignmentMetadataValue tombstone.");
            }
            consumerGroup.removeMember(memberId);
        }
        this.updateGroupsByTopics(groupId, oldSubscribedTopicNames, consumerGroup.subscribedTopicNames());
    }

    public Set<String> groupsSubscribedToTopic(String topicName) {
        Set<String> groups = (Set<String>)this.groupsByTopics.get((Object)topicName);
        return groups != null ? groups : Collections.emptySet();
    }

    private void subscribeGroupToTopic(String groupId, String topicName) {
        ((TimelineHashSet)this.groupsByTopics.computeIfAbsent((Object)topicName, __ -> new TimelineHashSet(this.snapshotRegistry, 1))).add((Object)groupId);
    }

    private void unsubscribeGroupFromTopic(String groupId, String topicName) {
        this.groupsByTopics.computeIfPresent((Object)topicName, (__, groupIds) -> {
            groupIds.remove((Object)groupId);
            return groupIds.isEmpty() ? null : groupIds;
        });
    }

    private void updateGroupsByTopics(String groupId, Set<String> oldSubscribedTopics, Set<String> newSubscribedTopics) {
        if (oldSubscribedTopics.isEmpty()) {
            newSubscribedTopics.forEach(topicName -> this.subscribeGroupToTopic(groupId, (String)topicName));
        } else if (newSubscribedTopics.isEmpty()) {
            oldSubscribedTopics.forEach(topicName -> this.unsubscribeGroupFromTopic(groupId, (String)topicName));
        } else {
            oldSubscribedTopics.forEach(topicName -> {
                if (!newSubscribedTopics.contains(topicName)) {
                    this.unsubscribeGroupFromTopic(groupId, (String)topicName);
                }
            });
            newSubscribedTopics.forEach(topicName -> {
                if (!oldSubscribedTopics.contains(topicName)) {
                    this.subscribeGroupToTopic(groupId, (String)topicName);
                }
            });
        }
    }

    public void replay(ConsumerGroupMetadataKey key, ConsumerGroupMetadataValue value) {
        String groupId = key.groupId();
        if (value != null) {
            ConsumerGroup consumerGroup = this.getOrMaybeCreateConsumerGroup(groupId, true);
            consumerGroup.setGroupEpoch(value.epoch());
        } else {
            ConsumerGroup consumerGroup = this.getOrMaybeCreateConsumerGroup(groupId, false);
            if (!consumerGroup.members().isEmpty()) {
                throw new IllegalStateException("Received a tombstone record to delete group " + groupId + " but the group still has " + consumerGroup.members().size() + " members.");
            }
            if (!consumerGroup.targetAssignment().isEmpty()) {
                throw new IllegalStateException("Received a tombstone record to delete group " + groupId + " but the target assignment still has " + consumerGroup.targetAssignment().size() + " members.");
            }
            if (consumerGroup.assignmentEpoch() != -1) {
                throw new IllegalStateException("Received a tombstone record to delete group " + groupId + " but did not receive ConsumerGroupTargetAssignmentMetadataValue tombstone.");
            }
            this.removeGroup(groupId);
        }
    }

    public void replay(ConsumerGroupPartitionMetadataKey key, ConsumerGroupPartitionMetadataValue value) {
        String groupId = key.groupId();
        ConsumerGroup consumerGroup = this.getOrMaybeCreateConsumerGroup(groupId, false);
        if (value != null) {
            HashMap<String, TopicMetadata> subscriptionMetadata = new HashMap<String, TopicMetadata>();
            value.topics().forEach(topicMetadata -> subscriptionMetadata.put(topicMetadata.topicName(), TopicMetadata.fromRecord(topicMetadata)));
            consumerGroup.setSubscriptionMetadata(subscriptionMetadata);
        } else {
            consumerGroup.setSubscriptionMetadata(Collections.emptyMap());
        }
    }

    public void replay(ConsumerGroupTargetAssignmentMemberKey key, ConsumerGroupTargetAssignmentMemberValue value) {
        String groupId = key.groupId();
        String memberId = key.memberId();
        ConsumerGroup consumerGroup = this.getOrMaybeCreateConsumerGroup(groupId, false);
        if (value != null) {
            consumerGroup.updateTargetAssignment(memberId, Assignment.fromRecord(value));
        } else {
            consumerGroup.removeTargetAssignment(memberId);
        }
    }

    public void replay(ConsumerGroupTargetAssignmentMetadataKey key, ConsumerGroupTargetAssignmentMetadataValue value) {
        String groupId = key.groupId();
        ConsumerGroup consumerGroup = this.getOrMaybeCreateConsumerGroup(groupId, false);
        if (value != null) {
            consumerGroup.setTargetAssignmentEpoch(value.assignmentEpoch());
        } else {
            if (!consumerGroup.targetAssignment().isEmpty()) {
                throw new IllegalStateException("Received a tombstone record to delete target assignment of " + groupId + " but the assignment still has " + consumerGroup.targetAssignment().size() + " members.");
            }
            consumerGroup.setTargetAssignmentEpoch(-1);
        }
    }

    public void replay(ConsumerGroupCurrentMemberAssignmentKey key, ConsumerGroupCurrentMemberAssignmentValue value) {
        String groupId = key.groupId();
        String memberId = key.memberId();
        ConsumerGroup consumerGroup = this.getOrMaybeCreateConsumerGroup(groupId, false);
        ConsumerGroupMember oldMember = consumerGroup.getOrMaybeCreateMember(memberId, false);
        if (value != null) {
            ConsumerGroupMember newMember = new ConsumerGroupMember.Builder(oldMember).updateWith(value).build();
            consumerGroup.updateMember(newMember);
        } else {
            ConsumerGroupMember newMember = new ConsumerGroupMember.Builder(oldMember).setMemberEpoch(-1).setPreviousMemberEpoch(-1).setTargetMemberEpoch(-1).setAssignedPartitions(Collections.emptyMap()).setPartitionsPendingRevocation(Collections.emptyMap()).setPartitionsPendingAssignment(Collections.emptyMap()).build();
            consumerGroup.updateMember(newMember);
        }
    }

    public void onNewMetadataImage(MetadataImage newImage, MetadataDelta delta) {
        this.metadataImage = newImage;
        Optional.ofNullable(delta.topicsDelta()).ifPresent(topicsDelta -> {
            HashSet allGroupIds = new HashSet();
            topicsDelta.changedTopics().forEach((topicId, topicDelta) -> {
                String topicName = topicDelta.name();
                allGroupIds.addAll(this.groupsSubscribedToTopic(topicName));
            });
            topicsDelta.deletedTopicIds().forEach(topicId -> {
                TopicImage topicImage = delta.image().topics().getTopic(topicId);
                allGroupIds.addAll(this.groupsSubscribedToTopic(topicImage.name()));
            });
            allGroupIds.forEach(groupId -> {
                Group group = (Group)this.groups.get(groupId);
                if (group != null && group.type() == Group.GroupType.CONSUMER) {
                    ((ConsumerGroup)group).requestMetadataRefresh();
                }
            });
        });
    }

    public void onLoaded() {
        this.groups.forEach((groupId, group) -> {
            switch (group.type()) {
                case CONSUMER: {
                    ConsumerGroup consumerGroup = (ConsumerGroup)group;
                    this.log.info("Loaded consumer group {} with {} members.", groupId, (Object)consumerGroup.members().size());
                    consumerGroup.members().forEach((memberId, member) -> {
                        this.log.debug("Loaded member {} in consumer group {}.", memberId, groupId);
                        this.scheduleConsumerGroupSessionTimeout((String)groupId, (String)memberId);
                        if (member.state() == ConsumerGroupMember.MemberState.REVOKING) {
                            this.scheduleConsumerGroupRevocationTimeout((String)groupId, (String)memberId, member.rebalanceTimeoutMs(), member.memberEpoch());
                        }
                    });
                    break;
                }
                case CLASSIC: {
                    ClassicGroup classicGroup = (ClassicGroup)group;
                    this.log.info("Loaded classic group {} with {} members.", groupId, (Object)classicGroup.allMembers().size());
                    classicGroup.allMembers().forEach(member -> {
                        this.log.debug("Loaded member {} in classic group {}.", (Object)member.memberId(), groupId);
                        this.rescheduleClassicGroupMemberHeartbeat(classicGroup, (ClassicGroupMember)member);
                    });
                    if (classicGroup.size() <= this.classicGroupMaxSize) break;
                    this.prepareRebalance(classicGroup, "Freshly-loaded group " + groupId + " (size " + classicGroup.size() + ") is over capacity " + this.classicGroupMaxSize + ". Rebalancing in order to give a chance for consumers to commit offsets");
                }
            }
        });
    }

    public static String consumerGroupSessionTimeoutKey(String groupId, String memberId) {
        return "session-timeout-" + groupId + "-" + memberId;
    }

    public static String consumerGroupRevocationTimeoutKey(String groupId, String memberId) {
        return "revocation-timeout-" + groupId + "-" + memberId;
    }

    public void replay(GroupMetadataKey key, GroupMetadataValue value) {
        String groupId = key.group();
        if (value == null) {
            this.removeGroup(groupId);
        } else {
            ArrayList<ClassicGroupMember> loadedMembers = new ArrayList<ClassicGroupMember>();
            for (GroupMetadataValue.MemberMetadata member2 : value.members()) {
                int rebalanceTimeout = member2.rebalanceTimeout() == -1 ? member2.sessionTimeout() : member2.rebalanceTimeout();
                JoinGroupRequestData.JoinGroupRequestProtocolCollection supportedProtocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
                supportedProtocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName(value.protocol()).setMetadata(member2.subscription()));
                ClassicGroupMember loadedMember = new ClassicGroupMember(member2.memberId(), Optional.ofNullable(member2.groupInstanceId()), member2.clientId(), member2.clientHost(), rebalanceTimeout, member2.sessionTimeout(), value.protocolType(), supportedProtocols, member2.assignment());
                loadedMembers.add(loadedMember);
            }
            String protocolType = value.protocolType();
            ClassicGroup classicGroup = new ClassicGroup(this.logContext, groupId, loadedMembers.isEmpty() ? ClassicGroupState.EMPTY : ClassicGroupState.STABLE, this.time, this.metrics, value.generation(), protocolType == null || protocolType.isEmpty() ? Optional.empty() : Optional.of(protocolType), Optional.ofNullable(value.protocol()), Optional.ofNullable(value.leader()), value.currentStateTimestamp() == -1L ? Optional.empty() : Optional.of(value.currentStateTimestamp()));
            loadedMembers.forEach(member -> classicGroup.add((ClassicGroupMember)member, null));
            Group prevGroup = (Group)this.groups.put((Object)groupId, (Object)classicGroup);
            if (prevGroup == null) {
                this.metrics.onClassicGroupStateTransition(null, classicGroup.currentState());
            }
            classicGroup.setSubscribedTopics(classicGroup.computeSubscribedTopics());
        }
    }

    public CoordinatorResult<Void, Record> classicGroupJoin(RequestContext context, JoinGroupRequestData request, CompletableFuture<JoinGroupResponseData> responseFuture) {
        CoordinatorResult<Void, Record> result = EMPTY_RESULT;
        String groupId = request.groupId();
        String memberId = request.memberId();
        int sessionTimeoutMs = request.sessionTimeoutMs();
        if (sessionTimeoutMs < this.classicGroupMinSessionTimeoutMs || sessionTimeoutMs > this.classicGroupMaxSessionTimeoutMs) {
            responseFuture.complete(new JoinGroupResponseData().setMemberId(memberId).setErrorCode(Errors.INVALID_SESSION_TIMEOUT.code()));
        } else {
            ClassicGroup group;
            boolean isUnknownMember = memberId.equals("");
            boolean isNewGroup = !this.groups.containsKey((Object)groupId);
            try {
                group = this.getOrMaybeCreateClassicGroup(groupId, isUnknownMember);
            }
            catch (Throwable t2) {
                responseFuture.complete(new JoinGroupResponseData().setMemberId(memberId).setErrorCode(Errors.forException((Throwable)t2).code()));
                return EMPTY_RESULT;
            }
            if (!this.acceptJoiningMember(group, memberId)) {
                group.remove(memberId);
                responseFuture.complete(new JoinGroupResponseData().setMemberId("").setErrorCode(Errors.GROUP_MAX_SIZE_REACHED.code()));
            } else {
                result = isUnknownMember ? this.classicGroupJoinNewMember(context, request, group, responseFuture) : this.classicGroupJoinExistingMember(context, request, group, responseFuture);
            }
            if (isNewGroup && result == EMPTY_RESULT) {
                CompletableFuture<Void> appendFuture = new CompletableFuture<Void>();
                appendFuture.whenComplete((__, t) -> {
                    if (t != null) {
                        this.log.warn("Failed to write empty metadata for group {}: {}", (Object)group.groupId(), (Object)t.getMessage());
                        responseFuture.complete(new JoinGroupResponseData().setErrorCode(GroupMetadataManager.appendGroupMetadataErrorToResponseError(Errors.forException((Throwable)t)).code()));
                    }
                });
                List<Record> records = Collections.singletonList(RecordHelpers.newEmptyGroupMetadataRecord(group, this.metadataImage.features().metadataVersion()));
                return new CoordinatorResult<Void, Record>(records, appendFuture);
            }
        }
        return result;
    }

    private CoordinatorResult<Void, Record> maybeCompleteJoinPhase(ClassicGroup group) {
        if (group.isInState(ClassicGroupState.PREPARING_REBALANCE) && group.hasAllMembersJoined() && group.previousState() != ClassicGroupState.EMPTY) {
            return this.completeClassicGroupJoin(group);
        }
        return EMPTY_RESULT;
    }

    private CoordinatorResult<Void, Record> classicGroupJoinNewMember(RequestContext context, JoinGroupRequestData request, ClassicGroup group, CompletableFuture<JoinGroupResponseData> responseFuture) {
        if (group.isInState(ClassicGroupState.DEAD)) {
            responseFuture.complete(new JoinGroupResponseData().setMemberId("").setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
        } else if (!group.supportsProtocols(request.protocolType(), request.protocols())) {
            responseFuture.complete(new JoinGroupResponseData().setMemberId("").setErrorCode(Errors.INCONSISTENT_GROUP_PROTOCOL.code()));
        } else {
            Optional<String> groupInstanceId = Optional.ofNullable(request.groupInstanceId());
            String newMemberId = group.generateMemberId(context.clientId(), groupInstanceId);
            if (groupInstanceId.isPresent()) {
                return this.classicGroupJoinNewStaticMember(context, request, group, newMemberId, responseFuture);
            }
            return this.classicGroupJoinNewDynamicMember(context, request, group, newMemberId, responseFuture);
        }
        return EMPTY_RESULT;
    }

    private CoordinatorResult<Void, Record> classicGroupJoinNewStaticMember(RequestContext context, JoinGroupRequestData request, ClassicGroup group, String newMemberId, CompletableFuture<JoinGroupResponseData> responseFuture) {
        String groupInstanceId = request.groupInstanceId();
        String existingMemberId = group.staticMemberId(groupInstanceId);
        if (existingMemberId != null) {
            this.log.info("Static member with groupInstanceId={} and unknown member id joins group {} in {} state. Replacing previously mapped member {} with this groupInstanceId.", new Object[]{groupInstanceId, group.groupId(), group.currentState(), existingMemberId});
            return this.updateStaticMemberThenRebalanceOrCompleteJoin(context, request, group, existingMemberId, newMemberId, responseFuture);
        }
        this.log.info("Static member with groupInstanceId={} and unknown member id joins group {} in {} state. Created a new member id {} for this member and added to the group.", new Object[]{groupInstanceId, group.groupId(), group.currentState(), newMemberId});
        return this.addMemberThenRebalanceOrCompleteJoin(context, request, group, newMemberId, responseFuture);
    }

    private CoordinatorResult<Void, Record> classicGroupJoinNewDynamicMember(RequestContext context, JoinGroupRequestData request, ClassicGroup group, String newMemberId, CompletableFuture<JoinGroupResponseData> responseFuture) {
        if (!JoinGroupRequest.requiresKnownMemberId((short)context.apiVersion())) {
            this.log.info("Dynamic member with unknown member id joins group {} in state {}. Created a new member id {} and added the member to the group.", new Object[]{group.groupId(), group.currentState(), newMemberId});
            return this.addMemberThenRebalanceOrCompleteJoin(context, request, group, newMemberId, responseFuture);
        }
        this.log.info("Dynamic member with unknown member id joins group {} in {} state. Created a new member id {} and requesting the member to rejoin with this id.", new Object[]{group.groupId(), group.currentState(), newMemberId});
        group.addPendingMember(newMemberId);
        String classicGroupHeartbeatKey = GroupMetadataManager.classicGroupHeartbeatKey(group.groupId(), newMemberId);
        this.timer.schedule(classicGroupHeartbeatKey, request.sessionTimeoutMs(), TimeUnit.MILLISECONDS, false, () -> this.expireClassicGroupMemberHeartbeat(group, newMemberId));
        responseFuture.complete(new JoinGroupResponseData().setMemberId(newMemberId).setErrorCode(Errors.MEMBER_ID_REQUIRED.code()));
        return EMPTY_RESULT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CoordinatorResult<Void, Record> classicGroupJoinExistingMember(RequestContext context, JoinGroupRequestData request, ClassicGroup group, CompletableFuture<JoinGroupResponseData> responseFuture) {
        String memberId = request.memberId();
        String groupInstanceId = request.groupInstanceId();
        if (group.isInState(ClassicGroupState.DEAD)) {
            responseFuture.complete(new JoinGroupResponseData().setMemberId(memberId).setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
            return EMPTY_RESULT;
        }
        if (!group.supportsProtocols(request.protocolType(), request.protocols())) {
            responseFuture.complete(new JoinGroupResponseData().setMemberId(memberId).setErrorCode(Errors.INCONSISTENT_GROUP_PROTOCOL.code()));
            return EMPTY_RESULT;
        }
        if (group.isPendingMember(memberId)) {
            if (groupInstanceId != null) {
                throw new IllegalStateException("Received unexpected JoinGroup with groupInstanceId=" + groupInstanceId + " for pending member with memberId=" + memberId);
            }
            this.log.debug("Pending dynamic member with id {} joins group {} in {} state. Adding to the group now.", new Object[]{memberId, group.groupId(), group.currentState()});
            return this.addMemberThenRebalanceOrCompleteJoin(context, request, group, memberId, responseFuture);
        }
        try {
            group.validateMember(memberId, groupInstanceId, "join-group");
        }
        catch (KafkaException ex) {
            responseFuture.complete(new JoinGroupResponseData().setMemberId(memberId).setErrorCode(Errors.forException((Throwable)ex).code()).setProtocolType(null).setProtocolName(null));
            return EMPTY_RESULT;
        }
        ClassicGroupMember member = group.member(memberId);
        if (group.isInState(ClassicGroupState.PREPARING_REBALANCE)) {
            return this.updateMemberThenRebalanceOrCompleteJoin(request, group, member, "Member " + member.memberId() + " is joining group during " + group.stateAsString() + "; client reason: " + JoinGroupRequest.joinReason((JoinGroupRequestData)request), responseFuture);
        }
        if (group.isInState(ClassicGroupState.COMPLETING_REBALANCE)) {
            if (!member.matches(request.protocols())) return this.updateMemberThenRebalanceOrCompleteJoin(request, group, member, "Updating metadata for member " + memberId + " during " + group.stateAsString() + "; client reason: " + JoinGroupRequest.joinReason((JoinGroupRequestData)request), responseFuture);
            responseFuture.complete(new JoinGroupResponseData().setMembers(group.isLeader(memberId) ? group.currentClassicGroupMembers() : Collections.emptyList()).setMemberId(memberId).setGenerationId(group.generationId()).setProtocolName((String)group.protocolName().orElse(null)).setProtocolType((String)group.protocolType().orElse(null)).setLeader(group.leaderOrNull()).setSkipAssignment(false));
            return EMPTY_RESULT;
        } else if (group.isInState(ClassicGroupState.STABLE)) {
            if (group.isLeader(memberId)) {
                return this.updateMemberThenRebalanceOrCompleteJoin(request, group, member, "Leader " + memberId + " re-joining group during " + group.stateAsString() + "; client reason: " + JoinGroupRequest.joinReason((JoinGroupRequestData)request), responseFuture);
            }
            if (!member.matches(request.protocols())) {
                return this.updateMemberThenRebalanceOrCompleteJoin(request, group, member, "Updating metadata for member " + memberId + " during " + group.stateAsString() + "; client reason: " + JoinGroupRequest.joinReason((JoinGroupRequestData)request), responseFuture);
            }
            responseFuture.complete(new JoinGroupResponseData().setMembers(Collections.emptyList()).setMemberId(memberId).setGenerationId(group.generationId()).setProtocolName((String)group.protocolName().orElse(null)).setProtocolType((String)group.protocolType().orElse(null)).setLeader(group.leaderOrNull()).setSkipAssignment(false));
            return EMPTY_RESULT;
        } else {
            this.log.warn("Attempt to add rejoining member {} of group {} in unexpected group state {}", new Object[]{memberId, group.groupId(), group.stateAsString()});
            responseFuture.complete(new JoinGroupResponseData().setMemberId(memberId).setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()));
        }
        return EMPTY_RESULT;
    }

    private CoordinatorResult<Void, Record> completeClassicGroupJoin(ClassicGroup group) {
        this.timer.cancel(GroupMetadataManager.classicGroupJoinKey(group.groupId()));
        String groupId = group.groupId();
        Map<String, ClassicGroupMember> notYetRejoinedDynamicMembers = group.notYetRejoinedMembers().entrySet().stream().filter(entry -> !((ClassicGroupMember)entry.getValue()).isStaticMember()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (!notYetRejoinedDynamicMembers.isEmpty()) {
            notYetRejoinedDynamicMembers.values().forEach(failedMember -> {
                group.remove(failedMember.memberId());
                this.timer.cancel(GroupMetadataManager.classicGroupHeartbeatKey(group.groupId(), failedMember.memberId()));
            });
            this.log.info("Group {} removed dynamic members who haven't joined: {}", (Object)groupId, notYetRejoinedDynamicMembers.keySet());
        }
        if (group.isInState(ClassicGroupState.DEAD)) {
            this.log.info("Group {} is dead, skipping rebalance stage.", (Object)groupId);
        } else {
            if (!group.maybeElectNewJoinedLeader() && !group.allMembers().isEmpty()) {
                this.log.error("Group {} could not complete rebalance because no members rejoined.", (Object)groupId);
                this.timer.schedule(GroupMetadataManager.classicGroupJoinKey(groupId), group.rebalanceTimeoutMs(), TimeUnit.MILLISECONDS, false, () -> this.completeClassicGroupJoin(group));
                return EMPTY_RESULT;
            }
            group.initNextGeneration();
            if (group.isInState(ClassicGroupState.EMPTY)) {
                this.log.info("Group {} with generation {} is now empty.", (Object)groupId, (Object)group.generationId());
                CompletableFuture<Void> appendFuture = new CompletableFuture<Void>();
                appendFuture.whenComplete((__, t) -> {
                    if (t != null) {
                        Errors error = GroupMetadataManager.appendGroupMetadataErrorToResponseError(Errors.forException((Throwable)t));
                        this.log.warn("Failed to write empty metadata for group {}: {}", (Object)group.groupId(), (Object)error.message());
                    }
                });
                List<Record> records = Collections.singletonList(RecordHelpers.newGroupMetadataRecord(group, Collections.emptyMap(), this.metadataImage.features().metadataVersion()));
                return new CoordinatorResult<Void, Record>(records, appendFuture);
            }
            this.log.info("Stabilized group {} generation {} with {} members.", new Object[]{groupId, group.generationId(), group.size()});
            group.allMembers().forEach(member -> {
                List<Object> members = Collections.emptyList();
                if (group.isLeader(member.memberId())) {
                    members = group.currentClassicGroupMembers();
                }
                JoinGroupResponseData response = new JoinGroupResponseData().setMembers(members).setMemberId(member.memberId()).setGenerationId(group.generationId()).setProtocolName((String)group.protocolName().orElse(null)).setProtocolType((String)group.protocolType().orElse(null)).setLeader(group.leaderOrNull()).setSkipAssignment(false).setErrorCode(Errors.NONE.code());
                group.completeJoinFuture((ClassicGroupMember)member, response);
                this.rescheduleClassicGroupMemberHeartbeat(group, (ClassicGroupMember)member);
                member.setIsNew(false);
                group.addPendingSyncMember(member.memberId());
            });
            this.schedulePendingSync(group);
        }
        return EMPTY_RESULT;
    }

    private void schedulePendingSync(ClassicGroup group) {
        this.timer.schedule(GroupMetadataManager.classicGroupSyncKey(group.groupId()), group.rebalanceTimeoutMs(), TimeUnit.MILLISECONDS, false, () -> this.expirePendingSync(group, group.generationId()));
    }

    private CoordinatorResult<Void, Record> expireClassicGroupMemberHeartbeat(ClassicGroup group, String memberId) {
        if (group.isInState(ClassicGroupState.DEAD)) {
            this.log.info("Received notification of heartbeat expiration for member {} after group {} had already been unloaded or deleted.", (Object)memberId, (Object)group.groupId());
        } else {
            if (group.isPendingMember(memberId)) {
                this.log.info("Pending member {} in group {} has been removed after session timeout expiration.", (Object)memberId, (Object)group.groupId());
                return this.removePendingMemberAndUpdateClassicGroup(group, memberId);
            }
            if (!group.hasMemberId(memberId)) {
                this.log.debug("Member {} has already been removed from the group.", (Object)memberId);
            } else {
                ClassicGroupMember member = group.member(memberId);
                if (!member.hasSatisfiedHeartbeat()) {
                    this.log.info("Member {} in group {} has failed, removing it from the group.", (Object)member.memberId(), (Object)group.groupId());
                    return this.removeMemberAndUpdateClassicGroup(group, member, "removing member " + member.memberId() + " on heartbeat expiration.");
                }
            }
        }
        return EMPTY_RESULT;
    }

    private CoordinatorResult<Void, Record> removeMemberAndUpdateClassicGroup(ClassicGroup group, ClassicGroupMember member, String reason) {
        group.completeJoinFuture(member, new JoinGroupResponseData().setMemberId("").setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()));
        group.remove(member.memberId());
        if (group.isInState(ClassicGroupState.STABLE) || group.isInState(ClassicGroupState.COMPLETING_REBALANCE)) {
            return this.maybePrepareRebalanceOrCompleteJoin(group, reason);
        }
        if (group.isInState(ClassicGroupState.PREPARING_REBALANCE) && group.hasAllMembersJoined()) {
            return this.completeClassicGroupJoin(group);
        }
        return EMPTY_RESULT;
    }

    private CoordinatorResult<Void, Record> removePendingMemberAndUpdateClassicGroup(ClassicGroup group, String memberId) {
        group.remove(memberId);
        if (group.isInState(ClassicGroupState.PREPARING_REBALANCE) && group.hasAllMembersJoined()) {
            return this.completeClassicGroupJoin(group);
        }
        return EMPTY_RESULT;
    }

    private CoordinatorResult<Void, Record> updateMemberThenRebalanceOrCompleteJoin(JoinGroupRequestData request, ClassicGroup group, ClassicGroupMember member, String joinReason, CompletableFuture<JoinGroupResponseData> responseFuture) {
        group.updateMember(member, request.protocols(), request.rebalanceTimeoutMs(), request.sessionTimeoutMs(), responseFuture);
        return this.maybePrepareRebalanceOrCompleteJoin(group, joinReason);
    }

    private CoordinatorResult<Void, Record> addMemberThenRebalanceOrCompleteJoin(RequestContext context, JoinGroupRequestData request, ClassicGroup group, String memberId, CompletableFuture<JoinGroupResponseData> responseFuture) {
        Optional<String> groupInstanceId = Optional.ofNullable(request.groupInstanceId());
        ClassicGroupMember member = new ClassicGroupMember(memberId, groupInstanceId, context.clientId(), context.clientAddress().toString(), request.rebalanceTimeoutMs(), request.sessionTimeoutMs(), request.protocolType(), request.protocols());
        member.setIsNew(true);
        if (group.isInState(ClassicGroupState.PREPARING_REBALANCE) && group.previousState() == ClassicGroupState.EMPTY) {
            group.setNewMemberAdded(true);
        }
        group.add(member, responseFuture);
        this.rescheduleClassicGroupMemberHeartbeat(group, member, this.classicGroupNewMemberJoinTimeoutMs);
        return this.maybePrepareRebalanceOrCompleteJoin(group, "Adding new member " + memberId + " with group instance id " + request.groupInstanceId() + "; client reason: " + JoinGroupRequest.joinReason((JoinGroupRequestData)request));
    }

    private CoordinatorResult<Void, Record> maybePrepareRebalanceOrCompleteJoin(ClassicGroup group, String reason) {
        if (group.canRebalance()) {
            return this.prepareRebalance(group, reason);
        }
        return this.maybeCompleteJoinPhase(group);
    }

    CoordinatorResult<Void, Record> prepareRebalance(ClassicGroup group, String reason) {
        if (group.isInState(ClassicGroupState.COMPLETING_REBALANCE)) {
            this.resetAndPropagateAssignmentWithError(group, Errors.REBALANCE_IN_PROGRESS);
        }
        this.removeSyncExpiration(group);
        boolean isInitialRebalance = group.isInState(ClassicGroupState.EMPTY);
        if (isInitialRebalance) {
            int delayMs = this.classicGroupInitialRebalanceDelayMs;
            int remainingMs = Math.max(group.rebalanceTimeoutMs() - this.classicGroupInitialRebalanceDelayMs, 0);
            this.timer.schedule(GroupMetadataManager.classicGroupJoinKey(group.groupId()), delayMs, TimeUnit.MILLISECONDS, false, () -> this.tryCompleteInitialRebalanceElseSchedule(group, delayMs, remainingMs));
        }
        group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        this.log.info("Preparing to rebalance group {} in state {} with old generation {} (reason: {}).", new Object[]{group.groupId(), group.currentState(), group.generationId(), reason});
        return isInitialRebalance ? EMPTY_RESULT : this.maybeCompleteJoinElseSchedule(group);
    }

    private CoordinatorResult<Void, Record> maybeCompleteJoinElseSchedule(ClassicGroup group) {
        String classicGroupJoinKey = GroupMetadataManager.classicGroupJoinKey(group.groupId());
        if (group.hasAllMembersJoined()) {
            return this.completeClassicGroupJoin(group);
        }
        this.timer.schedule(classicGroupJoinKey, group.rebalanceTimeoutMs(), TimeUnit.MILLISECONDS, false, () -> this.completeClassicGroupJoin(group));
        return EMPTY_RESULT;
    }

    private CoordinatorResult<Void, Record> tryCompleteInitialRebalanceElseSchedule(ClassicGroup group, int delayMs, int remainingMs) {
        if (!group.newMemberAdded() || remainingMs == 0) {
            return this.completeClassicGroupJoin(group);
        }
        group.setNewMemberAdded(false);
        int newDelayMs = Math.min(this.classicGroupInitialRebalanceDelayMs, remainingMs);
        int newRemainingMs = Math.max(remainingMs - delayMs, 0);
        this.timer.schedule(GroupMetadataManager.classicGroupJoinKey(group.groupId()), newDelayMs, TimeUnit.MILLISECONDS, false, () -> this.tryCompleteInitialRebalanceElseSchedule(group, newDelayMs, newRemainingMs));
        return EMPTY_RESULT;
    }

    private void resetAndPropagateAssignmentWithError(ClassicGroup group, Errors error) {
        if (!group.isInState(ClassicGroupState.COMPLETING_REBALANCE)) {
            throw new IllegalStateException("Group " + group.groupId() + " must be in " + ClassicGroupState.COMPLETING_REBALANCE.name() + " state but is in " + (Object)((Object)group.currentState()) + ".");
        }
        group.allMembers().forEach(member -> member.setAssignment(ClassicGroupMember.EMPTY_ASSIGNMENT));
        this.propagateAssignment(group, error);
    }

    private void setAndPropagateAssignment(ClassicGroup group, Map<String, byte[]> assignment) {
        if (!group.isInState(ClassicGroupState.COMPLETING_REBALANCE)) {
            throw new IllegalStateException("The group must be in CompletingRebalance state to set and propagate assignment.");
        }
        group.allMembers().forEach(member -> member.setAssignment(assignment.getOrDefault(member.memberId(), ClassicGroupMember.EMPTY_ASSIGNMENT)));
        this.propagateAssignment(group, Errors.NONE);
    }

    private void propagateAssignment(ClassicGroup group, Errors error) {
        Optional<Object> protocolName = Optional.empty();
        Optional<Object> protocolType = Optional.empty();
        if (error == Errors.NONE) {
            protocolName = group.protocolName();
            protocolType = group.protocolType();
        }
        for (ClassicGroupMember member : group.allMembers()) {
            if (!member.hasAssignment() && error == Errors.NONE) {
                this.log.warn("Sending empty assignment to member {} of {} for generation {} with no errors", new Object[]{member.memberId(), group.groupId(), group.generationId()});
            }
            if (!group.completeSyncFuture(member, new SyncGroupResponseData().setProtocolName((String)protocolName.orElse(null)).setProtocolType((String)protocolType.orElse(null)).setAssignment(member.assignment()).setErrorCode(error.code()))) continue;
            this.rescheduleClassicGroupMemberHeartbeat(group, member);
        }
    }

    public void rescheduleClassicGroupMemberHeartbeat(ClassicGroup group, ClassicGroupMember member) {
        this.rescheduleClassicGroupMemberHeartbeat(group, member, member.sessionTimeoutMs());
    }

    private void rescheduleClassicGroupMemberHeartbeat(ClassicGroup group, ClassicGroupMember member, long timeoutMs) {
        String classicGroupHeartbeatKey = GroupMetadataManager.classicGroupHeartbeatKey(group.groupId(), member.memberId());
        this.timer.schedule(classicGroupHeartbeatKey, timeoutMs, TimeUnit.MILLISECONDS, false, () -> this.expireClassicGroupMemberHeartbeat(group, member.memberId()));
    }

    private void removeSyncExpiration(ClassicGroup group) {
        group.clearPendingSyncMembers();
        this.timer.cancel(GroupMetadataManager.classicGroupSyncKey(group.groupId()));
    }

    private CoordinatorResult<Void, Record> expirePendingSync(ClassicGroup group, int generationId) {
        if (generationId != group.generationId()) {
            this.log.error("Received unexpected notification of sync expiration for {} with an old generation {} while the group has {}.", new Object[]{group.groupId(), generationId, group.generationId()});
        } else if (group.isInState(ClassicGroupState.DEAD) || group.isInState(ClassicGroupState.EMPTY) || group.isInState(ClassicGroupState.PREPARING_REBALANCE)) {
            this.log.error("Received unexpected notification of sync expiration after group {} already transitioned to {} state.", (Object)group.groupId(), (Object)group.stateAsString());
        } else if ((group.isInState(ClassicGroupState.COMPLETING_REBALANCE) || group.isInState(ClassicGroupState.STABLE)) && !group.hasReceivedSyncFromAllMembers()) {
            HashSet<String> pendingSyncMembers = new HashSet<String>(group.allPendingSyncMembers());
            pendingSyncMembers.forEach(memberId -> {
                group.remove((String)memberId);
                this.timer.cancel(GroupMetadataManager.classicGroupHeartbeatKey(group.groupId(), memberId));
            });
            this.log.debug("Group {} removed members who haven't sent their sync requests: {}", (Object)group.groupId(), pendingSyncMembers);
            return this.prepareRebalance(group, "Removing " + pendingSyncMembers + " on pending sync request expiration");
        }
        return EMPTY_RESULT;
    }

    private boolean acceptJoiningMember(ClassicGroup group, String memberId) {
        switch (group.currentState()) {
            case EMPTY: 
            case DEAD: {
                return true;
            }
            case PREPARING_REBALANCE: {
                return group.hasMemberId(memberId) && group.member(memberId).isAwaitingJoin() || group.numAwaitingJoinResponse() < this.classicGroupMaxSize;
            }
            case COMPLETING_REBALANCE: 
            case STABLE: {
                return group.hasMemberId(memberId) || group.size() < this.classicGroupMaxSize;
            }
        }
        throw new IllegalStateException("Unknown group state: " + group.stateAsString());
    }

    private CoordinatorResult<Void, Record> updateStaticMemberThenRebalanceOrCompleteJoin(RequestContext context, JoinGroupRequestData request, ClassicGroup group, String oldMemberId, String newMemberId, CompletableFuture<JoinGroupResponseData> responseFuture) {
        String currentLeader = group.leaderOrNull();
        ClassicGroupMember newMember = group.replaceStaticMember(request.groupInstanceId(), oldMemberId, newMemberId);
        this.rescheduleClassicGroupMemberHeartbeat(group, newMember);
        int oldRebalanceTimeoutMs = newMember.rebalanceTimeoutMs();
        int oldSessionTimeoutMs = newMember.sessionTimeoutMs();
        JoinGroupRequestData.JoinGroupRequestProtocolCollection oldProtocols = newMember.supportedProtocols();
        group.updateMember(newMember, request.protocols(), request.rebalanceTimeoutMs(), request.sessionTimeoutMs(), responseFuture);
        if (group.isInState(ClassicGroupState.STABLE)) {
            String groupInstanceId = request.groupInstanceId();
            String selectedProtocolForNextGeneration = group.selectProtocol();
            if (group.protocolName().orElse("").equals(selectedProtocolForNextGeneration)) {
                this.log.info("Static member which joins during Stable stage and doesn't affect the selected protocol will not trigger a rebalance.");
                Map<String, byte[]> groupAssignment = group.groupAssignment();
                CompletableFuture<Void> appendFuture = new CompletableFuture<Void>();
                appendFuture.whenComplete((__, t) -> {
                    if (t != null) {
                        this.log.warn("Failed to persist metadata for group {} static member {} with group instance id {} due to {}. Reverting to old member id {}.", new Object[]{group.groupId(), newMemberId, groupInstanceId, t.getMessage(), oldMemberId});
                        group.updateMember(newMember, oldProtocols, oldRebalanceTimeoutMs, oldSessionTimeoutMs, null);
                        ClassicGroupMember oldMember = group.replaceStaticMember(groupInstanceId, newMemberId, oldMemberId);
                        this.rescheduleClassicGroupMemberHeartbeat(group, oldMember);
                        responseFuture.complete(new JoinGroupResponseData().setMembers(Collections.emptyList()).setMemberId("").setGenerationId(group.generationId()).setProtocolName((String)group.protocolName().orElse(null)).setProtocolType((String)group.protocolType().orElse(null)).setLeader(currentLeader).setSkipAssignment(false).setErrorCode(GroupMetadataManager.appendGroupMetadataErrorToResponseError(Errors.forException((Throwable)t)).code()));
                    } else if (JoinGroupRequest.supportsSkippingAssignment((short)context.apiVersion())) {
                        boolean isLeader = group.isLeader(newMemberId);
                        group.completeJoinFuture(newMember, new JoinGroupResponseData().setMembers(isLeader ? group.currentClassicGroupMembers() : Collections.emptyList()).setMemberId(newMemberId).setGenerationId(group.generationId()).setProtocolName((String)group.protocolName().orElse(null)).setProtocolType((String)group.protocolType().orElse(null)).setLeader(group.leaderOrNull()).setSkipAssignment(isLeader));
                    } else {
                        group.completeJoinFuture(newMember, new JoinGroupResponseData().setMembers(Collections.emptyList()).setMemberId(newMemberId).setGenerationId(group.generationId()).setProtocolName((String)group.protocolName().orElse(null)).setProtocolType((String)group.protocolType().orElse(null)).setLeader(currentLeader).setSkipAssignment(false));
                    }
                });
                List<Record> records = Collections.singletonList(RecordHelpers.newGroupMetadataRecord(group, groupAssignment, this.metadataImage.features().metadataVersion()));
                return new CoordinatorResult<Void, Record>(records, appendFuture);
            }
            return this.maybePrepareRebalanceOrCompleteJoin(group, "Group's selectedProtocol will change because static member " + newMember.memberId() + " with instance id " + groupInstanceId + " joined with change of protocol; client reason: " + JoinGroupRequest.joinReason((JoinGroupRequestData)request));
        }
        if (group.isInState(ClassicGroupState.COMPLETING_REBALANCE)) {
            return this.prepareRebalance(group, "Updating metadata for static member " + newMember.memberId() + " with instance id " + request.groupInstanceId() + "; client reason: " + JoinGroupRequest.joinReason((JoinGroupRequestData)request));
        }
        if (group.isInState(ClassicGroupState.EMPTY) || group.isInState(ClassicGroupState.DEAD)) {
            throw new IllegalStateException("Group " + group.groupId() + " was not supposed to be in the state " + group.stateAsString() + " when the unknown static member " + request.groupInstanceId() + " rejoins.");
        }
        return this.maybeCompleteJoinPhase(group);
    }

    public CoordinatorResult<Void, Record> classicGroupSync(RequestContext context, SyncGroupRequestData request, CompletableFuture<SyncGroupResponseData> responseFuture) throws UnknownMemberIdException, GroupIdNotFoundException {
        ClassicGroup group;
        String groupId = request.groupId();
        String memberId = request.memberId();
        try {
            group = this.getOrMaybeCreateClassicGroup(groupId, false);
        }
        catch (Throwable t2) {
            responseFuture.complete(new SyncGroupResponseData().setErrorCode(Errors.forException((Throwable)t2).code()));
            return EMPTY_RESULT;
        }
        Optional<Errors> errorOpt = this.validateSyncGroup(group, request);
        if (errorOpt.isPresent()) {
            responseFuture.complete(new SyncGroupResponseData().setErrorCode(errorOpt.get().code()));
        } else if (group.isInState(ClassicGroupState.EMPTY)) {
            responseFuture.complete(new SyncGroupResponseData().setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()));
        } else if (group.isInState(ClassicGroupState.PREPARING_REBALANCE)) {
            responseFuture.complete(new SyncGroupResponseData().setErrorCode(Errors.REBALANCE_IN_PROGRESS.code()));
        } else if (group.isInState(ClassicGroupState.COMPLETING_REBALANCE)) {
            group.member(memberId).setAwaitingSyncFuture(responseFuture);
            this.removePendingSyncMember(group, request.memberId());
            if (group.isLeader(memberId)) {
                this.log.info("Assignment received from leader {} for group {} for generation {}. The group has {} members, {} of which are static.", new Object[]{memberId, groupId, group.generationId(), group.size(), group.allStaticMemberIds().size()});
                HashMap<String, byte[]> assignment = new HashMap<String, byte[]>();
                request.assignments().forEach(memberAssignment -> assignment.put(memberAssignment.memberId(), memberAssignment.assignment()));
                HashMap membersWithMissingAssignment = new HashMap();
                group.allMembers().forEach(member -> {
                    if (!assignment.containsKey(member.memberId())) {
                        membersWithMissingAssignment.put(member.memberId(), ClassicGroupMember.EMPTY_ASSIGNMENT);
                    }
                });
                assignment.putAll(membersWithMissingAssignment);
                if (!membersWithMissingAssignment.isEmpty()) {
                    this.log.warn("Setting empty assignments for members {} of {} for generation {}.", new Object[]{membersWithMissingAssignment, groupId, group.generationId()});
                }
                CompletableFuture<Void> appendFuture = new CompletableFuture<Void>();
                appendFuture.whenComplete((__, t) -> {
                    if (group.isInState(ClassicGroupState.COMPLETING_REBALANCE) && request.generationId() == group.generationId()) {
                        if (t != null) {
                            Errors error = GroupMetadataManager.appendGroupMetadataErrorToResponseError(Errors.forException((Throwable)t));
                            this.resetAndPropagateAssignmentWithError(group, error);
                            this.maybePrepareRebalanceOrCompleteJoin(group, "Error " + error + " when storing group assignmentduring SyncGroup (member: " + memberId + ").");
                        } else {
                            this.setAndPropagateAssignment(group, assignment);
                            group.transitionTo(ClassicGroupState.STABLE);
                            this.metrics.record("CompletedRebalances");
                        }
                    }
                });
                List<Record> records = Collections.singletonList(RecordHelpers.newGroupMetadataRecord(group, assignment, this.metadataImage.features().metadataVersion()));
                return new CoordinatorResult<Void, Record>(records, appendFuture);
            }
        } else if (group.isInState(ClassicGroupState.STABLE)) {
            this.removePendingSyncMember(group, memberId);
            ClassicGroupMember member2 = group.member(memberId);
            responseFuture.complete(new SyncGroupResponseData().setProtocolType((String)group.protocolType().orElse(null)).setProtocolName((String)group.protocolName().orElse(null)).setAssignment(member2.assignment()).setErrorCode(Errors.NONE.code()));
        } else if (group.isInState(ClassicGroupState.DEAD)) {
            throw new IllegalStateException("Reached unexpected condition for Dead group " + groupId);
        }
        return EMPTY_RESULT;
    }

    static Errors appendGroupMetadataErrorToResponseError(Errors appendError) {
        switch (appendError) {
            case UNKNOWN_TOPIC_OR_PARTITION: 
            case NOT_ENOUGH_REPLICAS: 
            case REQUEST_TIMED_OUT: {
                return Errors.COORDINATOR_NOT_AVAILABLE;
            }
            case NOT_LEADER_OR_FOLLOWER: 
            case KAFKA_STORAGE_ERROR: {
                return Errors.NOT_COORDINATOR;
            }
            case MESSAGE_TOO_LARGE: 
            case RECORD_LIST_TOO_LARGE: 
            case INVALID_FETCH_SIZE: {
                return Errors.UNKNOWN_SERVER_ERROR;
            }
        }
        return appendError;
    }

    private Optional<Errors> validateSyncGroup(ClassicGroup group, SyncGroupRequestData request) {
        if (group.isInState(ClassicGroupState.DEAD)) {
            return Optional.of(Errors.COORDINATOR_NOT_AVAILABLE);
        }
        try {
            group.validateMember(request.memberId(), request.groupInstanceId(), "sync-group");
        }
        catch (KafkaException ex) {
            return Optional.of(Errors.forException((Throwable)ex));
        }
        if (request.generationId() != group.generationId()) {
            return Optional.of(Errors.ILLEGAL_GENERATION);
        }
        if (this.isProtocolInconsistent(request.protocolType(), group.protocolType().orElse(null)) || this.isProtocolInconsistent(request.protocolName(), group.protocolName().orElse(null))) {
            return Optional.of(Errors.INCONSISTENT_GROUP_PROTOCOL);
        }
        return Optional.empty();
    }

    private void removePendingSyncMember(ClassicGroup group, String memberId) {
        group.removePendingSyncMember(memberId);
        String syncKey = GroupMetadataManager.classicGroupSyncKey(group.groupId());
        switch (group.currentState()) {
            case EMPTY: 
            case DEAD: 
            case PREPARING_REBALANCE: {
                this.timer.cancel(syncKey);
                break;
            }
            case COMPLETING_REBALANCE: 
            case STABLE: {
                if (!group.hasReceivedSyncFromAllMembers()) break;
                this.timer.cancel(syncKey);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown group state: " + group.stateAsString());
            }
        }
    }

    public HeartbeatResponseData classicGroupHeartbeat(RequestContext context, HeartbeatRequestData request) {
        ClassicGroup group = this.getOrMaybeCreateClassicGroup(request.groupId(), false);
        this.validateClassicGroupHeartbeat(group, request.memberId(), request.groupInstanceId(), request.generationId());
        switch (group.currentState()) {
            case EMPTY: {
                return new HeartbeatResponseData().setErrorCode(Errors.UNKNOWN_MEMBER_ID.code());
            }
            case PREPARING_REBALANCE: {
                this.rescheduleClassicGroupMemberHeartbeat(group, group.member(request.memberId()));
                return new HeartbeatResponseData().setErrorCode(Errors.REBALANCE_IN_PROGRESS.code());
            }
            case COMPLETING_REBALANCE: 
            case STABLE: {
                this.rescheduleClassicGroupMemberHeartbeat(group, group.member(request.memberId()));
                return new HeartbeatResponseData();
            }
        }
        throw new IllegalStateException("Reached unexpected state " + (Object)((Object)group.currentState()) + " for group " + group.groupId());
    }

    private void validateClassicGroupHeartbeat(ClassicGroup group, String memberId, String groupInstanceId, int generationId) throws CoordinatorNotAvailableException, IllegalGenerationException {
        if (group.isInState(ClassicGroupState.DEAD)) {
            throw Errors.COORDINATOR_NOT_AVAILABLE.exception();
        }
        group.validateMember(memberId, groupInstanceId, "heartbeat");
        if (generationId != group.generationId()) {
            throw Errors.ILLEGAL_GENERATION.exception();
        }
    }

    public CoordinatorResult<LeaveGroupResponseData, Record> classicGroupLeave(RequestContext context, LeaveGroupRequestData request) throws UnknownMemberIdException, GroupIdNotFoundException {
        ClassicGroup group = this.getOrMaybeCreateClassicGroup(request.groupId(), false);
        if (group.isInState(ClassicGroupState.DEAD)) {
            return new CoordinatorResult<LeaveGroupResponseData, Record>(Collections.emptyList(), new LeaveGroupResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
        }
        ArrayList<LeaveGroupResponseData.MemberResponse> memberResponses = new ArrayList<LeaveGroupResponseData.MemberResponse>();
        for (LeaveGroupRequestData.MemberIdentity member : request.members()) {
            String reason;
            String string = reason = member.reason() != null ? member.reason() : "not provided";
            if ("".equals(member.memberId())) {
                if (member.groupInstanceId() != null && group.hasStaticMember(member.groupInstanceId())) {
                    this.removeCurrentMemberFromClassicGroup(group, group.staticMemberId(member.groupInstanceId()), reason);
                    memberResponses.add(new LeaveGroupResponseData.MemberResponse().setMemberId(member.memberId()).setGroupInstanceId(member.groupInstanceId()));
                    continue;
                }
                memberResponses.add(new LeaveGroupResponseData.MemberResponse().setMemberId(member.memberId()).setGroupInstanceId(member.groupInstanceId()).setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()));
                continue;
            }
            if (group.isPendingMember(member.memberId())) {
                group.remove(member.memberId());
                this.timer.cancel(GroupMetadataManager.classicGroupHeartbeatKey(group.groupId(), member.memberId()));
                this.log.info("[Group {}] Pending member {} has left group through explicit `LeaveGroup` request; client reason: {}", new Object[]{group.groupId(), member.memberId(), reason});
                memberResponses.add(new LeaveGroupResponseData.MemberResponse().setMemberId(member.memberId()).setGroupInstanceId(member.groupInstanceId()));
                continue;
            }
            try {
                group.validateMember(member.memberId(), member.groupInstanceId(), "leave-group");
                this.removeCurrentMemberFromClassicGroup(group, member.memberId(), reason);
                memberResponses.add(new LeaveGroupResponseData.MemberResponse().setMemberId(member.memberId()).setGroupInstanceId(member.groupInstanceId()));
            }
            catch (KafkaException e) {
                memberResponses.add(new LeaveGroupResponseData.MemberResponse().setMemberId(member.memberId()).setGroupInstanceId(member.groupInstanceId()).setErrorCode(Errors.forException((Throwable)e).code()));
            }
        }
        List validLeaveGroupMembers = memberResponses.stream().filter(response -> response.errorCode() == Errors.NONE.code()).map(LeaveGroupResponseData.MemberResponse::memberId).collect(Collectors.toList());
        String reason = "explicit `LeaveGroup` request for (" + String.join((CharSequence)", ", validLeaveGroupMembers) + ") members.";
        CoordinatorResult<Void, Record> coordinatorResult = EMPTY_RESULT;
        if (!validLeaveGroupMembers.isEmpty()) {
            switch (group.currentState()) {
                case COMPLETING_REBALANCE: 
                case STABLE: {
                    coordinatorResult = this.maybePrepareRebalanceOrCompleteJoin(group, reason);
                    break;
                }
                case PREPARING_REBALANCE: {
                    coordinatorResult = this.maybeCompleteJoinPhase(group);
                    break;
                }
            }
        }
        return new CoordinatorResult<LeaveGroupResponseData, Record>(coordinatorResult.records(), new LeaveGroupResponseData().setMembers(memberResponses), coordinatorResult.appendFuture());
    }

    private void removeCurrentMemberFromClassicGroup(ClassicGroup group, String memberId, String reason) {
        ClassicGroupMember member = group.member(memberId);
        this.timer.cancel(GroupMetadataManager.classicGroupHeartbeatKey(group.groupId(), memberId));
        this.log.info("[Group {}] Member {} has left group through explicit `LeaveGroup` request; client reason: {}", new Object[]{group.groupId(), memberId, reason});
        group.completeJoinFuture(member, new JoinGroupResponseData().setMemberId("").setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()));
        group.remove(member.memberId());
    }

    public void deleteGroup(String groupId, List<Record> records) {
        this.group(groupId).createGroupTombstoneRecords(records);
    }

    void validateDeleteGroup(String groupId) throws ApiException {
        Group group = this.group(groupId);
        group.validateDeleteGroup();
    }

    public void maybeDeleteGroup(String groupId, List<Record> records) {
        Group group = (Group)this.groups.get((Object)groupId);
        if (group != null && group.isEmpty()) {
            this.deleteGroup(groupId, records);
        }
    }

    private boolean isProtocolInconsistent(String protocolTypeOrName, String groupProtocolTypeOrName) {
        return protocolTypeOrName != null && groupProtocolTypeOrName != null && !groupProtocolTypeOrName.equals(protocolTypeOrName);
    }

    public Set<String> groupIds() {
        return Collections.unmodifiableSet(this.groups.keySet());
    }

    static String classicGroupHeartbeatKey(String groupId, String memberId) {
        return "heartbeat-" + groupId + "-" + memberId;
    }

    static String classicGroupJoinKey(String groupId) {
        return "join-" + groupId;
    }

    static String classicGroupSyncKey(String groupId) {
        return "sync-" + groupId;
    }

    public static class Builder {
        private LogContext logContext = null;
        private SnapshotRegistry snapshotRegistry = null;
        private Time time = null;
        private CoordinatorTimer<Void, Record> timer = null;
        private List<PartitionAssignor> consumerGroupAssignors = null;
        private int consumerGroupMaxSize = Integer.MAX_VALUE;
        private int consumerGroupHeartbeatIntervalMs = 5000;
        private int consumerGroupMetadataRefreshIntervalMs = Integer.MAX_VALUE;
        private MetadataImage metadataImage = null;
        private int consumerGroupSessionTimeoutMs = 45000;
        private int classicGroupMaxSize = Integer.MAX_VALUE;
        private int classicGroupInitialRebalanceDelayMs = 3000;
        private int classicGroupNewMemberJoinTimeoutMs = 300000;
        private int classicGroupMinSessionTimeoutMs;
        private int classicGroupMaxSessionTimeoutMs;
        private GroupCoordinatorMetricsShard metrics;

        Builder withLogContext(LogContext logContext) {
            this.logContext = logContext;
            return this;
        }

        Builder withSnapshotRegistry(SnapshotRegistry snapshotRegistry) {
            this.snapshotRegistry = snapshotRegistry;
            return this;
        }

        Builder withTime(Time time) {
            this.time = time;
            return this;
        }

        Builder withTimer(CoordinatorTimer<Void, Record> timer) {
            this.timer = timer;
            return this;
        }

        Builder withConsumerGroupAssignors(List<PartitionAssignor> consumerGroupAssignors) {
            this.consumerGroupAssignors = consumerGroupAssignors;
            return this;
        }

        Builder withConsumerGroupMaxSize(int consumerGroupMaxSize) {
            this.consumerGroupMaxSize = consumerGroupMaxSize;
            return this;
        }

        Builder withConsumerGroupSessionTimeout(int consumerGroupSessionTimeoutMs) {
            this.consumerGroupSessionTimeoutMs = consumerGroupSessionTimeoutMs;
            return this;
        }

        Builder withConsumerGroupHeartbeatInterval(int consumerGroupHeartbeatIntervalMs) {
            this.consumerGroupHeartbeatIntervalMs = consumerGroupHeartbeatIntervalMs;
            return this;
        }

        Builder withConsumerGroupMetadataRefreshIntervalMs(int consumerGroupMetadataRefreshIntervalMs) {
            this.consumerGroupMetadataRefreshIntervalMs = consumerGroupMetadataRefreshIntervalMs;
            return this;
        }

        Builder withMetadataImage(MetadataImage metadataImage) {
            this.metadataImage = metadataImage;
            return this;
        }

        Builder withClassicGroupMaxSize(int classicGroupMaxSize) {
            this.classicGroupMaxSize = classicGroupMaxSize;
            return this;
        }

        Builder withClassicGroupInitialRebalanceDelayMs(int classicGroupInitialRebalanceDelayMs) {
            this.classicGroupInitialRebalanceDelayMs = classicGroupInitialRebalanceDelayMs;
            return this;
        }

        Builder withClassicGroupNewMemberJoinTimeoutMs(int classicGroupNewMemberJoinTimeoutMs) {
            this.classicGroupNewMemberJoinTimeoutMs = classicGroupNewMemberJoinTimeoutMs;
            return this;
        }

        Builder withClassicGroupMinSessionTimeoutMs(int classicGroupMinSessionTimeoutMs) {
            this.classicGroupMinSessionTimeoutMs = classicGroupMinSessionTimeoutMs;
            return this;
        }

        Builder withClassicGroupMaxSessionTimeoutMs(int classicGroupMaxSessionTimeoutMs) {
            this.classicGroupMaxSessionTimeoutMs = classicGroupMaxSessionTimeoutMs;
            return this;
        }

        Builder withGroupCoordinatorMetricsShard(GroupCoordinatorMetricsShard metrics) {
            this.metrics = metrics;
            return this;
        }

        GroupMetadataManager build() {
            if (this.logContext == null) {
                this.logContext = new LogContext();
            }
            if (this.snapshotRegistry == null) {
                this.snapshotRegistry = new SnapshotRegistry(this.logContext);
            }
            if (this.metadataImage == null) {
                this.metadataImage = MetadataImage.EMPTY;
            }
            if (this.time == null) {
                this.time = Time.SYSTEM;
            }
            if (this.timer == null) {
                throw new IllegalArgumentException("Timer must be set.");
            }
            if (this.consumerGroupAssignors == null || this.consumerGroupAssignors.isEmpty()) {
                throw new IllegalArgumentException("Assignors must be set before building.");
            }
            if (this.metrics == null) {
                throw new IllegalArgumentException("GroupCoordinatorMetricsShard must be set.");
            }
            return new GroupMetadataManager(this.snapshotRegistry, this.logContext, this.time, this.timer, this.metrics, this.consumerGroupAssignors, this.metadataImage, this.consumerGroupMaxSize, this.consumerGroupSessionTimeoutMs, this.consumerGroupHeartbeatIntervalMs, this.consumerGroupMetadataRefreshIntervalMs, this.classicGroupMaxSize, this.classicGroupInitialRebalanceDelayMs, this.classicGroupNewMemberJoinTimeoutMs, this.classicGroupMinSessionTimeoutMs, this.classicGroupMaxSessionTimeoutMs);
        }
    }
}

