/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.script.mustache;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.settings.Settings;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.rest.action.search.RestMultiSearchAction;
import org.opensearch.rest.action.search.RestSearchAction;
import org.opensearch.script.mustache.MultiSearchTemplateAction;
import org.opensearch.script.mustache.MultiSearchTemplateRequest;
import org.opensearch.script.mustache.SearchTemplateRequest;

public class RestMultiSearchTemplateAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestMultiSearchTemplateAction.class);
    static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Specifying types in multi search template requests is deprecated.";
    private static final Set<String> RESPONSE_PARAMS;
    private final boolean allowExplicitIndex;

    public RestMultiSearchTemplateAction(Settings settings) {
        this.allowExplicitIndex = (Boolean)MULTI_ALLOW_EXPLICIT_INDEX.get(settings);
    }

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_msearch/template"), new RestHandler.Route(RestRequest.Method.POST, "/_msearch/template"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_msearch/template"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_msearch/template"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/{type}/_msearch/template"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/{type}/_msearch/template")));
    }

    public String getName() {
        return "multi_search_template_action";
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MultiSearchTemplateRequest multiRequest = RestMultiSearchTemplateAction.parseRequest(request, this.allowExplicitIndex);
        for (SearchTemplateRequest searchTemplateRequest : multiRequest.requests()) {
            if (searchTemplateRequest.getRequest().types().length <= 0) continue;
            deprecationLogger.deprecate("msearch_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
            break;
        }
        return channel -> client.execute((ActionType)MultiSearchTemplateAction.INSTANCE, (ActionRequest)multiRequest, (ActionListener)new RestToXContentListener(channel));
    }

    public static MultiSearchTemplateRequest parseRequest(RestRequest restRequest, boolean allowExplicitIndex) throws IOException {
        MultiSearchTemplateRequest multiRequest = new MultiSearchTemplateRequest();
        if (restRequest.hasParam("max_concurrent_searches")) {
            multiRequest.maxConcurrentSearchRequests(restRequest.paramAsInt("max_concurrent_searches", 0));
        }
        RestMultiSearchAction.parseMultiLineRequest((RestRequest)restRequest, (IndicesOptions)multiRequest.indicesOptions(), (boolean)allowExplicitIndex, (searchRequest, bytes) -> {
            SearchTemplateRequest searchTemplateRequest = SearchTemplateRequest.fromXContent(bytes);
            if (searchTemplateRequest.getScript() == null) {
                throw new IllegalArgumentException("Malformed search template");
            }
            searchTemplateRequest.setRequest((SearchRequest)searchRequest);
            multiRequest.add(searchTemplateRequest);
            RestSearchAction.checkRestTotalHits((RestRequest)restRequest, (SearchRequest)searchRequest);
        });
        return multiRequest;
    }

    public boolean supportsContentStream() {
        return true;
    }

    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }

    static {
        HashSet<String> responseParams = new HashSet<String>(Arrays.asList("typed_keys", "rest_total_hits_as_int"));
        RESPONSE_PARAMS = Collections.unmodifiableSet(responseParams);
    }
}

