/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.hostdb;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.hostdb.CrawlDatumProcessor;
import org.apache.nutch.hostdb.HostDatum;

public class FetchOverdueCrawlDatumProcessor
implements CrawlDatumProcessor {
    protected final Configuration conf;
    protected long overDueTimeLimit = 172800000L;
    protected long overDueTime;
    protected long numOverDue = 0L;

    public FetchOverdueCrawlDatumProcessor(Configuration conf) {
        this.conf = conf;
        this.overDueTimeLimit = conf.getLong("crawl.datum.processor.overdue.time.limit", 172800000L);
        this.overDueTime = System.currentTimeMillis() - this.overDueTimeLimit;
    }

    @Override
    public void count(CrawlDatum crawlDatum) {
        if (crawlDatum.getStatus() == 1 && crawlDatum.getFetchTime() < this.overDueTime) {
            ++this.numOverDue;
        }
    }

    @Override
    public void finalize(HostDatum hostDatum) {
        hostDatum.getMetaData().put((Writable)new Text("num.overdue"), (Writable)new LongWritable(this.numOverDue));
    }
}

