/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.authentication.configuration;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.core.log.LogMessage;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configuration.GlobalAuthenticationConfigurerAdapter;

@Order(value=2147478547)
class InitializeAuthenticationProviderBeanManagerConfigurer
extends GlobalAuthenticationConfigurerAdapter {
    static final int DEFAULT_ORDER = 2147478547;
    private final ApplicationContext context;

    InitializeAuthenticationProviderBeanManagerConfigurer(ApplicationContext context) {
        this.context = context;
    }

    @Override
    public void init(AuthenticationManagerBuilder auth) {
        auth.apply(new InitializeAuthenticationProviderManagerConfigurer());
    }

    class InitializeAuthenticationProviderManagerConfigurer
    extends GlobalAuthenticationConfigurerAdapter {
        private final Log logger = LogFactory.getLog(this.getClass());

        InitializeAuthenticationProviderManagerConfigurer() {
        }

        @Override
        public void configure(AuthenticationManagerBuilder auth) {
            if (auth.isConfigured()) {
                return;
            }
            Object[] beanNames = InitializeAuthenticationProviderBeanManagerConfigurer.this.context.getBeanNamesForType(AuthenticationProvider.class);
            if (beanNames.length == 0) {
                return;
            }
            if (beanNames.length > 1) {
                this.logger.info((Object)LogMessage.format((String)"Found %s AuthenticationProvider beans, with names %s. Global Authentication Manager will not be configured with AuthenticationProviders. Consider publishing a single AuthenticationProvider bean, or wiring your Providers directly using the DSL.", (Object)beanNames.length, (Object)Arrays.toString(beanNames)));
                return;
            }
            AuthenticationProvider authenticationProvider = (AuthenticationProvider)InitializeAuthenticationProviderBeanManagerConfigurer.this.context.getBean(beanNames[0], AuthenticationProvider.class);
            auth.authenticationProvider(authenticationProvider);
            this.logger.info((Object)LogMessage.format((String)"Global AuthenticationManager configured with AuthenticationProvider bean with name %s", (Object)beanNames[0]));
        }
    }
}

