/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk.filter;

import java.io.IOException;
import java.time.Instant;
import java.util.Date;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.StopWalkException;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;

public abstract class CommitTimeRevFilter
extends RevFilter {
    final int when;

    @Deprecated(since="7.2")
    public static final RevFilter before(Date ts) {
        return CommitTimeRevFilter.before(ts.toInstant());
    }

    public static RevFilter before(Instant ts) {
        return new Before(ts);
    }

    public static final RevFilter before(long ts) {
        return new Before(Instant.ofEpochMilli(ts));
    }

    @Deprecated(since="7.2")
    public static final RevFilter after(Date ts) {
        return CommitTimeRevFilter.after(ts.toInstant());
    }

    public static RevFilter after(Instant ts) {
        return new After(ts);
    }

    public static final RevFilter after(long ts) {
        return CommitTimeRevFilter.after(Instant.ofEpochMilli(ts));
    }

    @Deprecated(since="7.2")
    public static final RevFilter between(Date since, Date until) {
        return CommitTimeRevFilter.between(since.toInstant(), until.toInstant());
    }

    public static RevFilter between(Instant since, Instant until) {
        return new Between(since, until);
    }

    @Deprecated(since="7.2")
    public static final RevFilter between(long since, long until) {
        return new Between(Instant.ofEpochMilli(since), Instant.ofEpochMilli(until));
    }

    CommitTimeRevFilter(long ts) {
        this.when = (int)(ts / 1000L);
    }

    CommitTimeRevFilter(Instant t) {
        this.when = (int)t.getEpochSecond();
    }

    @Override
    public RevFilter clone() {
        return this;
    }

    @Override
    public boolean requiresCommitBody() {
        return false;
    }

    private static class After
    extends CommitTimeRevFilter {
        After(Instant t) {
            super(t);
        }

        @Override
        public boolean include(RevWalk walker, RevCommit cmit) throws StopWalkException, MissingObjectException, IncorrectObjectTypeException, IOException {
            if (cmit.getCommitTime() < this.when) {
                throw StopWalkException.INSTANCE;
            }
            return true;
        }

        @Override
        public String toString() {
            return super.toString() + "(" + String.valueOf(Instant.ofEpochSecond(this.when)) + ")";
        }
    }

    private static class Before
    extends CommitTimeRevFilter {
        Before(Instant t) {
            super(t);
        }

        @Override
        public boolean include(RevWalk walker, RevCommit cmit) throws StopWalkException, MissingObjectException, IncorrectObjectTypeException, IOException {
            return cmit.getCommitTime() <= this.when;
        }

        @Override
        public String toString() {
            return super.toString() + "(" + String.valueOf(Instant.ofEpochSecond(this.when)) + ")";
        }
    }

    private static class Between
    extends CommitTimeRevFilter {
        private final int until;

        Between(Instant since, Instant until) {
            super(since);
            this.until = (int)until.getEpochSecond();
        }

        @Override
        public boolean include(RevWalk walker, RevCommit cmit) throws StopWalkException, MissingObjectException, IncorrectObjectTypeException, IOException {
            return cmit.getCommitTime() <= this.until && cmit.getCommitTime() >= this.when;
        }

        @Override
        public String toString() {
            return super.toString() + "(" + String.valueOf(Instant.ofEpochSecond(this.when)) + " - " + String.valueOf(Instant.ofEpochSecond(this.until)) + ")";
        }
    }
}

