/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.schema.common;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.nifi.minifi.toolkit.schema.common.BaseSchema;
import org.apache.nifi.minifi.toolkit.schema.common.StringUtil;
import org.apache.nifi.minifi.toolkit.schema.common.WritableSchema;

public class BaseSchemaWithId
extends BaseSchema
implements WritableSchema {
    private final String wrapperName;
    private String id;

    public BaseSchemaWithId(Map map, String wrapperName) {
        this.id = this.getId(map, wrapperName);
        this.wrapperName = wrapperName;
    }

    protected String getId(Map map, String wrapperName) {
        return this.getOptionalKeyAsType(map, "id", String.class, wrapperName, "");
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getWrapperName() {
        return this.wrapperName.replace("{id}", StringUtil.isNullOrEmpty(this.id) ? "unknown" : this.id);
    }

    @Override
    public Map<String, Object> toMap() {
        Map map = (Map)this.mapSupplier.get();
        map.put("id", this.id);
        return map;
    }

    @Override
    public List<String> getValidationIssues() {
        List<String> validationIssues = super.getValidationIssues();
        if (StringUtil.isNullOrEmpty(this.id)) {
            validationIssues.add(BaseSchemaWithId.getIssueText("id", this.getWrapperName(), "it was not found and it is required"));
        } else if (!this.isValidId(this.id)) {
            validationIssues.add(BaseSchemaWithId.getIssueText("id", this.getWrapperName(), "Id value of " + this.id + " is not a valid UUID"));
        }
        return validationIssues;
    }

    protected boolean isValidId(String value) {
        try {
            UUID.fromString(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

