/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.functions.JsonPathBaseEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPathDeleteEvaluator
extends JsonPathBaseEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonPathDeleteEvaluator.class);

    public JsonPathDeleteEvaluator(Evaluator<String> subject, Evaluator<String> jsonPathExp) {
        super(subject, jsonPathExp);
    }

    @Override
    public QueryResult<String> evaluate(EvaluationContext context) {
        DocumentContext documentContext = this.getDocumentContext(context);
        JsonPath compiledJsonPath = this.getJsonPath(context);
        String result = null;
        try {
            result = documentContext.delete(compiledJsonPath).jsonString();
        }
        catch (PathNotFoundException pnf) {
            LOGGER.debug("JSON Path not found: {}", (Object)compiledJsonPath.getPath(), (Object)pnf);
            result = documentContext.jsonString();
        }
        catch (Exception e) {
            return EMPTY_RESULT;
        }
        return new StringQueryResult(JsonPathDeleteEvaluator.getResultRepresentation(result, EMPTY_RESULT.getValue()));
    }
}

