/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.io.http;

import java.io.IOException;
import java.io.InputStream;
import org.apache.nifi.remote.io.InterruptableInputStream;
import org.apache.nifi.remote.protocol.CommunicationsInput;
import org.apache.nifi.stream.io.ByteCountingInputStream;

public class HttpInput
implements CommunicationsInput {
    private ByteCountingInputStream countingIn;
    private InterruptableInputStream interruptableIn;

    @Override
    public InputStream getInputStream() throws IOException {
        return this.countingIn;
    }

    @Override
    public long getBytesRead() {
        if (this.countingIn != null) {
            return this.countingIn.getBytesRead();
        }
        return 0L;
    }

    @Override
    public void consume() throws IOException {
        int bytesRead;
        if (this.countingIn == null) {
            return;
        }
        byte[] b = new byte[4096];
        while ((bytesRead = this.countingIn.read(b)) > 0) {
        }
    }

    public void setInputStream(InputStream inputStream) {
        this.interruptableIn = new InterruptableInputStream(inputStream);
        this.countingIn = new ByteCountingInputStream((InputStream)this.interruptableIn);
    }

    public void interrupt() {
        if (this.interruptableIn != null) {
            this.interruptableIn.interrupt();
        }
    }
}

