/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import java.util.Collections;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.MappedJwtClaimSetConverter;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.util.Assert;
import org.springframework.web.client.RestOperations;

@Deprecated
public final class NimbusJwtDecoderJwkSupport
implements JwtDecoder {
    private NimbusJwtDecoder.JwkSetUriJwtDecoderBuilder jwtDecoderBuilder;
    private OAuth2TokenValidator<Jwt> jwtValidator = JwtValidators.createDefault();
    private Converter<Map<String, Object>, Map<String, Object>> claimSetConverter = MappedJwtClaimSetConverter.withDefaults(Collections.emptyMap());
    private NimbusJwtDecoder delegate;

    public NimbusJwtDecoderJwkSupport(String jwkSetUrl) {
        this(jwkSetUrl, "RS256");
    }

    public NimbusJwtDecoderJwkSupport(String jwkSetUrl, String jwsAlgorithm) {
        Assert.hasText((String)jwkSetUrl, (String)"jwkSetUrl cannot be empty");
        Assert.hasText((String)jwsAlgorithm, (String)"jwsAlgorithm cannot be empty");
        this.jwtDecoderBuilder = NimbusJwtDecoder.withJwkSetUri(jwkSetUrl).jwsAlgorithm(SignatureAlgorithm.from(jwsAlgorithm));
        this.delegate = this.makeDelegate();
    }

    private NimbusJwtDecoder makeDelegate() {
        NimbusJwtDecoder delegate = this.jwtDecoderBuilder.build();
        delegate.setClaimSetConverter(this.claimSetConverter);
        delegate.setJwtValidator(this.jwtValidator);
        return delegate;
    }

    @Override
    public Jwt decode(String token) throws JwtException {
        return this.delegate.decode(token);
    }

    public void setJwtValidator(OAuth2TokenValidator<Jwt> jwtValidator) {
        Assert.notNull(jwtValidator, (String)"jwtValidator cannot be null");
        this.jwtValidator = jwtValidator;
        this.delegate.setJwtValidator(jwtValidator);
    }

    public void setClaimSetConverter(Converter<Map<String, Object>, Map<String, Object>> claimSetConverter) {
        Assert.notNull(claimSetConverter, (String)"claimSetConverter cannot be null");
        this.claimSetConverter = claimSetConverter;
        this.delegate.setClaimSetConverter(claimSetConverter);
    }

    public void setRestOperations(RestOperations restOperations) {
        Assert.notNull((Object)restOperations, (String)"restOperations cannot be null");
        this.jwtDecoderBuilder = this.jwtDecoderBuilder.restOperations(restOperations);
        this.delegate = this.makeDelegate();
    }
}

