/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.client;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.client.AccessClient;
import org.apache.nifi.registry.client.BucketClient;
import org.apache.nifi.registry.client.BundleClient;
import org.apache.nifi.registry.client.BundleVersionClient;
import org.apache.nifi.registry.client.ExtensionClient;
import org.apache.nifi.registry.client.ExtensionRepoClient;
import org.apache.nifi.registry.client.FlowClient;
import org.apache.nifi.registry.client.FlowSnapshotClient;
import org.apache.nifi.registry.client.ItemsClient;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryClientConfig;
import org.apache.nifi.registry.client.PoliciesClient;
import org.apache.nifi.registry.client.RequestConfig;
import org.apache.nifi.registry.client.TenantsClient;
import org.apache.nifi.registry.client.UserClient;
import org.apache.nifi.registry.client.impl.JerseyNiFiRegistryClient;
import org.apache.nifi.registry.client.impl.request.BasicAuthRequestConfig;
import org.apache.nifi.registry.client.impl.request.BearerTokenRequestConfig;
import org.apache.nifi.registry.client.impl.request.ProxiedEntityRequestConfig;
import org.apache.nifi.registry.security.util.KeystoreType;
import org.apache.nifi.toolkit.cli.api.ClientFactory;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;

public class NiFiRegistryClientFactory
implements ClientFactory<NiFiRegistryClient> {
    @Override
    public NiFiRegistryClient createClient(Properties properties) throws MissingOptionException {
        Integer timeout;
        String url = properties.getProperty(CommandOption.URL.getLongName());
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new MissingOptionException("Missing required option '" + CommandOption.URL.getLongName() + "'");
        }
        String connectionTimeout = properties.getProperty(CommandOption.CONNECTION_TIMEOUT.getLongName());
        String readTimeout = properties.getProperty(CommandOption.READ_TIMEOUT.getLongName());
        String keystore = properties.getProperty(CommandOption.KEYSTORE.getLongName());
        String keystoreType = properties.getProperty(CommandOption.KEYSTORE_TYPE.getLongName());
        String keystorePasswd = properties.getProperty(CommandOption.KEYSTORE_PASSWORD.getLongName());
        String keyPasswd = properties.getProperty(CommandOption.KEY_PASSWORD.getLongName());
        String truststore = properties.getProperty(CommandOption.TRUSTSTORE.getLongName());
        String truststoreType = properties.getProperty(CommandOption.TRUSTSTORE_TYPE.getLongName());
        String truststorePasswd = properties.getProperty(CommandOption.TRUSTSTORE_PASSWORD.getLongName());
        String proxiedEntity = properties.getProperty(CommandOption.PROXIED_ENTITY.getLongName());
        String protocol = properties.getProperty(CommandOption.PROTOCOL.getLongName());
        String basicAuthUsername = properties.getProperty(CommandOption.BASIC_AUTH_USER.getLongName());
        String basicAuthPassword = properties.getProperty(CommandOption.BASIC_AUTH_PASSWORD.getLongName());
        String bearerToken = properties.getProperty(CommandOption.BEARER_TOKEN.getLongName());
        boolean secureUrl = url.startsWith("https");
        if (secureUrl && (StringUtils.isBlank((CharSequence)truststore) || StringUtils.isBlank((CharSequence)truststoreType) || StringUtils.isBlank((CharSequence)truststorePasswd))) {
            throw new MissingOptionException(CommandOption.TRUSTSTORE.getLongName() + ", " + CommandOption.TRUSTSTORE_TYPE.getLongName() + ", and " + CommandOption.TRUSTSTORE_PASSWORD.getLongName() + " are required when using an https url");
        }
        if (!(StringUtils.isBlank((CharSequence)proxiedEntity) || StringUtils.isBlank((CharSequence)basicAuthUsername) && StringUtils.isBlank((CharSequence)basicAuthPassword))) {
            throw new IllegalStateException(CommandOption.PROXIED_ENTITY.getLongName() + " and basic authentication can not be used together");
        }
        if (!StringUtils.isBlank((CharSequence)proxiedEntity) && !StringUtils.isBlank((CharSequence)bearerToken)) {
            throw new IllegalStateException(CommandOption.PROXIED_ENTITY.getLongName() + " and " + CommandOption.BEARER_TOKEN.getLongName() + " can not be used together");
        }
        if (!(StringUtils.isBlank((CharSequence)bearerToken) || StringUtils.isBlank((CharSequence)basicAuthUsername) && StringUtils.isBlank((CharSequence)basicAuthPassword))) {
            throw new IllegalStateException(CommandOption.BEARER_TOKEN.getLongName() + " and basic authentication can not be used together");
        }
        if (!StringUtils.isBlank((CharSequence)basicAuthUsername) && StringUtils.isBlank((CharSequence)basicAuthPassword)) {
            throw new MissingOptionException(CommandOption.BASIC_AUTH_PASSWORD.getLongName() + " is required when specifying " + CommandOption.BASIC_AUTH_USER.getLongName());
        }
        if (!StringUtils.isBlank((CharSequence)basicAuthPassword) && StringUtils.isBlank((CharSequence)basicAuthUsername)) {
            throw new MissingOptionException(CommandOption.BASIC_AUTH_USER.getLongName() + " is required when specifying " + CommandOption.BASIC_AUTH_PASSWORD.getLongName());
        }
        NiFiRegistryClientConfig.Builder clientConfigBuilder = new NiFiRegistryClientConfig.Builder().baseUrl(url);
        if (secureUrl) {
            if (!StringUtils.isBlank((CharSequence)keystore)) {
                clientConfigBuilder.keystoreFilename(keystore);
            }
            if (!StringUtils.isBlank((CharSequence)keystoreType)) {
                clientConfigBuilder.keystoreType(KeystoreType.valueOf((String)keystoreType.toUpperCase()));
            }
            if (!StringUtils.isBlank((CharSequence)keystorePasswd)) {
                clientConfigBuilder.keystorePassword(keystorePasswd);
            }
            if (!StringUtils.isBlank((CharSequence)keyPasswd)) {
                clientConfigBuilder.keyPassword(keyPasswd);
            }
            if (!StringUtils.isBlank((CharSequence)truststore)) {
                clientConfigBuilder.truststoreFilename(truststore);
            }
            if (!StringUtils.isBlank((CharSequence)truststoreType)) {
                clientConfigBuilder.truststoreType(KeystoreType.valueOf((String)truststoreType.toUpperCase()));
            }
            if (!StringUtils.isBlank((CharSequence)truststorePasswd)) {
                clientConfigBuilder.truststorePassword(truststorePasswd);
            }
            if (!StringUtils.isBlank((CharSequence)protocol)) {
                clientConfigBuilder.protocol(protocol);
            }
        }
        if (!StringUtils.isBlank((CharSequence)connectionTimeout)) {
            try {
                timeout = Integer.valueOf(connectionTimeout);
                clientConfigBuilder.connectTimeout(timeout);
            }
            catch (Exception e) {
                throw new MissingOptionException("connectionTimeout has to be an integer");
            }
        }
        if (!StringUtils.isBlank((CharSequence)readTimeout)) {
            try {
                timeout = Integer.valueOf(readTimeout);
                clientConfigBuilder.readTimeout(timeout);
            }
            catch (Exception e) {
                throw new MissingOptionException("readTimeout has to be an integer");
            }
        }
        NiFiRegistryClientConfig clientConfig = clientConfigBuilder.build();
        NiFiRegistryClient client = new JerseyNiFiRegistryClient.Builder().config(clientConfig).build();
        if (!StringUtils.isBlank((CharSequence)proxiedEntity)) {
            ProxiedEntityRequestConfig proxiedEntityConfig = new ProxiedEntityRequestConfig(new String[]{proxiedEntity});
            return new NiFiRegistryClientWithRequestConfig(client, (RequestConfig)proxiedEntityConfig);
        }
        if (!StringUtils.isBlank((CharSequence)bearerToken)) {
            BearerTokenRequestConfig bearerTokenConfig = new BearerTokenRequestConfig(bearerToken);
            return new NiFiRegistryClientWithRequestConfig(client, (RequestConfig)bearerTokenConfig);
        }
        if (!StringUtils.isBlank((CharSequence)basicAuthUsername) && !StringUtils.isBlank((CharSequence)basicAuthPassword)) {
            BasicAuthRequestConfig basicAuthConfig = new BasicAuthRequestConfig(basicAuthUsername, basicAuthPassword);
            return new NiFiRegistryClientWithRequestConfig(client, (RequestConfig)basicAuthConfig);
        }
        return client;
    }

    private static class NiFiRegistryClientWithRequestConfig
    implements NiFiRegistryClient {
        private final NiFiRegistryClient client;
        private final RequestConfig requestConfig;

        public NiFiRegistryClientWithRequestConfig(NiFiRegistryClient client, RequestConfig requestConfig) {
            this.client = client;
            this.requestConfig = requestConfig;
        }

        public BucketClient getBucketClient() {
            return this.client.getBucketClient(this.requestConfig);
        }

        public BucketClient getBucketClient(String ... proxiedEntities) {
            ProxiedEntityRequestConfig requestConfig = new ProxiedEntityRequestConfig(proxiedEntities);
            return this.client.getBucketClient((RequestConfig)requestConfig);
        }

        public BucketClient getBucketClient(RequestConfig requestConfig) {
            return this.client.getBucketClient(requestConfig);
        }

        public FlowClient getFlowClient() {
            return this.client.getFlowClient(this.requestConfig);
        }

        public FlowClient getFlowClient(String ... proxiedEntities) {
            ProxiedEntityRequestConfig requestConfig = new ProxiedEntityRequestConfig(proxiedEntities);
            return this.client.getFlowClient((RequestConfig)requestConfig);
        }

        public FlowClient getFlowClient(RequestConfig requestConfig) {
            return this.client.getFlowClient(requestConfig);
        }

        public FlowSnapshotClient getFlowSnapshotClient() {
            return this.client.getFlowSnapshotClient(this.requestConfig);
        }

        public FlowSnapshotClient getFlowSnapshotClient(String ... proxiedEntities) {
            ProxiedEntityRequestConfig requestConfig = new ProxiedEntityRequestConfig(proxiedEntities);
            return this.client.getFlowSnapshotClient((RequestConfig)requestConfig);
        }

        public FlowSnapshotClient getFlowSnapshotClient(RequestConfig requestConfig) {
            return this.client.getFlowSnapshotClient(requestConfig);
        }

        public ItemsClient getItemsClient() {
            return this.client.getItemsClient(this.requestConfig);
        }

        public ItemsClient getItemsClient(String ... proxiedEntities) {
            ProxiedEntityRequestConfig requestConfig = new ProxiedEntityRequestConfig(proxiedEntities);
            return this.client.getItemsClient((RequestConfig)requestConfig);
        }

        public ItemsClient getItemsClient(RequestConfig requestConfig) {
            return this.client.getItemsClient(requestConfig);
        }

        public UserClient getUserClient() {
            return this.client.getUserClient(this.requestConfig);
        }

        public UserClient getUserClient(String ... proxiedEntities) {
            ProxiedEntityRequestConfig requestConfig = new ProxiedEntityRequestConfig(proxiedEntities);
            return this.client.getUserClient((RequestConfig)requestConfig);
        }

        public UserClient getUserClient(RequestConfig requestConfig) {
            return this.client.getUserClient(requestConfig);
        }

        public BundleClient getBundleClient() {
            return this.client.getBundleClient(this.requestConfig);
        }

        public BundleClient getBundleClient(String ... proxiedEntities) {
            ProxiedEntityRequestConfig requestConfig = new ProxiedEntityRequestConfig(proxiedEntities);
            return this.client.getBundleClient((RequestConfig)requestConfig);
        }

        public BundleClient getBundleClient(RequestConfig requestConfig) {
            return this.client.getBundleClient(requestConfig);
        }

        public BundleVersionClient getBundleVersionClient() {
            return this.client.getBundleVersionClient(this.requestConfig);
        }

        public BundleVersionClient getBundleVersionClient(String ... proxiedEntities) {
            ProxiedEntityRequestConfig requestConfig = new ProxiedEntityRequestConfig(proxiedEntities);
            return this.client.getBundleVersionClient((RequestConfig)requestConfig);
        }

        public BundleVersionClient getBundleVersionClient(RequestConfig requestConfig) {
            return this.client.getBundleVersionClient(requestConfig);
        }

        public ExtensionRepoClient getExtensionRepoClient() {
            return this.client.getExtensionRepoClient(this.requestConfig);
        }

        public ExtensionRepoClient getExtensionRepoClient(String ... proxiedEntities) {
            ProxiedEntityRequestConfig requestConfig = new ProxiedEntityRequestConfig(proxiedEntities);
            return this.client.getExtensionRepoClient((RequestConfig)requestConfig);
        }

        public ExtensionRepoClient getExtensionRepoClient(RequestConfig requestConfig) {
            return this.client.getExtensionRepoClient(requestConfig);
        }

        public ExtensionClient getExtensionClient() {
            return this.client.getExtensionClient(this.requestConfig);
        }

        public ExtensionClient getExtensionClient(String ... proxiedEntities) {
            ProxiedEntityRequestConfig requestConfig = new ProxiedEntityRequestConfig(proxiedEntities);
            return this.client.getExtensionClient((RequestConfig)requestConfig);
        }

        public ExtensionClient getExtensionClient(RequestConfig requestConfig) {
            return this.client.getExtensionClient(requestConfig);
        }

        public TenantsClient getTenantsClient() {
            return this.client.getTenantsClient(this.requestConfig);
        }

        public TenantsClient getTenantsClient(String ... proxiedEntities) {
            ProxiedEntityRequestConfig requestConfig = new ProxiedEntityRequestConfig(proxiedEntities);
            return this.client.getTenantsClient((RequestConfig)requestConfig);
        }

        public TenantsClient getTenantsClient(RequestConfig requestConfig) {
            return this.client.getTenantsClient(requestConfig);
        }

        public PoliciesClient getPoliciesClient() {
            return this.client.getPoliciesClient(this.requestConfig);
        }

        public PoliciesClient getPoliciesClient(String ... proxiedEntities) {
            ProxiedEntityRequestConfig requestConfig = new ProxiedEntityRequestConfig(proxiedEntities);
            return this.client.getPoliciesClient((RequestConfig)requestConfig);
        }

        public PoliciesClient getPoliciesClient(RequestConfig requestConfig) {
            return this.client.getPoliciesClient(requestConfig);
        }

        public AccessClient getAccessClient() {
            return this.client.getAccessClient();
        }

        public void close() throws IOException {
            this.client.close();
        }
    }
}

