/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class TableListRecordCursorFactory
extends AbstractRecordCursorFactory {
    public static final String TABLE_NAME_COLUMN = "table";
    private static final RecordMetadata METADATA;
    private final TableListRecordCursor cursor = new TableListRecordCursor();

    public TableListRecordCursorFactory() {
        super(METADATA);
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        return this.cursor.of(executionContext.getCairoEngine());
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("all_tables");
    }

    @Override
    protected void _close() {
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata(TABLE_NAME_COLUMN, 11));
        METADATA = metadata;
    }

    private static class TableListRecordCursor
    implements RecordCursor {
        private final TableListRecord record = new TableListRecord();
        private final ObjList<TableToken> tableBucket = new ObjList();
        private CairoEngine engine;
        private int tableIndex = -1;
        private String tableName = null;

        private TableListRecordCursor() {
        }

        @Override
        public void close() {
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public Record getRecordB() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            if (this.tableIndex < 0) {
                this.engine.getTableTokens(this.tableBucket, false);
                this.tableIndex = 0;
            }
            if (this.tableIndex == this.tableBucket.size()) {
                return false;
            }
            this.tableName = this.tableBucket.get(this.tableIndex++).getTableName();
            return true;
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long size() {
            return -1L;
        }

        @Override
        public void toTop() {
            this.tableIndex = -1;
        }

        private TableListRecordCursor of(@NotNull CairoEngine cairoEngine) {
            this.engine = cairoEngine;
            this.toTop();
            return this;
        }

        public class TableListRecord
        implements Record {
            @Override
            public CharSequence getStr(int col) {
                if (col == 0) {
                    return TableListRecordCursor.this.tableName;
                }
                return null;
            }

            @Override
            public CharSequence getStrB(int col) {
                return this.getStr(col);
            }

            @Override
            public int getStrLen(int col) {
                return this.getStr(col).length();
            }
        }
    }
}

