/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.GeoHashes;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.ExpressionParser;
import io.questdb.griffin.FunctionParser;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.engine.functions.AbstractGeoHashFunction;
import io.questdb.griffin.model.AliasTranslator;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.IntervalUtils;
import io.questdb.griffin.model.IntrinsicModel;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.str.FlyweightCharSequence;
import java.util.ArrayDeque;

final class WhereClauseParser
implements Mutable {
    private static final int INTRINSIC_OP_BETWEEN = 9;
    private static final int INTRINSIC_OP_EQUAL = 6;
    private static final int INTRINSIC_OP_GREATER = 2;
    private static final int INTRINSIC_OP_GREATER_EQ = 3;
    private static final int INTRINSIC_OP_IN = 1;
    private static final int INTRINSIC_OP_LESS = 4;
    private static final int INTRINSIC_OP_LESS_EQ = 5;
    private static final int INTRINSIC_OP_NOT = 8;
    private static final int INTRINSIC_OP_NOT_EQ = 7;
    private static final CharSequenceIntHashMap intrinsicOps = new CharSequenceIntHashMap();
    private final ObjectPool<FlyweightCharSequence> csPool = new ObjectPool<FlyweightCharSequence>(FlyweightCharSequence.FACTORY, 64);
    private final ObjList<ExpressionNode> keyExclNodes = new ObjList();
    private final ObjList<ExpressionNode> keyNodes = new ObjList();
    private final ObjectPool<IntrinsicModel> models = new ObjectPool<IntrinsicModel>(IntrinsicModel.FACTORY, 8);
    private final ArrayDeque<ExpressionNode> stack = new ArrayDeque();
    private final CharSequenceHashSet tempK = new CharSequenceHashSet();
    private final IntList tempKeyExcludedValuePos = new IntList();
    private final IntList tempKeyExcludedValueType = new IntList();
    private final CharSequenceHashSet tempKeyExcludedValues = new CharSequenceHashSet();
    private final IntList tempKeyValuePos = new IntList();
    private final IntList tempKeyValueType = new IntList();
    private final CharSequenceHashSet tempKeyValues = new CharSequenceHashSet();
    private final CharSequenceHashSet tempKeys = new CharSequenceHashSet();
    private final ObjList<ExpressionNode> tempNodes = new ObjList();
    private final IntList tempP = new IntList();
    private final IntList tempPos = new IntList();
    private final IntList tempT = new IntList();
    private final IntList tempType = new IntList();
    private boolean allKeyExcludedValuesAreKnown = true;
    private boolean allKeyValuesAreKnown = true;
    private boolean isConstFunction;
    private CharSequence preferredKeyColumn;
    private CharSequence timestamp;

    WhereClauseParser() {
    }

    @Override
    public void clear() {
        this.models.clear();
        this.stack.clear();
        this.keyNodes.clear();
        this.keyExclNodes.clear();
        this.tempNodes.clear();
        this.tempKeys.clear();
        this.tempPos.clear();
        this.tempType.clear();
        this.tempK.clear();
        this.tempP.clear();
        this.tempT.clear();
        this.clearKeys();
        this.clearExcludedKeys();
        this.csPool.clear();
        this.timestamp = null;
        this.preferredKeyColumn = null;
        this.allKeyValuesAreKnown = true;
        this.allKeyExcludedValuesAreKnown = true;
    }

    private static short adjustComparison(boolean equalsTo, boolean isLo) {
        return (short)(equalsTo ? 0 : (isLo ? 1 : -1));
    }

    private static boolean canCastToTimestamp(int type) {
        short typeTag = ColumnType.tagOf(type);
        return typeTag == 8 || typeTag == 7 || typeTag == 11 || typeTag == 12 || typeTag == 6;
    }

    private static void checkNodeValid(ExpressionNode node) throws SqlException {
        if (node.lhs == null || node.rhs == null) {
            throw SqlException.$(node.position, "Argument expected");
        }
    }

    private static long getTimestampFromConstFunction(Function function, int functionPosition) throws SqlException {
        if (!ColumnType.isSymbolOrString(function.getType())) {
            return function.getTimestamp(null);
        }
        CharSequence str = function.getStr(null);
        return WhereClauseParser.parseStringAsTimestamp(str, functionPosition);
    }

    private static boolean isFunc(ExpressionNode n) {
        return n.type == 8 || n.type == 6 || n.type == 1;
    }

    private static boolean isMoreSelective(IntrinsicModel model, RecordMetadata meta, TableReader reader, int idx) {
        int keyCount;
        SymbolMapReader colReader = reader.getSymbolMapReader(idx);
        SymbolMapReader keyReader = reader.getSymbolMapReader(meta.getColumnIndex(model.keyColumn));
        int colCount = colReader.getSymbolCount();
        return colCount > (keyCount = keyReader.getSymbolCount()) || colCount == keyCount && colReader.getSymbolCapacity() > keyReader.getSymbolCapacity();
    }

    private static boolean isTypeMismatch(int typeA, int typeB) {
        return typeA == 6 != (typeB == 6);
    }

    private static boolean nodesEqual(ExpressionNode left, ExpressionNode right) {
        return !(left.type != 4 && left.type != 2 || right.type != 4 && right.type != 2 || !Chars.equals(left.token, right.token));
    }

    private static long parseStringAsTimestamp(CharSequence str, int position) throws SqlException {
        try {
            return IntervalUtils.parseFloorPartialTimestamp(str);
        }
        catch (NumericException ignore) {
            throw SqlException.invalidDate(position);
        }
    }

    private static long parseTokenAsTimestamp(ExpressionNode lo) throws SqlException {
        try {
            if (!SqlKeywords.isNullKeyword(lo.token)) {
                return IntervalUtils.parseFloorPartialTimestamp(lo.token, 1, lo.token.length() - 1);
            }
            return Long.MIN_VALUE;
        }
        catch (NumericException e1) {
            try {
                return Numbers.parseLong(lo.token);
            }
            catch (NumericException ignore) {
                throw SqlException.invalidDate(lo.position);
            }
        }
    }

    private static void revertNodes(ObjList<ExpressionNode> nodes) {
        int k = nodes.size();
        for (int n = 0; n < k; ++n) {
            nodes.getQuick((int)n).intrinsicValue = 0;
        }
        nodes.clear();
    }

    private void addExcludedValue(ExpressionNode parentNode, ExpressionNode valueNode, CharSequence value) {
        if (this.tempKeyExcludedValues.add(value)) {
            this.tempKeyExcludedValuePos.add(valueNode.position);
            this.tempKeyExcludedValueType.add(valueNode.type);
            this.allKeyExcludedValuesAreKnown &= valueNode.type != 6;
        }
        parentNode.intrinsicValue = 1;
        this.keyExclNodes.add(parentNode);
    }

    private void addValue(ExpressionNode parentNode, ExpressionNode valueNode, CharSequence value) {
        if (this.tempKeyValues.add(value)) {
            this.tempKeyValuePos.add(valueNode.position);
            this.tempKeyValueType.add(valueNode.type);
            this.allKeyValuesAreKnown &= valueNode.type != 6;
        }
        parentNode.intrinsicValue = 1;
        this.keyNodes.add(parentNode);
    }

    private boolean analyzeBetween(AliasTranslator translator, IntrinsicModel model, ExpressionNode node, RecordMetadata m, FunctionParser functionParser, RecordMetadata metadata, SqlExecutionContext executionContext) throws SqlException {
        ExpressionNode col = node.args.getLast();
        if (col.type != 4) {
            return false;
        }
        CharSequence column = translator.translateAlias(col.token);
        if (m.getColumnIndexQuiet(column) == -1) {
            throw SqlException.invalidColumn(col.position, col.token);
        }
        return this.analyzeBetween0(model, col, node, false, functionParser, metadata, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean analyzeBetween0(IntrinsicModel model, ExpressionNode col, ExpressionNode between, boolean isNegated, FunctionParser functionParser, RecordMetadata metadata, SqlExecutionContext executionContext) throws SqlException {
        if (!this.isTimestamp(col)) {
            return false;
        }
        ExpressionNode lo = between.args.getQuick(1);
        ExpressionNode hi = between.args.getQuick(0);
        try {
            model.setBetweenNegated(isNegated);
            boolean isBetweenTranslated = this.translateBetweenToTimestampModel(model, functionParser, metadata, executionContext, lo);
            if (isBetweenTranslated) {
                isBetweenTranslated = this.translateBetweenToTimestampModel(model, functionParser, metadata, executionContext, hi);
            }
            if (isBetweenTranslated) {
                between.intrinsicValue = 1;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            model.clearBetweenTempParsing();
        }
        return false;
    }

    private boolean analyzeEquals(AliasTranslator translator, IntrinsicModel model, ExpressionNode node, RecordMetadata m, FunctionParser functionParser, SqlExecutionContext executionContext, boolean latestByMultiColumn, TableReader reader) throws SqlException {
        WhereClauseParser.checkNodeValid(node);
        return this.analyzeEquals0(translator, model, node, node.lhs, node.rhs, m, functionParser, executionContext, latestByMultiColumn, reader) || this.analyzeEquals0(translator, model, node, node.rhs, node.lhs, m, functionParser, executionContext, latestByMultiColumn, reader);
    }

    private boolean analyzeEquals0(AliasTranslator translator, IntrinsicModel model, ExpressionNode node, ExpressionNode a, ExpressionNode b, RecordMetadata m, FunctionParser functionParser, SqlExecutionContext executionContext, boolean latestByMultiColumn, TableReader reader) throws SqlException {
        if (WhereClauseParser.nodesEqual(a, b)) {
            node.intrinsicValue = 1;
            return true;
        }
        if (a.type == 4 && (b.type == 2 || WhereClauseParser.isFunc(b))) {
            if (this.isTimestamp(a)) {
                if (b.type == 2) {
                    if (SqlKeywords.isNullKeyword(b.token)) {
                        node.intrinsicValue = 2;
                        return false;
                    }
                    model.intersectTimestamp(b.token, 1, b.token.length() - 1, b.position);
                    node.intrinsicValue = 1;
                    return true;
                }
                Function function = functionParser.parseFunction(b, m, executionContext);
                this.checkFunctionCanBeTimestamp(m, executionContext, function, b.position);
                return this.analyzeTimestampEqualsFunction(model, node, function, b.position);
            }
            CharSequence columnName = translator.translateAlias(a.token);
            int index = m.getColumnIndexQuiet(columnName);
            if (index == -1) {
                throw SqlException.invalidColumn(a.position, a.token);
            }
            switch (ColumnType.tagOf(m.getColumnType(index))) {
                case 5: 
                case 6: 
                case 11: 
                case 12: {
                    CharSequence value;
                    if (!this.columnIsPreferredOrIndexedAndNotPartOfMultiColumnLatestBy(columnName, m, latestByMultiColumn)) break;
                    CharSequence charSequence = value = SqlKeywords.isNullKeyword(b.token) ? null : this.unquote(b.token);
                    if (Chars.equalsIgnoreCaseNc(columnName, model.keyColumn)) {
                        int idx;
                        if (!this.isCorrectType(b.type)) {
                            node.intrinsicValue = 2;
                            return false;
                        }
                        if (!this.allKeyValuesAreKnown || b.type == 6 && this.tempKeyValues.size() > 0) {
                            node.intrinsicValue = 2;
                            return false;
                        }
                        if (b.type == 8) {
                            CharSequence testValue = this.getStrFromFunction(functionParser, b, m, executionContext);
                            if (!this.isConstFunction) {
                                node.intrinsicValue = 2;
                                return false;
                            }
                            value = testValue;
                        }
                        if (this.tempKeyValues.contains(value)) {
                            if (this.tempKeyValues.size() > 1) {
                                this.clearKeys();
                                this.addValue(node, b, value);
                            }
                        } else if (this.tempKeyValues.size() > 0) {
                            this.clearKeys();
                            node.intrinsicValue = 1;
                            model.intrinsicValue = 2;
                            return false;
                        }
                        if (this.tempKeyExcludedValues.contains(value) && value != null && !WhereClauseParser.isTypeMismatch(this.tempKeyExcludedValueType.get(idx = this.tempKeyExcludedValues.getListIndexOf(value)), b.type)) {
                            this.clearExcludedKeys();
                            node.intrinsicValue = 1;
                            model.intrinsicValue = 2;
                            return false;
                        }
                        this.addValue(node, b, value);
                        return true;
                    }
                    if (model.keyColumn == null || WhereClauseParser.isMoreSelective(model, m, reader, index)) {
                        if (!this.isCorrectType(b.type)) {
                            b.intrinsicValue = 2;
                            return false;
                        }
                        if (b.type == 8) {
                            CharSequence testValue = this.getStrFromFunction(functionParser, b, m, executionContext);
                            if (!this.isConstFunction) {
                                node.intrinsicValue = 2;
                                return false;
                            }
                            value = testValue;
                        }
                        model.keyColumn = columnName;
                        this.clearKeys();
                        this.clearExcludedKeys();
                        this.resetNodes();
                        this.addValue(node, b, value);
                        return true;
                    }
                    this.keyNodes.add(node);
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean analyzeGreater(IntrinsicModel model, ExpressionNode node, boolean equalsTo, FunctionParser functionParser, RecordMetadata metadata, SqlExecutionContext executionContext) throws SqlException {
        WhereClauseParser.checkNodeValid(node);
        if (WhereClauseParser.nodesEqual(node.lhs, node.rhs)) {
            model.intrinsicValue = equalsTo ? 1 : 2;
            return false;
        }
        if (this.timestamp == null) {
            return false;
        }
        if (node.lhs.type == 4 && Chars.equalsIgnoreCase(node.lhs.token, this.timestamp)) {
            return this.analyzeTimestampGreater(model, node, equalsTo, functionParser, metadata, executionContext, node.rhs);
        }
        if (node.rhs.type == 4 && Chars.equalsIgnoreCase(node.rhs.token, this.timestamp)) {
            return this.analyzeTimestampLess(model, node, equalsTo, functionParser, metadata, executionContext, node.lhs);
        }
        return false;
    }

    private boolean analyzeIn(AliasTranslator translator, IntrinsicModel model, ExpressionNode node, RecordMetadata metadata, FunctionParser functionParser, SqlExecutionContext executionContext, boolean latestByMultiColumn, TableReader reader) throws SqlException {
        ExpressionNode col;
        if (node.paramCount < 2) {
            throw SqlException.$(node.position, "Too few arguments for 'in'");
        }
        ExpressionNode expressionNode = col = node.paramCount < 3 ? node.lhs : node.args.getLast();
        if (col.type != 4) {
            return false;
        }
        CharSequence column = translator.translateAlias(col.token);
        if (metadata.getColumnIndexQuiet(column) == -1) {
            throw SqlException.invalidColumn(col.position, col.token);
        }
        return this.analyzeInInterval(model, col, node, false, functionParser, metadata, executionContext) || this.analyzeListOfValues(model, column, metadata, node, latestByMultiColumn, reader, functionParser, executionContext) || this.analyzeInLambda(model, column, metadata, node, latestByMultiColumn, reader);
    }

    private boolean analyzeInInterval(IntrinsicModel model, ExpressionNode col, ExpressionNode in, boolean isNegated, FunctionParser functionParser, RecordMetadata metadata, SqlExecutionContext executionContext) throws SqlException {
        if (!this.isTimestamp(col)) {
            return false;
        }
        if (in.paramCount == 2) {
            ExpressionNode inArg = in.rhs;
            if (inArg.type == 2) {
                if (SqlKeywords.isNullKeyword(inArg.token)) {
                    if (!isNegated) {
                        model.intersectIntervals(Long.MIN_VALUE, Long.MIN_VALUE);
                    } else {
                        model.subtractIntervals(Long.MIN_VALUE, Long.MIN_VALUE);
                    }
                } else if (!isNegated) {
                    model.intersectIntervals(inArg.token, 1, inArg.token.length() - 1, inArg.position);
                } else {
                    model.subtractIntervals(inArg.token, 1, inArg.token.length() - 1, inArg.position);
                }
                in.intrinsicValue = 1;
                return true;
            }
            if (WhereClauseParser.isFunc(inArg)) {
                Function f1 = functionParser.parseFunction(inArg, metadata, executionContext);
                if (this.checkFunctionCanBeTimestampInterval(executionContext, f1)) {
                    if (f1.isConstant()) {
                        CharSequence funcVal = f1.getStr(null);
                        if (!isNegated) {
                            model.intersectIntervals(funcVal, 0, funcVal.length(), inArg.position);
                        } else {
                            model.subtractIntervals(funcVal, 0, funcVal.length(), inArg.position);
                        }
                    } else if (f1.isRuntimeConstant()) {
                        if (!isNegated) {
                            model.intersectRuntimeIntervals(f1);
                        } else {
                            model.subtractRuntimeIntervals(f1);
                        }
                    } else {
                        return false;
                    }
                    in.intrinsicValue = 1;
                    return true;
                }
                this.checkFunctionCanBeTimestamp(metadata, executionContext, f1, inArg.position);
                return this.analyzeTimestampEqualsFunction(model, in, f1, inArg.position);
            }
        } else if (!model.hasIntervalFilters() || isNegated) {
            ExpressionNode inListItem;
            int i;
            int n = in.args.size() - 1;
            for (i = 0; i < n; ++i) {
                inListItem = in.args.getQuick(i);
                if (inListItem.type == 2) continue;
                return false;
            }
            for (i = 0; i < n; ++i) {
                inListItem = in.args.getQuick(i);
                long ts = WhereClauseParser.parseTokenAsTimestamp(inListItem);
                if (!isNegated) {
                    if (i == 0) {
                        model.intersectIntervals(ts, ts);
                        continue;
                    }
                    model.unionIntervals(ts, ts);
                    continue;
                }
                model.subtractIntervals(ts, ts);
            }
            in.intrinsicValue = 1;
            return true;
        }
        return false;
    }

    private boolean analyzeInLambda(IntrinsicModel model, CharSequence columnName, RecordMetadata m, ExpressionNode node, boolean latestByMultiColumn, TableReader reader) throws SqlException {
        int columnIndex = m.getColumnIndex(columnName);
        if (this.columnIsPreferredOrIndexedAndNotPartOfMultiColumnLatestBy(columnName, m, latestByMultiColumn)) {
            if (this.preferredKeyColumn != null && !Chars.equalsIgnoreCase(columnName, this.preferredKeyColumn)) {
                return false;
            }
            if (node.rhs == null || node.rhs.type != 65) {
                return false;
            }
            if (model.keyColumn != null && !Chars.equalsIgnoreCase(model.keyColumn, columnName) && !WhereClauseParser.isMoreSelective(model, m, reader, columnIndex)) {
                return false;
            }
            if (Chars.equalsIgnoreCaseNc(columnName, model.keyColumn) && model.keySubQuery != null || node.paramCount > 2) {
                throw SqlException.$(node.position, "Multiple lambda expressions not supported");
            }
            this.clearKeys();
            this.tempKeyValuePos.add(node.position);
            this.tempKeyValueType.add(node.type);
            model.keySubQuery = node.rhs.queryModel;
            WhereClauseParser.revertNodes(this.keyNodes);
            model.keyColumn = columnName;
            this.keyNodes.add(node);
            node.intrinsicValue = 1;
            return true;
        }
        return false;
    }

    private boolean analyzeLess(IntrinsicModel model, ExpressionNode node, boolean equalsTo, FunctionParser functionParser, RecordMetadata metadata, SqlExecutionContext executionContext) throws SqlException {
        WhereClauseParser.checkNodeValid(node);
        if (WhereClauseParser.nodesEqual(node.lhs, node.rhs)) {
            model.intrinsicValue = equalsTo ? 1 : 2;
            return false;
        }
        if (this.timestamp == null) {
            return false;
        }
        if (node.lhs.type == 4 && Chars.equalsIgnoreCase(node.lhs.token, this.timestamp)) {
            return this.analyzeTimestampLess(model, node, equalsTo, functionParser, metadata, executionContext, node.rhs);
        }
        if (node.rhs.type == 4 && Chars.equalsIgnoreCase(node.rhs.token, this.timestamp)) {
            return this.analyzeTimestampGreater(model, node, equalsTo, functionParser, metadata, executionContext, node.lhs);
        }
        return false;
    }

    private boolean analyzeListOfValues(IntrinsicModel model, CharSequence columnName, RecordMetadata meta, ExpressionNode node, boolean latestByMultiColumn, TableReader reader, FunctionParser functionParser, SqlExecutionContext executionContext) throws SqlException {
        int columnIndex = meta.getColumnIndex(columnName);
        boolean newColumn = true;
        if (this.columnIsPreferredOrIndexedAndNotPartOfMultiColumnLatestBy(columnName, meta, latestByMultiColumn)) {
            if (model.keyColumn != null && (newColumn = !Chars.equalsIgnoreCase(model.keyColumn, columnName)) && !WhereClauseParser.isMoreSelective(model, meta, reader, columnIndex)) {
                return false;
            }
            if (!this.allKeyValuesAreKnown) {
                return false;
            }
            int i = node.paramCount - 1;
            this.tempKeys.clear();
            this.tempPos.clear();
            this.tempType.clear();
            boolean tmpAllKeyValuesAreKnown = true;
            if (i == 1) {
                CharSequence value;
                if (node.rhs == null || node.rhs.type != 2 && node.rhs.type != 6 && node.rhs.type != 8 || node.rhs.type == 6 && this.tempKeyValues.size() > 0) {
                    return false;
                }
                if (node.rhs.type == 8) {
                    CharSequence testValue = this.getStrFromFunction(functionParser, node.rhs, meta, executionContext);
                    if (!this.isConstFunction) {
                        node.intrinsicValue = 2;
                        return false;
                    }
                    value = testValue;
                } else {
                    value = SqlKeywords.isNullKeyword(node.rhs.token) ? null : this.unquote(node.rhs.token);
                }
                if (this.tempKeys.add(value)) {
                    this.tempPos.add(node.position);
                    this.tempType.add(node.rhs.type);
                    tmpAllKeyValuesAreKnown = node.rhs.type != 6;
                }
            } else {
                --i;
                while (i > -1) {
                    ExpressionNode c = node.args.getQuick(i);
                    if (c.type != 2 && c.type != 6 && c.type != 8 || c.type == 6 && this.tempKeyValues.size() > 0) {
                        return false;
                    }
                    if (SqlKeywords.isNullKeyword(c.token)) {
                        if (this.tempKeys.add(null)) {
                            this.tempPos.add(c.position);
                            this.tempType.add(c.type);
                        }
                    } else {
                        CharSequence value;
                        if (c.type == 8) {
                            CharSequence testValue = this.getStrFromFunction(functionParser, c, meta, executionContext);
                            if (!this.isConstFunction) {
                                node.intrinsicValue = 2;
                                return false;
                            }
                            value = testValue;
                        } else {
                            value = this.unquote(c.token);
                        }
                        if (this.tempKeys.add(value)) {
                            this.tempPos.add(c.position);
                            this.tempType.add(c.type);
                            tmpAllKeyValuesAreKnown &= c.type != 6;
                        }
                    }
                    --i;
                }
            }
            if (newColumn) {
                this.clearKeys();
                this.tempKeyValues.addAll(this.tempKeys);
                this.tempKeyValuePos.addAll(this.tempPos);
                this.tempKeyValueType.addAll(this.tempType);
                this.allKeyValuesAreKnown = tmpAllKeyValuesAreKnown;
                WhereClauseParser.revertNodes(this.keyNodes);
                model.keyColumn = columnName;
                this.keyNodes.add(node);
                node.intrinsicValue = 1;
                return true;
            }
            if (this.tempKeyValues.size() == 0) {
                this.tempKeyValues.addAll(this.tempKeys);
                this.tempKeyValuePos.addAll(this.tempPos);
                this.tempKeyValueType.addAll(this.tempType);
            } else if (!tmpAllKeyValuesAreKnown) {
                node.intrinsicValue = 2;
                return false;
            }
            this.allKeyValuesAreKnown &= tmpAllKeyValuesAreKnown;
            if (model.keySubQuery == null) {
                this.mergeKeys(model, true);
                if (!(this.tempKeyExcludedValues.size() <= 0 || this.allKeyValuesAreKnown && this.allKeyExcludedValuesAreKnown)) {
                    this.clearExcludedKeys();
                    this.resetExcludedNodes();
                }
                this.keyNodes.add(node);
                node.intrinsicValue = 1;
                return true;
            }
        }
        return false;
    }

    private boolean analyzeNotBetween(AliasTranslator translator, IntrinsicModel model, ExpressionNode notNode, RecordMetadata m, FunctionParser functionParser, RecordMetadata metadata, SqlExecutionContext executionContext, boolean latestByMultiColumn, TableReader reader) throws SqlException {
        ExpressionNode node = notNode.rhs;
        ExpressionNode col = node.args.getLast();
        if (col.type != 4) {
            return false;
        }
        CharSequence column = translator.translateAlias(col.token);
        if (m.getColumnIndexQuiet(column) == -1) {
            throw SqlException.invalidColumn(col.position, col.token);
        }
        boolean ok = this.analyzeBetween0(model, col, node, true, functionParser, metadata, executionContext);
        if (ok) {
            notNode.intrinsicValue = 1;
        } else {
            this.analyzeNotListOfValues(model, column, m, node, notNode, latestByMultiColumn, reader, functionParser, executionContext);
        }
        return ok;
    }

    private boolean analyzeNotEquals(AliasTranslator translator, IntrinsicModel model, ExpressionNode node, RecordMetadata m, FunctionParser functionParser, SqlExecutionContext executionContext, boolean canUseIndex, TableReader reader) throws SqlException {
        WhereClauseParser.checkNodeValid(node);
        return this.analyzeNotEquals0(translator, model, node, node.lhs, node.rhs, m, functionParser, executionContext, canUseIndex, reader) || this.analyzeNotEquals0(translator, model, node, node.rhs, node.lhs, m, functionParser, executionContext, canUseIndex, reader);
    }

    private boolean analyzeNotEquals0(AliasTranslator translator, IntrinsicModel model, ExpressionNode node, ExpressionNode a, ExpressionNode b, RecordMetadata m, FunctionParser functionParser, SqlExecutionContext executionContext, boolean latestByMultiColumn, TableReader reader) throws SqlException {
        if (WhereClauseParser.nodesEqual(a, b) && !a.hasLeafs() && !b.hasLeafs()) {
            model.intrinsicValue = 2;
            return true;
        }
        if (a.type == 4 && (b.type == 2 || WhereClauseParser.isFunc(b))) {
            if (this.isTimestamp(a)) {
                if (b.type == 2) {
                    if (SqlKeywords.isNullKeyword(b.token)) {
                        node.intrinsicValue = 2;
                        return false;
                    }
                    model.subtractIntervals(b.token, 1, b.token.length() - 1, b.position);
                    node.intrinsicValue = 1;
                    return true;
                }
                Function function = functionParser.parseFunction(b, m, executionContext);
                this.checkFunctionCanBeTimestamp(m, executionContext, function, b.position);
                return this.analyzeTimestampNotEqualsFunction(model, node, function, b.position);
            }
            CharSequence columnName = translator.translateAlias(a.token);
            int index = m.getColumnIndexQuiet(columnName);
            if (index == -1) {
                throw SqlException.invalidColumn(a.position, a.token);
            }
            switch (ColumnType.tagOf(m.getColumnType(index))) {
                case 5: 
                case 6: 
                case 11: 
                case 12: {
                    if (this.columnIsPreferredOrIndexedAndNotPartOfMultiColumnLatestBy(columnName, m, latestByMultiColumn)) {
                        CharSequence value;
                        CharSequence charSequence = value = SqlKeywords.isNullKeyword(b.token) ? null : this.unquote(b.token);
                        if (Chars.equalsIgnoreCaseNc(columnName, model.keyColumn)) {
                            if (!this.isCorrectType(b.type)) {
                                node.intrinsicValue = 2;
                                return false;
                            }
                            if (b.type == 8) {
                                CharSequence testValue = this.getStrFromFunction(functionParser, b, m, executionContext);
                                if (!this.isConstFunction) {
                                    node.intrinsicValue = 2;
                                    return false;
                                }
                                value = testValue;
                            }
                            if (this.tempKeyExcludedValues.contains(value)) {
                                int idx;
                                if (value != null && WhereClauseParser.isTypeMismatch(this.tempKeyExcludedValueType.get(idx = this.tempKeyExcludedValues.getListIndexOf(value)), b.type)) {
                                    node.intrinsicValue = 2;
                                    return false;
                                }
                                node.intrinsicValue = 1;
                                this.keyExclNodes.add(node);
                            } else if (this.tempKeyValues.contains(value) && this.allKeyValuesAreKnown && b.type != 6) {
                                int listIdx;
                                if (value == null) {
                                    listIdx = this.tempKeyValues.removeNull();
                                } else {
                                    int hashIdx = this.tempKeyValues.keyIndex(value);
                                    listIdx = this.tempKeyValues.getListIndexAt(hashIdx);
                                    this.tempKeyValues.removeAt(hashIdx);
                                }
                                this.tempKeyValuePos.removeIndex(listIdx);
                                this.tempKeyValueType.removeIndex(listIdx);
                                this.removeNodes(b, this.keyNodes);
                                node.intrinsicValue = 1;
                                if (this.tempKeyValues.size() == 0) {
                                    model.intrinsicValue = 2;
                                }
                            } else {
                                this.addExcludedValue(node, b, value);
                            }
                        } else if (model.keyColumn == null || WhereClauseParser.isMoreSelective(model, m, reader, index)) {
                            if (!this.isCorrectType(b.type)) {
                                node.intrinsicValue = 2;
                                return false;
                            }
                            if (b.type == 8) {
                                CharSequence testValue = this.getStrFromFunction(functionParser, b, m, executionContext);
                                if (!this.isConstFunction) {
                                    node.intrinsicValue = 2;
                                    return false;
                                }
                                value = testValue;
                            }
                            model.keyColumn = columnName;
                            this.clearKeys();
                            this.clearExcludedKeys();
                            this.resetNodes();
                            this.addExcludedValue(node, b, value);
                            return true;
                        }
                        this.keyExclNodes.add(node);
                        return true;
                    }
                    if (!Chars.equalsIgnoreCaseNc(columnName, this.preferredKeyColumn)) break;
                    this.keyExclNodes.add(node);
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    private boolean analyzeNotIn(AliasTranslator translator, IntrinsicModel model, ExpressionNode notNode, RecordMetadata m, FunctionParser functionParser, RecordMetadata metadata, SqlExecutionContext executionContext, boolean latestByMultiColumn, TableReader reader) throws SqlException {
        ExpressionNode col;
        ExpressionNode node = notNode.rhs;
        if (node.paramCount < 2) {
            throw SqlException.$(node.position, "Too few arguments for 'in'");
        }
        ExpressionNode expressionNode = col = node.paramCount < 3 ? node.lhs : node.args.getLast();
        if (col.type != 4) {
            throw SqlException.$(col.position, "Column name expected");
        }
        CharSequence column = translator.translateAlias(col.token);
        if (m.getColumnIndexQuiet(column) == -1) {
            throw SqlException.invalidColumn(col.position, col.token);
        }
        boolean ok = this.analyzeInInterval(model, col, node, true, functionParser, metadata, executionContext);
        if (ok) {
            notNode.intrinsicValue = 1;
        } else {
            this.analyzeNotListOfValues(model, column, m, node, notNode, latestByMultiColumn, reader, functionParser, executionContext);
        }
        return ok;
    }

    private void analyzeNotListOfValues(IntrinsicModel model, CharSequence columnName, RecordMetadata m, ExpressionNode node, ExpressionNode notNode, boolean latestByMultiColumn, TableReader reader, FunctionParser functionParser, SqlExecutionContext executionContext) throws SqlException {
        int columnIndex = m.getColumnIndex(columnName);
        boolean newColumn = true;
        if (this.columnIsPreferredOrIndexedAndNotPartOfMultiColumnLatestBy(columnName, m, latestByMultiColumn)) {
            if (model.keyColumn != null && (newColumn = !Chars.equalsIgnoreCase(model.keyColumn, columnName)) && !WhereClauseParser.isMoreSelective(model, m, reader, columnIndex)) {
                return;
            }
            int i = node.paramCount - 1;
            this.tempKeys.clear();
            this.tempPos.clear();
            this.tempType.clear();
            boolean tmpAllKeyExcludedValuesAreKnown = true;
            if (i == 1) {
                CharSequence value;
                if (node.rhs == null || node.rhs.type != 2 && node.rhs.type != 8 && node.rhs.type != 6) {
                    return;
                }
                if (node.rhs.type == 8) {
                    CharSequence testValue = this.getStrFromFunction(functionParser, node.rhs, m, executionContext);
                    if (!this.isConstFunction) {
                        node.intrinsicValue = 2;
                        return;
                    }
                    value = testValue;
                } else {
                    value = SqlKeywords.isNullKeyword(node.rhs.token) ? null : this.unquote(node.rhs.token);
                }
                if (this.tempKeys.add(value)) {
                    this.tempPos.add(node.position);
                    this.tempType.add(node.rhs.type);
                    tmpAllKeyExcludedValuesAreKnown = node.rhs.type != 6;
                }
            } else {
                --i;
                while (i > -1) {
                    ExpressionNode c = node.args.getQuick(i);
                    if (c.type != 2 && c.type != 8 && c.type != 6) {
                        return;
                    }
                    if (SqlKeywords.isNullKeyword(c.token)) {
                        if (this.tempKeys.add(null)) {
                            this.tempPos.add(c.position);
                            this.tempType.add(c.type);
                        }
                    } else {
                        CharSequence value;
                        if (c.type == 8) {
                            CharSequence testValue = this.getStrFromFunction(functionParser, c, m, executionContext);
                            if (!this.isConstFunction) {
                                node.intrinsicValue = 2;
                                return;
                            }
                            value = testValue;
                        } else {
                            value = this.unquote(c.token);
                        }
                        if (this.tempKeys.add(value)) {
                            this.tempPos.add(c.position);
                            this.tempType.add(c.type);
                            tmpAllKeyExcludedValuesAreKnown &= c.type != 6;
                        }
                    }
                    --i;
                }
            }
            if (newColumn) {
                this.clearKeys();
                WhereClauseParser.revertNodes(this.keyNodes);
                this.clearExcludedKeys();
                WhereClauseParser.revertNodes(this.keyExclNodes);
                model.keyColumn = columnName;
                this.keyExclNodes.add(notNode);
                notNode.intrinsicValue = 1;
                this.tempKeyExcludedValues.addAll(this.tempKeys);
                this.tempKeyExcludedValuePos.addAll(this.tempPos);
                this.tempKeyExcludedValueType.addAll(this.tempType);
                this.allKeyExcludedValuesAreKnown = tmpAllKeyExcludedValuesAreKnown;
                return;
            }
            if (this.tempKeyExcludedValues.size() == 0) {
                this.tempKeyExcludedValues.addAll(this.tempKeys);
                this.tempKeyExcludedValuePos.addAll(this.tempPos);
                this.tempKeyExcludedValueType.addAll(this.tempType);
            }
            this.allKeyExcludedValuesAreKnown &= tmpAllKeyExcludedValuesAreKnown;
            if (model.keySubQuery == null && this.mergeKeys(model, false)) {
                this.keyExclNodes.add(notNode);
                notNode.intrinsicValue = 1;
            }
        }
    }

    private boolean analyzeTimestampEqualsFunction(IntrinsicModel model, ExpressionNode node, Function function, int functionPosition) throws SqlException {
        if (function.isConstant()) {
            long value = WhereClauseParser.getTimestampFromConstFunction(function, functionPosition);
            if (value == Long.MIN_VALUE) {
                model.intersectEmpty();
            } else {
                model.intersectIntervals(value, value);
            }
            node.intrinsicValue = 1;
            return true;
        }
        if (function.isRuntimeConstant()) {
            model.intersectEquals(function);
            node.intrinsicValue = 1;
            return true;
        }
        return false;
    }

    private boolean analyzeTimestampGreater(IntrinsicModel model, ExpressionNode node, boolean equalsTo, FunctionParser functionParser, RecordMetadata metadata, SqlExecutionContext executionContext, ExpressionNode compareWithNode) throws SqlException {
        if (compareWithNode.type == 2) {
            long lo;
            if (SqlKeywords.isNullKeyword(compareWithNode.token)) {
                node.intrinsicValue = 2;
                return false;
            }
            try {
                lo = this.parseFullOrPartialDate(equalsTo, compareWithNode, true);
            }
            catch (NumericException e) {
                throw SqlException.invalidDate(compareWithNode.position);
            }
            model.intersectIntervals(lo, Long.MAX_VALUE);
            node.intrinsicValue = 1;
            return true;
        }
        if (WhereClauseParser.isFunc(compareWithNode)) {
            Function function = functionParser.parseFunction(compareWithNode, metadata, executionContext);
            this.checkFunctionCanBeTimestamp(metadata, executionContext, function, compareWithNode.position);
            if (function.isConstant()) {
                long lo = WhereClauseParser.getTimestampFromConstFunction(function, compareWithNode.position);
                if (lo == Long.MIN_VALUE) {
                    model.intersectEmpty();
                } else {
                    model.intersectIntervals(lo + (long)WhereClauseParser.adjustComparison(equalsTo, true), Long.MAX_VALUE);
                }
                node.intrinsicValue = 1;
                return true;
            }
            if (function.isRuntimeConstant()) {
                model.intersectIntervals(function, Long.MAX_VALUE, WhereClauseParser.adjustComparison(equalsTo, true));
                node.intrinsicValue = 1;
                return true;
            }
        }
        return false;
    }

    private boolean analyzeTimestampLess(IntrinsicModel model, ExpressionNode node, boolean equalsTo, FunctionParser functionParser, RecordMetadata metadata, SqlExecutionContext executionContext, ExpressionNode compareWithNode) throws SqlException {
        if (compareWithNode.type == 2) {
            if (SqlKeywords.isNullKeyword(compareWithNode.token)) {
                node.intrinsicValue = 2;
                return false;
            }
            try {
                long hi = this.parseFullOrPartialDate(equalsTo, compareWithNode, false);
                model.intersectIntervals(Long.MIN_VALUE, hi);
                node.intrinsicValue = 1;
            }
            catch (NumericException e) {
                throw SqlException.invalidDate(compareWithNode.position);
            }
            return true;
        }
        if (WhereClauseParser.isFunc(compareWithNode)) {
            Function function = functionParser.parseFunction(compareWithNode, metadata, executionContext);
            this.checkFunctionCanBeTimestamp(metadata, executionContext, function, compareWithNode.position);
            if (function.isConstant()) {
                long hi = WhereClauseParser.getTimestampFromConstFunction(function, compareWithNode.position);
                if (hi == Long.MIN_VALUE) {
                    model.intersectEmpty();
                } else {
                    model.intersectIntervals(Long.MIN_VALUE, hi + (long)WhereClauseParser.adjustComparison(equalsTo, false));
                }
                node.intrinsicValue = 1;
                return true;
            }
            if (function.isRuntimeConstant()) {
                model.intersectIntervals(Long.MIN_VALUE, function, WhereClauseParser.adjustComparison(equalsTo, false));
                node.intrinsicValue = 1;
                return true;
            }
        }
        return false;
    }

    private boolean analyzeTimestampNotEqualsFunction(IntrinsicModel model, ExpressionNode node, Function function, int functionPosition) throws SqlException {
        if (function.isConstant()) {
            long value = WhereClauseParser.getTimestampFromConstFunction(function, functionPosition);
            model.subtractIntervals(value, value);
            node.intrinsicValue = 1;
            return true;
        }
        if (function.isRuntimeConstant()) {
            model.subtractEquals(function);
            node.intrinsicValue = 1;
            return true;
        }
        return false;
    }

    private void applyKeyExclusions(AliasTranslator translator, FunctionParser functionParser, RecordMetadata metadata, SqlExecutionContext executionContext, IntrinsicModel model) throws SqlException {
        if (model.keyColumn != null && this.tempKeyValues.size() > 0 && this.keyExclNodes.size() > 0) {
            if (this.allKeyValuesAreKnown && this.allKeyExcludedValuesAreKnown) {
                int n = this.keyExclNodes.size();
                block0: for (int i = 0; i < n; ++i) {
                    ExpressionNode col;
                    ExpressionNode node;
                    ExpressionNode parent = this.keyExclNodes.getQuick(i);
                    ExpressionNode expressionNode = node = SqlKeywords.isNotKeyword(parent.token) ? parent.rhs : parent;
                    if (node.paramCount == 2) {
                        ExpressionNode val;
                        if (node.lhs.type == 4) {
                            col = node.lhs;
                            val = node.rhs;
                        } else {
                            col = node.rhs;
                            val = node.lhs;
                        }
                        CharSequence column = translator.translateAlias(col.token);
                        if (Chars.equalsIgnoreCase(column, model.keyColumn)) {
                            this.excludeKeyValue(model, functionParser, metadata, executionContext, val);
                            parent.intrinsicValue = 1;
                            if (model.intrinsicValue == 2) break;
                        }
                    }
                    if (node.paramCount <= 2) continue;
                    col = node.args.getQuick(node.paramCount - 1);
                    CharSequence column = translator.translateAlias(col.token);
                    if (!Chars.equalsIgnoreCase(column, model.keyColumn)) continue;
                    for (int j = node.paramCount - 2; j > -1; --j) {
                        ExpressionNode val = node.args.getQuick(j);
                        this.excludeKeyValue(model, functionParser, metadata, executionContext, val);
                        if (model.intrinsicValue == 2) break block0;
                    }
                    parent.intrinsicValue = 1;
                }
            }
            if (this.tempKeyValues.size() > 0 && this.tempKeyExcludedValues.size() > 0) {
                if (!this.allKeyValuesAreKnown || !this.allKeyExcludedValuesAreKnown) {
                    this.resetExcludedNodes();
                }
                this.clearExcludedKeys();
                this.allKeyExcludedValuesAreKnown = true;
            }
        }
        this.keyExclNodes.clear();
    }

    private void checkFunctionCanBeTimestamp(RecordMetadata metadata, SqlExecutionContext executionContext, Function function, int functionPosition) throws SqlException {
        if (ColumnType.isUndefined(function.getType())) {
            int timestampType = metadata.getColumnType(metadata.getTimestampIndex());
            function.assignType(timestampType, executionContext.getBindVariableService());
        } else if (!WhereClauseParser.canCastToTimestamp(function.getType())) {
            throw SqlException.invalidDate(functionPosition);
        }
    }

    private boolean checkFunctionCanBeTimestampInterval(SqlExecutionContext executionContext, Function function) throws SqlException {
        int type = function.getType();
        if (ColumnType.isUndefined(type)) {
            function.assignType(11, executionContext.getBindVariableService());
            return true;
        }
        return ColumnType.isString(type);
    }

    private void clearExcludedKeys() {
        this.tempKeyExcludedValues.clear();
        this.tempKeyExcludedValuePos.clear();
        this.tempKeyExcludedValueType.clear();
        this.allKeyExcludedValuesAreKnown = true;
    }

    private void clearKeys() {
        this.tempKeyValues.clear();
        this.tempKeyValuePos.clear();
        this.tempKeyValueType.clear();
        this.allKeyValuesAreKnown = true;
    }

    private ExpressionNode collapseIntrinsicNodes(ExpressionNode node) {
        if (node == null || node.intrinsicValue == 1) {
            return null;
        }
        node.lhs = this.collapseIntrinsicNodes(this.collapseNulls0(node.lhs));
        node.rhs = this.collapseIntrinsicNodes(this.collapseNulls0(node.rhs));
        return this.collapseNulls0(node);
    }

    private ExpressionNode collapseNulls0(ExpressionNode node) {
        if (node == null || node.intrinsicValue == 1) {
            return null;
        }
        if (node.queryModel == null && SqlKeywords.isAndKeyword(node.token)) {
            if (node.lhs == null || node.lhs.intrinsicValue == 1) {
                return node.rhs;
            }
            if (node.rhs == null || node.rhs.intrinsicValue == 1) {
                return node.lhs;
            }
        }
        return node;
    }

    private ExpressionNode collapseWithin0(ExpressionNode node) {
        if (node == null || SqlKeywords.isWithinKeyword(node.token)) {
            return null;
        }
        if (node.queryModel == null && (SqlKeywords.isAndKeyword(node.token) || SqlKeywords.isOrKeyword(node.token))) {
            if (node.lhs == null || SqlKeywords.isWithinKeyword(node.lhs.token)) {
                return node.rhs;
            }
            if (node.rhs == null || SqlKeywords.isWithinKeyword(node.rhs.token)) {
                return node.lhs;
            }
        }
        return node;
    }

    private ExpressionNode collapseWithinNodes(ExpressionNode node) {
        if (node == null || SqlKeywords.isWithinKeyword(node.token)) {
            return null;
        }
        node.lhs = this.collapseWithinNodes(this.collapseWithin0(node.lhs));
        node.rhs = this.collapseWithinNodes(this.collapseWithin0(node.rhs));
        return this.collapseWithin0(node);
    }

    private boolean columnIsPreferredOrIndexedAndNotPartOfMultiColumnLatestBy(CharSequence columnName, RecordMetadata m, boolean latestByMultiColumn) {
        return !latestByMultiColumn && (Chars.equalsIgnoreCaseNc(columnName, this.preferredKeyColumn) || this.preferredKeyColumn == null && m.isColumnIndexed(m.getColumnIndex(columnName)));
    }

    private Function createKeyValueBindVariable(FunctionParser functionParser, SqlExecutionContext executionContext, int position, CharSequence value, int expressionType) throws SqlException {
        Function func = functionParser.createBindVariable(executionContext, position, value, expressionType);
        if (func.isRuntimeConstant() && ColumnType.isUndefined(func.getType())) {
            func.assignType(11, executionContext.getBindVariableService());
        }
        func.init(null, executionContext);
        return func;
    }

    private void createKeyValueBindVariables(IntrinsicModel model, FunctionParser functionParser, SqlExecutionContext executionContext) throws SqlException {
        Function func;
        int i;
        int n = this.tempKeyValues.size();
        for (i = 0; i < n; ++i) {
            func = this.createKeyValueBindVariable(functionParser, executionContext, this.tempKeyValuePos.getQuick(i), this.tempKeyValues.get(i), this.tempKeyValueType.get(i));
            model.keyValueFuncs.add(func);
        }
        this.clearKeys();
        n = this.tempKeyExcludedValues.size();
        for (i = 0; i < n; ++i) {
            func = this.createKeyValueBindVariable(functionParser, executionContext, this.tempKeyExcludedValuePos.getQuick(i), this.tempKeyExcludedValues.get(i), this.tempKeyExcludedValueType.get(i));
            model.keyExcludedValueFuncs.add(func);
        }
        this.clearExcludedKeys();
    }

    private void excludeKeyValue(IntrinsicModel model, FunctionParser functionParser, RecordMetadata m, SqlExecutionContext executionContext, ExpressionNode val) throws SqlException {
        if (SqlKeywords.isNullKeyword(val.token)) {
            int index = this.tempKeyValues.removeNull();
            if (index > -1) {
                this.tempKeyValuePos.removeIndex(index);
                this.tempKeyValueType.removeIndex(index);
            }
        } else if (this.isCorrectType(val.type)) {
            int index;
            int keyIndex;
            if (val.type == 8) {
                CharSequence result = this.getStrFromFunction(functionParser, val, m, executionContext);
                if (!this.isConstFunction) {
                    return;
                }
                if (result != null) {
                    keyIndex = this.tempKeyValues.keyIndex(result);
                } else {
                    keyIndex = 0;
                    index = this.tempKeyValues.removeNull();
                    if (index > -1) {
                        this.tempKeyValuePos.removeIndex(index);
                        this.tempKeyValueType.removeIndex(index);
                    }
                }
            } else {
                int n = keyIndex = Chars.isQuoted(val.token) ? this.tempKeyValues.keyIndex(val.token, 1, val.token.length() - 1) : this.tempKeyValues.keyIndex(val.token);
            }
            if (keyIndex < 0) {
                index = this.tempKeyValues.getListIndexAt(keyIndex);
                this.tempKeyValues.removeAt(keyIndex);
                this.tempKeyValuePos.removeIndex(index);
                this.tempKeyValueType.removeIndex(index);
            }
        }
        if (this.tempKeyValues.size() == 0) {
            model.intrinsicValue = 2;
        }
    }

    private CharSequence getStrFromFunction(FunctionParser functionParser, ExpressionNode node, RecordMetadata metadata, SqlExecutionContext executionContext) throws SqlException {
        Function function = functionParser.parseFunction(node, metadata, executionContext);
        if (!function.isConstant()) {
            this.isConstFunction = false;
            return null;
        }
        this.isConstFunction = true;
        int type = function.getType();
        if (type == 12 || type == 11 || type == 4 || type == 0 || type == 29) {
            return function.getStr(null);
        }
        throw SqlException.$(node.position, "Unexpected function type [").put(ColumnType.nameOf(type)).put("]");
    }

    private boolean isCorrectType(int type) {
        return type != 1;
    }

    private boolean isGeoHashConstFunction(Function fn) {
        return fn instanceof AbstractGeoHashFunction && fn.isConstant();
    }

    private boolean isNull(ExpressionNode node) {
        return node == null || SqlKeywords.isNullKeyword(node.token);
    }

    private boolean isTimestamp(ExpressionNode n) {
        return Chars.equalsIgnoreCaseNc(n.token, this.timestamp);
    }

    private boolean mergeKeys(IntrinsicModel model, boolean includedValues) {
        IntList types;
        IntList positions;
        CharSequenceHashSet values;
        if (includedValues) {
            values = this.tempKeyValues;
            positions = this.tempKeyValuePos;
            types = this.tempKeyValueType;
        } else {
            values = this.tempKeyExcludedValues;
            positions = this.tempKeyExcludedValuePos;
            types = this.tempKeyExcludedValueType;
        }
        this.tempK.clear();
        this.tempP.clear();
        this.tempT.clear();
        if (includedValues) {
            int k = this.tempKeys.size();
            for (int i = 0; i < k; ++i) {
                if (!values.contains(this.tempKeys.get(i)) || !this.tempK.add(this.tempKeys.get(i))) continue;
                this.tempP.add(this.tempPos.get(i));
                this.tempT.add(this.tempType.get(i));
            }
        } else {
            this.tempK.addAll(values);
            this.tempP.addAll(positions);
            this.tempT.addAll(types);
            int k = this.tempKeys.size();
            for (int i = 0; i < k; ++i) {
                if (this.tempK.add(this.tempKeys.get(i))) {
                    this.tempP.add(this.tempPos.get(i));
                    this.tempT.add(this.tempType.get(i));
                    continue;
                }
                if (this.tempKeys.get(i) == null) continue;
                int listIdx = this.tempK.getListIndexOf(this.tempKeys.get(i));
                if (!WhereClauseParser.isTypeMismatch(this.tempType.get(i), this.tempT.get(listIdx))) continue;
                return false;
            }
        }
        values.clear();
        positions.clear();
        types.clear();
        if (this.tempK.size() > 0) {
            values.addAll(this.tempK);
            positions.addAll(this.tempP);
            types.addAll(this.tempT);
        } else {
            model.intrinsicValue = 2;
        }
        return true;
    }

    private long parseFullOrPartialDate(boolean equalsTo, ExpressionNode node, boolean isLo) throws NumericException {
        long ts;
        int len = node.token.length();
        try {
            ts = IntervalUtils.parseFloorPartialTimestamp(node.token, 1, len - 1);
        }
        catch (NumericException e) {
            try {
                ts = Numbers.parseLong(node.token);
            }
            catch (NumericException e2) {
                ts = TimestampFormatUtils.tryParse(node.token, 1, node.token.length() - 1);
            }
        }
        if (!equalsTo) {
            ts += isLo ? 1L : -1L;
        }
        return ts;
    }

    private void processArgument(ExpressionNode inArg, RecordMetadata metadata, FunctionParser functionParser, SqlExecutionContext executionContext, int columnType, LongList prefixes) throws SqlException {
        long hash;
        int type;
        int position;
        block22: {
            boolean isCharsPrefix;
            position = inArg.position;
            if (this.isNull(inArg)) {
                throw SqlException.$(position, "GeoHash value expected");
            }
            if (WhereClauseParser.isFunc(inArg)) {
                try (Function f = functionParser.parseFunction(inArg, metadata, executionContext);){
                    if (this.isGeoHashConstFunction(f)) {
                        type = f.getType();
                        hash = GeoHashes.getGeoLong(type, f, null);
                        break block22;
                    }
                    throw SqlException.$(inArg.position, "GeoHash const function expected");
                }
            }
            boolean isConstant = inArg.type == 2;
            CharSequence token = inArg.token;
            int len = token.length();
            boolean isBitsPrefix = len > 2 && token.charAt(0) == '#' && token.charAt(1) == '#';
            boolean bl = isCharsPrefix = len > 1 && token.charAt(0) == '#';
            if (!isConstant || !isBitsPrefix && !isCharsPrefix) {
                throw SqlException.$(position, "GeoHash literal expected");
            }
            try {
                if (!isBitsPrefix) {
                    int sdd = ExpressionParser.extractGeoHashSuffix(position, token);
                    short sddLen = Numbers.decodeLowShort(sdd);
                    short bits = Numbers.decodeHighShort(sdd);
                    type = ColumnType.getGeoHashTypeWithBits(bits);
                    hash = GeoHashes.fromStringTruncatingNl(token, 1, len - sddLen, bits);
                    break block22;
                }
                int bits = len - 2;
                if (bits <= 60) {
                    type = ColumnType.getGeoHashTypeWithBits(bits);
                    hash = GeoHashes.fromBitStringNl(token, 2);
                    break block22;
                }
                throw SqlException.$(position, "GeoHash bits literal expected");
            }
            catch (NumericException ignored) {
                throw SqlException.$(position, "GeoHash literal expected");
            }
        }
        try {
            GeoHashes.addNormalizedGeoPrefix(hash, type, columnType, prefixes);
        }
        catch (NumericException e) {
            throw SqlException.$(position, "GeoHash prefix precision mismatch");
        }
    }

    private boolean removeAndIntrinsics(AliasTranslator translator, IntrinsicModel model, ExpressionNode node, RecordMetadata m, FunctionParser functionParser, RecordMetadata metadata, SqlExecutionContext executionContext, boolean latestByMultiColumn, TableReader reader) throws SqlException {
        switch (intrinsicOps.get(node.token)) {
            case 1: {
                return this.analyzeIn(translator, model, node, m, functionParser, executionContext, latestByMultiColumn, reader);
            }
            case 3: {
                return this.analyzeGreater(model, node, true, functionParser, metadata, executionContext);
            }
            case 2: {
                return this.analyzeGreater(model, node, false, functionParser, metadata, executionContext);
            }
            case 5: {
                return this.analyzeLess(model, node, true, functionParser, metadata, executionContext);
            }
            case 4: {
                return this.analyzeLess(model, node, false, functionParser, metadata, executionContext);
            }
            case 6: {
                return this.analyzeEquals(translator, model, node, m, functionParser, executionContext, latestByMultiColumn, reader);
            }
            case 7: {
                return this.analyzeNotEquals(translator, model, node, m, functionParser, executionContext, latestByMultiColumn, reader);
            }
            case 8: {
                return SqlKeywords.isInKeyword(node.rhs.token) && this.analyzeNotIn(translator, model, node, m, functionParser, metadata, executionContext, latestByMultiColumn, reader) || SqlKeywords.isBetweenKeyword(node.rhs.token) && this.analyzeNotBetween(translator, model, node, m, functionParser, metadata, executionContext, latestByMultiColumn, reader);
            }
            case 9: {
                return this.analyzeBetween(translator, model, node, m, functionParser, metadata, executionContext);
            }
        }
        return false;
    }

    private void removeNodes(ExpressionNode b, ObjList<ExpressionNode> nodes) {
        int i;
        this.tempNodes.clear();
        int size = nodes.size();
        for (i = 0; i < size; ++i) {
            ExpressionNode node = nodes.get(i);
            if ((node.lhs == null || !Chars.equals(node.lhs.token, b.token)) && (node.rhs == null || !Chars.equals(node.rhs.token, b.token))) continue;
            node.intrinsicValue = 1;
            this.tempNodes.add(node);
        }
        size = this.tempNodes.size();
        for (i = 0; i < size; ++i) {
            nodes.remove(this.tempNodes.get(i));
        }
    }

    private boolean removeWithin(AliasTranslator translator, ExpressionNode node, RecordMetadata metadata, FunctionParser functionParser, SqlExecutionContext executionContext, LongList prefixes) throws SqlException {
        if (SqlKeywords.isWithinKeyword(node.token)) {
            int c;
            ExpressionNode col;
            if (prefixes.size() > 0) {
                throw SqlException.$(node.position, "Multiple 'within' expressions not supported");
            }
            if (node.paramCount < 2) {
                throw SqlException.$(node.position, "Too few arguments for 'within'");
            }
            ExpressionNode expressionNode = col = node.paramCount < 3 ? node.lhs : node.args.getLast();
            if (col.type != 4) {
                throw SqlException.unexpectedToken(col.position, col.token);
            }
            CharSequence column = translator.translateAlias(col.token);
            if (metadata.getColumnIndexQuiet(column) == -1) {
                throw SqlException.invalidColumn(col.position, col.token);
            }
            int hashColumnIndex = metadata.getColumnIndex(column);
            int hashColumnType = metadata.getColumnType(hashColumnIndex);
            if (!ColumnType.isGeoHash(hashColumnType)) {
                throw SqlException.$(node.position, "GeoHash column type expected");
            }
            if (prefixes.size() == 0) {
                prefixes.add(hashColumnIndex);
                prefixes.add(hashColumnType);
            }
            if ((c = node.paramCount - 1) == 1) {
                ExpressionNode inArg = node.rhs;
                this.processArgument(inArg, metadata, functionParser, executionContext, hashColumnType, prefixes);
            } else {
                --c;
                while (c > -1) {
                    ExpressionNode inArg = node.args.getQuick(c);
                    this.processArgument(inArg, metadata, functionParser, executionContext, hashColumnType, prefixes);
                    --c;
                }
            }
            return true;
        }
        return false;
    }

    private void resetExcludedNodes() {
        WhereClauseParser.revertNodes(this.keyExclNodes);
    }

    private void resetNodes() {
        WhereClauseParser.revertNodes(this.keyNodes);
        this.resetExcludedNodes();
    }

    private boolean translateBetweenToTimestampModel(IntrinsicModel model, FunctionParser functionParser, RecordMetadata metadata, SqlExecutionContext executionContext, ExpressionNode node) throws SqlException {
        if (node.type == 2) {
            model.setBetweenBoundary(WhereClauseParser.parseTokenAsTimestamp(node));
            return true;
        }
        if (WhereClauseParser.isFunc(node)) {
            Function function = functionParser.parseFunction(node, metadata, executionContext);
            this.checkFunctionCanBeTimestamp(metadata, executionContext, function, node.position);
            if (function.isConstant()) {
                long timestamp = WhereClauseParser.getTimestampFromConstFunction(function, node.position);
                model.setBetweenBoundary(timestamp);
            } else if (function.isRuntimeConstant()) {
                model.setBetweenBoundary(function);
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    private CharSequence unquote(CharSequence value) {
        if (Chars.isQuoted(value)) {
            return this.csPool.next().of(value, 1, value.length() - 2);
        }
        return value;
    }

    IntrinsicModel extract(AliasTranslator translator, ExpressionNode node, RecordMetadata m, CharSequence preferredKeyColumn, int timestampIndex, FunctionParser functionParser, RecordMetadata metadata, SqlExecutionContext executionContext, boolean latestByMultiColumn, TableReader reader) throws SqlException {
        this.clearKeys();
        this.clearExcludedKeys();
        this.timestamp = timestampIndex < 0 ? null : m.getColumnName(timestampIndex);
        this.preferredKeyColumn = preferredKeyColumn;
        IntrinsicModel model = this.models.next();
        if (this.removeAndIntrinsics(translator, model, node, m, functionParser, metadata, executionContext, latestByMultiColumn, reader)) {
            this.createKeyValueBindVariables(model, functionParser, executionContext);
            return model;
        }
        ExpressionNode root = node;
        while (!this.stack.isEmpty() || node != null) {
            if (node != null) {
                if (SqlKeywords.isAndKeyword(node.token)) {
                    if (!this.removeAndIntrinsics(translator, model, node.rhs, m, functionParser, metadata, executionContext, latestByMultiColumn, reader)) {
                        this.stack.push(node.rhs);
                    }
                    node = this.removeAndIntrinsics(translator, model, node.lhs, m, functionParser, metadata, executionContext, latestByMultiColumn, reader) ? null : node.lhs;
                    continue;
                }
                node = this.stack.poll();
                continue;
            }
            node = this.stack.poll();
        }
        this.applyKeyExclusions(translator, functionParser, metadata, executionContext, model);
        model.filter = this.collapseIntrinsicNodes(root);
        this.createKeyValueBindVariables(model, functionParser, executionContext);
        return model;
    }

    ExpressionNode extractWithin(AliasTranslator translator, ExpressionNode node, RecordMetadata metadata, FunctionParser functionParser, SqlExecutionContext executionContext, LongList prefixes) throws SqlException {
        prefixes.clear();
        if (node == null) {
            return null;
        }
        if (this.removeWithin(translator, node, metadata, functionParser, executionContext, prefixes)) {
            return this.collapseWithinNodes(node);
        }
        ExpressionNode root = node;
        while (!this.stack.isEmpty() || node != null) {
            if (node != null) {
                if (SqlKeywords.isAndKeyword(node.token) || SqlKeywords.isOrKeyword(node.token)) {
                    if (!this.removeWithin(translator, node.rhs, metadata, functionParser, executionContext, prefixes)) {
                        this.stack.push(node.rhs);
                    }
                    node = this.removeWithin(translator, node.lhs, metadata, functionParser, executionContext, prefixes) ? null : node.lhs;
                    continue;
                }
                node = this.stack.poll();
                continue;
            }
            node = this.stack.poll();
        }
        return this.collapseWithinNodes(root);
    }

    static {
        intrinsicOps.put("in", 1);
        intrinsicOps.put(">", 2);
        intrinsicOps.put(">=", 3);
        intrinsicOps.put("<", 4);
        intrinsicOps.put("<=", 5);
        intrinsicOps.put("=", 6);
        intrinsicOps.put("!=", 7);
        intrinsicOps.put("not", 8);
        intrinsicOps.put("between", 9);
    }
}

