/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KeyAgreementAlgorithmSpec {
    ECDH("ECDH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KeyAgreementAlgorithmSpec> VALUE_MAP;
    private final String value;

    private KeyAgreementAlgorithmSpec(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KeyAgreementAlgorithmSpec fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KeyAgreementAlgorithmSpec> knownValues() {
        EnumSet<KeyAgreementAlgorithmSpec> knownValues = EnumSet.allOf(KeyAgreementAlgorithmSpec.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KeyAgreementAlgorithmSpec.class, KeyAgreementAlgorithmSpec::toString);
    }
}

