/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.registry.bucket.Bucket;
import org.apache.nifi.registry.bucket.BucketItem;
import org.apache.nifi.registry.db.entity.BucketEntity;
import org.apache.nifi.registry.db.entity.BucketItemEntity;
import org.apache.nifi.registry.db.entity.BundleEntity;
import org.apache.nifi.registry.db.entity.FlowEntity;
import org.apache.nifi.registry.db.entity.FlowSnapshotEntity;
import org.apache.nifi.registry.diff.ComponentDifferenceGroup;
import org.apache.nifi.registry.diff.VersionedFlowDifference;
import org.apache.nifi.registry.exception.ResourceNotFoundException;
import org.apache.nifi.registry.extension.BundleCoordinate;
import org.apache.nifi.registry.extension.BundlePersistenceProvider;
import org.apache.nifi.registry.flow.FlowPersistenceProvider;
import org.apache.nifi.registry.flow.FlowSnapshotContext;
import org.apache.nifi.registry.flow.VersionedFlow;
import org.apache.nifi.registry.flow.VersionedFlowSnapshot;
import org.apache.nifi.registry.flow.VersionedFlowSnapshotMetadata;
import org.apache.nifi.registry.flow.diff.ComparableDataFlow;
import org.apache.nifi.registry.flow.diff.ConciseEvolvingDifferenceDescriptor;
import org.apache.nifi.registry.flow.diff.DifferenceDescriptor;
import org.apache.nifi.registry.flow.diff.FlowComparatorVersionedStrategy;
import org.apache.nifi.registry.flow.diff.FlowComparison;
import org.apache.nifi.registry.flow.diff.FlowDifference;
import org.apache.nifi.registry.flow.diff.StandardComparableDataFlow;
import org.apache.nifi.registry.flow.diff.StandardFlowComparator;
import org.apache.nifi.registry.provider.extension.StandardBundleCoordinate;
import org.apache.nifi.registry.provider.flow.StandardFlowSnapshotContext;
import org.apache.nifi.registry.serialization.FlowContent;
import org.apache.nifi.registry.serialization.FlowContentSerializer;
import org.apache.nifi.registry.service.MetadataService;
import org.apache.nifi.registry.service.alias.RegistryUrlAliasService;
import org.apache.nifi.registry.service.mapper.BucketMappings;
import org.apache.nifi.registry.service.mapper.ExtensionMappings;
import org.apache.nifi.registry.service.mapper.FlowMappings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RegistryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegistryService.class);
    private final MetadataService metadataService;
    private final FlowPersistenceProvider flowPersistenceProvider;
    private final BundlePersistenceProvider bundlePersistenceProvider;
    private final FlowContentSerializer flowContentSerializer;
    private final Validator validator;
    private final RegistryUrlAliasService registryUrlAliasService;

    @Autowired
    public RegistryService(MetadataService metadataService, FlowPersistenceProvider flowPersistenceProvider, BundlePersistenceProvider bundlePersistenceProvider, FlowContentSerializer flowContentSerializer, Validator validator, RegistryUrlAliasService registryUrlAliasService) {
        this.metadataService = Objects.requireNonNull(metadataService);
        this.flowPersistenceProvider = Objects.requireNonNull(flowPersistenceProvider);
        this.bundlePersistenceProvider = Objects.requireNonNull(bundlePersistenceProvider);
        this.flowContentSerializer = Objects.requireNonNull(flowContentSerializer);
        this.validator = Objects.requireNonNull(validator);
        this.registryUrlAliasService = Objects.requireNonNull(registryUrlAliasService);
    }

    private <T> void validate(T t, String invalidMessage) {
        Set violations = this.validator.validate(t, new Class[0]);
        if (violations.size() > 0) {
            throw new ConstraintViolationException(invalidMessage, violations);
        }
    }

    public Bucket createBucket(Bucket bucket) {
        if (bucket == null) {
            throw new IllegalArgumentException("Bucket cannot be null");
        }
        bucket.setCreatedTimestamp(System.currentTimeMillis());
        if (bucket.isAllowBundleRedeploy() == null) {
            bucket.setAllowBundleRedeploy(Boolean.valueOf(false));
        }
        if (bucket.isAllowPublicRead() == null) {
            bucket.setAllowPublicRead(Boolean.valueOf(false));
        }
        this.validate(bucket, "Cannot create Bucket");
        List<BucketEntity> bucketsWithSameName = this.metadataService.getBucketsByName(bucket.getName());
        if (bucketsWithSameName.size() > 0) {
            throw new IllegalStateException("A bucket with the same name already exists");
        }
        BucketEntity createdBucket = this.metadataService.createBucket(BucketMappings.map(bucket));
        return BucketMappings.map(createdBucket);
    }

    public Bucket getBucket(String bucketIdentifier) {
        if (bucketIdentifier == null) {
            throw new IllegalArgumentException("Bucket identifier cannot be null");
        }
        BucketEntity bucket = this.metadataService.getBucketById(bucketIdentifier);
        if (bucket == null) {
            LOGGER.warn("The specified bucket id [{}] does not exist.", (Object)bucketIdentifier);
            throw new ResourceNotFoundException("The specified bucket ID does not exist in this registry.");
        }
        return BucketMappings.map(bucket);
    }

    public void verifyBucketExists(String bucketIdentifier) {
        if (bucketIdentifier == null) {
            throw new IllegalArgumentException("Bucket identifier cannot be null");
        }
        BucketEntity bucket = this.metadataService.getBucketById(bucketIdentifier);
        if (bucket == null) {
            LOGGER.warn("The specified bucket id [{}] does not exist.", (Object)bucketIdentifier);
            throw new ResourceNotFoundException("The specified bucket ID does not exist in this registry.");
        }
    }

    public Bucket getBucketByName(String bucketName) {
        if (bucketName == null) {
            throw new IllegalArgumentException("Bucket name cannot be null");
        }
        List<BucketEntity> buckets = this.metadataService.getBucketsByName(bucketName);
        if (buckets.isEmpty()) {
            LOGGER.warn("The specified bucket name [{}] does not exist.", (Object)bucketName);
            throw new ResourceNotFoundException("The specified bucket name does not exist in this registry.");
        }
        return BucketMappings.map(buckets.get(0));
    }

    public List<Bucket> getBuckets() {
        List<BucketEntity> buckets = this.metadataService.getAllBuckets();
        return buckets.stream().map(b -> BucketMappings.map(b)).collect(Collectors.toList());
    }

    public List<Bucket> getBuckets(Set<String> bucketIds) {
        List<BucketEntity> buckets = this.metadataService.getBuckets(bucketIds);
        return buckets.stream().map(b -> BucketMappings.map(b)).collect(Collectors.toList());
    }

    public Bucket updateBucket(Bucket bucket) {
        List<BucketEntity> bucketsWithSameName;
        if (bucket == null) {
            throw new IllegalArgumentException("Bucket cannot be null");
        }
        if (bucket.getIdentifier() == null) {
            throw new IllegalArgumentException("Bucket identifier cannot be null");
        }
        if (bucket.getName() != null && StringUtils.isBlank((CharSequence)bucket.getName())) {
            throw new IllegalArgumentException("Bucket name cannot be blank");
        }
        BucketEntity existingBucketById = this.metadataService.getBucketById(bucket.getIdentifier());
        if (existingBucketById == null) {
            LOGGER.warn("The specified bucket id [{}] does not exist.", (Object)bucket.getIdentifier());
            throw new ResourceNotFoundException("The specified bucket ID does not exist in this registry.");
        }
        if (StringUtils.isNotBlank((CharSequence)bucket.getName()) && (bucketsWithSameName = this.metadataService.getBucketsByName(bucket.getName())) != null) {
            for (BucketEntity bucketWithSameName : bucketsWithSameName) {
                if (bucketWithSameName.getId().equals(existingBucketById.getId())) continue;
                throw new IllegalStateException("A bucket with the same name already exists - " + bucket.getName());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)bucket.getName())) {
            existingBucketById.setName(bucket.getName());
        }
        if (bucket.getDescription() != null) {
            existingBucketById.setDescription(bucket.getDescription());
        }
        if (bucket.isAllowBundleRedeploy() != null) {
            existingBucketById.setAllowExtensionBundleRedeploy(bucket.isAllowBundleRedeploy());
        }
        if (bucket.isAllowPublicRead() != null) {
            existingBucketById.setAllowPublicRead(bucket.isAllowPublicRead());
        }
        BucketEntity updatedBucket = this.metadataService.updateBucket(existingBucketById);
        return BucketMappings.map(updatedBucket);
    }

    public Bucket deleteBucket(String bucketIdentifier) {
        if (bucketIdentifier == null) {
            throw new IllegalArgumentException("Bucket identifier cannot be null");
        }
        BucketEntity existingBucket = this.metadataService.getBucketById(bucketIdentifier);
        if (existingBucket == null) {
            LOGGER.warn("The specified bucket id [{}] does not exist.", (Object)bucketIdentifier);
            throw new ResourceNotFoundException("The specified bucket ID does not exist in this registry.");
        }
        for (FlowEntity flowEntity : this.metadataService.getFlowsByBucket(existingBucket.getId())) {
            this.flowPersistenceProvider.deleteAllFlowContent(bucketIdentifier, flowEntity.getId());
        }
        for (BundleEntity bundleEntity : this.metadataService.getBundlesByBucket(existingBucket.getId())) {
            StandardBundleCoordinate bundleCoordinate = new StandardBundleCoordinate.Builder().bucketId(bundleEntity.getBucketId()).groupId(bundleEntity.getGroupId()).artifactId(bundleEntity.getArtifactId()).build();
            this.bundlePersistenceProvider.deleteAllBundleVersions((BundleCoordinate)bundleCoordinate);
        }
        this.metadataService.deleteBucket(existingBucket);
        return BucketMappings.map(existingBucket);
    }

    public List<BucketItem> getBucketItems(String bucketIdentifier) {
        if (bucketIdentifier == null) {
            throw new IllegalArgumentException("Bucket identifier cannot be null");
        }
        BucketEntity bucket = this.metadataService.getBucketById(bucketIdentifier);
        if (bucket == null) {
            LOGGER.warn("The specified bucket id [{}] does not exist.", (Object)bucketIdentifier);
            throw new ResourceNotFoundException("The specified bucket ID does not exist in this registry.");
        }
        ArrayList<BucketItem> bucketItems = new ArrayList<BucketItem>();
        this.metadataService.getBucketItems(bucket.getId()).stream().forEach(b -> this.addBucketItem((List<BucketItem>)bucketItems, (BucketItemEntity)b));
        return bucketItems;
    }

    public List<BucketItem> getBucketItems(Set<String> bucketIdentifiers) {
        if (bucketIdentifiers == null || bucketIdentifiers.isEmpty()) {
            throw new IllegalArgumentException("Bucket identifiers cannot be null or empty");
        }
        ArrayList<BucketItem> bucketItems = new ArrayList<BucketItem>();
        this.metadataService.getBucketItems(bucketIdentifiers).stream().forEach(b -> this.addBucketItem((List<BucketItem>)bucketItems, (BucketItemEntity)b));
        return bucketItems;
    }

    private void addBucketItem(List<BucketItem> bucketItems, BucketItemEntity itemEntity) {
        if (itemEntity instanceof FlowEntity) {
            FlowEntity flowEntity = (FlowEntity)itemEntity;
            bucketItems.add((BucketItem)FlowMappings.map(null, flowEntity));
        } else if (itemEntity instanceof BundleEntity) {
            BundleEntity bundleEntity = (BundleEntity)itemEntity;
            bucketItems.add((BucketItem)ExtensionMappings.map(null, bundleEntity));
        } else {
            LOGGER.error("Unknown type of BucketItemEntity: " + itemEntity.getClass().getCanonicalName());
        }
    }

    public VersionedFlow createFlow(String bucketIdentifier, VersionedFlow versionedFlow) {
        if (StringUtils.isBlank((CharSequence)bucketIdentifier)) {
            throw new IllegalArgumentException("Bucket identifier cannot be null or blank");
        }
        if (versionedFlow == null) {
            throw new IllegalArgumentException("Versioned flow cannot be null");
        }
        if (versionedFlow.getBucketIdentifier() != null && !bucketIdentifier.equals(versionedFlow.getBucketIdentifier())) {
            throw new IllegalArgumentException("Bucket identifiers must match");
        }
        if (versionedFlow.getBucketIdentifier() == null) {
            versionedFlow.setBucketIdentifier(bucketIdentifier);
        }
        long timestamp = System.currentTimeMillis();
        if (versionedFlow.getCreatedTimestamp() <= 0L) {
            versionedFlow.setCreatedTimestamp(timestamp);
        }
        versionedFlow.setModifiedTimestamp(timestamp);
        this.validate(versionedFlow, "Cannot create versioned flow");
        BucketEntity existingBucket = this.metadataService.getBucketById(bucketIdentifier);
        if (existingBucket == null) {
            LOGGER.warn("The specified bucket id [{}] does not exist.", (Object)bucketIdentifier);
            throw new ResourceNotFoundException("The specified bucket ID does not exist in this registry.");
        }
        List<FlowEntity> flowsWithSameName = this.metadataService.getFlowsByName(existingBucket.getId(), versionedFlow.getName());
        if (flowsWithSameName != null && flowsWithSameName.size() > 0) {
            throw new IllegalStateException("A versioned flow with the same name already exists in the selected bucket");
        }
        FlowEntity flowEntity = FlowMappings.map(versionedFlow);
        flowEntity.setBucketId(existingBucket.getId());
        FlowEntity createdFlow = this.metadataService.createFlow(flowEntity);
        return FlowMappings.map(existingBucket, createdFlow);
    }

    public VersionedFlow getFlow(String bucketIdentifier, String flowIdentifier) {
        if (StringUtils.isBlank((CharSequence)bucketIdentifier)) {
            throw new IllegalArgumentException("Bucket identifier cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)flowIdentifier)) {
            throw new IllegalArgumentException("Versioned flow identifier cannot be null or blank");
        }
        BucketEntity existingBucket = this.metadataService.getBucketById(bucketIdentifier);
        if (existingBucket == null) {
            LOGGER.warn("The specified bucket id [{}] does not exist.", (Object)bucketIdentifier);
            throw new ResourceNotFoundException("The specified bucket ID does not exist in this registry.");
        }
        FlowEntity existingFlow = this.metadataService.getFlowByIdWithSnapshotCounts(flowIdentifier);
        if (existingFlow == null) {
            LOGGER.warn("The specified flow id [{}] does not exist.", (Object)flowIdentifier);
            throw new ResourceNotFoundException("The specified flow ID does not exist in this bucket.");
        }
        if (!existingBucket.getId().equals(existingFlow.getBucketId())) {
            throw new IllegalStateException("The requested flow is not located in the given bucket");
        }
        return FlowMappings.map(existingBucket, existingFlow);
    }

    public VersionedFlow getFlow(String flowIdentifier) {
        if (StringUtils.isBlank((CharSequence)flowIdentifier)) {
            throw new IllegalArgumentException("Versioned flow identifier cannot be null or blank");
        }
        FlowEntity existingFlow = this.metadataService.getFlowByIdWithSnapshotCounts(flowIdentifier);
        if (existingFlow == null) {
            LOGGER.warn("The specified flow id [{}] does not exist.", (Object)flowIdentifier);
            throw new ResourceNotFoundException("The specified flow ID does not exist.");
        }
        BucketEntity existingBucket = this.metadataService.getBucketById(existingFlow.getBucketId());
        return FlowMappings.map(existingBucket, existingFlow);
    }

    public void verifyFlowExists(String flowIdentifier) {
        if (StringUtils.isBlank((CharSequence)flowIdentifier)) {
            throw new IllegalArgumentException("Versioned flow identifier cannot be null or blank");
        }
        FlowEntity existingFlow = this.metadataService.getFlowById(flowIdentifier);
        if (existingFlow == null) {
            LOGGER.warn("The specified flow id [{}] does not exist.", (Object)flowIdentifier);
            throw new ResourceNotFoundException("The specified flow ID does not exist.");
        }
    }

    public List<VersionedFlow> getFlows(String bucketId) {
        if (StringUtils.isBlank((CharSequence)bucketId)) {
            throw new IllegalArgumentException("Bucket identifier cannot be null");
        }
        BucketEntity existingBucket = this.metadataService.getBucketById(bucketId);
        if (existingBucket == null) {
            LOGGER.warn("The specified bucket id [{}] does not exist.", (Object)bucketId);
            throw new ResourceNotFoundException("The specified bucket ID does not exist in this registry.");
        }
        List<FlowEntity> flows = this.metadataService.getFlowsByBucket(existingBucket.getId());
        return flows.stream().map(f -> FlowMappings.map(existingBucket, f)).collect(Collectors.toList());
    }

    public VersionedFlow updateFlow(VersionedFlow versionedFlow) {
        List<FlowEntity> flowsWithSameName;
        if (versionedFlow == null) {
            throw new IllegalArgumentException("Versioned flow cannot be null");
        }
        if (StringUtils.isBlank((CharSequence)versionedFlow.getIdentifier())) {
            throw new IllegalArgumentException("Versioned flow identifier cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)versionedFlow.getBucketIdentifier())) {
            throw new IllegalArgumentException("Versioned flow bucket identifier cannot be null or blank");
        }
        if (versionedFlow.getName() != null && StringUtils.isBlank((CharSequence)versionedFlow.getName())) {
            throw new IllegalArgumentException("Versioned flow name cannot be blank");
        }
        BucketEntity existingBucket = this.metadataService.getBucketById(versionedFlow.getBucketIdentifier());
        if (existingBucket == null) {
            LOGGER.warn("The specified bucket id [{}] does not exist.", (Object)versionedFlow.getBucketIdentifier());
            throw new ResourceNotFoundException("The specified bucket ID does not exist in this registry.");
        }
        FlowEntity existingFlow = this.metadataService.getFlowByIdWithSnapshotCounts(versionedFlow.getIdentifier());
        if (existingFlow == null) {
            LOGGER.warn("The specified flow id [{}] does not exist.", (Object)versionedFlow.getIdentifier());
            throw new ResourceNotFoundException("The specified flow ID does not exist in this bucket.");
        }
        if (!existingBucket.getId().equals(existingFlow.getBucketId())) {
            throw new IllegalStateException("The requested flow is not located in the given bucket");
        }
        if (StringUtils.isNotBlank((CharSequence)versionedFlow.getName()) && (flowsWithSameName = this.metadataService.getFlowsByName(existingBucket.getId(), versionedFlow.getName())) != null) {
            for (FlowEntity flowWithSameName : flowsWithSameName) {
                if (flowWithSameName.getId().equals(existingFlow.getId())) continue;
                throw new IllegalStateException("A versioned flow with the same name already exists in the selected bucket");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)versionedFlow.getName())) {
            existingFlow.setName(versionedFlow.getName());
        }
        if (versionedFlow.getDescription() != null) {
            existingFlow.setDescription(versionedFlow.getDescription());
        }
        FlowEntity updatedFlow = this.metadataService.updateFlow(existingFlow);
        return FlowMappings.map(existingBucket, updatedFlow);
    }

    public VersionedFlow deleteFlow(String bucketIdentifier, String flowIdentifier) {
        if (StringUtils.isBlank((CharSequence)bucketIdentifier)) {
            throw new IllegalArgumentException("Bucket identifier cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)flowIdentifier)) {
            throw new IllegalArgumentException("Flow identifier cannot be null or blank");
        }
        BucketEntity existingBucket = this.metadataService.getBucketById(bucketIdentifier);
        if (existingBucket == null) {
            LOGGER.warn("The specified bucket id [{}] does not exist.", (Object)bucketIdentifier);
            throw new ResourceNotFoundException("The specified bucket ID does not exist in this registry.");
        }
        FlowEntity existingFlow = this.metadataService.getFlowById(flowIdentifier);
        if (existingFlow == null) {
            LOGGER.warn("The specified flow id [{}] does not exist.", (Object)flowIdentifier);
            throw new ResourceNotFoundException("The specified flow ID does not exist in this bucket.");
        }
        if (!existingBucket.getId().equals(existingFlow.getBucketId())) {
            throw new IllegalStateException("The requested flow is not located in the given bucket");
        }
        this.flowPersistenceProvider.deleteAllFlowContent(existingFlow.getBucketId(), existingFlow.getId());
        this.metadataService.deleteFlow(existingFlow);
        return FlowMappings.map(existingBucket, existingFlow);
    }

    public VersionedFlowSnapshot createFlowSnapshot(VersionedFlowSnapshot flowSnapshot) {
        if (flowSnapshot == null) {
            throw new IllegalArgumentException("Versioned flow snapshot cannot be null");
        }
        if (flowSnapshot.getSnapshotMetadata() != null && flowSnapshot.getSnapshotMetadata().getTimestamp() <= 0L) {
            flowSnapshot.getSnapshotMetadata().setTimestamp(System.currentTimeMillis());
        }
        flowSnapshot.setFlow(null);
        flowSnapshot.setBucket(null);
        this.validate(flowSnapshot, "Cannot create versioned flow snapshot");
        VersionedFlowSnapshotMetadata snapshotMetadata = flowSnapshot.getSnapshotMetadata();
        BucketEntity existingBucket = this.metadataService.getBucketById(snapshotMetadata.getBucketIdentifier());
        if (existingBucket == null) {
            LOGGER.warn("The specified bucket id [{}] does not exist.", (Object)snapshotMetadata.getBucketIdentifier());
            throw new ResourceNotFoundException("The specified bucket ID does not exist in this registry.");
        }
        FlowEntity existingFlow = this.metadataService.getFlowById(snapshotMetadata.getFlowIdentifier());
        if (existingFlow == null) {
            LOGGER.warn("The specified flow id [{}] does not exist.", (Object)snapshotMetadata.getFlowIdentifier());
            throw new ResourceNotFoundException("The specified flow ID does not exist in this bucket.");
        }
        if (!existingBucket.getId().equals(existingFlow.getBucketId())) {
            throw new IllegalStateException("The requested flow is not located in the given bucket");
        }
        if (snapshotMetadata.getVersion() == 0) {
            throw new IllegalArgumentException("Version must be greater than zero, or use -1 to indicate latest version");
        }
        TreeSet sortedSnapshots = new TreeSet();
        List<FlowSnapshotEntity> existingFlowSnapshots = this.metadataService.getSnapshots(existingFlow.getId());
        if (existingFlowSnapshots != null) {
            existingFlowSnapshots.stream().forEach(s -> sortedSnapshots.add(FlowMappings.map(existingBucket, s)));
        }
        if (sortedSnapshots.size() > 0) {
            VersionedFlowSnapshotMetadata lastSnapshot = (VersionedFlowSnapshotMetadata)sortedSnapshots.last();
            if (snapshotMetadata.getVersion() == -1) {
                snapshotMetadata.setVersion(lastSnapshot.getVersion() + 1);
            } else {
                if (snapshotMetadata.getVersion() <= lastSnapshot.getVersion()) {
                    throw new IllegalStateException("A Versioned flow snapshot with the same version already exists: " + snapshotMetadata.getVersion());
                }
                if (snapshotMetadata.getVersion() > lastSnapshot.getVersion() + 1) {
                    throw new IllegalStateException("Version must be a one-up number, last version was " + lastSnapshot.getVersion() + " and version for this snapshot was " + snapshotMetadata.getVersion());
                }
            }
        } else if (snapshotMetadata.getVersion() == -1) {
            snapshotMetadata.setVersion(1);
        } else if (snapshotMetadata.getVersion() != 1) {
            throw new IllegalStateException("Version of first snapshot must be 1");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.registryUrlAliasService.setInternal(flowSnapshot.getFlowContents());
        FlowContent flowContent = new FlowContent();
        flowContent.setFlowSnapshot(flowSnapshot);
        flowSnapshot.setSnapshotMetadata(null);
        this.flowContentSerializer.serializeFlowContent(flowContent, out);
        flowSnapshot.setSnapshotMetadata(snapshotMetadata);
        Bucket bucket = BucketMappings.map(existingBucket);
        VersionedFlow versionedFlow = FlowMappings.map(existingBucket, existingFlow);
        StandardFlowSnapshotContext context = new StandardFlowSnapshotContext.Builder(bucket, versionedFlow, snapshotMetadata).build();
        this.flowPersistenceProvider.saveFlowContent((FlowSnapshotContext)context, out.toByteArray());
        this.metadataService.createFlowSnapshot(FlowMappings.map(snapshotMetadata));
        this.metadataService.updateFlow(existingFlow);
        FlowEntity updatedFlow = this.metadataService.getFlowByIdWithSnapshotCounts(snapshotMetadata.getFlowIdentifier());
        if (updatedFlow == null) {
            throw new ResourceNotFoundException("Versioned flow does not exist for identifier " + snapshotMetadata.getFlowIdentifier());
        }
        VersionedFlow updatedVersionedFlow = FlowMappings.map(existingBucket, updatedFlow);
        flowSnapshot.setBucket(bucket);
        flowSnapshot.setFlow(updatedVersionedFlow);
        this.registryUrlAliasService.setExternal(flowSnapshot.getFlowContents());
        return flowSnapshot;
    }

    public VersionedFlowSnapshot getFlowSnapshot(String bucketIdentifier, String flowIdentifier, Integer version) {
        if (StringUtils.isBlank((CharSequence)bucketIdentifier)) {
            throw new IllegalArgumentException("Bucket identifier cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)flowIdentifier)) {
            throw new IllegalArgumentException("Flow identifier cannot be null or blank");
        }
        if (version == null) {
            throw new IllegalArgumentException("Version cannot be null or blank");
        }
        BucketEntity existingBucket = this.metadataService.getBucketById(bucketIdentifier);
        if (existingBucket == null) {
            LOGGER.warn("The specified bucket id [{}] does not exist.", (Object)bucketIdentifier);
            throw new ResourceNotFoundException("The specified bucket ID does not exist in this registry.");
        }
        FlowEntity flowEntityWithCount = this.metadataService.getFlowByIdWithSnapshotCounts(flowIdentifier);
        if (flowEntityWithCount == null) {
            LOGGER.warn("The specified flow id [{}] does not exist.", (Object)flowIdentifier);
            throw new ResourceNotFoundException("The specified flow ID does not exist in this bucket.");
        }
        if (!existingBucket.getId().equals(flowEntityWithCount.getBucketId())) {
            throw new IllegalStateException("The requested flow is not located in the given bucket");
        }
        return this.getVersionedFlowSnapshot(existingBucket, flowEntityWithCount, version);
    }

    private VersionedFlowSnapshot getVersionedFlowSnapshot(BucketEntity bucketEntity, FlowEntity flowEntity, Integer version) {
        FlowSnapshotEntity snapshotEntity = this.metadataService.getFlowSnapshot(flowEntity.getId(), version);
        if (snapshotEntity == null) {
            LOGGER.warn("The specified flow snapshot id [{}] does not exist for version [{}].", (Object)flowEntity.getId(), (Object)version);
            throw new ResourceNotFoundException("The specified versioned flow snapshot does not exist for this flow.");
        }
        byte[] serializedSnapshot = this.flowPersistenceProvider.getFlowContent(bucketEntity.getId(), flowEntity.getId(), version.intValue());
        if (serializedSnapshot == null || serializedSnapshot.length == 0) {
            throw new IllegalStateException("No serialized content found for snapshot with flow identifier " + flowEntity.getId() + " and version " + version);
        }
        ByteArrayInputStream input = new ByteArrayInputStream(serializedSnapshot);
        VersionedFlowSnapshot snapshot = this.deserializeFlowContent(input);
        Bucket bucket = BucketMappings.map(bucketEntity);
        VersionedFlow versionedFlow = FlowMappings.map(bucketEntity, flowEntity);
        VersionedFlowSnapshotMetadata snapshotMetadata = FlowMappings.map(bucketEntity, snapshotEntity);
        this.registryUrlAliasService.setExternal(snapshot.getFlowContents());
        snapshot.setSnapshotMetadata(snapshotMetadata);
        snapshot.setFlow(versionedFlow);
        snapshot.setBucket(bucket);
        return snapshot;
    }

    private VersionedFlowSnapshot deserializeFlowContent(InputStream input) {
        int dataModelVersion = this.flowContentSerializer.readDataModelVersion(input);
        if (this.flowContentSerializer.isProcessGroupVersion(dataModelVersion)) {
            VersionedProcessGroup processGroup = this.flowContentSerializer.deserializeProcessGroup(dataModelVersion, input);
            VersionedFlowSnapshot snapshot = new VersionedFlowSnapshot();
            snapshot.setFlowContents(processGroup);
            return snapshot;
        }
        FlowContent flowContent = this.flowContentSerializer.deserializeFlowContent(dataModelVersion, input);
        return flowContent.getFlowSnapshot();
    }

    public SortedSet<VersionedFlowSnapshotMetadata> getFlowSnapshots(String bucketIdentifier, String flowIdentifier) {
        if (StringUtils.isBlank((CharSequence)bucketIdentifier)) {
            throw new IllegalArgumentException("Bucket identifier cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)flowIdentifier)) {
            throw new IllegalArgumentException("Flow identifier cannot be null or blank");
        }
        BucketEntity existingBucket = this.metadataService.getBucketById(bucketIdentifier);
        if (existingBucket == null) {
            LOGGER.warn("The specified bucket id [{}] does not exist.", (Object)bucketIdentifier);
            throw new ResourceNotFoundException("The specified bucket ID does not exist in this registry.");
        }
        FlowEntity existingFlow = this.metadataService.getFlowById(flowIdentifier);
        if (existingFlow == null) {
            LOGGER.warn("The specified flow id [{}] does not exist.", (Object)flowIdentifier);
            throw new ResourceNotFoundException("The specified flow ID does not exist in this bucket.");
        }
        if (!existingBucket.getId().equals(existingFlow.getBucketId())) {
            throw new IllegalStateException("The requested flow is not located in the given bucket");
        }
        TreeSet<VersionedFlowSnapshotMetadata> sortedSnapshots = new TreeSet<VersionedFlowSnapshotMetadata>(Collections.reverseOrder());
        List<FlowSnapshotEntity> existingFlowSnapshots = this.metadataService.getSnapshots(existingFlow.getId());
        if (existingFlowSnapshots != null) {
            existingFlowSnapshots.stream().forEach(s -> sortedSnapshots.add(FlowMappings.map(existingBucket, s)));
        }
        return sortedSnapshots;
    }

    public VersionedFlowSnapshotMetadata getLatestFlowSnapshotMetadata(String bucketIdentifier, String flowIdentifier) {
        if (StringUtils.isBlank((CharSequence)bucketIdentifier)) {
            throw new IllegalArgumentException("Bucket identifier cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)flowIdentifier)) {
            throw new IllegalArgumentException("Flow identifier cannot be null or blank");
        }
        BucketEntity existingBucket = this.metadataService.getBucketById(bucketIdentifier);
        if (existingBucket == null) {
            LOGGER.warn("The specified bucket id [{}] does not exist.", (Object)bucketIdentifier);
            throw new ResourceNotFoundException("The specified bucket ID does not exist in this registry.");
        }
        FlowEntity existingFlow = this.metadataService.getFlowById(flowIdentifier);
        if (existingFlow == null) {
            LOGGER.warn("The specified flow id [{}] does not exist.", (Object)flowIdentifier);
            throw new ResourceNotFoundException("The specified flow ID does not exist in this bucket.");
        }
        if (!existingBucket.getId().equals(existingFlow.getBucketId())) {
            throw new IllegalStateException("The requested flow is not located in the given bucket");
        }
        FlowSnapshotEntity latestSnapshot = this.metadataService.getLatestSnapshot(existingFlow.getId());
        if (latestSnapshot == null) {
            throw new ResourceNotFoundException("The specified flow ID has no versions");
        }
        return FlowMappings.map(existingBucket, latestSnapshot);
    }

    public VersionedFlowSnapshotMetadata getLatestFlowSnapshotMetadata(String flowIdentifier) {
        if (StringUtils.isBlank((CharSequence)flowIdentifier)) {
            throw new IllegalArgumentException("Flow identifier cannot be null or blank");
        }
        FlowEntity existingFlow = this.metadataService.getFlowById(flowIdentifier);
        if (existingFlow == null) {
            LOGGER.warn("The specified flow id [{}] does not exist.", (Object)flowIdentifier);
            throw new ResourceNotFoundException("The specified flow ID does not exist in this bucket.");
        }
        BucketEntity existingBucket = this.metadataService.getBucketById(existingFlow.getBucketId());
        if (existingBucket == null) {
            LOGGER.warn("The specified bucket id [{}] does not exist.", (Object)existingFlow.getBucketId());
            throw new ResourceNotFoundException("The specified bucket ID does not exist in this registry.");
        }
        FlowSnapshotEntity latestSnapshot = this.metadataService.getLatestSnapshot(existingFlow.getId());
        if (latestSnapshot == null) {
            throw new ResourceNotFoundException("The specified flow ID has no versions");
        }
        return FlowMappings.map(existingBucket, latestSnapshot);
    }

    public VersionedFlowSnapshotMetadata deleteFlowSnapshot(String bucketIdentifier, String flowIdentifier, Integer version) {
        if (StringUtils.isBlank((CharSequence)bucketIdentifier)) {
            throw new IllegalArgumentException("Bucket identifier cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)flowIdentifier)) {
            throw new IllegalArgumentException("Flow identifier cannot be null or blank");
        }
        if (version == null) {
            throw new IllegalArgumentException("Version cannot be null or blank");
        }
        BucketEntity existingBucket = this.metadataService.getBucketById(bucketIdentifier);
        if (existingBucket == null) {
            LOGGER.warn("The specified bucket id [{}] does not exist.", (Object)bucketIdentifier);
            throw new ResourceNotFoundException("The specified bucket ID does not exist in this registry.");
        }
        FlowEntity existingFlow = this.metadataService.getFlowById(flowIdentifier);
        if (existingFlow == null) {
            LOGGER.warn("The specified flow id [{}] does not exist.", (Object)flowIdentifier);
            throw new ResourceNotFoundException("The specified flow ID does not exist in this bucket.");
        }
        if (!existingBucket.getId().equals(existingFlow.getBucketId())) {
            throw new IllegalStateException("The requested flow is not located in the given bucket");
        }
        FlowSnapshotEntity snapshotEntity = this.metadataService.getFlowSnapshot(flowIdentifier, version);
        if (snapshotEntity == null) {
            throw new ResourceNotFoundException("Versioned flow snapshot does not exist for flow " + flowIdentifier + " and version " + version);
        }
        this.flowPersistenceProvider.deleteFlowContent(bucketIdentifier, flowIdentifier, version.intValue());
        this.metadataService.deleteFlowSnapshot(snapshotEntity);
        return FlowMappings.map(existingBucket, snapshotEntity);
    }

    public VersionedFlowDifference getFlowDiff(String bucketIdentifier, String flowIdentifier, Integer versionA, Integer versionB) {
        if (StringUtils.isBlank((CharSequence)bucketIdentifier)) {
            throw new IllegalArgumentException("Bucket identifier cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)flowIdentifier)) {
            throw new IllegalArgumentException("Flow identifier cannot be null or blank");
        }
        if (versionA == null || versionB == null) {
            throw new IllegalArgumentException("Version cannot be null or blank");
        }
        Integer older = Math.min(versionA, versionB);
        Integer newer = Math.max(versionA, versionB);
        byte[] serializedSnapshotA = this.flowPersistenceProvider.getFlowContent(bucketIdentifier, flowIdentifier, older.intValue());
        if (serializedSnapshotA == null || serializedSnapshotA.length == 0) {
            throw new IllegalStateException("No serialized content found for snapshot with flow identifier " + flowIdentifier + " and version " + older);
        }
        byte[] serializedSnapshotB = this.flowPersistenceProvider.getFlowContent(bucketIdentifier, flowIdentifier, newer.intValue());
        if (serializedSnapshotB == null || serializedSnapshotB.length == 0) {
            throw new IllegalStateException("No serialized content found for snapshot with flow identifier " + flowIdentifier + " and version " + newer);
        }
        ByteArrayInputStream inputA = new ByteArrayInputStream(serializedSnapshotA);
        VersionedFlowSnapshot snapshotA = this.deserializeFlowContent(inputA);
        VersionedProcessGroup flowContentsA = snapshotA.getFlowContents();
        ByteArrayInputStream inputB = new ByteArrayInputStream(serializedSnapshotB);
        VersionedFlowSnapshot snapshotB = this.deserializeFlowContent(inputB);
        VersionedProcessGroup flowContentsB = snapshotB.getFlowContents();
        StandardComparableDataFlow comparableFlowA = new StandardComparableDataFlow(String.format("Version %d", older), flowContentsA);
        StandardComparableDataFlow comparableFlowB = new StandardComparableDataFlow(String.format("Version %d", newer), flowContentsB);
        StandardFlowComparator flowComparator = new StandardFlowComparator((ComparableDataFlow)comparableFlowA, (ComparableDataFlow)comparableFlowB, null, (DifferenceDescriptor)new ConciseEvolvingDifferenceDescriptor(), Function.identity(), VersionedComponent::getIdentifier, FlowComparatorVersionedStrategy.DEEP);
        FlowComparison flowComparison = flowComparator.compare();
        VersionedFlowDifference result = new VersionedFlowDifference();
        result.setBucketId(bucketIdentifier);
        result.setFlowId(flowIdentifier);
        result.setVersionA(older.intValue());
        result.setVersionB(newer.intValue());
        Set<ComponentDifferenceGroup> differenceGroups = this.getStringComponentDifferenceGroupMap(flowComparison.getDifferences());
        result.setComponentDifferenceGroups(differenceGroups);
        return result;
    }

    private Set<ComponentDifferenceGroup> getStringComponentDifferenceGroupMap(Set<FlowDifference> flowDifferences) {
        HashMap<String, ComponentDifferenceGroup> differenceGroups = new HashMap<String, ComponentDifferenceGroup>();
        for (FlowDifference diff : flowDifferences) {
            ComponentDifferenceGroup group;
            VersionedComponent component = (VersionedComponent)ObjectUtils.firstNonNull((Object[])new VersionedComponent[]{diff.getComponentA(), diff.getComponentB()});
            if (differenceGroups.containsKey(component.getIdentifier())) {
                group = (ComponentDifferenceGroup)differenceGroups.get(component.getIdentifier());
            } else {
                group = FlowMappings.map(component);
                differenceGroups.put(component.getIdentifier(), group);
            }
            group.getDifferences().add(FlowMappings.map(diff));
        }
        return differenceGroups.values().stream().collect(Collectors.toSet());
    }

    public Set<String> getBucketFields() {
        return this.metadataService.getBucketFields();
    }

    public Set<String> getBucketItemFields() {
        return this.metadataService.getBucketItemFields();
    }

    public Set<String> getFlowFields() {
        return this.metadataService.getFlowFields();
    }
}

