/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.info;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.flywaydb.core.api.ErrorCode;
import org.flywaydb.core.api.ErrorDetails;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.MigrationPattern;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.MigrationType;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.output.CommandResultFactory;
import org.flywaydb.core.api.output.InfoResult;
import org.flywaydb.core.api.output.OperationResult;
import org.flywaydb.core.api.output.ValidateOutput;
import org.flywaydb.core.api.resolver.Context;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.info.AppliedMigrationAttributes;
import org.flywaydb.core.internal.info.MigrationInfoContext;
import org.flywaydb.core.internal.info.MigrationInfoImpl;
import org.flywaydb.core.internal.schemahistory.AppliedMigration;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;
import org.flywaydb.core.internal.util.Pair;

public class MigrationInfoServiceImpl
implements MigrationInfoService,
OperationResult {
    private final MigrationResolver migrationResolver;
    private final Configuration configuration;
    private final Database database;
    private final Context context;
    private final SchemaHistory schemaHistory;
    private final MigrationVersion target;
    private final MigrationPattern[] cherryPick;
    private final boolean outOfOrder;
    private final boolean pending;
    private final boolean missing;
    private final boolean ignored;
    private final boolean future;
    private List<MigrationInfoImpl> migrationInfos;
    private Boolean allSchemasEmpty;

    public MigrationInfoServiceImpl(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Configuration configuration, MigrationVersion target, boolean outOfOrder, MigrationPattern[] cherryPick, boolean pending, boolean missing, boolean ignored, boolean future) {
        this.migrationResolver = migrationResolver;
        this.schemaHistory = schemaHistory;
        this.configuration = configuration;
        this.context = () -> configuration;
        this.database = database;
        this.target = target;
        this.outOfOrder = outOfOrder;
        this.cherryPick = cherryPick;
        this.pending = pending;
        this.missing = missing;
        this.ignored = ignored || cherryPick != null;
        this.future = future;
    }

    public void refresh() {
        Collection<ResolvedMigration> resolvedMigrations = this.migrationResolver.resolveMigrations(this.context);
        List<AppliedMigration> appliedMigrations = this.schemaHistory.allAppliedMigrations();
        MigrationInfoContext context = new MigrationInfoContext();
        context.outOfOrder = this.outOfOrder;
        context.pending = this.pending;
        context.missing = this.missing;
        context.ignored = this.ignored;
        context.future = this.future;
        context.ignorePatterns = this.configuration.getIgnoreMigrationPatterns();
        context.target = this.target;
        context.cherryPick = this.cherryPick;
        TreeMap resolvedVersioned = new TreeMap();
        TreeMap<String, ResolvedMigration> resolvedRepeatable = new TreeMap<String, ResolvedMigration>();
        ResolvedMigration pendingBaselineMigration = null;
        Object appliedBaselineMigration = null;
        for (ResolvedMigration resolvedMigration : resolvedMigrations) {
            MigrationVersion version = resolvedMigration.getVersion();
            if (version != null) {
                if (version.compareTo(context.lastResolved) > 0) {
                    context.lastResolved = version;
                }
                if (resolvedMigration.getType().isBaselineMigration() && version.compareTo(context.latestBaselineMigration) > 0) continue;
                resolvedVersioned.put(Pair.of(version, false), resolvedMigration);
                continue;
            }
            resolvedRepeatable.put(resolvedMigration.getDescription(), resolvedMigration);
        }
        ArrayList<Pair<AppliedMigration, AppliedMigrationAttributes>> appliedVersioned = new ArrayList<Pair<AppliedMigration, AppliedMigrationAttributes>>();
        ArrayList<Pair<AppliedMigration, AppliedMigrationAttributes>> appliedRepeatable = new ArrayList<Pair<AppliedMigration, AppliedMigrationAttributes>>();
        for (AppliedMigration appliedMigration : appliedMigrations) {
            MigrationVersion version = appliedMigration.getVersion();
            if (version == null) {
                appliedRepeatable.add(Pair.of(appliedMigration, new AppliedMigrationAttributes()));
                if (!appliedMigration.getType().equals((Object)MigrationType.DELETE) || !appliedMigration.isSuccess()) continue;
                this.markRepeatableAsDeleted(appliedMigration.getDescription(), appliedRepeatable);
                continue;
            }
            if (appliedMigration.getType() == MigrationType.SCHEMA) {
                context.schema = version;
            }
            if (appliedMigration.getType() == MigrationType.BASELINE) {
                context.baseline = version;
            }
            if (appliedMigration.getType().equals((Object)MigrationType.DELETE) && appliedMigration.isSuccess()) {
                this.markAsDeleted(version, appliedVersioned);
            }
            appliedVersioned.add(Pair.of(appliedMigration, new AppliedMigrationAttributes()));
        }
        for (Pair pair : appliedVersioned) {
            AppliedMigration appliedMigration = (AppliedMigration)pair.getLeft();
            MigrationVersion migrationVersion = appliedMigration.getVersion();
            if (migrationVersion == null) continue;
            if (migrationVersion.compareTo(context.lastApplied) > 0) {
                if (((AppliedMigration)pair.getLeft()).getType() == MigrationType.DELETE || ((AppliedMigrationAttributes)pair.getRight()).deleted) continue;
                context.lastApplied = migrationVersion;
                continue;
            }
            ((AppliedMigrationAttributes)pair.getRight()).outOfOrder = true;
        }
        if (MigrationVersion.CURRENT == this.target) {
            context.target = context.lastApplied;
        }
        ArrayList<MigrationInfoImpl> migrationInfos1 = new ArrayList<MigrationInfoImpl>();
        HashSet hashSet = new HashSet(resolvedVersioned.values());
        for (Pair pair : appliedVersioned) {
            ResolvedMigration resolvedMigration = (ResolvedMigration)resolvedVersioned.get(Pair.of(((AppliedMigration)pair.getLeft()).getVersion(), ((AppliedMigration)pair.getLeft()).getType().isUndo()));
            if (resolvedMigration != null && !((AppliedMigrationAttributes)pair.getRight()).deleted && ((AppliedMigration)pair.getLeft()).getType() != MigrationType.DELETE) {
                hashSet.remove(resolvedMigration);
            }
            migrationInfos1.add(new MigrationInfoImpl(resolvedMigration, (AppliedMigration)pair.getLeft(), context, ((AppliedMigrationAttributes)pair.getRight()).outOfOrder, ((AppliedMigrationAttributes)pair.getRight()).deleted, ((AppliedMigrationAttributes)pair.getRight()).undone));
        }
        for (ResolvedMigration resolvedMigration : hashSet) {
            if (resolvedMigration.getVersion().compareTo(context.latestBaselineMigration) <= 0) continue;
            migrationInfos1.add(new MigrationInfoImpl(resolvedMigration, null, context, false, false, false));
        }
        if (pendingBaselineMigration != null) {
            migrationInfos1.add(new MigrationInfoImpl(pendingBaselineMigration, null, context, false, false, false));
        }
        if (this.configuration.isFailOnMissingTarget() && this.target != null && this.target != MigrationVersion.CURRENT && this.target != MigrationVersion.LATEST && this.target != MigrationVersion.NEXT) {
            boolean targetFound = false;
            for (MigrationInfoImpl migrationInfoImpl : migrationInfos1) {
                if (this.target.compareTo(migrationInfoImpl.getVersion()) != 0) continue;
                targetFound = true;
                break;
            }
            if (!targetFound) {
                throw new FlywayException("No migration with a target version " + this.target + " could be found. Ensure target is specified correctly and the migration exists.");
            }
        }
        for (Pair pair : appliedRepeatable) {
            if (((AppliedMigrationAttributes)pair.getRight()).deleted && ((AppliedMigration)pair.getLeft()).getType() == MigrationType.DELETE) continue;
            AppliedMigration appliedMigration = (AppliedMigration)pair.getLeft();
            String desc = appliedMigration.getDescription();
            int rank = appliedMigration.getInstalledRank();
            Map<String, Integer> latestRepeatableRuns = context.latestRepeatableRuns;
            if (latestRepeatableRuns.containsKey(desc) && rank <= latestRepeatableRuns.get(desc)) continue;
            latestRepeatableRuns.put(desc, rank);
        }
        HashSet pendingResolvedRepeatable = new HashSet(resolvedRepeatable.values());
        for (Pair pair : appliedRepeatable) {
            AppliedMigration appliedRepeatableMigration = (AppliedMigration)pair.getLeft();
            String desc = appliedRepeatableMigration.getDescription();
            int rank = appliedRepeatableMigration.getInstalledRank();
            ResolvedMigration resolvedMigration = (ResolvedMigration)resolvedRepeatable.get(desc);
            int latestRank = context.latestRepeatableRuns.get(desc);
            if (!((AppliedMigrationAttributes)pair.getRight()).deleted && ((AppliedMigration)pair.getLeft()).getType() != MigrationType.DELETE && resolvedMigration != null && rank == latestRank && resolvedMigration.checksumMatches(appliedRepeatableMigration.getChecksum())) {
                pendingResolvedRepeatable.remove(resolvedMigration);
            }
            migrationInfos1.add(new MigrationInfoImpl(resolvedMigration, appliedRepeatableMigration, context, false, ((AppliedMigrationAttributes)pair.getRight()).deleted, false));
        }
        for (ResolvedMigration resolvedMigration : pendingResolvedRepeatable) {
            migrationInfos1.add(new MigrationInfoImpl(resolvedMigration, null, context, false, false, false));
        }
        Collections.sort(migrationInfos1);
        this.migrationInfos = migrationInfos1;
        if (context.target == MigrationVersion.NEXT) {
            MigrationInfoImpl[] migrationInfoImplArray = this.pending();
            context.target = migrationInfoImplArray.length == 0 ? null : migrationInfoImplArray[0].getVersion();
        }
    }

    private void markRepeatableAsDeleted(String description, List<Pair<AppliedMigration, AppliedMigrationAttributes>> appliedRepeatable) {
        for (int i = appliedRepeatable.size() - 1; i >= 0; --i) {
            Pair<AppliedMigration, AppliedMigrationAttributes> ar = appliedRepeatable.get(i);
            if (ar.getLeft().getType().isSynthetic() || !description.equals(ar.getLeft().getDescription())) continue;
            if (!ar.getRight().deleted) {
                ar.getRight().deleted = true;
            }
            return;
        }
    }

    private void markAsDeleted(MigrationVersion version, List<Pair<AppliedMigration, AppliedMigrationAttributes>> appliedVersioned) {
        for (int i = appliedVersioned.size() - 1; i >= 0; --i) {
            Pair<AppliedMigration, AppliedMigrationAttributes> av = appliedVersioned.get(i);
            if (av.getLeft().getType().isSynthetic() || !version.equals(av.getLeft().getVersion())) continue;
            if (av.getRight().deleted) {
                throw new FlywayException("Corrupted schema history: multiple delete entries for version " + version, ErrorCode.DUPLICATE_DELETED_MIGRATION);
            }
            av.getRight().deleted = true;
            return;
        }
    }

    @Override
    public MigrationInfo[] all() {
        return this.migrationInfos.toArray(new MigrationInfo[0]);
    }

    @Override
    public MigrationInfo current() {
        MigrationInfoImpl current = null;
        for (MigrationInfoImpl migrationInfo : this.migrationInfos) {
            if (!migrationInfo.getState().isApplied() || MigrationState.DELETED.equals((Object)migrationInfo.getState()) || migrationInfo.getType().equals((Object)MigrationType.DELETE) || migrationInfo.getVersion() == null || current != null && migrationInfo.getVersion().compareTo(current.getVersion()) <= 0) continue;
            current = migrationInfo;
        }
        if (current != null) {
            return current;
        }
        for (int i = this.migrationInfos.size() - 1; i >= 0; --i) {
            MigrationInfoImpl migrationInfo;
            migrationInfo = this.migrationInfos.get(i);
            if (!migrationInfo.getState().isApplied() || MigrationState.DELETED.equals((Object)migrationInfo.getState()) || migrationInfo.getType().equals((Object)MigrationType.DELETE)) continue;
            return migrationInfo;
        }
        return null;
    }

    public MigrationInfoImpl[] pending() {
        ArrayList<MigrationInfoImpl> pendingMigrations = new ArrayList<MigrationInfoImpl>();
        for (MigrationInfoImpl migrationInfo : this.migrationInfos) {
            if (MigrationState.PENDING != migrationInfo.getState()) continue;
            pendingMigrations.add(migrationInfo);
        }
        return pendingMigrations.toArray(new MigrationInfoImpl[0]);
    }

    public MigrationInfoImpl[] applied() {
        ArrayList<MigrationInfoImpl> appliedMigrations = new ArrayList<MigrationInfoImpl>();
        for (MigrationInfoImpl migrationInfo : this.migrationInfos) {
            if (!migrationInfo.getState().isApplied()) continue;
            appliedMigrations.add(migrationInfo);
        }
        return appliedMigrations.toArray(new MigrationInfoImpl[0]);
    }

    public MigrationInfo[] resolved() {
        ArrayList<MigrationInfo> resolvedMigrations = new ArrayList<MigrationInfo>();
        for (MigrationInfo migrationInfo : this.migrationInfos) {
            if (!migrationInfo.getState().isResolved()) continue;
            resolvedMigrations.add(migrationInfo);
        }
        return resolvedMigrations.toArray(new MigrationInfo[0]);
    }

    public MigrationInfoImpl[] failed() {
        ArrayList<MigrationInfoImpl> failedMigrations = new ArrayList<MigrationInfoImpl>();
        for (MigrationInfoImpl migrationInfo : this.migrationInfos) {
            if (!migrationInfo.getState().isFailed()) continue;
            failedMigrations.add(migrationInfo);
        }
        return failedMigrations.toArray(new MigrationInfoImpl[0]);
    }

    public MigrationInfo[] future() {
        ArrayList<MigrationInfo> futureMigrations = new ArrayList<MigrationInfo>();
        for (MigrationInfo migrationInfo : this.migrationInfos) {
            if (migrationInfo.getState() != MigrationState.FUTURE_SUCCESS && migrationInfo.getState() != MigrationState.FUTURE_FAILED) continue;
            futureMigrations.add(migrationInfo);
        }
        return futureMigrations.toArray(new MigrationInfo[0]);
    }

    public MigrationInfo[] outOfOrder() {
        ArrayList<MigrationInfo> outOfOrderMigrations = new ArrayList<MigrationInfo>();
        for (MigrationInfo migrationInfo : this.migrationInfos) {
            if (migrationInfo.getState() != MigrationState.OUT_OF_ORDER) continue;
            outOfOrderMigrations.add(migrationInfo);
        }
        return outOfOrderMigrations.toArray(new MigrationInfo[0]);
    }

    public List<ValidateOutput> validate() {
        ArrayList<ValidateOutput> invalidMigrations = new ArrayList<ValidateOutput>();
        for (MigrationInfoImpl migrationInfo : this.migrationInfos) {
            ErrorDetails validateError = migrationInfo.validate();
            if (validateError == null) continue;
            invalidMigrations.add(CommandResultFactory.createValidateOutput(migrationInfo, validateError));
        }
        return invalidMigrations;
    }

    public void setAllSchemasEmpty(Schema[] schemas) {
        this.allSchemasEmpty = Arrays.stream(schemas).filter(Schema::exists).allMatch(Schema::empty);
    }

    @Override
    public InfoResult getInfoResult() {
        return this.getInfoResult(this.all());
    }

    public InfoResult getInfoResult(MigrationInfo[] infos) {
        return CommandResultFactory.createInfoResult(this.context.getConfiguration(), this.database, infos, this.current(), this.allSchemasEmpty);
    }
}

