/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.retries.api.internal.backoff;

import java.time.Duration;
import software.amazon.awssdk.annotations.SdkInternalApi;

@SdkInternalApi
class BackoffStrategiesConstants {
    static final Duration BASE_DELAY_CEILING = Duration.ofMillis(Integer.MAX_VALUE);
    static final Duration MAX_BACKOFF_CEILING = Duration.ofMillis(Integer.MAX_VALUE);
    static final int RETRIES_ATTEMPTED_CEILING = (int)Math.floor(Math.log(2.147483647E9) / Math.log(2.0));

    private BackoffStrategiesConstants() {
    }

    static int calculateExponentialDelay(int retriesAttempted, Duration baseDelay, Duration maxBackoffTime) {
        int cappedRetries = Math.min(retriesAttempted, RETRIES_ATTEMPTED_CEILING);
        return (int)Math.min(baseDelay.multipliedBy(1L << cappedRetries - 2).toMillis(), maxBackoffTime.toMillis());
    }
}

